/*
 * Decompiled with CFR 0.152.
 */
package com.twelvemonkeys.imageio.stream;

import com.twelvemonkeys.imageio.stream.BufferedChannelImageInputStream;
import com.twelvemonkeys.imageio.stream.BufferedImageInputStreamTest;
import java.io.EOFException;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.nio.channels.SeekableByteChannel;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.util.Random;
import javax.imageio.stream.ImageInputStream;
import org.junit.Assert;
import org.junit.Test;
import org.junit.function.ThrowingRunnable;
import org.mockito.Mockito;
import org.mockito.verification.VerificationMode;

public class BufferedChannelImageInputStreamTest {
    private final Random random = new Random(170984354357234566L);

    private File randomDataToFile(byte[] byArray) throws IOException {
        this.random.nextBytes(byArray);
        File file = File.createTempFile("read", ".tmp");
        Files.write(file.toPath(), byArray, new OpenOption[0]);
        return file;
    }

    @Test
    public void testCreate() throws IOException {
        try (BufferedChannelImageInputStream bufferedChannelImageInputStream = new BufferedChannelImageInputStream(new FileInputStream(File.createTempFile("empty", ".tmp")));){
            Assert.assertEquals((String)"Data length should be same as stream length", (long)0L, (long)bufferedChannelImageInputStream.length());
        }
    }

    @Test
    public void testCreateNullFileInputStream() {
        try {
            new BufferedChannelImageInputStream((FileInputStream)null);
            Assert.fail((String)"Expected IllegalArgumentException");
        }
        catch (IllegalArgumentException illegalArgumentException) {
            Assert.assertNotNull((String)"Null exception message", (Object)illegalArgumentException.getMessage());
            String string = illegalArgumentException.getMessage().toLowerCase();
            Assert.assertTrue((String)"Exception message does not contain parameter name", (boolean)string.contains("inputstream"));
            Assert.assertTrue((String)"Exception message does not contain null", (boolean)string.contains("null"));
        }
    }

    @Test
    public void testCreateNullByteChannel() {
        try {
            new BufferedChannelImageInputStream((SeekableByteChannel)null);
            Assert.fail((String)"Expected IllegalArgumentException");
        }
        catch (IllegalArgumentException illegalArgumentException) {
            Assert.assertNotNull((String)"Null exception message", (Object)illegalArgumentException.getMessage());
            String string = illegalArgumentException.getMessage().toLowerCase();
            Assert.assertTrue((String)"Exception message does not contain parameter name", (boolean)string.contains("channel"));
            Assert.assertTrue((String)"Exception message does not contain null", (boolean)string.contains("null"));
        }
    }

    @Test
    public void testRead() throws IOException {
        byte[] byArray = new byte[0x100000];
        File file = this.randomDataToFile(byArray);
        try (BufferedChannelImageInputStream bufferedChannelImageInputStream = new BufferedChannelImageInputStream(new FileInputStream(file));){
            Assert.assertEquals((String)"File length should be same as stream length", (long)file.length(), (long)bufferedChannelImageInputStream.length());
            for (byte by : byArray) {
                Assert.assertEquals((String)"Wrong data read", (long)(by & 0xFF), (long)bufferedChannelImageInputStream.read());
            }
        }
    }

    @Test
    public void testReadArray() throws IOException {
        byte[] byArray = new byte[0x100000];
        File file = this.randomDataToFile(byArray);
        try (BufferedChannelImageInputStream bufferedChannelImageInputStream = new BufferedChannelImageInputStream(new FileInputStream(file));){
            Assert.assertEquals((String)"File length should be same as stream length", (long)file.length(), (long)bufferedChannelImageInputStream.length());
            byte[] byArray2 = new byte[1024];
            for (int i = 0; i < byArray.length / byArray2.length; ++i) {
                bufferedChannelImageInputStream.readFully(byArray2);
                Assert.assertTrue((String)("Wrong data read: " + i), (boolean)BufferedImageInputStreamTest.rangeEquals(byArray, i * byArray2.length, byArray2, 0, byArray2.length));
            }
        }
    }

    @Test
    public void testReadSkip() throws IOException {
        byte[] byArray = new byte[14336];
        File file = this.randomDataToFile(byArray);
        try (BufferedChannelImageInputStream bufferedChannelImageInputStream = new BufferedChannelImageInputStream(new FileInputStream(file));){
            Assert.assertEquals((String)"File length should be same as stream length", (long)file.length(), (long)bufferedChannelImageInputStream.length());
            byte[] byArray2 = new byte[7];
            for (int i = 0; i < byArray.length / byArray2.length; i += 2) {
                bufferedChannelImageInputStream.readFully(byArray2);
                bufferedChannelImageInputStream.skipBytes(byArray2.length);
                Assert.assertTrue((String)("Wrong data read: " + i), (boolean)BufferedImageInputStreamTest.rangeEquals(byArray, i * byArray2.length, byArray2, 0, byArray2.length));
            }
        }
    }

    @Test
    public void testReadSeek() throws IOException {
        byte[] byArray = new byte[18432];
        File file = this.randomDataToFile(byArray);
        try (BufferedChannelImageInputStream bufferedChannelImageInputStream = new BufferedChannelImageInputStream(new FileInputStream(file));){
            Assert.assertEquals((String)"File length should be same as stream length", (long)file.length(), (long)bufferedChannelImageInputStream.length());
            byte[] byArray2 = new byte[9];
            for (int i = 0; i < byArray.length / byArray2.length; ++i) {
                long l = bufferedChannelImageInputStream.length() - (long)byArray2.length - (long)(i * byArray2.length);
                bufferedChannelImageInputStream.seek(l);
                Assert.assertEquals((String)"Wrong stream position", (long)l, (long)bufferedChannelImageInputStream.getStreamPosition());
                bufferedChannelImageInputStream.readFully(byArray2);
                Assert.assertTrue((String)("Wrong data read: " + i), (boolean)BufferedImageInputStreamTest.rangeEquals(byArray, (int)l, byArray2, 0, byArray2.length));
            }
        }
    }

    @Test
    public void testReadOutsideDataSeek0Read() throws IOException {
        byte[] byArray = new byte[256];
        File file = this.randomDataToFile(byArray);
        try (BufferedChannelImageInputStream bufferedChannelImageInputStream = new BufferedChannelImageInputStream(new FileInputStream(file));){
            Assert.assertEquals((String)"File length should be same as stream length", (long)file.length(), (long)bufferedChannelImageInputStream.length());
            byte[] byArray2 = new byte[byArray.length * 2];
            bufferedChannelImageInputStream.read(byArray2);
            bufferedChannelImageInputStream.seek(0L);
            Assert.assertNotEquals((long)-1L, (long)bufferedChannelImageInputStream.read());
            Assert.assertNotEquals((long)-1L, (long)bufferedChannelImageInputStream.read(byArray2));
        }
    }

    @Test
    public void testReadBitRandom() throws IOException {
        byte[] byArray = new byte[8];
        File file = this.randomDataToFile(byArray);
        long l = ByteBuffer.wrap(byArray).getLong();
        try (BufferedChannelImageInputStream bufferedChannelImageInputStream = new BufferedChannelImageInputStream(new FileInputStream(file));){
            for (int i = 1; i <= 64; ++i) {
                Assert.assertEquals((String)String.format("bit %d differ", i), (long)(l << (int)((long)i - 1L) >>> 63), (long)bufferedChannelImageInputStream.readBit());
            }
        }
    }

    @Test
    public void testReadBitsRandom() throws IOException {
        byte[] byArray = new byte[8];
        File file = this.randomDataToFile(byArray);
        long l = ByteBuffer.wrap(byArray).getLong();
        try (BufferedChannelImageInputStream bufferedChannelImageInputStream = new BufferedChannelImageInputStream(new FileInputStream(file));){
            for (int i = 1; i <= 64; ++i) {
                bufferedChannelImageInputStream.seek(0L);
                Assert.assertEquals((String)String.format("bit %d differ", i), (long)(l >>> (int)(64L - (long)i)), (long)bufferedChannelImageInputStream.readBits(i));
                Assert.assertEquals((long)(i % 8), (long)bufferedChannelImageInputStream.getBitOffset());
            }
        }
    }

    @Test
    public void testReadBitsRandomOffset() throws IOException {
        byte[] byArray = new byte[8];
        File file = this.randomDataToFile(byArray);
        long l = ByteBuffer.wrap(byArray).getLong();
        try (BufferedChannelImageInputStream bufferedChannelImageInputStream = new BufferedChannelImageInputStream(new FileInputStream(file));){
            for (int i = 1; i <= 60; ++i) {
                bufferedChannelImageInputStream.seek(0L);
                bufferedChannelImageInputStream.setBitOffset(i % 8);
                Assert.assertEquals((String)String.format("bit %d differ", i), (long)(l << i % 8 >>> (int)(64L - (long)i)), (long)bufferedChannelImageInputStream.readBits(i));
                Assert.assertEquals((long)(i * 2 % 8), (long)bufferedChannelImageInputStream.getBitOffset());
            }
        }
    }

    @Test
    public void testReadShort() throws IOException {
        byte[] byArray = new byte[8743];
        File file = this.randomDataToFile(byArray);
        ByteBuffer byteBuffer = ByteBuffer.wrap(byArray).order(ByteOrder.BIG_ENDIAN);
        try (BufferedChannelImageInputStream bufferedChannelImageInputStream = new BufferedChannelImageInputStream(new FileInputStream(file));){
            int n;
            bufferedChannelImageInputStream.setByteOrder(ByteOrder.BIG_ENDIAN);
            for (n = 0; n < byArray.length / 2; ++n) {
                Assert.assertEquals((long)byteBuffer.getShort(), (long)bufferedChannelImageInputStream.readShort());
            }
            Assert.assertThrows(EOFException.class, (ThrowingRunnable)new ThrowingRunnable((ImageInputStream)bufferedChannelImageInputStream){
                final /* synthetic */ ImageInputStream val$stream;
                {
                    this.val$stream = imageInputStream;
                }

                public void run() throws Throwable {
                    this.val$stream.readShort();
                }
            });
            bufferedChannelImageInputStream.seek(0L);
            bufferedChannelImageInputStream.setByteOrder(ByteOrder.LITTLE_ENDIAN);
            byteBuffer.position(0);
            byteBuffer.order(ByteOrder.LITTLE_ENDIAN);
            for (n = 0; n < byArray.length / 2; ++n) {
                Assert.assertEquals((long)byteBuffer.getShort(), (long)bufferedChannelImageInputStream.readShort());
            }
            Assert.assertThrows(EOFException.class, (ThrowingRunnable)new ThrowingRunnable((ImageInputStream)bufferedChannelImageInputStream){
                final /* synthetic */ ImageInputStream val$stream;
                {
                    this.val$stream = imageInputStream;
                }

                public void run() throws Throwable {
                    this.val$stream.readShort();
                }
            });
        }
    }

    @Test
    public void testReadInt() throws IOException {
        byte[] byArray = new byte[8743];
        File file = this.randomDataToFile(byArray);
        ByteBuffer byteBuffer = ByteBuffer.wrap(byArray).order(ByteOrder.BIG_ENDIAN);
        try (BufferedChannelImageInputStream bufferedChannelImageInputStream = new BufferedChannelImageInputStream(new FileInputStream(file));){
            int n;
            bufferedChannelImageInputStream.setByteOrder(ByteOrder.BIG_ENDIAN);
            for (n = 0; n < byArray.length / 4; ++n) {
                Assert.assertEquals((long)byteBuffer.getInt(), (long)bufferedChannelImageInputStream.readInt());
            }
            Assert.assertThrows(EOFException.class, (ThrowingRunnable)new ThrowingRunnable((ImageInputStream)bufferedChannelImageInputStream){
                final /* synthetic */ ImageInputStream val$stream;
                {
                    this.val$stream = imageInputStream;
                }

                public void run() throws Throwable {
                    this.val$stream.readInt();
                }
            });
            bufferedChannelImageInputStream.seek(0L);
            bufferedChannelImageInputStream.setByteOrder(ByteOrder.LITTLE_ENDIAN);
            byteBuffer.position(0);
            byteBuffer.order(ByteOrder.LITTLE_ENDIAN);
            for (n = 0; n < byArray.length / 4; ++n) {
                Assert.assertEquals((long)byteBuffer.getInt(), (long)bufferedChannelImageInputStream.readInt());
            }
            Assert.assertThrows(EOFException.class, (ThrowingRunnable)new ThrowingRunnable((ImageInputStream)bufferedChannelImageInputStream){
                final /* synthetic */ ImageInputStream val$stream;
                {
                    this.val$stream = imageInputStream;
                }

                public void run() throws Throwable {
                    this.val$stream.readInt();
                }
            });
        }
    }

    @Test
    public void testReadLong() throws IOException {
        byte[] byArray = new byte[8743];
        File file = this.randomDataToFile(byArray);
        ByteBuffer byteBuffer = ByteBuffer.wrap(byArray).order(ByteOrder.BIG_ENDIAN);
        try (BufferedChannelImageInputStream bufferedChannelImageInputStream = new BufferedChannelImageInputStream(new FileInputStream(file));){
            int n;
            bufferedChannelImageInputStream.setByteOrder(ByteOrder.BIG_ENDIAN);
            for (n = 0; n < byArray.length / 8; ++n) {
                Assert.assertEquals((long)byteBuffer.getLong(), (long)bufferedChannelImageInputStream.readLong());
            }
            Assert.assertThrows(EOFException.class, (ThrowingRunnable)new ThrowingRunnable((ImageInputStream)bufferedChannelImageInputStream){
                final /* synthetic */ ImageInputStream val$stream;
                {
                    this.val$stream = imageInputStream;
                }

                public void run() throws Throwable {
                    this.val$stream.readLong();
                }
            });
            bufferedChannelImageInputStream.seek(0L);
            bufferedChannelImageInputStream.setByteOrder(ByteOrder.LITTLE_ENDIAN);
            byteBuffer.position(0);
            byteBuffer.order(ByteOrder.LITTLE_ENDIAN);
            for (n = 0; n < byArray.length / 8; ++n) {
                Assert.assertEquals((long)byteBuffer.getLong(), (long)bufferedChannelImageInputStream.readLong());
            }
            Assert.assertThrows(EOFException.class, (ThrowingRunnable)new ThrowingRunnable((ImageInputStream)bufferedChannelImageInputStream){
                final /* synthetic */ ImageInputStream val$stream;
                {
                    this.val$stream = imageInputStream;
                }

                public void run() throws Throwable {
                    this.val$stream.readLong();
                }
            });
        }
    }

    @Test
    public void testSeekPastEOF() throws IOException {
        byte[] byArray = new byte[9];
        File file = this.randomDataToFile(byArray);
        try (BufferedChannelImageInputStream bufferedChannelImageInputStream = new BufferedChannelImageInputStream(new FileInputStream(file));){
            bufferedChannelImageInputStream.seek(1000L);
            Assert.assertEquals((long)-1L, (long)bufferedChannelImageInputStream.read());
            Assert.assertEquals((long)-1L, (long)bufferedChannelImageInputStream.read(new byte[1], 0, 1));
            Assert.assertThrows(EOFException.class, (ThrowingRunnable)new ThrowingRunnable((ImageInputStream)bufferedChannelImageInputStream){
                final /* synthetic */ ImageInputStream val$stream;
                {
                    this.val$stream = imageInputStream;
                }

                public void run() throws Throwable {
                    this.val$stream.readFully(new byte[1]);
                }
            });
            Assert.assertThrows(EOFException.class, (ThrowingRunnable)new ThrowingRunnable((ImageInputStream)bufferedChannelImageInputStream){
                final /* synthetic */ ImageInputStream val$stream;
                {
                    this.val$stream = imageInputStream;
                }

                public void run() throws Throwable {
                    this.val$stream.readByte();
                }
            });
            Assert.assertThrows(EOFException.class, (ThrowingRunnable)new ThrowingRunnable((ImageInputStream)bufferedChannelImageInputStream){
                final /* synthetic */ ImageInputStream val$stream;
                {
                    this.val$stream = imageInputStream;
                }

                public void run() throws Throwable {
                    this.val$stream.readShort();
                }
            });
            Assert.assertThrows(EOFException.class, (ThrowingRunnable)new ThrowingRunnable((ImageInputStream)bufferedChannelImageInputStream){
                final /* synthetic */ ImageInputStream val$stream;
                {
                    this.val$stream = imageInputStream;
                }

                public void run() throws Throwable {
                    this.val$stream.readInt();
                }
            });
            Assert.assertThrows(EOFException.class, (ThrowingRunnable)new ThrowingRunnable((ImageInputStream)bufferedChannelImageInputStream){
                final /* synthetic */ ImageInputStream val$stream;
                {
                    this.val$stream = imageInputStream;
                }

                public void run() throws Throwable {
                    this.val$stream.readLong();
                }
            });
            bufferedChannelImageInputStream.seek(0L);
            for (byte by : byArray) {
                Assert.assertEquals((long)by, (long)bufferedChannelImageInputStream.readByte());
            }
            Assert.assertEquals((long)-1L, (long)bufferedChannelImageInputStream.read());
        }
    }

    @Test
    public void testCloseChannel() throws IOException {
        SeekableByteChannel seekableByteChannel = (SeekableByteChannel)Mockito.mock(SeekableByteChannel.class);
        BufferedChannelImageInputStream bufferedChannelImageInputStream = new BufferedChannelImageInputStream(seekableByteChannel);
        bufferedChannelImageInputStream.close();
        ((SeekableByteChannel)Mockito.verify((Object)seekableByteChannel, (VerificationMode)Mockito.never())).close();
    }

    @Test
    public void testWorkaroundForWBMPImageReaderExpectsReadToBehaveAsReadFully() throws IOException {
        int n = 57344;
        byte[] byArray = new byte[n];
        File file = this.randomDataToFile(byArray);
        try (BufferedChannelImageInputStream bufferedChannelImageInputStream = new BufferedChannelImageInputStream(new FileInputStream(file));){
            byte[] byArray2 = new byte[n];
            int n2 = bufferedChannelImageInputStream.read(byArray2, 0, 12);
            int n3 = bufferedChannelImageInputStream.read(byArray2, 12, n - 12);
            Assert.assertEquals((long)n, (long)(n3 + n2));
            Assert.assertArrayEquals((byte[])byArray, (byte[])byArray2);
        }
    }
}

