/*
 * Decompiled with CFR 0.152.
 */
package com.twelvemonkeys.imageio.stream;

import com.twelvemonkeys.imageio.stream.BufferedChannelImageInputStream;
import com.twelvemonkeys.imageio.stream.BufferedImageInputStreamTest;
import com.twelvemonkeys.imageio.stream.Cache;
import com.twelvemonkeys.imageio.stream.MemoryCache;
import java.io.ByteArrayInputStream;
import java.io.EOFException;
import java.io.IOException;
import java.io.InputStream;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.nio.channels.ReadableByteChannel;
import java.util.Random;
import javax.imageio.stream.ImageInputStream;
import org.junit.Assert;
import org.junit.Test;
import org.junit.function.ThrowingRunnable;
import org.mockito.Mockito;
import org.mockito.verification.VerificationMode;

public class BufferedChannelImageInputStreamMemoryCacheTest {
    private final Random random = new Random(170984354357234566L);

    private InputStream randomDataToInputStream(byte[] byArray) {
        this.random.nextBytes(byArray);
        return new ByteArrayInputStream(byArray);
    }

    @Test
    public void testCreate() throws IOException {
        try (BufferedChannelImageInputStream bufferedChannelImageInputStream = new BufferedChannelImageInputStream((Cache)new MemoryCache((InputStream)new ByteArrayInputStream(new byte[0])));){
            Assert.assertEquals((String)"Stream length should be unknown", (long)-1L, (long)bufferedChannelImageInputStream.length());
        }
    }

    @Test
    public void testCreateNullStream() {
        try {
            new MemoryCache((InputStream)null);
            Assert.fail((String)"Expected IllegalArgumentException");
        }
        catch (IllegalArgumentException illegalArgumentException) {
            Assert.assertNotNull((String)"Null exception message", (Object)illegalArgumentException.getMessage());
            String string = illegalArgumentException.getMessage().toLowerCase();
            Assert.assertTrue((String)"Exception message does not contain parameter name", (boolean)string.contains("stream"));
            Assert.assertTrue((String)"Exception message does not contain null", (boolean)string.contains("null"));
        }
    }

    @Test
    public void testCreateNullChannel() {
        try {
            new MemoryCache((ReadableByteChannel)null);
            Assert.fail((String)"Expected IllegalArgumentException");
        }
        catch (IllegalArgumentException illegalArgumentException) {
            Assert.assertNotNull((String)"Null exception message", (Object)illegalArgumentException.getMessage());
            String string = illegalArgumentException.getMessage().toLowerCase();
            Assert.assertTrue((String)"Exception message does not contain parameter name", (boolean)string.contains("channel"));
            Assert.assertTrue((String)"Exception message does not contain null", (boolean)string.contains("null"));
        }
    }

    @Test
    public void testRead() throws IOException {
        byte[] byArray = new byte[0x100000];
        InputStream inputStream = this.randomDataToInputStream(byArray);
        try (BufferedChannelImageInputStream bufferedChannelImageInputStream = new BufferedChannelImageInputStream((Cache)new MemoryCache(inputStream));){
            Assert.assertEquals((String)"Stream length should be unknown", (long)-1L, (long)bufferedChannelImageInputStream.length());
            for (byte by : byArray) {
                Assert.assertEquals((String)"Wrong data read", (long)(by & 0xFF), (long)bufferedChannelImageInputStream.read());
            }
            Assert.assertEquals((String)"Wrong data read", (long)-1L, (long)bufferedChannelImageInputStream.read());
        }
    }

    @Test
    public void testReadArray() throws IOException {
        byte[] byArray = new byte[0x100000];
        InputStream inputStream = this.randomDataToInputStream(byArray);
        try (BufferedChannelImageInputStream bufferedChannelImageInputStream = new BufferedChannelImageInputStream((Cache)new MemoryCache(inputStream));){
            Assert.assertEquals((String)"Stream length should be unknown", (long)-1L, (long)bufferedChannelImageInputStream.length());
            byte[] byArray2 = new byte[1024];
            for (int i = 0; i < byArray.length / byArray2.length; ++i) {
                bufferedChannelImageInputStream.readFully(byArray2);
                Assert.assertTrue((String)("Wrong data read: " + i), (boolean)BufferedImageInputStreamTest.rangeEquals(byArray, i * byArray2.length, byArray2, 0, byArray2.length));
            }
            Assert.assertEquals((String)"Wrong data read", (long)-1L, (long)bufferedChannelImageInputStream.read());
        }
    }

    @Test
    public void testReadSkip() throws IOException {
        byte[] byArray = new byte[14336];
        InputStream inputStream = this.randomDataToInputStream(byArray);
        try (BufferedChannelImageInputStream bufferedChannelImageInputStream = new BufferedChannelImageInputStream((Cache)new MemoryCache(inputStream));){
            Assert.assertEquals((String)"Stream length should be unknown", (long)-1L, (long)bufferedChannelImageInputStream.length());
            byte[] byArray2 = new byte[7];
            for (int i = 0; i < byArray.length / byArray2.length; i += 2) {
                bufferedChannelImageInputStream.readFully(byArray2);
                bufferedChannelImageInputStream.skipBytes(byArray2.length);
                Assert.assertTrue((String)("Wrong data read: " + i), (boolean)BufferedImageInputStreamTest.rangeEquals(byArray, i * byArray2.length, byArray2, 0, byArray2.length));
            }
        }
    }

    @Test
    public void testReadSeek() throws IOException {
        byte[] byArray = new byte[18432];
        InputStream inputStream = this.randomDataToInputStream(byArray);
        try (BufferedChannelImageInputStream bufferedChannelImageInputStream = new BufferedChannelImageInputStream((Cache)new MemoryCache(inputStream));){
            Assert.assertEquals((String)"Stream length should be unknown", (long)-1L, (long)bufferedChannelImageInputStream.length());
            byte[] byArray2 = new byte[9];
            for (int i = 0; i < byArray.length / byArray2.length; ++i) {
                long l = byArray.length - byArray2.length - i * byArray2.length;
                bufferedChannelImageInputStream.seek(l);
                Assert.assertEquals((String)"Wrong stream position", (long)l, (long)bufferedChannelImageInputStream.getStreamPosition());
                bufferedChannelImageInputStream.readFully(byArray2);
                Assert.assertTrue((String)("Wrong data read: " + i), (boolean)BufferedImageInputStreamTest.rangeEquals(byArray, (int)l, byArray2, 0, byArray2.length));
            }
        }
    }

    @Test
    public void testReadOutsideDataSeek0Read() throws IOException {
        byte[] byArray = new byte[256];
        InputStream inputStream = this.randomDataToInputStream(byArray);
        try (BufferedChannelImageInputStream bufferedChannelImageInputStream = new BufferedChannelImageInputStream((Cache)new MemoryCache(inputStream));){
            Assert.assertEquals((String)"Stream length should be unknown", (long)-1L, (long)bufferedChannelImageInputStream.length());
            byte[] byArray2 = new byte[byArray.length * 2];
            bufferedChannelImageInputStream.read(byArray2);
            bufferedChannelImageInputStream.seek(0L);
            Assert.assertNotEquals((long)-1L, (long)bufferedChannelImageInputStream.read());
            Assert.assertNotEquals((long)-1L, (long)bufferedChannelImageInputStream.read(byArray2));
        }
    }

    @Test
    public void testReadBitRandom() throws IOException {
        byte[] byArray = new byte[8];
        InputStream inputStream = this.randomDataToInputStream(byArray);
        long l = ByteBuffer.wrap(byArray).getLong();
        try (BufferedChannelImageInputStream bufferedChannelImageInputStream = new BufferedChannelImageInputStream((Cache)new MemoryCache(inputStream));){
            for (int i = 1; i <= 64; ++i) {
                Assert.assertEquals((String)String.format("bit %d differ", i), (long)(l << (int)((long)i - 1L) >>> 63), (long)bufferedChannelImageInputStream.readBit());
            }
        }
    }

    @Test
    public void testReadBitsRandom() throws IOException {
        byte[] byArray = new byte[8];
        InputStream inputStream = this.randomDataToInputStream(byArray);
        long l = ByteBuffer.wrap(byArray).getLong();
        try (BufferedChannelImageInputStream bufferedChannelImageInputStream = new BufferedChannelImageInputStream((Cache)new MemoryCache(inputStream));){
            for (int i = 1; i <= 64; ++i) {
                bufferedChannelImageInputStream.seek(0L);
                Assert.assertEquals((String)String.format("bit %d differ", i), (long)(l >>> (int)(64L - (long)i)), (long)bufferedChannelImageInputStream.readBits(i));
                Assert.assertEquals((long)(i % 8), (long)bufferedChannelImageInputStream.getBitOffset());
            }
        }
    }

    @Test
    public void testReadBitsRandomOffset() throws IOException {
        byte[] byArray = new byte[8];
        InputStream inputStream = this.randomDataToInputStream(byArray);
        long l = ByteBuffer.wrap(byArray).getLong();
        try (BufferedChannelImageInputStream bufferedChannelImageInputStream = new BufferedChannelImageInputStream((Cache)new MemoryCache(inputStream));){
            for (int i = 1; i <= 60; ++i) {
                bufferedChannelImageInputStream.seek(0L);
                bufferedChannelImageInputStream.setBitOffset(i % 8);
                Assert.assertEquals((String)String.format("bit %d differ", i), (long)(l << i % 8 >>> (int)(64L - (long)i)), (long)bufferedChannelImageInputStream.readBits(i));
                Assert.assertEquals((long)(i * 2 % 8), (long)bufferedChannelImageInputStream.getBitOffset());
            }
        }
    }

    @Test
    public void testReadShort() throws IOException {
        byte[] byArray = new byte[8743];
        InputStream inputStream = this.randomDataToInputStream(byArray);
        ByteBuffer byteBuffer = ByteBuffer.wrap(byArray).order(ByteOrder.BIG_ENDIAN);
        try (BufferedChannelImageInputStream bufferedChannelImageInputStream = new BufferedChannelImageInputStream((Cache)new MemoryCache(inputStream));){
            int n;
            bufferedChannelImageInputStream.setByteOrder(ByteOrder.BIG_ENDIAN);
            for (n = 0; n < byArray.length / 2; ++n) {
                Assert.assertEquals((long)byteBuffer.getShort(), (long)bufferedChannelImageInputStream.readShort());
            }
            Assert.assertThrows(EOFException.class, (ThrowingRunnable)new ThrowingRunnable((ImageInputStream)bufferedChannelImageInputStream){
                final /* synthetic */ ImageInputStream val$stream;
                {
                    this.val$stream = imageInputStream;
                }

                public void run() throws Throwable {
                    this.val$stream.readShort();
                }
            });
            bufferedChannelImageInputStream.seek(0L);
            bufferedChannelImageInputStream.setByteOrder(ByteOrder.LITTLE_ENDIAN);
            byteBuffer.position(0);
            byteBuffer.order(ByteOrder.LITTLE_ENDIAN);
            for (n = 0; n < byArray.length / 2; ++n) {
                Assert.assertEquals((long)byteBuffer.getShort(), (long)bufferedChannelImageInputStream.readShort());
            }
            Assert.assertThrows(EOFException.class, (ThrowingRunnable)new ThrowingRunnable((ImageInputStream)bufferedChannelImageInputStream){
                final /* synthetic */ ImageInputStream val$stream;
                {
                    this.val$stream = imageInputStream;
                }

                public void run() throws Throwable {
                    this.val$stream.readShort();
                }
            });
        }
    }

    @Test
    public void testReadInt() throws IOException {
        byte[] byArray = new byte[8743];
        InputStream inputStream = this.randomDataToInputStream(byArray);
        ByteBuffer byteBuffer = ByteBuffer.wrap(byArray).order(ByteOrder.BIG_ENDIAN);
        try (BufferedChannelImageInputStream bufferedChannelImageInputStream = new BufferedChannelImageInputStream((Cache)new MemoryCache(inputStream));){
            int n;
            bufferedChannelImageInputStream.setByteOrder(ByteOrder.BIG_ENDIAN);
            for (n = 0; n < byArray.length / 4; ++n) {
                Assert.assertEquals((long)byteBuffer.getInt(), (long)bufferedChannelImageInputStream.readInt());
            }
            Assert.assertThrows(EOFException.class, (ThrowingRunnable)new ThrowingRunnable((ImageInputStream)bufferedChannelImageInputStream){
                final /* synthetic */ ImageInputStream val$stream;
                {
                    this.val$stream = imageInputStream;
                }

                public void run() throws Throwable {
                    this.val$stream.readInt();
                }
            });
            bufferedChannelImageInputStream.seek(0L);
            bufferedChannelImageInputStream.setByteOrder(ByteOrder.LITTLE_ENDIAN);
            byteBuffer.position(0);
            byteBuffer.order(ByteOrder.LITTLE_ENDIAN);
            for (n = 0; n < byArray.length / 4; ++n) {
                Assert.assertEquals((long)byteBuffer.getInt(), (long)bufferedChannelImageInputStream.readInt());
            }
            Assert.assertThrows(EOFException.class, (ThrowingRunnable)new ThrowingRunnable((ImageInputStream)bufferedChannelImageInputStream){
                final /* synthetic */ ImageInputStream val$stream;
                {
                    this.val$stream = imageInputStream;
                }

                public void run() throws Throwable {
                    this.val$stream.readInt();
                }
            });
        }
    }

    @Test
    public void testReadLong() throws IOException {
        byte[] byArray = new byte[8743];
        InputStream inputStream = this.randomDataToInputStream(byArray);
        ByteBuffer byteBuffer = ByteBuffer.wrap(byArray).order(ByteOrder.BIG_ENDIAN);
        try (BufferedChannelImageInputStream bufferedChannelImageInputStream = new BufferedChannelImageInputStream((Cache)new MemoryCache(inputStream));){
            int n;
            bufferedChannelImageInputStream.setByteOrder(ByteOrder.BIG_ENDIAN);
            for (n = 0; n < byArray.length / 8; ++n) {
                Assert.assertEquals((long)byteBuffer.getLong(), (long)bufferedChannelImageInputStream.readLong());
            }
            Assert.assertThrows(EOFException.class, (ThrowingRunnable)new ThrowingRunnable((ImageInputStream)bufferedChannelImageInputStream){
                final /* synthetic */ ImageInputStream val$stream;
                {
                    this.val$stream = imageInputStream;
                }

                public void run() throws Throwable {
                    this.val$stream.readLong();
                }
            });
            bufferedChannelImageInputStream.seek(0L);
            bufferedChannelImageInputStream.setByteOrder(ByteOrder.LITTLE_ENDIAN);
            byteBuffer.position(0);
            byteBuffer.order(ByteOrder.LITTLE_ENDIAN);
            for (n = 0; n < byArray.length / 8; ++n) {
                Assert.assertEquals((long)byteBuffer.getLong(), (long)bufferedChannelImageInputStream.readLong());
            }
            Assert.assertThrows(EOFException.class, (ThrowingRunnable)new ThrowingRunnable((ImageInputStream)bufferedChannelImageInputStream){
                final /* synthetic */ ImageInputStream val$stream;
                {
                    this.val$stream = imageInputStream;
                }

                public void run() throws Throwable {
                    this.val$stream.readLong();
                }
            });
        }
    }

    @Test
    public void testSeekPastEOF() throws IOException {
        byte[] byArray = new byte[9];
        InputStream inputStream = this.randomDataToInputStream(byArray);
        try (BufferedChannelImageInputStream bufferedChannelImageInputStream = new BufferedChannelImageInputStream((Cache)new MemoryCache(inputStream));){
            bufferedChannelImageInputStream.seek(1000L);
            Assert.assertEquals((long)-1L, (long)bufferedChannelImageInputStream.read());
            Assert.assertEquals((long)-1L, (long)bufferedChannelImageInputStream.read(new byte[1], 0, 1));
            Assert.assertThrows(EOFException.class, (ThrowingRunnable)new ThrowingRunnable((ImageInputStream)bufferedChannelImageInputStream){
                final /* synthetic */ ImageInputStream val$stream;
                {
                    this.val$stream = imageInputStream;
                }

                public void run() throws Throwable {
                    this.val$stream.readFully(new byte[1]);
                }
            });
            Assert.assertThrows(EOFException.class, (ThrowingRunnable)new ThrowingRunnable((ImageInputStream)bufferedChannelImageInputStream){
                final /* synthetic */ ImageInputStream val$stream;
                {
                    this.val$stream = imageInputStream;
                }

                public void run() throws Throwable {
                    this.val$stream.readByte();
                }
            });
            Assert.assertThrows(EOFException.class, (ThrowingRunnable)new ThrowingRunnable((ImageInputStream)bufferedChannelImageInputStream){
                final /* synthetic */ ImageInputStream val$stream;
                {
                    this.val$stream = imageInputStream;
                }

                public void run() throws Throwable {
                    this.val$stream.readShort();
                }
            });
            Assert.assertThrows(EOFException.class, (ThrowingRunnable)new ThrowingRunnable((ImageInputStream)bufferedChannelImageInputStream){
                final /* synthetic */ ImageInputStream val$stream;
                {
                    this.val$stream = imageInputStream;
                }

                public void run() throws Throwable {
                    this.val$stream.readInt();
                }
            });
            Assert.assertThrows(EOFException.class, (ThrowingRunnable)new ThrowingRunnable((ImageInputStream)bufferedChannelImageInputStream){
                final /* synthetic */ ImageInputStream val$stream;
                {
                    this.val$stream = imageInputStream;
                }

                public void run() throws Throwable {
                    this.val$stream.readLong();
                }
            });
            bufferedChannelImageInputStream.seek(0L);
            for (byte by : byArray) {
                Assert.assertEquals((long)by, (long)bufferedChannelImageInputStream.readByte());
            }
            Assert.assertEquals((long)-1L, (long)bufferedChannelImageInputStream.read());
        }
    }

    @Test
    public void testClose() throws IOException {
        Cache cache = (Cache)Mockito.mock(Cache.class);
        BufferedChannelImageInputStream bufferedChannelImageInputStream = new BufferedChannelImageInputStream(cache);
        bufferedChannelImageInputStream.close();
        ((Cache)Mockito.verify((Object)cache, (VerificationMode)Mockito.only())).close();
    }

    @Test
    public void testWorkaroundForWBMPImageReaderExpectsReadToBehaveAsReadFully() throws IOException {
        int n = 57344;
        byte[] byArray = new byte[n];
        InputStream inputStream = this.randomDataToInputStream(byArray);
        try (BufferedChannelImageInputStream bufferedChannelImageInputStream = new BufferedChannelImageInputStream((Cache)new MemoryCache(inputStream));){
            byte[] byArray2 = new byte[n];
            int n2 = bufferedChannelImageInputStream.read(byArray2, 0, 12);
            int n3 = bufferedChannelImageInputStream.read(byArray2, 12, n - 12);
            Assert.assertEquals((long)n, (long)(n3 + n2));
            Assert.assertArrayEquals((byte[])byArray, (byte[])byArray2);
        }
    }
}

