/*
 * Decompiled with CFR 0.152.
 */
package com.twelvemonkeys.imageio.spi;

import com.twelvemonkeys.imageio.spi.ReaderWriterProviderInfo;
import java.util.Arrays;
import java.util.List;
import javax.imageio.ImageReader;
import javax.imageio.ImageWriter;
import javax.imageio.metadata.IIOMetadataFormat;
import javax.imageio.spi.ImageReaderSpi;
import javax.imageio.spi.ImageWriterSpi;
import org.hamcrest.Description;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.TypeSafeMatcher;
import org.junit.Assert;
import org.junit.Test;

public abstract class ReaderWriterProviderInfoTest {
    private final ReaderWriterProviderInfo providerInfo = this.createProviderInfo();

    protected abstract ReaderWriterProviderInfo createProviderInfo();

    protected final ReaderWriterProviderInfo getProviderInfo() {
        return this.providerInfo;
    }

    @Test
    public void readerClassName() {
        ReaderWriterProviderInfoTest.assertClassExists(this.providerInfo.readerClassName(), ImageReader.class);
    }

    @Test
    public void readerSpiClassNames() {
        ReaderWriterProviderInfoTest.assertClassesExist(this.providerInfo.readerSpiClassNames(), ImageReaderSpi.class);
    }

    @Test
    public void inputTypes() {
        Assert.assertNotNull((Object)this.providerInfo.inputTypes());
    }

    @Test
    public void writerClassName() {
        ReaderWriterProviderInfoTest.assertClassExists(this.providerInfo.writerClassName(), ImageWriter.class);
    }

    @Test
    public void writerSpiClassNames() {
        ReaderWriterProviderInfoTest.assertClassesExist(this.providerInfo.writerSpiClassNames(), ImageWriterSpi.class);
    }

    @Test
    public void outputTypes() {
        Assert.assertNotNull((Object)this.providerInfo.outputTypes());
    }

    @Test
    public void nativeStreamMetadataFormatClassName() {
        ReaderWriterProviderInfoTest.assertClassExists(this.providerInfo.nativeStreamMetadataFormatClassName(), IIOMetadataFormat.class);
    }

    @Test
    public void extraStreamMetadataFormatClassNames() {
        ReaderWriterProviderInfoTest.assertClassesExist(this.providerInfo.extraStreamMetadataFormatClassNames(), IIOMetadataFormat.class);
    }

    @Test
    public void nativeImageMetadataFormatClassName() {
        ReaderWriterProviderInfoTest.assertClassExists(this.providerInfo.nativeImageMetadataFormatClassName(), IIOMetadataFormat.class);
    }

    @Test
    public void extraImageMetadataFormatClassNames() {
        ReaderWriterProviderInfoTest.assertClassesExist(this.providerInfo.extraImageMetadataFormatClassNames(), IIOMetadataFormat.class);
    }

    @Test
    public void formatNames() {
        String[] stringArray = this.providerInfo.formatNames();
        Assert.assertNotNull((Object)stringArray);
        Assert.assertNotEquals((long)0L, (long)stringArray.length);
        List<String> list = Arrays.asList(stringArray);
        for (String string : list) {
            Assert.assertNotNull((Object)string);
            Assert.assertFalse((boolean)string.isEmpty());
            Assert.assertTrue((boolean)list.contains(string.toLowerCase()));
            Assert.assertTrue((boolean)list.contains(string.toUpperCase()));
        }
    }

    @Test
    public void suffixes() {
        String[] stringArray = this.providerInfo.suffixes();
        Assert.assertNotNull((Object)stringArray);
        Assert.assertNotEquals((long)0L, (long)stringArray.length);
        for (String string : stringArray) {
            Assert.assertNotNull((Object)string);
            Assert.assertFalse((boolean)string.isEmpty());
        }
    }

    @Test
    public void mimeTypes() {
        String[] stringArray = this.providerInfo.mimeTypes();
        Assert.assertNotNull((Object)stringArray);
        Assert.assertNotEquals((long)0L, (long)stringArray.length);
        for (String string : stringArray) {
            Assert.assertNotNull((Object)string);
            Assert.assertFalse((boolean)string.isEmpty());
            Assert.assertTrue((string.length() > 1 ? 1 : 0) != 0);
            Assert.assertTrue((string.indexOf(47) > 0 ? 1 : 0) != 0);
            Assert.assertTrue((string.indexOf(47) < string.length() - 1 ? 1 : 0) != 0);
        }
    }

    public static <T> void assertClassExists(String string, final Class<T> clazz) {
        if (string != null) {
            try {
                final Class<?> clazz2 = Class.forName(string);
                MatcherAssert.assertThat(clazz2, (Matcher)new TypeSafeMatcher<Class<?>>(){

                    public boolean matchesSafely(Class<?> clazz3) {
                        return clazz.isAssignableFrom(clazz2);
                    }

                    public void describeTo(Description description) {
                        description.appendText("is subclass of ").appendValue((Object)clazz);
                    }
                });
            }
            catch (ClassNotFoundException classNotFoundException) {
                classNotFoundException.printStackTrace();
                Assert.fail((String)("Class not found: " + classNotFoundException.getMessage()));
            }
        }
    }

    public static <T> void assertClassesExist(String[] stringArray, Class<T> clazz) {
        if (stringArray != null) {
            for (String string : stringArray) {
                ReaderWriterProviderInfoTest.assertClassExists(string, clazz);
            }
        }
    }
}

