/*
 * Decompiled with CFR 0.152.
 */
package com.twelvemonkeys.imageio.color;

import com.twelvemonkeys.imageio.color.ColorSpaces;
import java.awt.color.ColorSpace;
import java.awt.color.ICC_ColorSpace;
import java.awt.color.ICC_Profile;
import java.io.IOException;
import org.junit.Assert;
import org.junit.Assume;
import org.junit.Test;

public class ColorSpacesTest {
    @Test
    public void testAdobeRGB98AlwaysSame() {
        ColorSpace colorSpace = ColorSpaces.getColorSpace((int)5000);
        Assert.assertSame((Object)colorSpace, (Object)ColorSpaces.getColorSpace((int)5000));
        Assert.assertTrue((boolean)(colorSpace instanceof ICC_ColorSpace));
        ICC_ColorSpace iCC_ColorSpace = (ICC_ColorSpace)colorSpace;
        Assert.assertSame((Object)colorSpace, (Object)ColorSpaces.createColorSpace((ICC_Profile)iCC_ColorSpace.getProfile()));
    }

    @Test
    public void testCMYKAlwaysSame() {
        ColorSpace colorSpace = ColorSpaces.getColorSpace((int)5001);
        Assert.assertSame((Object)colorSpace, (Object)ColorSpaces.getColorSpace((int)5001));
        Assume.assumeTrue((boolean)(colorSpace instanceof ICC_ColorSpace));
        ICC_ColorSpace iCC_ColorSpace = (ICC_ColorSpace)colorSpace;
        Assert.assertSame((Object)colorSpace, (Object)ColorSpaces.createColorSpace((ICC_Profile)iCC_ColorSpace.getProfile()));
    }

    @Test
    public void testCreateColorSpaceFromKnownProfileReturnsInternalCS_sRGB() {
        ICC_Profile iCC_Profile = ICC_Profile.getInstance(1000);
        ICC_ColorSpace iCC_ColorSpace = ColorSpaces.createColorSpace((ICC_Profile)iCC_Profile);
        Assert.assertSame((Object)iCC_ColorSpace, (Object)ColorSpace.getInstance(1000));
        Assert.assertTrue((boolean)iCC_ColorSpace.isCS_sRGB());
    }

    @Test
    public void testCreateColorSpaceFromKnownProfileDataReturnsInternalCS_sRGB() {
        ICC_Profile iCC_Profile = ICC_Profile.getInstance(1000);
        byte[] byArray = iCC_Profile.getData();
        Assert.assertNotSame((Object)iCC_Profile.getData(), (Object)byArray);
        ICC_Profile iCC_Profile2 = ICC_Profile.getInstance(byArray);
        Assert.assertNotSame((Object)iCC_Profile, (Object)iCC_Profile2);
        ICC_ColorSpace iCC_ColorSpace = ColorSpaces.createColorSpace((ICC_Profile)iCC_Profile2);
        Assert.assertSame((Object)ColorSpace.getInstance(1000), (Object)iCC_ColorSpace);
        Assert.assertTrue((boolean)iCC_ColorSpace.isCS_sRGB());
    }

    @Test
    public void testCreateColorSpaceFromKnownProfileReturnsInternalCS_GRAY() {
        ICC_Profile iCC_Profile = ICC_Profile.getInstance(1003);
        ICC_ColorSpace iCC_ColorSpace = ColorSpaces.createColorSpace((ICC_Profile)iCC_Profile);
        Assert.assertSame((Object)ColorSpace.getInstance(1003), (Object)iCC_ColorSpace);
    }

    @Test
    public void testCreateColorSpaceFromKnownProfileReturnsInternalCS_PYCC() {
        ICC_Profile iCC_Profile = ICC_Profile.getInstance(1002);
        ICC_ColorSpace iCC_ColorSpace = ColorSpaces.createColorSpace((ICC_Profile)iCC_Profile);
        Assert.assertSame((Object)ColorSpace.getInstance(1002), (Object)iCC_ColorSpace);
    }

    @Test
    public void testCreateColorSpaceFromKnownProfileReturnsInternalCS_CIEXYZ() {
        ICC_Profile iCC_Profile = ICC_Profile.getInstance(1001);
        ICC_ColorSpace iCC_ColorSpace = ColorSpaces.createColorSpace((ICC_Profile)iCC_Profile);
        Assert.assertSame((Object)ColorSpace.getInstance(1001), (Object)iCC_ColorSpace);
    }

    @Test
    public void testCreateColorSpaceFromKnownProfileReturnsInternalCS_LINEAR_RGB() {
        ICC_Profile iCC_Profile = ICC_Profile.getInstance(1004);
        ICC_ColorSpace iCC_ColorSpace = ColorSpaces.createColorSpace((ICC_Profile)iCC_Profile);
        Assert.assertSame((Object)ColorSpace.getInstance(1004), (Object)iCC_ColorSpace);
    }

    @Test
    public void testAdobeRGB98NotNull() {
        Assert.assertNotNull((Object)ColorSpaces.getColorSpace((int)5000));
    }

    @Test
    public void testAdobeRGB98IsTypeRGB() {
        Assert.assertEquals((long)5L, (long)ColorSpaces.getColorSpace((int)5000).getType());
    }

    @Test
    public void testCMYKNotNull() {
        Assert.assertNotNull((Object)ColorSpaces.getColorSpace((int)5001));
    }

    @Test
    public void testCMYKIsTypeCMYK() {
        Assert.assertEquals((long)9L, (long)ColorSpaces.getColorSpace((int)5001).getType());
    }

    @Test
    public void testIsCS_sRGBTrue() {
        Assert.assertTrue((boolean)ColorSpaces.isCS_sRGB((ICC_Profile)ICC_Profile.getInstance(1000)));
    }

    @Test
    public void testIsCS_sRGBFalse() {
        Assert.assertFalse((boolean)ColorSpaces.isCS_sRGB((ICC_Profile)ICC_Profile.getInstance(1004)));
        Assert.assertFalse((boolean)ColorSpaces.isCS_sRGB((ICC_Profile)ICC_Profile.getInstance(1001)));
        Assert.assertFalse((boolean)ColorSpaces.isCS_sRGB((ICC_Profile)ICC_Profile.getInstance(1003)));
        Assert.assertFalse((boolean)ColorSpaces.isCS_sRGB((ICC_Profile)ICC_Profile.getInstance(1002)));
    }

    @Test(expected=IllegalArgumentException.class)
    public void testIsCS_sRGBNull() {
        ColorSpaces.isCS_sRGB(null);
    }

    @Test
    public void testIsCS_GRAYTrue() {
        Assert.assertTrue((boolean)ColorSpaces.isCS_GRAY((ICC_Profile)ICC_Profile.getInstance(1003)));
    }

    @Test
    public void testIsCS_GRAYFalse() {
        Assert.assertFalse((boolean)ColorSpaces.isCS_GRAY((ICC_Profile)ICC_Profile.getInstance(1000)));
        Assert.assertFalse((boolean)ColorSpaces.isCS_GRAY((ICC_Profile)ICC_Profile.getInstance(1004)));
        Assert.assertFalse((boolean)ColorSpaces.isCS_GRAY((ICC_Profile)ICC_Profile.getInstance(1001)));
        Assert.assertFalse((boolean)ColorSpaces.isCS_GRAY((ICC_Profile)ICC_Profile.getInstance(1002)));
    }

    @Test(expected=IllegalArgumentException.class)
    public void testIsCS_GRAYNull() {
        ColorSpaces.isCS_GRAY(null);
    }

    @Test
    public void testEqualHeadersDifferentProfile() throws IOException {
        ICC_Profile iCC_Profile = ICC_Profile.getInstance(this.getClass().getResourceAsStream("/profiles/adobe_rgb_1998.icc"));
        ICC_Profile iCC_Profile2 = ICC_Profile.getInstance(this.getClass().getResourceAsStream("/profiles/color_match_rgb.icc"));
        Assert.assertNotSame((Object)iCC_Profile, (Object)iCC_Profile2);
        ICC_ColorSpace iCC_ColorSpace = ColorSpaces.createColorSpace((ICC_Profile)iCC_Profile);
        ICC_ColorSpace iCC_ColorSpace2 = ColorSpaces.createColorSpace((ICC_Profile)iCC_Profile2);
        Assert.assertNotSame((Object)iCC_ColorSpace, (Object)iCC_ColorSpace2);
    }
}

