/*
 * Decompiled with CFR 0.152.
 */
package com.twelvemonkeys.imageio.color;

import com.twelvemonkeys.imageio.color.CIELabColorConverter;
import org.junit.Assert;
import org.junit.Test;

public class CIELabColorConverterTest {
    @Test(expected=IllegalArgumentException.class)
    public void testNoIllumninant() {
        new CIELabColorConverter(null);
    }

    @Test
    public void testD50() {
        CIELabColorConverter cIELabColorConverter = new CIELabColorConverter(CIELabColorConverter.Illuminant.D50);
        float[] fArray = new float[3];
        cIELabColorConverter.toRGB(100.0f, -128.0f, -128.0f, fArray);
        Assert.assertArrayEquals((float[])new float[]{0.0f, 255.0f, 255.0f}, (float[])fArray, (float)1.0f);
        cIELabColorConverter.toRGB(100.0f, 0.0f, 0.0f, fArray);
        Assert.assertArrayEquals((float[])new float[]{255.0f, 252.0f, 220.0f}, (float[])fArray, (float)5.0f);
        cIELabColorConverter.toRGB(0.0f, 0.0f, 0.0f, fArray);
        Assert.assertArrayEquals((float[])new float[]{0.0f, 0.0f, 0.0f}, (float[])fArray, (float)1.0f);
        cIELabColorConverter.toRGB(100.0f, 0.0f, 127.0f, fArray);
        Assert.assertArrayEquals((float[])new float[]{255.0f, 249.0f, 0.0f}, (float[])fArray, (float)5.0f);
        cIELabColorConverter.toRGB(50.0f, -128.0f, 127.0f, fArray);
        Assert.assertArrayEquals((float[])new float[]{0.0f, 152.0f, 0.0f}, (float[])fArray, (float)2.0f);
        cIELabColorConverter.toRGB(50.0f, 127.0f, -128.0f, fArray);
        Assert.assertArrayEquals((float[])new float[]{222.0f, 0.0f, 255.0f}, (float[])fArray, (float)2.0f);
    }

    @Test
    public void testD65() {
        CIELabColorConverter cIELabColorConverter = new CIELabColorConverter(CIELabColorConverter.Illuminant.D65);
        float[] fArray = new float[3];
        cIELabColorConverter.toRGB(100.0f, -128.0f, -128.0f, fArray);
        Assert.assertArrayEquals((float[])new float[]{0.0f, 255.0f, 255.0f}, (float[])fArray, (float)1.0f);
        cIELabColorConverter.toRGB(100.0f, 0.0f, 0.0f, fArray);
        Assert.assertArrayEquals((float[])new float[]{255.0f, 252.0f, 255.0f}, (float[])fArray, (float)5.0f);
        cIELabColorConverter.toRGB(0.0f, 0.0f, 0.0f, fArray);
        Assert.assertArrayEquals((float[])new float[]{0.0f, 0.0f, 0.0f}, (float[])fArray, (float)1.0f);
        cIELabColorConverter.toRGB(100.0f, 0.0f, 127.0f, fArray);
        Assert.assertArrayEquals((float[])new float[]{255.0f, 250.0f, 0.0f}, (float[])fArray, (float)5.0f);
        cIELabColorConverter.toRGB(50.0f, -128.0f, 127.0f, fArray);
        Assert.assertArrayEquals((float[])new float[]{0.0f, 152.0f, 0.0f}, (float[])fArray, (float)3.0f);
        cIELabColorConverter.toRGB(50.0f, 127.0f, -128.0f, fArray);
        Assert.assertArrayEquals((float[])new float[]{184.0f, 0.0f, 255.0f}, (float[])fArray, (float)5.0f);
    }
}

