/*
 * Decompiled with CFR 0.152.
 */
package com.twelvemonkeys.imageio;

import com.twelvemonkeys.imageio.ImageReaderBase;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.color.ColorSpace;
import java.awt.image.BufferedImage;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import javax.imageio.IIOException;
import javax.imageio.ImageReadParam;
import javax.imageio.ImageTypeSpecifier;
import org.junit.Assert;
import org.junit.Test;

public class ImageReaderBaseTest {
    private static final List<ImageTypeSpecifier> TYPES = Arrays.asList(ImageTypeSpecifier.createFromBufferedImageType(1), ImageTypeSpecifier.createFromBufferedImageType(2));

    @Test(expected=IllegalArgumentException.class)
    public void testGetDestinationZeroWidth() throws IIOException {
        ImageReaderBase.getDestination(null, TYPES.iterator(), (int)0, (int)42);
    }

    @Test(expected=IllegalArgumentException.class)
    public void testGetDestinationNegativeWidth() throws IIOException {
        ImageReaderBase.getDestination(null, TYPES.iterator(), (int)-1, (int)42);
    }

    @Test(expected=IllegalArgumentException.class)
    public void testGetDestinationZeroHeight() throws IIOException {
        ImageReaderBase.getDestination(null, TYPES.iterator(), (int)42, (int)0);
    }

    @Test(expected=IllegalArgumentException.class)
    public void testGetDestinationNegativeHeight() throws IIOException {
        ImageReaderBase.getDestination(null, TYPES.iterator(), (int)42, (int)-1);
    }

    @Test(expected=IllegalArgumentException.class)
    public void testGetDestinationNullTypes() throws IIOException {
        ImageReaderBase.getDestination(null, null, (int)42, (int)42);
    }

    @Test(expected=IllegalArgumentException.class)
    public void testGetDestinationNoTypes() throws IIOException {
        ImageReaderBase.getDestination(null, Collections.emptyList().iterator(), (int)42, (int)42);
    }

    @Test
    public void testGetDestinationParamSourceRegionWider() throws IIOException {
        ImageReadParam imageReadParam = new ImageReadParam();
        imageReadParam.setSourceRegion(new Rectangle(42, 1));
        BufferedImage bufferedImage = ImageReaderBase.getDestination((ImageReadParam)imageReadParam, TYPES.iterator(), (int)3, (int)3);
        Assert.assertEquals((long)3L, (long)bufferedImage.getWidth());
        Assert.assertEquals((long)1L, (long)bufferedImage.getHeight());
        Assert.assertEquals((long)TYPES.get(0).getBufferedImageType(), (long)bufferedImage.getType());
    }

    @Test
    public void testGetDestinationParamSourceRegionTaller() throws IIOException {
        ImageReadParam imageReadParam = new ImageReadParam();
        imageReadParam.setSourceRegion(new Rectangle(1, 42));
        BufferedImage bufferedImage = ImageReaderBase.getDestination((ImageReadParam)imageReadParam, TYPES.iterator(), (int)3, (int)3);
        Assert.assertEquals((long)1L, (long)bufferedImage.getWidth());
        Assert.assertEquals((long)3L, (long)bufferedImage.getHeight());
        Assert.assertEquals((long)TYPES.get(0).getBufferedImageType(), (long)bufferedImage.getType());
    }

    @Test
    public void testGetDestinationParamDestinationWider() throws IIOException {
        ImageReadParam imageReadParam = new ImageReadParam();
        imageReadParam.setDestination(new BufferedImage(42, 1, 1));
        BufferedImage bufferedImage = ImageReaderBase.getDestination((ImageReadParam)imageReadParam, TYPES.iterator(), (int)3, (int)3);
        Assert.assertEquals((long)42L, (long)bufferedImage.getWidth());
        Assert.assertEquals((long)1L, (long)bufferedImage.getHeight());
        Assert.assertEquals((long)1L, (long)bufferedImage.getType());
    }

    @Test
    public void testGetDestinationParamDestinationTaller() throws IIOException {
        ImageReadParam imageReadParam = new ImageReadParam();
        imageReadParam.setDestination(new BufferedImage(1, 42, 2));
        BufferedImage bufferedImage = ImageReaderBase.getDestination((ImageReadParam)imageReadParam, TYPES.iterator(), (int)3, (int)3);
        Assert.assertEquals((long)1L, (long)bufferedImage.getWidth());
        Assert.assertEquals((long)42L, (long)bufferedImage.getHeight());
        Assert.assertEquals((long)2L, (long)bufferedImage.getType());
    }

    @Test
    public void testGetDestinationNoParam() throws IIOException {
        BufferedImage bufferedImage = ImageReaderBase.getDestination(null, TYPES.iterator(), (int)42, (int)1);
        Assert.assertEquals((long)1L, (long)bufferedImage.getType());
        Assert.assertEquals((long)42L, (long)bufferedImage.getWidth());
        Assert.assertEquals((long)1L, (long)bufferedImage.getHeight());
    }

    @Test
    public void testGetDestinationParamNoDestination() throws IIOException {
        BufferedImage bufferedImage = ImageReaderBase.getDestination((ImageReadParam)new ImageReadParam(), TYPES.iterator(), (int)42, (int)1);
        Assert.assertEquals((long)1L, (long)bufferedImage.getType());
        Assert.assertEquals((long)42L, (long)bufferedImage.getWidth());
        Assert.assertEquals((long)1L, (long)bufferedImage.getHeight());
    }

    @Test
    public void testGetDestinationParamGoodDestination() throws IIOException {
        ImageReadParam imageReadParam = new ImageReadParam();
        imageReadParam.setDestination(new BufferedImage(21, 1, 2));
        BufferedImage bufferedImage = ImageReaderBase.getDestination((ImageReadParam)imageReadParam, TYPES.iterator(), (int)42, (int)1);
        Assert.assertEquals((long)2L, (long)bufferedImage.getType());
        Assert.assertEquals((long)21L, (long)bufferedImage.getWidth());
        Assert.assertEquals((long)1L, (long)bufferedImage.getHeight());
    }

    @Test(expected=IIOException.class)
    public void testGetDestinationParamIllegalDestination() throws IIOException {
        ImageReadParam imageReadParam = new ImageReadParam();
        imageReadParam.setDestination(new BufferedImage(21, 1, 8));
        ImageReaderBase.getDestination((ImageReadParam)imageReadParam, TYPES.iterator(), (int)42, (int)1);
    }

    @Test
    public void testGetDestinationParamGoodDestinationType() throws IIOException {
        ImageReadParam imageReadParam = new ImageReadParam();
        imageReadParam.setDestinationType(ImageTypeSpecifier.createFromBufferedImageType(2));
        BufferedImage bufferedImage = ImageReaderBase.getDestination((ImageReadParam)imageReadParam, TYPES.iterator(), (int)6, (int)7);
        Assert.assertEquals((long)2L, (long)bufferedImage.getType());
        Assert.assertEquals((long)6L, (long)bufferedImage.getWidth());
        Assert.assertEquals((long)7L, (long)bufferedImage.getHeight());
    }

    @Test
    public void testGetDestinationParamGoodDestinationTypeAlt() throws IIOException {
        ImageReadParam imageReadParam = new ImageReadParam();
        ImageTypeSpecifier imageTypeSpecifier = ImageTypeSpecifier.createPacked(ColorSpace.getInstance(1000), 0xFF0000, 65280, 255, -16777216, 3, false);
        imageReadParam.setDestinationType(imageTypeSpecifier);
        BufferedImage bufferedImage = ImageReaderBase.getDestination((ImageReadParam)imageReadParam, TYPES.iterator(), (int)6, (int)7);
        Assert.assertEquals((long)2L, (long)bufferedImage.getType());
        Assert.assertEquals((long)6L, (long)bufferedImage.getWidth());
        Assert.assertEquals((long)7L, (long)bufferedImage.getHeight());
    }

    @Test(expected=IIOException.class)
    public void testGetDestinationParamIllegalDestinationType() throws IIOException {
        ImageReadParam imageReadParam = new ImageReadParam();
        imageReadParam.setDestinationType(ImageTypeSpecifier.createFromBufferedImageType(10));
        ImageReaderBase.getDestination((ImageReadParam)imageReadParam, TYPES.iterator(), (int)6, (int)7);
    }

    @Test(expected=IIOException.class)
    public void testGetDestinationParamIllegalDestinationTypeAlt() throws IIOException {
        ImageReadParam imageReadParam = new ImageReadParam();
        imageReadParam.setDestinationType(ImageTypeSpecifier.createFromBufferedImageType(4));
        ImageReaderBase.getDestination((ImageReadParam)imageReadParam, TYPES.iterator(), (int)6, (int)7);
    }

    @Test
    public void testGetDestinationSourceExceedsIntegerMax() throws IIOException {
        ImageReadParam imageReadParam = new ImageReadParam();
        imageReadParam.setSourceRegion(new Rectangle(42, 7));
        BufferedImage bufferedImage = ImageReaderBase.getDestination((ImageReadParam)imageReadParam, TYPES.iterator(), (int)Integer.MAX_VALUE, (int)42);
        Assert.assertEquals((long)42L, (long)bufferedImage.getWidth());
        Assert.assertEquals((long)7L, (long)bufferedImage.getHeight());
        Assert.assertEquals((long)TYPES.get(0).getBufferedImageType(), (long)bufferedImage.getType());
    }

    @Test(expected=IIOException.class)
    public void testGetDestinationParamDestinationExceedsIntegerMax() throws IIOException {
        ImageReadParam imageReadParam = new ImageReadParam();
        imageReadParam.setSourceRegion(new Rectangle(98301, 65534));
        ImageReaderBase.getDestination((ImageReadParam)imageReadParam, TYPES.iterator(), (int)196602, (int)131068);
    }

    @Test(expected=IIOException.class)
    public void testGetDestinationDimensionExceedsIntegerMax() throws IIOException {
        ImageReaderBase.getDestination(null, TYPES.iterator(), (int)98301, (int)65534);
    }

    @Test(expected=IIOException.class)
    public void testGetDestinationStorageExceedsIntegerMax() throws IIOException {
        Set<ImageTypeSpecifier> set = Collections.singleton(ImageTypeSpecifier.createFromBufferedImageType(5));
        ImageReaderBase.getDestination(null, set.iterator(), (int)Short.MAX_VALUE, (int)Short.MAX_VALUE);
    }

    @Test
    public void testHasExplicitDestinationNull() {
        Assert.assertFalse((boolean)ImageReaderBase.hasExplicitDestination(null));
    }

    @Test
    public void testHasExplicitDestinationDefaultParam() {
        Assert.assertFalse((boolean)ImageReaderBase.hasExplicitDestination((ImageReadParam)new ImageReadParam()));
    }

    @Test
    public void testHasExplicitDestinationParamWithDestination() {
        ImageReadParam imageReadParam = new ImageReadParam();
        imageReadParam.setDestination(new BufferedImage(1, 1, 10));
        Assert.assertTrue((boolean)ImageReaderBase.hasExplicitDestination((ImageReadParam)imageReadParam));
    }

    @Test
    public void testHasExplicitDestinationParamWithDestinationType() {
        ImageReadParam imageReadParam = new ImageReadParam();
        imageReadParam.setDestinationType(ImageTypeSpecifier.createFromBufferedImageType(2));
        Assert.assertTrue((boolean)ImageReaderBase.hasExplicitDestination((ImageReadParam)imageReadParam));
    }

    @Test
    public void testHasExplicitDestinationParamWithDestinationOffset() {
        ImageReadParam imageReadParam = new ImageReadParam();
        imageReadParam.setDestinationOffset(new Point(42, 42));
        Assert.assertTrue((boolean)ImageReaderBase.hasExplicitDestination((ImageReadParam)imageReadParam));
    }

    @Test
    public void testHasExplicitDestinationParamWithDestinationOffsetUnspecified() {
        ImageReadParam imageReadParam = new ImageReadParam();
        Assert.assertFalse((boolean)ImageReaderBase.hasExplicitDestination((ImageReadParam)imageReadParam));
    }

    @Test
    public void testHasExplicitDestinationParamWithDestinationOffsetOrigin() {
        ImageReadParam imageReadParam = new ImageReadParam();
        imageReadParam.setDestinationOffset(new Point(0, 0));
        Assert.assertFalse((boolean)ImageReaderBase.hasExplicitDestination((ImageReadParam)imageReadParam));
    }
}

