/*
 * Decompiled with CFR 0.152.
 */
package com.twelvemonkeys.imageio.util;

import com.twelvemonkeys.imageio.util.IndexedImageTypeSpecifier;
import java.awt.image.BufferedImage;
import java.awt.image.IndexColorModel;
import javax.imageio.ImageTypeSpecifier;
import org.junit.Assert;
import org.junit.Test;

public class IndexedImageTypeSpecifierTest {
    @Test
    public void testEquals() {
        IndexColorModel indexColorModel = new IndexColorModel(1, 2, new int[]{0xFFFFFF, 0}, 0, false, -1, 0);
        ImageTypeSpecifier imageTypeSpecifier = IndexedImageTypeSpecifier.createFromIndexColorModel((IndexColorModel)indexColorModel);
        ImageTypeSpecifier imageTypeSpecifier2 = IndexedImageTypeSpecifier.createFromIndexColorModel((IndexColorModel)indexColorModel);
        ImageTypeSpecifier imageTypeSpecifier3 = IndexedImageTypeSpecifier.createFromIndexColorModel((IndexColorModel)new IndexColorModel(2, 2, new int[]{0xFF00FF, 0, 0xFF00FF, 0}, 0, false, -1, 0));
        Assert.assertEquals((Object)imageTypeSpecifier, (Object)imageTypeSpecifier2);
        Assert.assertEquals((Object)imageTypeSpecifier2, (Object)imageTypeSpecifier);
        Assert.assertEquals((long)imageTypeSpecifier.hashCode(), (long)imageTypeSpecifier2.hashCode());
        Assert.assertTrue((boolean)imageTypeSpecifier.equals(imageTypeSpecifier2));
        Assert.assertTrue((boolean)imageTypeSpecifier2.equals(imageTypeSpecifier));
        Assert.assertFalse((boolean)imageTypeSpecifier2.equals(imageTypeSpecifier3));
    }

    @Test
    public void testHashCode() {
        IndexColorModel indexColorModel = new IndexColorModel(1, 2, new int[]{0xFFFFFF, 0}, 0, false, -1, 0);
        ImageTypeSpecifier imageTypeSpecifier = IndexedImageTypeSpecifier.createFromIndexColorModel((IndexColorModel)indexColorModel);
        ImageTypeSpecifier imageTypeSpecifier2 = IndexedImageTypeSpecifier.createFromIndexColorModel((IndexColorModel)indexColorModel);
        ImageTypeSpecifier imageTypeSpecifier3 = IndexedImageTypeSpecifier.createFromIndexColorModel((IndexColorModel)new IndexColorModel(2, 2, new int[]{0xFF00FF, 0, 0xFF00FF, 0}, 0, false, -1, 0));
        Assert.assertEquals((long)imageTypeSpecifier.hashCode(), (long)imageTypeSpecifier2.hashCode());
        Assert.assertFalse((imageTypeSpecifier.hashCode() == imageTypeSpecifier3.hashCode() ? 1 : 0) != 0);
    }

    @Test(expected=IllegalArgumentException.class)
    public void testCreateNull() {
        IndexedImageTypeSpecifier.createFromIndexColorModel(null);
    }

    @Test
    public void testCreateBufferedImageBinary() {
        IndexColorModel indexColorModel = new IndexColorModel(1, 2, new int[]{0xFFFFFF, 0}, 0, false, -1, 0);
        ImageTypeSpecifier imageTypeSpecifier = IndexedImageTypeSpecifier.createFromIndexColorModel((IndexColorModel)indexColorModel);
        BufferedImage bufferedImage = imageTypeSpecifier.createBufferedImage(2, 2);
        Assert.assertNotNull((Object)bufferedImage);
        Assert.assertEquals((long)12L, (long)bufferedImage.getType());
        Assert.assertEquals((Object)indexColorModel, (Object)bufferedImage.getColorModel());
    }

    @Test
    public void testCreateBufferedImageIndexed() {
        IndexColorModel indexColorModel = new IndexColorModel(8, 256, new int[256], 0, false, -1, 0);
        ImageTypeSpecifier imageTypeSpecifier = IndexedImageTypeSpecifier.createFromIndexColorModel((IndexColorModel)indexColorModel);
        BufferedImage bufferedImage = imageTypeSpecifier.createBufferedImage(2, 2);
        Assert.assertNotNull((Object)bufferedImage);
        Assert.assertEquals((long)13L, (long)bufferedImage.getType());
        Assert.assertEquals((Object)indexColorModel, (Object)bufferedImage.getColorModel());
    }
}

