/*
 * Decompiled with CFR 0.152.
 */
package com.twelvemonkeys.imageio.util;

import com.twelvemonkeys.imageio.stream.URLImageInputStreamSpi;
import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.LinearGradientPaint;
import java.awt.Polygon;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.net.URL;
import java.util.List;
import javax.imageio.ImageIO;
import javax.imageio.ImageWriteParam;
import javax.imageio.ImageWriter;
import javax.imageio.event.IIOWriteProgressListener;
import javax.imageio.spi.IIORegistry;
import javax.imageio.stream.ImageOutputStream;
import org.junit.Assert;
import org.junit.Test;
import org.mockito.InOrder;
import org.mockito.Matchers;
import org.mockito.Mockito;

public abstract class ImageWriterAbstractTest {
    protected abstract ImageWriter createImageWriter();

    protected abstract List<? extends RenderedImage> getTestData();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected static BufferedImage drawSomething(BufferedImage bufferedImage) {
        Graphics2D graphics2D = bufferedImage.createGraphics();
        try {
            int n = bufferedImage.getWidth();
            int n2 = bufferedImage.getHeight();
            graphics2D.clearRect(0, 0, n, n2);
            graphics2D.setPaint(new LinearGradientPaint(0.0f, 0.0f, n, 0.0f, new float[]{0.2f, 1.0f}, new Color[]{new Color(0, true), Color.BLUE}));
            graphics2D.fillRect(0, 0, n, n2);
            graphics2D.setPaint(new LinearGradientPaint(0.0f, 0.0f, 0.0f, n2, new float[]{0.2f, 1.0f}, new Color[]{new Color(0, true), Color.RED}));
            graphics2D.fillRect(0, 0, n, n2);
            graphics2D.setPaint(new LinearGradientPaint(0.0f, 0.0f, 0.0f, n2, new float[]{0.0f, 1.0f}, new Color[]{new Color(0xFFFFFF, true), Color.WHITE}));
            graphics2D.fill(new Polygon(new int[]{0, n, n}, new int[]{0, n2, 0}, 3));
        }
        finally {
            graphics2D.dispose();
        }
        return bufferedImage;
    }

    protected final RenderedImage getTestData(int n) {
        return this.getTestData().get(n);
    }

    protected URL getClassLoaderResource(String string) {
        return this.getClass().getResource(string);
    }

    @Test
    public void testSetOutput() throws IOException {
        ImageWriter imageWriter = this.createImageWriter();
        Assert.assertNotNull((Object)imageWriter);
        imageWriter.setOutput(ImageIO.createImageOutputStream(new ByteArrayOutputStream()));
    }

    @Test
    public void testSetOutputNull() {
        ImageWriter imageWriter = this.createImageWriter();
        Assert.assertNotNull((Object)imageWriter);
        imageWriter.setOutput(null);
    }

    @Test
    public void testWrite() throws IOException {
        ImageWriter imageWriter = this.createImageWriter();
        for (RenderedImage renderedImage : this.getTestData()) {
            ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
            try (ImageOutputStream imageOutputStream = ImageIO.createImageOutputStream(byteArrayOutputStream);){
                imageWriter.setOutput(imageOutputStream);
                imageWriter.write(ImageWriterAbstractTest.drawSomething((BufferedImage)renderedImage));
            }
            catch (IOException iOException) {
                Assert.fail((String)iOException.getMessage());
            }
            Assert.assertTrue((String)"No image data written", (byteArrayOutputStream.size() > 0 ? 1 : 0) != 0);
        }
    }

    @Test
    public void testWriteNull() throws IOException {
        ImageWriter imageWriter = this.createImageWriter();
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        imageWriter.setOutput(ImageIO.createImageOutputStream(byteArrayOutputStream));
        try {
            imageWriter.write((RenderedImage)null);
        }
        catch (IllegalArgumentException illegalArgumentException) {
        }
        catch (IOException iOException) {
            Assert.fail((String)iOException.getMessage());
        }
        Assert.assertTrue((String)"Image data written", (byteArrayOutputStream.size() == 0 ? 1 : 0) != 0);
    }

    @Test(expected=IllegalStateException.class)
    public void testWriteNoOutput() {
        ImageWriter imageWriter = this.createImageWriter();
        try {
            imageWriter.write(this.getTestData(0));
        }
        catch (IOException iOException) {
            Assert.fail((String)iOException.getMessage());
        }
    }

    @Test
    public void testGetDefaultWriteParam() {
        ImageWriter imageWriter = this.createImageWriter();
        ImageWriteParam imageWriteParam = imageWriter.getDefaultWriteParam();
        Assert.assertNotNull((String)"Default ImageWriteParam is null", (Object)imageWriteParam);
    }

    @Test
    public void testAddIIOWriteProgressListener() {
        ImageWriter imageWriter = this.createImageWriter();
        imageWriter.addIIOWriteProgressListener((IIOWriteProgressListener)Mockito.mock(IIOWriteProgressListener.class));
    }

    @Test
    public void testAddIIOWriteProgressListenerNull() {
        ImageWriter imageWriter = this.createImageWriter();
        imageWriter.addIIOWriteProgressListener(null);
    }

    @Test
    public void testAddIIOWriteProgressListenerCallbacks() throws IOException {
        ImageWriter imageWriter = this.createImageWriter();
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        imageWriter.setOutput(ImageIO.createImageOutputStream(byteArrayOutputStream));
        IIOWriteProgressListener iIOWriteProgressListener = (IIOWriteProgressListener)Mockito.mock(IIOWriteProgressListener.class);
        imageWriter.addIIOWriteProgressListener(iIOWriteProgressListener);
        try {
            imageWriter.write(this.getTestData(0));
        }
        catch (IOException iOException) {
            Assert.fail((String)"Could not write image");
        }
        InOrder inOrder = Mockito.inOrder((Object[])new Object[]{iIOWriteProgressListener});
        ((IIOWriteProgressListener)inOrder.verify((Object)iIOWriteProgressListener)).imageStarted(imageWriter, 0);
        ((IIOWriteProgressListener)inOrder.verify((Object)iIOWriteProgressListener, Mockito.atLeastOnce())).imageProgress((ImageWriter)Mockito.eq((Object)imageWriter), Matchers.anyInt());
        ((IIOWriteProgressListener)inOrder.verify((Object)iIOWriteProgressListener)).imageComplete(imageWriter);
    }

    @Test
    public void testMultipleAddIIOWriteProgressListenerCallbacks() throws IOException {
        ImageWriter imageWriter = this.createImageWriter();
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        imageWriter.setOutput(ImageIO.createImageOutputStream(byteArrayOutputStream));
        IIOWriteProgressListener iIOWriteProgressListener = (IIOWriteProgressListener)Mockito.mock(IIOWriteProgressListener.class);
        IIOWriteProgressListener iIOWriteProgressListener2 = (IIOWriteProgressListener)Mockito.mock(IIOWriteProgressListener.class);
        IIOWriteProgressListener iIOWriteProgressListener3 = (IIOWriteProgressListener)Mockito.mock(IIOWriteProgressListener.class);
        imageWriter.addIIOWriteProgressListener(iIOWriteProgressListener);
        imageWriter.addIIOWriteProgressListener(iIOWriteProgressListener2);
        imageWriter.addIIOWriteProgressListener(iIOWriteProgressListener3);
        try {
            imageWriter.write(this.getTestData(0));
        }
        catch (IOException iOException) {
            Assert.fail((String)"Could not write image");
        }
        InOrder inOrder = Mockito.inOrder((Object[])new Object[]{iIOWriteProgressListener, iIOWriteProgressListener2, iIOWriteProgressListener3});
        ((IIOWriteProgressListener)inOrder.verify((Object)iIOWriteProgressListener)).imageStarted(imageWriter, 0);
        ((IIOWriteProgressListener)inOrder.verify((Object)iIOWriteProgressListener2)).imageStarted(imageWriter, 0);
        ((IIOWriteProgressListener)inOrder.verify((Object)iIOWriteProgressListener3)).imageStarted(imageWriter, 0);
        ((IIOWriteProgressListener)inOrder.verify((Object)iIOWriteProgressListener, Mockito.atLeastOnce())).imageProgress((ImageWriter)Mockito.eq((Object)imageWriter), Matchers.anyInt());
        ((IIOWriteProgressListener)inOrder.verify((Object)iIOWriteProgressListener2, Mockito.atLeastOnce())).imageProgress((ImageWriter)Mockito.eq((Object)imageWriter), Matchers.anyInt());
        ((IIOWriteProgressListener)inOrder.verify((Object)iIOWriteProgressListener3, Mockito.atLeastOnce())).imageProgress((ImageWriter)Mockito.eq((Object)imageWriter), Matchers.anyInt());
        ((IIOWriteProgressListener)inOrder.verify((Object)iIOWriteProgressListener)).imageComplete(imageWriter);
        ((IIOWriteProgressListener)inOrder.verify((Object)iIOWriteProgressListener2)).imageComplete(imageWriter);
        ((IIOWriteProgressListener)inOrder.verify((Object)iIOWriteProgressListener3)).imageComplete(imageWriter);
    }

    @Test
    public void testRemoveIIOWriteProgressListenerNull() {
        ImageWriter imageWriter = this.createImageWriter();
        imageWriter.removeIIOWriteProgressListener(null);
    }

    @Test
    public void testRemoveIIOWriteProgressListenerNone() {
        ImageWriter imageWriter = this.createImageWriter();
        imageWriter.removeIIOWriteProgressListener((IIOWriteProgressListener)Mockito.mock(IIOWriteProgressListener.class));
    }

    @Test
    public void testRemoveIIOWriteProgressListener() throws IOException {
        ImageWriter imageWriter = this.createImageWriter();
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        imageWriter.setOutput(ImageIO.createImageOutputStream(byteArrayOutputStream));
        IIOWriteProgressListener iIOWriteProgressListener = (IIOWriteProgressListener)Mockito.mock(IIOWriteProgressListener.class);
        imageWriter.addIIOWriteProgressListener(iIOWriteProgressListener);
        imageWriter.removeIIOWriteProgressListener(iIOWriteProgressListener);
        try {
            imageWriter.write(this.getTestData(0));
        }
        catch (IOException iOException) {
            Assert.fail((String)"Could not write image");
        }
        Mockito.verifyZeroInteractions((Object[])new Object[]{iIOWriteProgressListener});
    }

    @Test
    public void testRemoveIIOWriteProgressListenerMultiple() throws IOException {
        ImageWriter imageWriter = this.createImageWriter();
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        imageWriter.setOutput(ImageIO.createImageOutputStream(byteArrayOutputStream));
        IIOWriteProgressListener iIOWriteProgressListener = (IIOWriteProgressListener)Mockito.mock(IIOWriteProgressListener.class);
        imageWriter.addIIOWriteProgressListener(iIOWriteProgressListener);
        IIOWriteProgressListener iIOWriteProgressListener2 = (IIOWriteProgressListener)Mockito.mock(IIOWriteProgressListener.class);
        imageWriter.addIIOWriteProgressListener(iIOWriteProgressListener2);
        imageWriter.removeIIOWriteProgressListener(iIOWriteProgressListener);
        try {
            imageWriter.write(this.getTestData(0));
        }
        catch (IOException iOException) {
            Assert.fail((String)"Could not write image");
        }
        Mockito.verifyZeroInteractions((Object[])new Object[]{iIOWriteProgressListener});
        InOrder inOrder = Mockito.inOrder((Object[])new Object[]{iIOWriteProgressListener2});
        ((IIOWriteProgressListener)inOrder.verify((Object)iIOWriteProgressListener2)).imageStarted(imageWriter, 0);
        ((IIOWriteProgressListener)inOrder.verify((Object)iIOWriteProgressListener2, Mockito.atLeastOnce())).imageProgress((ImageWriter)Mockito.eq((Object)imageWriter), Matchers.anyInt());
        ((IIOWriteProgressListener)inOrder.verify((Object)iIOWriteProgressListener2)).imageComplete(imageWriter);
    }

    @Test
    public void testRemoveAllIIOWriteProgressListeners() throws IOException {
        ImageWriter imageWriter = this.createImageWriter();
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        imageWriter.setOutput(ImageIO.createImageOutputStream(byteArrayOutputStream));
        IIOWriteProgressListener iIOWriteProgressListener = (IIOWriteProgressListener)Mockito.mock(IIOWriteProgressListener.class);
        imageWriter.addIIOWriteProgressListener(iIOWriteProgressListener);
        imageWriter.removeAllIIOWriteProgressListeners();
        try {
            imageWriter.write(this.getTestData(0));
        }
        catch (IOException iOException) {
            Assert.fail((String)"Could not write image");
        }
        Mockito.verifyZeroInteractions((Object[])new Object[]{iIOWriteProgressListener});
    }

    @Test
    public void testRemoveAllIIOWriteProgressListenersMultiple() throws IOException {
        ImageWriter imageWriter = this.createImageWriter();
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        imageWriter.setOutput(ImageIO.createImageOutputStream(byteArrayOutputStream));
        IIOWriteProgressListener iIOWriteProgressListener = (IIOWriteProgressListener)Mockito.mock(IIOWriteProgressListener.class);
        imageWriter.addIIOWriteProgressListener(iIOWriteProgressListener);
        IIOWriteProgressListener iIOWriteProgressListener2 = (IIOWriteProgressListener)Mockito.mock(IIOWriteProgressListener.class);
        imageWriter.addIIOWriteProgressListener(iIOWriteProgressListener2);
        imageWriter.removeAllIIOWriteProgressListeners();
        try {
            imageWriter.write(this.getTestData(0));
        }
        catch (IOException iOException) {
            Assert.fail((String)"Could not write image");
        }
        Mockito.verifyZeroInteractions((Object[])new Object[]{iIOWriteProgressListener});
        Mockito.verifyZeroInteractions((Object[])new Object[]{iIOWriteProgressListener2});
    }

    static {
        IIORegistry.getDefaultInstance().registerServiceProvider(new URLImageInputStreamSpi());
        ImageIO.setUseCache(false);
    }
}

