/*
 * Decompiled with CFR 0.152.
 */
package com.twelvemonkeys.imageio.util;

import com.twelvemonkeys.imageio.stream.URLImageInputStreamSpi;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics2D;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.awt.image.SampleModel;
import java.io.File;
import java.io.IOException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import javax.imageio.IIOException;
import javax.imageio.ImageIO;
import javax.imageio.ImageReadParam;
import javax.imageio.ImageReader;
import javax.imageio.ImageTypeSpecifier;
import javax.imageio.event.IIOReadProgressListener;
import javax.imageio.metadata.IIOMetadata;
import javax.imageio.spi.IIORegistry;
import javax.imageio.spi.ImageReaderSpi;
import javax.imageio.stream.ImageInputStream;
import org.junit.Assert;
import org.junit.Ignore;
import org.junit.Test;
import org.mockito.InOrder;
import org.mockito.Mockito;
import org.mockito.invocation.InvocationOnMock;
import org.mockito.stubbing.Answer;

public abstract class ImageReaderAbstractTest<T extends ImageReader> {
    protected abstract List<TestData> getTestData();

    protected abstract ImageReaderSpi createProvider();

    protected abstract Class<T> getReaderClass();

    protected T createReader() {
        try {
            return (T)((ImageReader)this.getReaderClass().newInstance());
        }
        catch (IllegalAccessException | InstantiationException reflectiveOperationException) {
            throw new RuntimeException(reflectiveOperationException);
        }
    }

    protected abstract List<String> getFormatNames();

    protected abstract List<String> getSuffixes();

    protected abstract List<String> getMIMETypes();

    protected boolean allowsNullRawImageType() {
        return false;
    }

    protected static void failBecause(String string, Throwable throwable) {
        AssertionError assertionError = new AssertionError((Object)string);
        ((Throwable)((Object)assertionError)).initCause(throwable);
        throw assertionError;
    }

    protected void assertProviderInstalledForName(String string, Class<? extends ImageReader> clazz) {
        this.assertProviderInstalled0(string.toUpperCase(), clazz, ImageIO.getImageReadersByFormatName(string.toUpperCase()));
        this.assertProviderInstalled0(string.toLowerCase(), clazz, ImageIO.getImageReadersByFormatName(string.toLowerCase()));
    }

    protected void assertProviderInstalledForMIMEType(String string, Class<? extends ImageReader> clazz) {
        this.assertProviderInstalled0(string, clazz, ImageIO.getImageReadersByMIMEType(string));
    }

    protected void assertProviderInstalledForSuffix(String string, Class<? extends ImageReader> clazz) {
        this.assertProviderInstalled0(string, clazz, ImageIO.getImageReadersBySuffix(string));
    }

    private void assertProviderInstalled0(String string, Class<? extends ImageReader> clazz, Iterator<ImageReader> iterator) {
        boolean bl = false;
        while (iterator.hasNext()) {
            ImageReader imageReader = iterator.next();
            if (imageReader.getClass() != clazz) continue;
            bl = true;
        }
        Assert.assertTrue((String)String.format("%s not installed for %s", clazz.getSimpleName(), string), (boolean)bl);
    }

    @Test
    public void testProviderInstalledForNames() {
        Class<T> clazz = this.getReaderClass();
        for (String string : this.getFormatNames()) {
            this.assertProviderInstalledForName(string, clazz);
        }
    }

    @Test
    public void testProviderInstalledForSuffixes() {
        Class<T> clazz = this.getReaderClass();
        for (String string : this.getSuffixes()) {
            this.assertProviderInstalledForSuffix(string, clazz);
        }
    }

    @Test
    public void testProviderInstalledForMIMETypes() {
        Class<T> clazz = this.getReaderClass();
        for (String string : this.getMIMETypes()) {
            this.assertProviderInstalledForMIMEType(string, clazz);
        }
    }

    @Test
    public void testProviderCanRead() throws IOException {
        List<TestData> list = this.getTestData();
        ImageReaderSpi imageReaderSpi = this.createProvider();
        for (TestData testData : list) {
            ImageInputStream imageInputStream = testData.getInputStream();
            Assert.assertNotNull((Object)imageInputStream);
            Assert.assertTrue((String)("Provider is expected to be able to decode data: " + testData), (boolean)imageReaderSpi.canDecodeInput(imageInputStream));
        }
    }

    @Test
    public void testProviderCanReadNull() {
        boolean bl = false;
        try {
            bl = this.createProvider().canDecodeInput(null);
        }
        catch (IllegalArgumentException illegalArgumentException) {
        }
        catch (RuntimeException runtimeException) {
            ImageReaderAbstractTest.failBecause("RuntimeException other than IllegalArgumentException thrown", runtimeException);
        }
        catch (IOException iOException) {
            ImageReaderAbstractTest.failBecause("Could not test data for read", iOException);
        }
        Assert.assertFalse((String)"ImageReader can read null input", (boolean)bl);
    }

    @Test
    public void testSetInput() {
        T t = this.createReader();
        Assert.assertNotNull(t);
        for (TestData testData : this.getTestData()) {
            ((ImageReader)t).setInput(testData.getInputStream());
        }
        ((ImageReader)t).dispose();
    }

    @Test
    public void testSetInputNull() {
        T t = this.createReader();
        Assert.assertNotNull(t);
        ((ImageReader)t).setInput(null);
        ((ImageReader)t).dispose();
    }

    @Test
    public void testRead() {
        T t = this.createReader();
        for (TestData testData : this.getTestData()) {
            ((ImageReader)t).setInput(testData.getInputStream());
            for (int i = 0; i < testData.getImageCount(); ++i) {
                BufferedImage bufferedImage = null;
                try {
                    bufferedImage = ((ImageReader)t).read(i);
                }
                catch (Exception exception) {
                    ImageReaderAbstractTest.failBecause(String.format("Image %s index %s could not be read: %s", testData.getInput(), i, exception), exception);
                }
                Assert.assertNotNull((String)String.format("Image %s index %s was null!", testData.getInput(), i), (Object)bufferedImage);
                Assert.assertEquals((String)String.format("Image %s index %s has wrong width: %s", testData.getInput(), i, bufferedImage.getWidth()), (long)testData.getDimension((int)i).width, (long)bufferedImage.getWidth());
                Assert.assertEquals((String)String.format("Image %s index %s has wrong height: %s", testData.getInput(), i, bufferedImage.getHeight()), (long)testData.getDimension((int)i).height, (long)bufferedImage.getHeight());
            }
        }
        ((ImageReader)t).dispose();
    }

    @Test
    public void testReadIndexNegative() {
        T t = this.createReader();
        TestData testData = this.getTestData().get(0);
        ((ImageReader)t).setInput(testData.getInputStream());
        BufferedImage bufferedImage = null;
        try {
            bufferedImage = ((ImageReader)t).read(-1);
            Assert.fail((String)"Read image with illegal index");
        }
        catch (IndexOutOfBoundsException indexOutOfBoundsException) {
        }
        catch (IOException iOException) {
            ImageReaderAbstractTest.failBecause("Image could not be read", iOException);
        }
        Assert.assertNull((Object)bufferedImage);
        ((ImageReader)t).dispose();
    }

    @Test
    public void testReadIndexOutOfBounds() {
        T t = this.createReader();
        TestData testData = this.getTestData().get(0);
        ((ImageReader)t).setInput(testData.getInputStream());
        BufferedImage bufferedImage = null;
        try {
            bufferedImage = ((ImageReader)t).read(Integer.MAX_VALUE);
            Assert.fail((String)"Read image with index out of bounds");
        }
        catch (IndexOutOfBoundsException indexOutOfBoundsException) {
        }
        catch (IOException iOException) {
            ImageReaderAbstractTest.failBecause("Image could not be read", iOException);
        }
        Assert.assertNull((Object)bufferedImage);
        ((ImageReader)t).dispose();
    }

    @Test
    public void testReadNoInput() {
        T t = this.createReader();
        BufferedImage bufferedImage = null;
        try {
            bufferedImage = ((ImageReader)t).read(0);
            Assert.fail((String)"Read image with no input");
        }
        catch (IllegalStateException illegalStateException) {
        }
        catch (IOException iOException) {
            ImageReaderAbstractTest.failBecause("Image could not be read", iOException);
        }
        Assert.assertNull((Object)bufferedImage);
        ((ImageReader)t).dispose();
    }

    @Test
    public void testReRead() throws IOException {
        T t = this.createReader();
        TestData testData = this.getTestData().get(0);
        ((ImageReader)t).setInput(testData.getInputStream(), false);
        BufferedImage bufferedImage = ((ImageReader)t).read(0);
        Assert.assertNotNull((Object)bufferedImage);
        BufferedImage bufferedImage2 = ((ImageReader)t).read(0);
        Assert.assertNotNull((Object)bufferedImage2);
        Assert.assertEquals((long)bufferedImage.getType(), (long)bufferedImage2.getType());
        Assert.assertEquals((long)bufferedImage.getWidth(), (long)bufferedImage2.getWidth());
        Assert.assertEquals((long)bufferedImage.getHeight(), (long)bufferedImage2.getHeight());
        ((ImageReader)t).dispose();
    }

    @Test
    public void testReadIndexNegativeWithParam() {
        T t = this.createReader();
        TestData testData = this.getTestData().get(0);
        ((ImageReader)t).setInput(testData.getInputStream());
        BufferedImage bufferedImage = null;
        try {
            bufferedImage = ((ImageReader)t).read(-1, ((ImageReader)t).getDefaultReadParam());
            Assert.fail((String)"Read image with illegal index");
        }
        catch (IndexOutOfBoundsException indexOutOfBoundsException) {
        }
        catch (IOException iOException) {
            ImageReaderAbstractTest.failBecause("Image could not be read", iOException);
        }
        Assert.assertNull(bufferedImage);
        ((ImageReader)t).dispose();
    }

    @Test
    public void testReadIndexOutOfBoundsWithParam() {
        T t = this.createReader();
        TestData testData = this.getTestData().get(0);
        ((ImageReader)t).setInput(testData.getInputStream());
        BufferedImage bufferedImage = null;
        try {
            bufferedImage = ((ImageReader)t).read(Short.MAX_VALUE, ((ImageReader)t).getDefaultReadParam());
            Assert.fail((String)"Read image with index out of bounds");
        }
        catch (IndexOutOfBoundsException indexOutOfBoundsException) {
        }
        catch (IOException iOException) {
            ImageReaderAbstractTest.failBecause("Image could not be read", iOException);
        }
        Assert.assertNull(bufferedImage);
        ((ImageReader)t).dispose();
    }

    @Test
    public void testReadNoInputWithParam() {
        T t = this.createReader();
        BufferedImage bufferedImage = null;
        try {
            bufferedImage = ((ImageReader)t).read(0, ((ImageReader)t).getDefaultReadParam());
            Assert.fail((String)"Read image with no input");
        }
        catch (IllegalStateException illegalStateException) {
        }
        catch (IOException iOException) {
            ImageReaderAbstractTest.failBecause("Image could not be read", iOException);
        }
        Assert.assertNull(bufferedImage);
        ((ImageReader)t).dispose();
    }

    @Test
    public void testReadWithNewParam() {
        T t = this.createReader();
        TestData testData = this.getTestData().get(0);
        ((ImageReader)t).setInput(testData.getInputStream());
        BufferedImage bufferedImage = null;
        try {
            bufferedImage = ((ImageReader)t).read(0, new ImageReadParam());
        }
        catch (IOException iOException) {
            ImageReaderAbstractTest.failBecause("Image could not be read", iOException);
        }
        Assert.assertNotNull((String)"Image was null!", (Object)bufferedImage);
        Assert.assertEquals((String)("Read image has wrong width: " + bufferedImage.getWidth()), (long)testData.getDimension((int)0).width, (long)bufferedImage.getWidth());
        Assert.assertEquals((String)("Read image has wrong height: " + bufferedImage.getHeight()), (long)testData.getDimension((int)0).height, (long)bufferedImage.getHeight());
        ((ImageReader)t).dispose();
    }

    @Test
    public void testReadWithDefaultParam() {
        T t = this.createReader();
        TestData testData = this.getTestData().get(0);
        ((ImageReader)t).setInput(testData.getInputStream());
        BufferedImage bufferedImage = null;
        try {
            bufferedImage = ((ImageReader)t).read(0, ((ImageReader)t).getDefaultReadParam());
        }
        catch (IOException iOException) {
            ImageReaderAbstractTest.failBecause("Image could not be read", iOException);
        }
        Assert.assertNotNull((String)"Image was null!", (Object)bufferedImage);
        Assert.assertEquals((String)("Read image has wrong width: " + bufferedImage.getWidth()), (long)testData.getDimension((int)0).width, (long)bufferedImage.getWidth());
        Assert.assertEquals((String)("Read image has wrong height: " + bufferedImage.getHeight()), (long)testData.getDimension((int)0).height, (long)bufferedImage.getHeight());
        ((ImageReader)t).dispose();
    }

    @Test
    public void testReadWithNullParam() {
        T t = this.createReader();
        TestData testData = this.getTestData().get(0);
        ((ImageReader)t).setInput(testData.getInputStream());
        BufferedImage bufferedImage = null;
        try {
            bufferedImage = ((ImageReader)t).read(0, null);
        }
        catch (IOException iOException) {
            ImageReaderAbstractTest.failBecause("Image could not be read", iOException);
        }
        Assert.assertNotNull((String)"Image was null!", (Object)bufferedImage);
        Assert.assertEquals((String)("Read image has wrong width: " + bufferedImage.getWidth()), (long)testData.getDimension((int)0).width, (long)bufferedImage.getWidth());
        Assert.assertEquals((String)("Read image has wrong height: " + bufferedImage.getHeight()), (long)testData.getDimension((int)0).height, (long)bufferedImage.getHeight());
        ((ImageReader)t).dispose();
    }

    @Test
    public void testReadWithSizeParam() {
        T t = this.createReader();
        TestData testData = this.getTestData().get(0);
        ((ImageReader)t).setInput(testData.getInputStream());
        ImageReadParam imageReadParam = ((ImageReader)t).getDefaultReadParam();
        if (imageReadParam.canSetSourceRenderSize()) {
            imageReadParam.setSourceRenderSize(new Dimension(10, 10));
            BufferedImage bufferedImage = null;
            try {
                bufferedImage = ((ImageReader)t).read(0, imageReadParam);
            }
            catch (IOException iOException) {
                ImageReaderAbstractTest.failBecause("Image could not be read", iOException);
            }
            Assert.assertNotNull((String)"Image was null!", (Object)bufferedImage);
            Assert.assertEquals((String)("Read image has wrong width: " + bufferedImage.getWidth()), (long)10L, (long)bufferedImage.getWidth());
            Assert.assertEquals((String)("Read image has wrong height: " + bufferedImage.getHeight()), (long)10L, (long)bufferedImage.getHeight());
        }
        ((ImageReader)t).dispose();
    }

    @Test
    public void testReadWithSubsampleParamDimensions() {
        T t = this.createReader();
        TestData testData = this.getTestData().get(0);
        ((ImageReader)t).setInput(testData.getInputStream());
        ImageReadParam imageReadParam = ((ImageReader)t).getDefaultReadParam();
        imageReadParam.setSourceSubsampling(5, 5, 0, 0);
        BufferedImage bufferedImage = null;
        try {
            bufferedImage = ((ImageReader)t).read(0, imageReadParam);
        }
        catch (IOException iOException) {
            ImageReaderAbstractTest.failBecause("Image could not be read", iOException);
        }
        Assert.assertNotNull((String)"Image was null!", (Object)bufferedImage);
        Assert.assertEquals((String)"Read image has wrong width: ", (long)((testData.getDimension((int)0).width + 4) / 5), (long)bufferedImage.getWidth());
        Assert.assertEquals((String)"Read image has wrong height: ", (long)((testData.getDimension((int)0).height + 4) / 5), (long)bufferedImage.getHeight());
        ((ImageReader)t).dispose();
    }

    @Test
    public void testReadWithSubsampleParamPixels() throws IOException {
        T t = this.createReader();
        TestData testData = this.getTestData().get(0);
        ((ImageReader)t).setInput(testData.getInputStream());
        ImageReadParam imageReadParam = ((ImageReader)t).getDefaultReadParam();
        BufferedImage bufferedImage = null;
        BufferedImage bufferedImage2 = null;
        try {
            bufferedImage = ((ImageReader)t).read(0, imageReadParam);
            imageReadParam.setSourceSubsampling(2, 2, 0, 0);
            bufferedImage2 = ((ImageReader)t).read(0, imageReadParam);
        }
        catch (IOException iOException) {
            ImageReaderAbstractTest.failBecause("Image could not be read", iOException);
        }
        this.assertSubsampledImageDataEquals("Subsampled image data does not match expected", bufferedImage, bufferedImage2, imageReadParam);
        ((ImageReader)t).dispose();
    }

    protected final void assertSubsampledImageDataEquals(String string, BufferedImage bufferedImage, BufferedImage bufferedImage2, ImageReadParam imageReadParam) throws IOException {
        Assert.assertNotNull((String)"Expected image was null", (Object)bufferedImage);
        Assert.assertNotNull((String)"Actual image was null!", (Object)bufferedImage2);
        if (bufferedImage == bufferedImage2) {
            return;
        }
        int n = imageReadParam.getSubsamplingXOffset();
        int n2 = imageReadParam.getSubsamplingYOffset();
        int n3 = imageReadParam.getSourceXSubsampling();
        int n4 = imageReadParam.getSourceYSubsampling();
        Assert.assertEquals((String)"Subsampled image has wrong width: ", (long)((bufferedImage.getWidth() - n + n3 - 1) / n3), (long)bufferedImage2.getWidth());
        Assert.assertEquals((String)"Subsampled image has wrong height: ", (long)((bufferedImage.getHeight() - n2 + n4 - 1) / n4), (long)bufferedImage2.getHeight());
        Assert.assertEquals((String)"Subsampled has different type", (long)bufferedImage.getType(), (long)bufferedImage2.getType());
        for (int i = 0; i < bufferedImage2.getHeight(); ++i) {
            for (int j = 0; j < bufferedImage2.getWidth(); ++j) {
                int n5 = bufferedImage.getRGB(n + j * n3, n2 + i * n4);
                int n6 = bufferedImage2.getRGB(j, i);
                try {
                    Assert.assertEquals((String)String.format("%s alpha at (%d, %d)", string, j, i), (double)(n5 >>> 24 & 0xFF), (double)(n6 >>> 24 & 0xFF), (double)5.0);
                    Assert.assertEquals((String)String.format("%s red at (%d, %d)", string, j, i), (double)(n5 >> 16 & 0xFF), (double)(n6 >> 16 & 0xFF), (double)5.0);
                    Assert.assertEquals((String)String.format("%s green at (%d, %d)", string, j, i), (double)(n5 >> 8 & 0xFF), (double)(n6 >> 8 & 0xFF), (double)5.0);
                    Assert.assertEquals((String)String.format("%s blue at (%d, %d)", string, j, i), (double)(n5 & 0xFF), (double)(n6 & 0xFF), (double)5.0);
                    continue;
                }
                catch (AssertionError assertionError) {
                    File file = File.createTempFile("junit-expected-", ".png");
                    System.err.println("tempExpected.getAbsolutePath(): " + file.getAbsolutePath());
                    ImageIO.write((RenderedImage)bufferedImage, "PNG", file);
                    File file2 = File.createTempFile("junit-actual-", ".png");
                    System.err.println("tempActual.getAbsolutePath(): " + file2.getAbsolutePath());
                    ImageIO.write((RenderedImage)bufferedImage2, "PNG", file2);
                    Assert.assertEquals((String)String.format("%s ARGB at (%d, %d)", string, j, i), (Object)String.format("#%08x", n5), (Object)String.format("#%08x", n6));
                }
            }
        }
    }

    public static void assertImageDataEquals(String string, BufferedImage bufferedImage, BufferedImage bufferedImage2) {
        Assert.assertNotNull((String)"Expected image was null", (Object)bufferedImage);
        Assert.assertNotNull((String)"Actual image was null!", (Object)bufferedImage2);
        if (bufferedImage == bufferedImage2) {
            return;
        }
        for (int i = 0; i < bufferedImage.getHeight(); ++i) {
            for (int j = 0; j < bufferedImage.getWidth(); ++j) {
                int n = bufferedImage.getRGB(j, i);
                int n2 = bufferedImage2.getRGB(j, i);
                Assert.assertEquals((String)String.format("%s alpha at (%d, %d)", string, j, i), (double)(n >> 24 & 0xFF), (double)(n2 >> 24 & 0xFF), (double)5.0);
                Assert.assertEquals((String)String.format("%s red at (%d, %d)", string, j, i), (double)(n >> 16 & 0xFF), (double)(n2 >> 16 & 0xFF), (double)5.0);
                Assert.assertEquals((String)String.format("%s green at (%d, %d)", string, j, i), (double)(n >> 8 & 0xFF), (double)(n2 >> 8 & 0xFF), (double)5.0);
                Assert.assertEquals((String)String.format("%s blue at (%d, %d)", string, j, i), (double)(n & 0xFF), (double)(n2 & 0xFF), (double)5.0);
            }
        }
    }

    @Test
    public void testReadWithSourceRegionParam() {
        T t = this.createReader();
        TestData testData = this.getTestData().get(0);
        ((ImageReader)t).setInput(testData.getInputStream());
        ImageReadParam imageReadParam = ((ImageReader)t).getDefaultReadParam();
        imageReadParam.setSourceRegion(new Rectangle(0, 0, 10, 10));
        BufferedImage bufferedImage = null;
        try {
            bufferedImage = ((ImageReader)t).read(0, imageReadParam);
        }
        catch (IOException iOException) {
            ImageReaderAbstractTest.failBecause("Image could not be read", iOException);
        }
        Assert.assertNotNull((String)"Image was null!", (Object)bufferedImage);
        Assert.assertEquals((String)("Read image has wrong width: " + bufferedImage.getWidth()), (long)10L, (long)bufferedImage.getWidth());
        Assert.assertEquals((String)("Read image has wrong height: " + bufferedImage.getHeight()), (long)10L, (long)bufferedImage.getHeight());
        ((ImageReader)t).dispose();
    }

    @Test
    public void testReadWithSourceRegionParamEqualImage() throws IOException {
        this.assertReadWithSourceRegionParamEqualImage(new Rectangle(3, 3, 9, 9), this.getTestData().get(0), 0);
    }

    protected void assertReadWithSourceRegionParamEqualImage(Rectangle rectangle, TestData testData, int n) throws IOException {
        T t = this.createReader();
        ((ImageReader)t).setInput(testData.getInputStream());
        ImageReadParam imageReadParam = ((ImageReader)t).getDefaultReadParam();
        BufferedImage bufferedImage = ((ImageReader)t).read(n, imageReadParam).getSubimage(rectangle.x, rectangle.y, rectangle.width, rectangle.height);
        imageReadParam.setSourceRegion(rectangle);
        BufferedImage bufferedImage2 = ((ImageReader)t).read(n, imageReadParam);
        Assert.assertNotNull((String)"Image was null!", (Object)bufferedImage2);
        Assert.assertEquals((String)("Read image has wrong width: " + bufferedImage2.getWidth()), (long)rectangle.width, (long)bufferedImage2.getWidth());
        Assert.assertEquals((String)("Read image has wrong height: " + bufferedImage2.getHeight()), (long)rectangle.height, (long)bufferedImage2.getHeight());
        ImageReaderAbstractTest.assertImageDataEquals("Images differ", bufferedImage, bufferedImage2);
        ((ImageReader)t).dispose();
    }

    @Test
    public void testReadWithSizeAndSourceRegionParam() {
        T t = this.createReader();
        TestData testData = this.getTestData().get(0);
        ((ImageReader)t).setInput(testData.getInputStream());
        ImageReadParam imageReadParam = ((ImageReader)t).getDefaultReadParam();
        if (imageReadParam.canSetSourceRenderSize()) {
            Dimension dimension = testData.getDimension(0);
            dimension = new Dimension(dimension.width * 2, dimension.height * 2);
            imageReadParam.setSourceRenderSize(dimension);
            imageReadParam.setSourceRegion(new Rectangle(0, 0, 10, 10));
            BufferedImage bufferedImage = null;
            try {
                bufferedImage = ((ImageReader)t).read(0, imageReadParam);
            }
            catch (IOException iOException) {
                ImageReaderAbstractTest.failBecause("Image could not be read", iOException);
            }
            Assert.assertNotNull((String)"Image was null!", (Object)bufferedImage);
            Assert.assertEquals((String)("Read image has wrong width: " + bufferedImage.getWidth()), (long)10L, (long)bufferedImage.getWidth());
            Assert.assertEquals((String)("Read image has wrong height: " + bufferedImage.getHeight()), (long)10L, (long)bufferedImage.getHeight());
        }
        ((ImageReader)t).dispose();
    }

    @Test
    public void testReadWithSubsampleAndSourceRegionParam() {
        T t = this.createReader();
        TestData testData = this.getTestData().get(0);
        ((ImageReader)t).setInput(testData.getInputStream());
        ImageReadParam imageReadParam = ((ImageReader)t).getDefaultReadParam();
        imageReadParam.setSourceSubsampling(2, 2, 0, 0);
        imageReadParam.setSourceRegion(new Rectangle(0, 0, 10, 10));
        BufferedImage bufferedImage = null;
        try {
            bufferedImage = ((ImageReader)t).read(0, imageReadParam);
        }
        catch (IOException iOException) {
            ImageReaderAbstractTest.failBecause("Image could not be read", iOException);
        }
        Assert.assertNotNull((String)"Image was null!", (Object)bufferedImage);
        Assert.assertEquals((String)("Read image has wrong width: " + bufferedImage.getWidth()), (long)5L, (long)bufferedImage.getWidth());
        Assert.assertEquals((String)("Read image has wrong height: " + bufferedImage.getHeight()), (long)5L, (long)bufferedImage.getHeight());
        ((ImageReader)t).dispose();
    }

    @Test
    public void testReadAsRenderedImageIndexNegative() {
        T t = this.createReader();
        TestData testData = this.getTestData().get(0);
        ((ImageReader)t).setInput(testData.getInputStream());
        RenderedImage renderedImage = null;
        try {
            renderedImage = ((ImageReader)t).readAsRenderedImage(-1, ((ImageReader)t).getDefaultReadParam());
            Assert.fail((String)"Read image with illegal index");
        }
        catch (IndexOutOfBoundsException indexOutOfBoundsException) {
        }
        catch (IOException iOException) {
            ImageReaderAbstractTest.failBecause("Image could not be read", iOException);
        }
        Assert.assertNull(renderedImage);
        ((ImageReader)t).dispose();
    }

    @Test
    public void testReadAsRenderedImageIndexOutOfBounds() throws IIOException {
        T t = this.createReader();
        TestData testData = this.getTestData().get(0);
        ((ImageReader)t).setInput(testData.getInputStream());
        RenderedImage renderedImage = null;
        try {
            renderedImage = ((ImageReader)t).readAsRenderedImage(((ImageReader)t).getNumImages(true), ((ImageReader)t).getDefaultReadParam());
            Assert.fail((String)"Read image with index out of bounds");
        }
        catch (IndexOutOfBoundsException indexOutOfBoundsException) {
        }
        catch (IIOException iIOException) {
            throw iIOException;
        }
        catch (IOException iOException) {
            ImageReaderAbstractTest.failBecause("Image could not be read", iOException);
        }
        Assert.assertNull(renderedImage);
        ((ImageReader)t).dispose();
    }

    @Test
    public void testReadAsRenderedImageNoInput() {
        T t = this.createReader();
        RenderedImage renderedImage = null;
        try {
            renderedImage = ((ImageReader)t).readAsRenderedImage(0, ((ImageReader)t).getDefaultReadParam());
            Assert.fail((String)"Read image with no input");
        }
        catch (IllegalStateException illegalStateException) {
        }
        catch (IOException iOException) {
            ImageReaderAbstractTest.failBecause("Image could not be read", iOException);
        }
        Assert.assertNull(renderedImage);
        ((ImageReader)t).dispose();
    }

    @Test
    public void testReadAsRenderedImage() {
        T t = this.createReader();
        TestData testData = this.getTestData().get(0);
        ((ImageReader)t).setInput(testData.getInputStream());
        RenderedImage renderedImage = null;
        try {
            renderedImage = ((ImageReader)t).readAsRenderedImage(0, null);
        }
        catch (IOException iOException) {
            ImageReaderAbstractTest.failBecause("Image could not be read", iOException);
        }
        Assert.assertNotNull((String)"Image was null!", (Object)renderedImage);
        Assert.assertEquals((String)("Read image has wrong width: " + renderedImage.getWidth()), (long)testData.getDimension((int)0).width, (long)renderedImage.getWidth());
        Assert.assertEquals((String)("Read image has wrong height: " + renderedImage.getHeight()), (long)testData.getDimension((int)0).height, (long)renderedImage.getHeight());
        ((ImageReader)t).dispose();
    }

    @Test
    public void testReadAsRenderedImageWithDefaultParam() {
        T t = this.createReader();
        TestData testData = this.getTestData().get(0);
        ((ImageReader)t).setInput(testData.getInputStream());
        RenderedImage renderedImage = null;
        try {
            renderedImage = ((ImageReader)t).readAsRenderedImage(0, ((ImageReader)t).getDefaultReadParam());
        }
        catch (IOException iOException) {
            ImageReaderAbstractTest.failBecause("Image could not be read", iOException);
        }
        Assert.assertNotNull((String)"Image was null!", (Object)renderedImage);
        Assert.assertEquals((String)("Read image has wrong width: " + renderedImage.getWidth()), (long)testData.getDimension((int)0).width, (long)renderedImage.getWidth());
        Assert.assertEquals((String)("Read image has wrong height: " + renderedImage.getHeight()), (long)testData.getDimension((int)0).height, (long)renderedImage.getHeight());
        ((ImageReader)t).dispose();
    }

    @Test
    public void testGetDefaultReadParam() {
        T t = this.createReader();
        ImageReadParam imageReadParam = ((ImageReader)t).getDefaultReadParam();
        Assert.assertNotNull((Object)imageReadParam);
        ((ImageReader)t).dispose();
    }

    @Test
    public void testGetFormatName() {
        T t = this.createReader();
        TestData testData = this.getTestData().get(0);
        ((ImageReader)t).setInput(testData.getInputStream());
        String string = null;
        try {
            string = ((ImageReader)t).getFormatName();
        }
        catch (IOException iOException) {
            Assert.fail((String)iOException.getMessage());
        }
        Assert.assertNotNull((Object)string);
        ((ImageReader)t).dispose();
    }

    @Test
    public void testGetMinIndex() {
        T t = this.createReader();
        TestData testData = this.getTestData().get(0);
        ((ImageReader)t).setInput(testData.getInputStream());
        int n = 0;
        try {
            n = ((ImageReader)t).getMinIndex();
        }
        catch (IllegalStateException illegalStateException) {
            // empty catch block
        }
        Assert.assertEquals((long)0L, (long)n);
        ((ImageReader)t).dispose();
    }

    @Test
    public void testGetMinIndexNoInput() {
        T t = this.createReader();
        int n = 0;
        try {
            n = ((ImageReader)t).getMinIndex();
        }
        catch (IllegalStateException illegalStateException) {
            // empty catch block
        }
        Assert.assertEquals((long)0L, (long)n);
        ((ImageReader)t).dispose();
    }

    @Test
    public void testGetNumImages() {
        T t = this.createReader();
        TestData testData = this.getTestData().get(0);
        ((ImageReader)t).setInput(testData.getInputStream());
        int n = -1;
        try {
            n = ((ImageReader)t).getNumImages(false);
        }
        catch (IOException iOException) {
            Assert.fail((String)iOException.getMessage());
        }
        Assert.assertTrue((n == -1 || n > 0 ? 1 : 0) != 0);
        try {
            n = ((ImageReader)t).getNumImages(true);
        }
        catch (IOException iOException) {
            Assert.fail((String)iOException.getMessage());
        }
        Assert.assertTrue((n > 0 ? 1 : 0) != 0);
        Assert.assertTrue((testData.getImageCount() <= n ? 1 : 0) != 0);
        if (testData.getImageCount() != n) {
            System.err.println("WARNING: Image count not equal to test data count");
        }
        ((ImageReader)t).dispose();
    }

    @Test
    public void testGetNumImagesNoInput() {
        T t = this.createReader();
        int n = -1;
        try {
            n = ((ImageReader)t).getNumImages(false);
        }
        catch (IllegalStateException illegalStateException) {
        }
        catch (IOException iOException) {
            Assert.fail((String)iOException.getMessage());
        }
        Assert.assertEquals((long)-1L, (long)n);
        try {
            n = ((ImageReader)t).getNumImages(true);
            Assert.fail((String)"Should throw IllegalStateException");
        }
        catch (IllegalStateException illegalStateException) {
        }
        catch (IOException iOException) {
            Assert.fail((String)iOException.getMessage());
        }
        Assert.assertEquals((long)-1L, (long)n);
        ((ImageReader)t).dispose();
    }

    @Test
    public void testGetWidth() {
        T t = this.createReader();
        TestData testData = this.getTestData().get(0);
        ((ImageReader)t).setInput(testData.getInputStream());
        int n = 0;
        try {
            n = ((ImageReader)t).getWidth(0);
        }
        catch (IOException iOException) {
            Assert.fail((String)("Could not read image width: " + iOException));
        }
        Assert.assertEquals((String)"Wrong width reported", (long)testData.getDimension((int)0).width, (long)n);
        ((ImageReader)t).dispose();
    }

    @Test
    public void testGetWidthIndexOutOfBounds() {
        T t = this.createReader();
        TestData testData = this.getTestData().get(0);
        ((ImageReader)t).setInput(testData.getInputStream());
        try {
            ((ImageReader)t).getWidth(-1);
        }
        catch (IndexOutOfBoundsException indexOutOfBoundsException) {
        }
        catch (IOException iOException) {
            Assert.fail((String)("Could not read image aspect ratio: " + iOException));
        }
        ((ImageReader)t).dispose();
    }

    @Test
    public void testGetWidthNoInput() {
        T t = this.createReader();
        int n = 0;
        try {
            n = ((ImageReader)t).getWidth(0);
            Assert.fail((String)"Width read without imput");
        }
        catch (IllegalStateException illegalStateException) {
        }
        catch (IOException iOException) {
            Assert.fail((String)("Could not read image width: " + iOException));
        }
        Assert.assertEquals((String)"Wrong width reported", (long)0L, (long)n);
        ((ImageReader)t).dispose();
    }

    @Test
    public void testGetHeight() {
        T t = this.createReader();
        TestData testData = this.getTestData().get(0);
        ((ImageReader)t).setInput(testData.getInputStream());
        int n = 0;
        try {
            n = ((ImageReader)t).getHeight(0);
        }
        catch (IOException iOException) {
            Assert.fail((String)("Could not read image height: " + iOException));
        }
        Assert.assertEquals((String)"Wrong height reported", (long)testData.getDimension((int)0).height, (long)n);
        ((ImageReader)t).dispose();
    }

    @Test
    public void testGetHeightNoInput() {
        T t = this.createReader();
        int n = 0;
        try {
            n = ((ImageReader)t).getHeight(0);
            Assert.fail((String)"height read without imput");
        }
        catch (IllegalStateException illegalStateException) {
        }
        catch (IOException iOException) {
            Assert.fail((String)("Could not read image height: " + iOException));
        }
        Assert.assertEquals((String)"Wrong height reported", (long)0L, (long)n);
        ((ImageReader)t).dispose();
    }

    @Test
    public void testGetHeightIndexOutOfBounds() {
        T t = this.createReader();
        TestData testData = this.getTestData().get(0);
        ((ImageReader)t).setInput(testData.getInputStream());
        try {
            ((ImageReader)t).getHeight(-1);
        }
        catch (IndexOutOfBoundsException indexOutOfBoundsException) {
        }
        catch (IOException iOException) {
            Assert.fail((String)("Could not read image height: " + iOException));
        }
        ((ImageReader)t).dispose();
    }

    @Test
    public void testGetAspectRatio() {
        T t = this.createReader();
        TestData testData = this.getTestData().get(0);
        ((ImageReader)t).setInput(testData.getInputStream());
        float f = 0.0f;
        try {
            f = ((ImageReader)t).getAspectRatio(0);
        }
        catch (IOException iOException) {
            Assert.fail((String)("Could not read image aspect ratio" + iOException));
        }
        Dimension dimension = testData.getDimension(0);
        Assert.assertEquals((String)"Wrong aspect aspect ratio", (double)(dimension.getWidth() / dimension.getHeight()), (double)f, (double)0.001);
        ((ImageReader)t).dispose();
    }

    @Test
    public void testGetAspectRatioNoInput() {
        T t = this.createReader();
        float f = 0.0f;
        try {
            f = ((ImageReader)t).getAspectRatio(0);
            Assert.fail((String)"aspect read without input");
        }
        catch (IllegalStateException illegalStateException) {
        }
        catch (IOException iOException) {
            Assert.fail((String)("Could not read image aspect ratio" + iOException));
        }
        Assert.assertEquals((String)"Wrong aspect aspect ratio", (double)0.0, (double)f, (double)0.0);
        ((ImageReader)t).dispose();
    }

    @Test
    public void testGetAspectRatioIndexOutOfBounds() {
        T t = this.createReader();
        TestData testData = this.getTestData().get(0);
        ((ImageReader)t).setInput(testData.getInputStream());
        try {
            ((ImageReader)t).getAspectRatio(-1);
        }
        catch (IndexOutOfBoundsException indexOutOfBoundsException) {
        }
        catch (IOException iOException) {
            Assert.fail((String)("Could not read image aspect ratio" + iOException));
        }
        ((ImageReader)t).dispose();
    }

    @Test
    public void testDisposeBeforeRead() {
        T t = this.createReader();
        ((ImageReader)t).dispose();
    }

    @Test
    public void testDisposeAfterRead() {
        T t = this.createReader();
        TestData testData = this.getTestData().get(0);
        ((ImageReader)t).setInput(testData.getInputStream());
        ((ImageReader)t).dispose();
    }

    @Test
    public void testAddIIOReadProgressListener() {
        T t = this.createReader();
        ((ImageReader)t).addIIOReadProgressListener((IIOReadProgressListener)Mockito.mock(IIOReadProgressListener.class));
        ((ImageReader)t).dispose();
    }

    @Test
    public void testAddIIOReadProgressListenerNull() {
        T t = this.createReader();
        ((ImageReader)t).addIIOReadProgressListener(null);
        ((ImageReader)t).dispose();
    }

    @Test
    public void testAddIIOReadProgressListenerCallbacks() {
        T t = this.createReader();
        TestData testData = this.getTestData().get(0);
        ((ImageReader)t).setInput(testData.getInputStream());
        IIOReadProgressListener iIOReadProgressListener = (IIOReadProgressListener)Mockito.mock(IIOReadProgressListener.class);
        ((ImageReader)t).addIIOReadProgressListener(iIOReadProgressListener);
        try {
            ((ImageReader)t).read(0);
        }
        catch (IOException iOException) {
            Assert.fail((String)"Could not read image");
        }
        InOrder inOrder = Mockito.inOrder((Object[])new Object[]{iIOReadProgressListener});
        ((IIOReadProgressListener)inOrder.verify((Object)iIOReadProgressListener)).imageStarted((ImageReader)t, 0);
        ((IIOReadProgressListener)inOrder.verify((Object)iIOReadProgressListener, Mockito.atLeastOnce())).imageProgress((ImageReader)Mockito.eq(t), Mockito.anyInt());
        ((IIOReadProgressListener)inOrder.verify((Object)iIOReadProgressListener)).imageComplete((ImageReader)t);
        ((ImageReader)t).dispose();
    }

    @Test
    public void testMultipleAddIIOReadProgressListenerCallbacks() {
        T t = this.createReader();
        TestData testData = this.getTestData().get(0);
        ((ImageReader)t).setInput(testData.getInputStream());
        IIOReadProgressListener iIOReadProgressListener = (IIOReadProgressListener)Mockito.mock(IIOReadProgressListener.class);
        IIOReadProgressListener iIOReadProgressListener2 = (IIOReadProgressListener)Mockito.mock(IIOReadProgressListener.class);
        IIOReadProgressListener iIOReadProgressListener3 = (IIOReadProgressListener)Mockito.mock(IIOReadProgressListener.class);
        ((ImageReader)t).addIIOReadProgressListener(iIOReadProgressListener);
        ((ImageReader)t).addIIOReadProgressListener(iIOReadProgressListener2);
        ((ImageReader)t).addIIOReadProgressListener(iIOReadProgressListener3);
        try {
            ((ImageReader)t).read(0);
        }
        catch (IOException iOException) {
            Assert.fail((String)"Could not read image");
        }
        InOrder inOrder = Mockito.inOrder((Object[])new Object[]{iIOReadProgressListener, iIOReadProgressListener2, iIOReadProgressListener3});
        ((IIOReadProgressListener)inOrder.verify((Object)iIOReadProgressListener)).imageStarted((ImageReader)t, 0);
        ((IIOReadProgressListener)inOrder.verify((Object)iIOReadProgressListener2)).imageStarted((ImageReader)t, 0);
        ((IIOReadProgressListener)inOrder.verify((Object)iIOReadProgressListener3)).imageStarted((ImageReader)t, 0);
        ((IIOReadProgressListener)inOrder.verify((Object)iIOReadProgressListener, Mockito.atLeastOnce())).imageProgress((ImageReader)Mockito.eq(t), Mockito.anyInt());
        ((IIOReadProgressListener)inOrder.verify((Object)iIOReadProgressListener2, Mockito.atLeastOnce())).imageProgress((ImageReader)Mockito.eq(t), Mockito.anyInt());
        ((IIOReadProgressListener)inOrder.verify((Object)iIOReadProgressListener3, Mockito.atLeastOnce())).imageProgress((ImageReader)Mockito.eq(t), Mockito.anyInt());
        ((IIOReadProgressListener)inOrder.verify((Object)iIOReadProgressListener)).imageComplete((ImageReader)t);
        ((IIOReadProgressListener)inOrder.verify((Object)iIOReadProgressListener2)).imageComplete((ImageReader)t);
        ((IIOReadProgressListener)inOrder.verify((Object)iIOReadProgressListener3)).imageComplete((ImageReader)t);
        ((ImageReader)t).dispose();
    }

    @Test
    public void testRemoveIIOReadProgressListenerNull() {
        T t = this.createReader();
        ((ImageReader)t).removeIIOReadProgressListener(null);
        ((ImageReader)t).dispose();
    }

    @Test
    public void testRemoveIIOReadProgressListenerNone() {
        T t = this.createReader();
        ((ImageReader)t).removeIIOReadProgressListener((IIOReadProgressListener)Mockito.mock(IIOReadProgressListener.class));
        ((ImageReader)t).dispose();
    }

    @Test
    public void testRemoveIIOReadProgressListener() {
        T t = this.createReader();
        TestData testData = this.getTestData().get(0);
        ((ImageReader)t).setInput(testData.getInputStream());
        IIOReadProgressListener iIOReadProgressListener = (IIOReadProgressListener)Mockito.mock(IIOReadProgressListener.class);
        ((ImageReader)t).addIIOReadProgressListener(iIOReadProgressListener);
        ((ImageReader)t).removeIIOReadProgressListener(iIOReadProgressListener);
        try {
            ((ImageReader)t).read(0);
        }
        catch (IOException iOException) {
            Assert.fail((String)"Could not read image");
        }
        Mockito.verifyZeroInteractions((Object[])new Object[]{iIOReadProgressListener});
        ((ImageReader)t).dispose();
    }

    @Test
    public void testRemoveIIOReadProgressListenerMultiple() {
        T t = this.createReader();
        TestData testData = this.getTestData().get(0);
        ((ImageReader)t).setInput(testData.getInputStream());
        IIOReadProgressListener iIOReadProgressListener = (IIOReadProgressListener)Mockito.mock(IIOReadProgressListener.class, (String)"Listener1");
        ((ImageReader)t).addIIOReadProgressListener(iIOReadProgressListener);
        IIOReadProgressListener iIOReadProgressListener2 = (IIOReadProgressListener)Mockito.mock(IIOReadProgressListener.class, (String)"Listener2");
        ((ImageReader)t).addIIOReadProgressListener(iIOReadProgressListener2);
        ((ImageReader)t).removeIIOReadProgressListener(iIOReadProgressListener);
        try {
            ((ImageReader)t).read(0);
        }
        catch (IOException iOException) {
            Assert.fail((String)"Could not read image");
        }
        Mockito.verifyZeroInteractions((Object[])new Object[]{iIOReadProgressListener});
        InOrder inOrder = Mockito.inOrder((Object[])new Object[]{iIOReadProgressListener2});
        ((IIOReadProgressListener)inOrder.verify((Object)iIOReadProgressListener2)).imageStarted((ImageReader)t, 0);
        ((IIOReadProgressListener)inOrder.verify((Object)iIOReadProgressListener2, Mockito.atLeastOnce())).imageProgress((ImageReader)Mockito.eq(t), Mockito.anyInt());
        ((IIOReadProgressListener)inOrder.verify((Object)iIOReadProgressListener2)).imageComplete((ImageReader)t);
        ((ImageReader)t).dispose();
    }

    @Test
    public void testRemoveAllIIOReadProgressListeners() {
        T t = this.createReader();
        TestData testData = this.getTestData().get(0);
        ((ImageReader)t).setInput(testData.getInputStream());
        IIOReadProgressListener iIOReadProgressListener = (IIOReadProgressListener)Mockito.mock(IIOReadProgressListener.class);
        ((ImageReader)t).addIIOReadProgressListener(iIOReadProgressListener);
        ((ImageReader)t).removeAllIIOReadProgressListeners();
        try {
            ((ImageReader)t).read(0);
        }
        catch (IOException iOException) {
            Assert.fail((String)"Could not read image");
        }
        Mockito.verifyZeroInteractions((Object[])new Object[]{iIOReadProgressListener});
        ((ImageReader)t).dispose();
    }

    @Test
    public void testRemoveAllIIOReadProgressListenersMultiple() {
        T t = this.createReader();
        TestData testData = this.getTestData().get(0);
        ((ImageReader)t).setInput(testData.getInputStream());
        IIOReadProgressListener iIOReadProgressListener = (IIOReadProgressListener)Mockito.mock(IIOReadProgressListener.class);
        ((ImageReader)t).addIIOReadProgressListener(iIOReadProgressListener);
        IIOReadProgressListener iIOReadProgressListener2 = (IIOReadProgressListener)Mockito.mock(IIOReadProgressListener.class);
        ((ImageReader)t).addIIOReadProgressListener(iIOReadProgressListener2);
        ((ImageReader)t).removeAllIIOReadProgressListeners();
        try {
            ((ImageReader)t).read(0);
        }
        catch (IOException iOException) {
            Assert.fail((String)"Could not read image");
        }
        Mockito.verifyZeroInteractions((Object[])new Object[]{iIOReadProgressListener});
        Mockito.verifyZeroInteractions((Object[])new Object[]{iIOReadProgressListener2});
        ((ImageReader)t).dispose();
    }

    @Test
    public void testAbort() {
        final T t = this.createReader();
        TestData testData = this.getTestData().get(0);
        ((ImageReader)t).setInput(testData.getInputStream());
        IIOReadProgressListener iIOReadProgressListener = (IIOReadProgressListener)Mockito.mock(IIOReadProgressListener.class, (String)"Progress1");
        ((ImageReader)t).addIIOReadProgressListener(iIOReadProgressListener);
        IIOReadProgressListener iIOReadProgressListener2 = (IIOReadProgressListener)Mockito.mock(IIOReadProgressListener.class, (String)"Progress2");
        ((ImageReader)t).addIIOReadProgressListener(iIOReadProgressListener2);
        IIOReadProgressListener iIOReadProgressListener3 = (IIOReadProgressListener)Mockito.mock(IIOReadProgressListener.class, (String)"Aborter");
        Answer<Void> answer = new Answer<Void>(){

            public Void answer(InvocationOnMock invocationOnMock) throws Throwable {
                t.abort();
                return null;
            }
        };
        ((IIOReadProgressListener)Mockito.doAnswer((Answer)answer).when((Object)iIOReadProgressListener3)).imageStarted((ImageReader)Mockito.any(ImageReader.class), Mockito.anyInt());
        ((IIOReadProgressListener)Mockito.doAnswer((Answer)answer).when((Object)iIOReadProgressListener3)).imageProgress((ImageReader)Mockito.any(ImageReader.class), Mockito.anyInt());
        ((ImageReader)t).addIIOReadProgressListener(iIOReadProgressListener3);
        try {
            ((ImageReader)t).read(0);
        }
        catch (IOException iOException) {
            ImageReaderAbstractTest.failBecause("Image could not be read", iOException);
        }
        ((IIOReadProgressListener)Mockito.verify((Object)iIOReadProgressListener)).readAborted((ImageReader)t);
        ((IIOReadProgressListener)Mockito.verify((Object)iIOReadProgressListener2)).readAborted((ImageReader)t);
        ((ImageReader)t).dispose();
    }

    @Test
    public void testGetTypeSpecifiers() throws IOException {
        T t = this.createReader();
        for (TestData testData : this.getTestData()) {
            ((ImageReader)t).setInput(testData.getInputStream());
            ImageTypeSpecifier imageTypeSpecifier = ((ImageReader)t).getRawImageType(0);
            if (imageTypeSpecifier == null && this.allowsNullRawImageType()) continue;
            Assert.assertNotNull((Object)imageTypeSpecifier);
            Iterator<ImageTypeSpecifier> iterator = ((ImageReader)t).getImageTypes(0);
            Assert.assertNotNull(iterator);
            Assert.assertTrue((boolean)iterator.hasNext());
            boolean bl = false;
            while (iterator.hasNext()) {
                ImageTypeSpecifier imageTypeSpecifier2 = iterator.next();
                if (!imageTypeSpecifier2.equals(imageTypeSpecifier)) continue;
                bl = true;
                break;
            }
            Assert.assertTrue((String)"ImageTypeSepcifier from getRawImageType should be in the iterator from getImageTypes", (boolean)bl);
        }
        ((ImageReader)t).dispose();
    }

    @Test
    public void testSetDestination() throws IOException {
        T t = this.createReader();
        TestData testData = this.getTestData().get(0);
        ((ImageReader)t).setInput(testData.getInputStream());
        ImageReadParam imageReadParam = ((ImageReader)t).getDefaultReadParam();
        Iterator<ImageTypeSpecifier> iterator = ((ImageReader)t).getImageTypes(0);
        while (iterator.hasNext()) {
            ImageTypeSpecifier imageTypeSpecifier = iterator.next();
            BufferedImage bufferedImage = imageTypeSpecifier.createBufferedImage(50, 50);
            imageReadParam.setDestination(bufferedImage);
            BufferedImage bufferedImage2 = null;
            try {
                bufferedImage2 = ((ImageReader)t).read(0, imageReadParam);
            }
            catch (Exception exception) {
                ImageReaderAbstractTest.failBecause("Could not read " + testData.getInput() + " with explicit destination " + bufferedImage, exception);
            }
            Assert.assertSame((Object)bufferedImage, (Object)bufferedImage2);
        }
        ((ImageReader)t).dispose();
    }

    @Test
    public void testSetDestinationRaw() throws IOException {
        T t = this.createReader();
        TestData testData = this.getTestData().get(0);
        ((ImageReader)t).setInput(testData.getInputStream());
        ImageReadParam imageReadParam = ((ImageReader)t).getDefaultReadParam();
        ImageTypeSpecifier imageTypeSpecifier = ((ImageReader)t).getRawImageType(0);
        if (imageTypeSpecifier != null) {
            BufferedImage bufferedImage = imageTypeSpecifier.createBufferedImage(((ImageReader)t).getWidth(0), ((ImageReader)t).getHeight(0));
            imageReadParam.setDestination(bufferedImage);
            BufferedImage bufferedImage2 = null;
            try {
                bufferedImage2 = ((ImageReader)t).read(0, imageReadParam);
            }
            catch (Exception exception) {
                ImageReaderAbstractTest.failBecause("Image could not be read", exception);
            }
            Assert.assertSame((Object)bufferedImage, (Object)bufferedImage2);
        } else {
            System.err.println("WARNING: Test skipped due to reader.getRawImageType(0) returning null");
        }
        ((ImageReader)t).dispose();
    }

    @Test
    public void testSetDestinationIllegal() throws IOException {
        T t = this.createReader();
        TestData testData = this.getTestData().get(0);
        ((ImageReader)t).setInput(testData.getInputStream());
        List<ImageTypeSpecifier> list = this.createIllegalTypes(((ImageReader)t).getImageTypes(0));
        ImageReadParam imageReadParam = ((ImageReader)t).getDefaultReadParam();
        for (ImageTypeSpecifier imageTypeSpecifier : list) {
            String string;
            BufferedImage bufferedImage = imageTypeSpecifier.createBufferedImage(50, 50);
            imageReadParam.setDestination(bufferedImage);
            try {
                BufferedImage bufferedImage2 = ((ImageReader)t).read(0, imageReadParam);
                System.err.println("WARNING: Reader does not throw exception with non-declared destination: " + bufferedImage);
                Assert.assertSame((Object)bufferedImage, (Object)bufferedImage2);
            }
            catch (IIOException iIOException) {
                string = iIOException.getMessage().toLowerCase();
                if (string.contains("destination") || string.contains("band size") || (bufferedImage.getType() == 12 || bufferedImage.getType() == 13) && string.contains("indexcolormodel")) continue;
                ImageReaderAbstractTest.failBecause("Wrong message: " + string + " for type " + bufferedImage.getType(), iIOException);
            }
            catch (IllegalArgumentException illegalArgumentException) {
                string = illegalArgumentException.getMessage().toLowerCase();
                Assert.assertTrue((String)("Wrong message: " + string), (boolean)string.contains("dest"));
            }
        }
        ((ImageReader)t).dispose();
    }

    @Test
    public void testSetDestinationTypeIllegal() throws IOException {
        T t = this.createReader();
        TestData testData = this.getTestData().get(0);
        ((ImageReader)t).setInput(testData.getInputStream());
        List<ImageTypeSpecifier> list = this.createIllegalTypes(((ImageReader)t).getImageTypes(0));
        ImageReadParam imageReadParam = ((ImageReader)t).getDefaultReadParam();
        for (ImageTypeSpecifier imageTypeSpecifier : list) {
            imageReadParam.setDestinationType(imageTypeSpecifier);
            try {
                ((ImageReader)t).read(0, imageReadParam);
                Assert.fail((String)"Expected to throw exception with illegal type specifier");
            }
            catch (IllegalArgumentException | IIOException exception) {
                String string = exception.getMessage().toLowerCase();
                if (string.contains("destination") && string.contains("type") || string.contains("num source & dest bands differ")) continue;
                throw exception;
            }
        }
        ((ImageReader)t).dispose();
    }

    private List<ImageTypeSpecifier> createIllegalTypes(Iterator<ImageTypeSpecifier> iterator) {
        ArrayList<ImageTypeSpecifier> arrayList = new ArrayList<ImageTypeSpecifier>();
        for (int i = 1; i < 13; ++i) {
            arrayList.add(ImageTypeSpecifier.createFromBufferedImageType(i));
        }
        ArrayList<ImageTypeSpecifier> arrayList2 = new ArrayList<ImageTypeSpecifier>(arrayList);
        while (iterator.hasNext()) {
            ImageTypeSpecifier imageTypeSpecifier = iterator.next();
            boolean bl = arrayList2.remove(imageTypeSpecifier);
            if (bl) continue;
            Iterator iterator2 = arrayList2.iterator();
            while (iterator2.hasNext()) {
                ImageTypeSpecifier imageTypeSpecifier2 = (ImageTypeSpecifier)iterator2.next();
                if (imageTypeSpecifier2.getBufferedImageType() != imageTypeSpecifier.getBufferedImageType()) continue;
                iterator2.remove();
            }
        }
        return arrayList2;
    }

    @Test
    public void testSetDestinationOffset() throws IOException {
        T t = this.createReader();
        TestData testData = this.getTestData().get(0);
        ((ImageReader)t).setInput(testData.getInputStream());
        ImageReadParam imageReadParam = ((ImageReader)t).getDefaultReadParam();
        Point point = new Point(37, 42);
        imageReadParam.setDestinationOffset(point);
        BufferedImage bufferedImage = ((ImageReader)t).read(0, imageReadParam);
        Assert.assertNotNull((Object)bufferedImage);
        Assert.assertEquals((long)(((ImageReader)t).getWidth(0) + point.x), (long)bufferedImage.getWidth());
        Assert.assertEquals((long)(((ImageReader)t).getHeight(0) + point.y), (long)bufferedImage.getHeight());
        ((ImageReader)t).dispose();
    }

    @Test
    public void testSetDestinationOffsetNull() throws IOException {
        T t = this.createReader();
        TestData testData = this.getTestData().get(0);
        ((ImageReader)t).setInput(testData.getInputStream());
        ImageReadParam imageReadParam = ((ImageReader)t).getDefaultReadParam();
        try {
            imageReadParam.setDestinationOffset(null);
            Assert.fail((String)"Null offset not allowed");
        }
        catch (IllegalArgumentException illegalArgumentException) {
            Assert.assertTrue((boolean)illegalArgumentException.getMessage().toLowerCase().contains("offset"));
        }
        ((ImageReader)t).dispose();
    }

    @Test
    public void testSetDestinationType() throws IOException {
        T t = this.createReader();
        TestData testData = this.getTestData().get(0);
        ((ImageReader)t).setInput(testData.getInputStream());
        ImageReadParam imageReadParam = ((ImageReader)t).getDefaultReadParam();
        Iterator<ImageTypeSpecifier> iterator = ((ImageReader)t).getImageTypes(0);
        while (iterator.hasNext()) {
            ImageTypeSpecifier imageTypeSpecifier = iterator.next();
            imageReadParam.setDestinationType(imageTypeSpecifier);
            BufferedImage bufferedImage = null;
            try {
                bufferedImage = ((ImageReader)t).read(0, imageReadParam);
            }
            catch (Exception exception) {
                ImageReaderAbstractTest.failBecause("Could not read " + testData.getInput() + " with explicit destination type " + imageTypeSpecifier, exception);
            }
            Assert.assertNotNull((Object)bufferedImage);
            Assert.assertEquals((Object)imageTypeSpecifier.getColorModel(), (Object)bufferedImage.getColorModel());
            SampleModel sampleModel = imageTypeSpecifier.getSampleModel();
            SampleModel sampleModel2 = bufferedImage.getSampleModel();
            Assert.assertEquals((long)sampleModel.getDataType(), (long)sampleModel2.getDataType());
            Assert.assertEquals((long)sampleModel.getNumBands(), (long)sampleModel2.getNumBands());
            Assert.assertEquals((long)sampleModel.getNumDataElements(), (long)sampleModel2.getNumDataElements());
            Assert.assertTrue((boolean)Arrays.equals(sampleModel.getSampleSize(), sampleModel2.getSampleSize()));
            Assert.assertEquals((long)sampleModel.getTransferType(), (long)sampleModel2.getTransferType());
            for (int i = 0; i < sampleModel.getNumBands(); ++i) {
                Assert.assertEquals((long)sampleModel.getSampleSize(i), (long)sampleModel2.getSampleSize(i));
            }
        }
        ((ImageReader)t).dispose();
    }

    @Test
    public void testNotBadCaching() throws IOException {
        T t = this.createReader();
        TestData testData = this.getTestData().get(0);
        ((ImageReader)t).setInput(testData.getInputStream());
        BufferedImage bufferedImage = ((ImageReader)t).read(0);
        BufferedImage bufferedImage2 = ((ImageReader)t).read(0);
        Assert.assertNotSame((String)"Multiple reads return same (mutable) image", (Object)bufferedImage, (Object)bufferedImage2);
        bufferedImage.setRGB(0, 0, Color.BLUE.getRGB());
        bufferedImage2.setRGB(0, 0, Color.RED.getRGB());
        Assert.assertTrue((bufferedImage.getRGB(0, 0) != bufferedImage2.getRGB(0, 0) ? 1 : 0) != 0);
        ((ImageReader)t).dispose();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testNotBadCachingThumbnails() throws IOException {
        T t = this.createReader();
        if (((ImageReader)t).readerSupportsThumbnails()) {
            for (TestData testData : this.getTestData()) {
                ((ImageReader)t).setInput(testData.getInputStream());
                int n = ((ImageReader)t).getNumImages(true);
                for (int i = 0; i < n; ++i) {
                    int n2 = ((ImageReader)t).getNumThumbnails(0);
                    for (int j = 0; j < n2; ++j) {
                        BufferedImage bufferedImage = ((ImageReader)t).readThumbnail(i, j);
                        BufferedImage bufferedImage2 = ((ImageReader)t).readThumbnail(i, j);
                        Assert.assertNotSame((String)"Multiple reads return same (mutable) image", (Object)bufferedImage, (Object)bufferedImage2);
                        Graphics2D graphics2D = bufferedImage.createGraphics();
                        try {
                            graphics2D.setColor(Color.WHITE);
                            graphics2D.setXORMode(Color.BLACK);
                            graphics2D.fillRect(0, 0, bufferedImage.getWidth(), bufferedImage.getHeight());
                        }
                        finally {
                            graphics2D.dispose();
                        }
                        Assert.assertTrue((bufferedImage.getRGB(0, 0) != bufferedImage2.getRGB(0, 0) ? 1 : 0) != 0);
                    }
                    if (n2 <= 0) continue;
                    return;
                }
            }
            Assert.fail((String)"No thumbnails tested for reader that supports thumbnails.");
        }
        ((ImageReader)t).dispose();
    }

    @Ignore(value="TODO: Implement")
    @Test
    public void testSetDestinationBands() throws IOException {
        throw new UnsupportedOperationException("Method testSetDestinationBands not implemented");
    }

    @Ignore(value="TODO: Implement")
    @Test
    public void testSetSourceBands() throws IOException {
        throw new UnsupportedOperationException("Method testSetDestinationBands not implemented");
    }

    @Test
    public void testProviderAndMetadataFormatNamesMatch() throws IOException {
        IIOMetadata iIOMetadata;
        ImageReaderSpi imageReaderSpi = this.createProvider();
        T t = this.createReader();
        ((ImageReader)t).setInput(this.getTestData().get(0).getInputStream());
        IIOMetadata iIOMetadata2 = ((ImageReader)t).getImageMetadata(0);
        if (iIOMetadata2 != null) {
            Assert.assertEquals((Object)imageReaderSpi.getNativeImageMetadataFormatName(), (Object)iIOMetadata2.getNativeMetadataFormatName());
        }
        if ((iIOMetadata = ((ImageReader)t).getStreamMetadata()) != null) {
            Assert.assertEquals((Object)imageReaderSpi.getNativeStreamMetadataFormatName(), (Object)iIOMetadata.getNativeMetadataFormatName());
        }
        ((ImageReader)t).dispose();
    }

    protected URL getClassLoaderResource(String string) {
        return this.getClass().getResource(string);
    }

    public static void assertRGBEquals(String string, int n, int n2, int n3) {
        try {
            Assert.assertEquals((double)(n >>> 24 & 0xFF), (double)(n2 >>> 24 & 0xFF), (double)0.0);
            Assert.assertEquals((double)(n >> 16 & 0xFF), (double)(n2 >> 16 & 0xFF), (double)n3);
            Assert.assertEquals((double)(n >> 8 & 0xFF), (double)(n2 >> 8 & 0xFF), (double)n3);
            Assert.assertEquals((double)(n & 0xFF), (double)(n2 & 0xFF), (double)n3);
        }
        catch (AssertionError assertionError) {
            Assert.assertEquals((String)string, (Object)String.format("#%08x", n), (Object)String.format("#%08x", n2));
        }
    }

    static {
        IIORegistry.getDefaultInstance().registerServiceProvider(new URLImageInputStreamSpi());
        ImageIO.setUseCache(false);
    }

    protected static final class TestData {
        private final Object input;
        private final List<Dimension> sizes;
        private final List<BufferedImage> images;

        public TestData(Object object, Dimension ... dimensionArray) {
            this(object, Arrays.asList(dimensionArray), null);
        }

        public TestData(Object object, BufferedImage ... bufferedImageArray) {
            this(object, null, Arrays.asList(bufferedImageArray));
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public TestData(Object object, List<Dimension> list, List<BufferedImage> list2) {
            if (object == null) {
                throw new IllegalArgumentException("input == null");
            }
            this.sizes = new ArrayList<Dimension>();
            this.images = new ArrayList<BufferedImage>();
            List<Dimension> list3 = list;
            if (list3 == null) {
                list3 = new ArrayList<Dimension>();
                if (list2 == null) throw new IllegalArgumentException("Need either size or image");
                for (BufferedImage bufferedImage : list2) {
                    list3.add(new Dimension(bufferedImage.getWidth(), bufferedImage.getHeight()));
                }
            } else if (list2 != null) {
                if (list2.size() != list.size()) {
                    throw new IllegalArgumentException("Size parameter and image size differs");
                }
                for (int i = 0; i < list3.size(); ++i) {
                    if (new Dimension(list2.get(i).getWidth(), list2.get(i).getHeight()).equals(list3.get(i))) continue;
                    throw new IllegalArgumentException("Size parameter and image size differs");
                }
            }
            this.sizes.addAll(list3);
            if (list2 != null) {
                this.images.addAll(list2);
            }
            this.input = object;
        }

        public Object getInput() {
            return this.input;
        }

        public ImageInputStream getInputStream() {
            try {
                ImageInputStream imageInputStream = ImageIO.createImageInputStream(this.input);
                Assert.assertNotNull((String)("Could not create ImageInputStream for input: " + this.input), (Object)imageInputStream);
                return imageInputStream;
            }
            catch (IOException iOException) {
                ImageReaderAbstractTest.failBecause("Could not create ImageInputStream for input: " + this.input, iOException);
                return null;
            }
        }

        public int getImageCount() {
            return this.sizes.size();
        }

        public Dimension getDimension(int n) {
            return this.sizes.get(n);
        }

        public BufferedImage getImage(int n) {
            return this.images.get(n);
        }

        public String toString() {
            return this.getClass().getSimpleName() + ": " + String.valueOf(this.input);
        }
    }
}

