/*
 * Decompiled with CFR 0.152.
 */
package com.twelvemonkeys.imageio.util;

import com.twelvemonkeys.imageio.util.IIOInputStreamAdapter;
import com.twelvemonkeys.io.InputStreamAbstractTest;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import javax.imageio.stream.ImageInputStream;
import javax.imageio.stream.MemoryCacheImageInputStream;
import org.junit.Assert;
import org.junit.Test;

public class IIOInputStreamAdapterTest
extends InputStreamAbstractTest {
    protected InputStream makeInputStream(byte[] byArray) {
        return new IIOInputStreamAdapter((ImageInputStream)new MemoryCacheImageInputStream(new ByteArrayInputStream(byArray)), (long)byArray.length);
    }

    @Test(expected=IllegalArgumentException.class)
    public void testCreateNull() {
        new IIOInputStreamAdapter(null);
    }

    @Test
    public void testReadSubstreamOpenEnd() throws IOException {
        byte[] byArray = new byte[20];
        MemoryCacheImageInputStream memoryCacheImageInputStream = new MemoryCacheImageInputStream(new ByteArrayInputStream(byArray));
        memoryCacheImageInputStream.seek(10L);
        Assert.assertEquals((long)10L, (long)memoryCacheImageInputStream.getStreamPosition());
        IIOInputStreamAdapter iIOInputStreamAdapter = new IIOInputStreamAdapter((ImageInputStream)memoryCacheImageInputStream);
        for (int i = 0; i < 10; ++i) {
            Assert.assertTrue((String)"Unexpected end of stream", (-1 != iIOInputStreamAdapter.read() ? 1 : 0) != 0);
        }
        Assert.assertEquals((String)"Read value after end of stream", (long)-1L, (long)iIOInputStreamAdapter.read());
        Assert.assertEquals((String)"Read value after end of stream", (long)-1L, (long)iIOInputStreamAdapter.read());
        iIOInputStreamAdapter.close();
        Assert.assertEquals((long)20L, (long)memoryCacheImageInputStream.getStreamPosition());
        memoryCacheImageInputStream.close();
    }

    @Test
    public void testReadSubstream() throws IOException {
        byte[] byArray = new byte[20];
        MemoryCacheImageInputStream memoryCacheImageInputStream = new MemoryCacheImageInputStream(new ByteArrayInputStream(byArray));
        IIOInputStreamAdapter iIOInputStreamAdapter = new IIOInputStreamAdapter((ImageInputStream)memoryCacheImageInputStream, 9L);
        for (int i = 0; i < 9; ++i) {
            Assert.assertTrue((String)"Unexpected end of stream", (-1 != iIOInputStreamAdapter.read() ? 1 : 0) != 0);
        }
        Assert.assertEquals((String)"Read value after end of stream", (long)-1L, (long)iIOInputStreamAdapter.read());
        Assert.assertEquals((String)"Read value after end of stream", (long)-1L, (long)iIOInputStreamAdapter.read());
        Assert.assertTrue((memoryCacheImageInputStream.getStreamPosition() <= 9L ? 1 : 0) != 0);
        memoryCacheImageInputStream.close();
    }

    @Test
    public void testReadSubstreamRepositionOnClose() throws IOException {
        byte[] byArray = new byte[20];
        MemoryCacheImageInputStream memoryCacheImageInputStream = new MemoryCacheImageInputStream(new ByteArrayInputStream(byArray));
        IIOInputStreamAdapter iIOInputStreamAdapter = new IIOInputStreamAdapter((ImageInputStream)memoryCacheImageInputStream, 10L);
        for (int i = 0; i < 7; ++i) {
            Assert.assertTrue((String)"Unexpected end of stream", (-1 != iIOInputStreamAdapter.read() ? 1 : 0) != 0);
        }
        Assert.assertTrue((memoryCacheImageInputStream.getStreamPosition() <= 7L ? 1 : 0) != 0);
        iIOInputStreamAdapter.close();
        Assert.assertEquals((long)10L, (long)memoryCacheImageInputStream.getStreamPosition());
        memoryCacheImageInputStream.close();
    }

    @Test
    public void testSeekBeforeStreamNoEnd() throws IOException {
        byte[] byArray = new byte[20];
        MemoryCacheImageInputStream memoryCacheImageInputStream = new MemoryCacheImageInputStream(new ByteArrayInputStream(byArray));
        memoryCacheImageInputStream.seek(10L);
        Assert.assertEquals((long)10L, (long)memoryCacheImageInputStream.getStreamPosition());
        IIOInputStreamAdapter iIOInputStreamAdapter = new IIOInputStreamAdapter((ImageInputStream)memoryCacheImageInputStream);
        Assert.assertEquals((String)"Should not skip backwards", (long)0L, (long)iIOInputStreamAdapter.skip(-5L));
        Assert.assertEquals((long)10L, (long)memoryCacheImageInputStream.getStreamPosition());
    }

    @Test
    public void testSeekBeforeStream() throws IOException {
        byte[] byArray = new byte[20];
        MemoryCacheImageInputStream memoryCacheImageInputStream = new MemoryCacheImageInputStream(new ByteArrayInputStream(byArray));
        memoryCacheImageInputStream.seek(10L);
        Assert.assertEquals((long)10L, (long)memoryCacheImageInputStream.getStreamPosition());
        IIOInputStreamAdapter iIOInputStreamAdapter = new IIOInputStreamAdapter((ImageInputStream)memoryCacheImageInputStream, 9L);
        Assert.assertEquals((String)"Should not skip backwards", (long)0L, (long)iIOInputStreamAdapter.skip(-5L));
        Assert.assertEquals((long)10L, (long)memoryCacheImageInputStream.getStreamPosition());
    }
}

