/*
 * Decompiled with CFR 0.152.
 */
package com.twelvemonkeys.imageio.stream;

import com.twelvemonkeys.imageio.stream.BufferedImageInputStreamTest;
import com.twelvemonkeys.imageio.stream.ByteArrayImageInputStream;
import java.io.IOException;
import java.util.Random;
import org.junit.Assert;
import org.junit.Test;

public class ByteArrayImageInputStreamTest {
    private final Random random = new Random(1709843507234566L);

    @Test
    public void testCreate() {
        ByteArrayImageInputStream byteArrayImageInputStream = new ByteArrayImageInputStream(new byte[0]);
        Assert.assertEquals((String)"Data length should be same as stream length", (long)0L, (long)byteArrayImageInputStream.length());
    }

    @Test
    public void testCreateNull() {
        try {
            new ByteArrayImageInputStream(null);
            Assert.fail((String)"Expected IllegalArgumentException");
        }
        catch (IllegalArgumentException illegalArgumentException) {
            Assert.assertNotNull((String)"Null exception message", (Object)illegalArgumentException.getMessage());
            String string = illegalArgumentException.getMessage().toLowerCase();
            Assert.assertTrue((String)"Exception message does not contain parameter name", (boolean)string.contains("data"));
            Assert.assertTrue((String)"Exception message does not contain null", (boolean)string.contains("null"));
        }
    }

    @Test
    public void testCreateNullOffLen() {
        try {
            new ByteArrayImageInputStream(null, 0, -1);
            Assert.fail((String)"Expected IllegalArgumentException");
        }
        catch (IllegalArgumentException illegalArgumentException) {
            Assert.assertNotNull((String)"Null exception message", (Object)illegalArgumentException.getMessage());
            String string = illegalArgumentException.getMessage().toLowerCase();
            Assert.assertTrue((String)"Exception message does not contain parameter name", (boolean)string.contains("data"));
            Assert.assertTrue((String)"Exception message does not contain null", (boolean)string.contains("null"));
        }
    }

    @Test
    public void testCreateNegativeOff() {
        try {
            new ByteArrayImageInputStream(new byte[0], -1, 1);
            Assert.fail((String)"Expected IllegalArgumentException");
        }
        catch (IllegalArgumentException illegalArgumentException) {
            Assert.assertNotNull((String)"Null exception message", (Object)illegalArgumentException.getMessage());
            String string = illegalArgumentException.getMessage().toLowerCase();
            Assert.assertTrue((String)"Exception message does not contain parameter name", (boolean)string.contains("offset"));
            Assert.assertTrue((String)"Exception message does not contain -1", (boolean)string.contains("-1"));
        }
    }

    @Test
    public void testCreateBadOff() {
        try {
            new ByteArrayImageInputStream(new byte[1], 2, 0);
            Assert.fail((String)"Expected IllegalArgumentException");
        }
        catch (IllegalArgumentException illegalArgumentException) {
            Assert.assertNotNull((String)"Null exception message", (Object)illegalArgumentException.getMessage());
            String string = illegalArgumentException.getMessage().toLowerCase();
            Assert.assertTrue((String)"Exception message does not contain parameter name", (boolean)string.contains("offset"));
            Assert.assertTrue((String)"Exception message does not contain 2", (boolean)string.contains("2"));
        }
    }

    @Test
    public void testCreateNegativeLen() {
        try {
            new ByteArrayImageInputStream(new byte[0], 0, -1);
            Assert.fail((String)"Expected IllegalArgumentException");
        }
        catch (IllegalArgumentException illegalArgumentException) {
            Assert.assertNotNull((String)"Null exception message", (Object)illegalArgumentException.getMessage());
            String string = illegalArgumentException.getMessage().toLowerCase();
            Assert.assertTrue((String)"Exception message does not contain parameter name", (boolean)string.contains("length"));
            Assert.assertTrue((String)"Exception message does not contain -1", (boolean)string.contains("-1"));
        }
    }

    @Test
    public void testCreateBadLen() {
        try {
            new ByteArrayImageInputStream(new byte[1], 0, 2);
            Assert.fail((String)"Expected IllegalArgumentException");
        }
        catch (IllegalArgumentException illegalArgumentException) {
            Assert.assertNotNull((String)"Null exception message", (Object)illegalArgumentException.getMessage());
            String string = illegalArgumentException.getMessage().toLowerCase();
            Assert.assertTrue((String)"Exception message does not contain parameter name", (boolean)string.contains("length"));
            Assert.assertTrue((String)"Exception message does not contain \u2122", (boolean)string.contains("2"));
        }
    }

    @Test
    public void testRead() throws IOException {
        byte[] byArray = new byte[0x100000];
        this.random.nextBytes(byArray);
        ByteArrayImageInputStream byteArrayImageInputStream = new ByteArrayImageInputStream(byArray);
        Assert.assertEquals((String)"Data length should be same as stream length", (long)byArray.length, (long)byteArrayImageInputStream.length());
        for (byte by : byArray) {
            Assert.assertEquals((String)"Wrong data read", (long)(by & 0xFF), (long)byteArrayImageInputStream.read());
        }
    }

    @Test
    public void testReadOffsetLen() throws IOException {
        byte[] byArray = new byte[0x100000];
        this.random.nextBytes(byArray);
        int n = this.random.nextInt(byArray.length / 10);
        int n2 = this.random.nextInt(byArray.length - n);
        ByteArrayImageInputStream byteArrayImageInputStream = new ByteArrayImageInputStream(byArray, n, n2);
        Assert.assertEquals((String)"Data length should be same as stream length", (long)n2, (long)byteArrayImageInputStream.length());
        for (int i = n; i < n + n2; ++i) {
            Assert.assertEquals((String)"Wrong data read", (long)(byArray[i] & 0xFF), (long)byteArrayImageInputStream.read());
        }
    }

    @Test
    public void testReadArray() throws IOException {
        byte[] byArray = new byte[0x100000];
        this.random.nextBytes(byArray);
        ByteArrayImageInputStream byteArrayImageInputStream = new ByteArrayImageInputStream(byArray);
        Assert.assertEquals((String)"Data length should be same as stream length", (long)byArray.length, (long)byteArrayImageInputStream.length());
        byte[] byArray2 = new byte[1024];
        for (int i = 0; i < byArray.length / byArray2.length; ++i) {
            byteArrayImageInputStream.readFully(byArray2);
            Assert.assertTrue((String)("Wrong data read: " + i), (boolean)BufferedImageInputStreamTest.rangeEquals(byArray, i * byArray2.length, byArray2, 0, byArray2.length));
        }
    }

    @Test
    public void testReadArrayOffLen() throws IOException {
        byte[] byArray = new byte[0x100000];
        this.random.nextBytes(byArray);
        int n = this.random.nextInt(byArray.length - 10240);
        int n2 = 10240;
        ByteArrayImageInputStream byteArrayImageInputStream = new ByteArrayImageInputStream(byArray, n, n2);
        Assert.assertEquals((String)"Data length should be same as stream length", (long)n2, (long)byteArrayImageInputStream.length());
        byte[] byArray2 = new byte[1024];
        for (int i = 0; i < n2 / byArray2.length; ++i) {
            byteArrayImageInputStream.readFully(byArray2);
            Assert.assertTrue((String)("Wrong data read: " + i), (boolean)BufferedImageInputStreamTest.rangeEquals(byArray, n + i * byArray2.length, byArray2, 0, byArray2.length));
        }
    }

    @Test
    public void testReadSkip() throws IOException {
        byte[] byArray = new byte[14336];
        this.random.nextBytes(byArray);
        ByteArrayImageInputStream byteArrayImageInputStream = new ByteArrayImageInputStream(byArray);
        Assert.assertEquals((String)"Data length should be same as stream length", (long)byArray.length, (long)byteArrayImageInputStream.length());
        byte[] byArray2 = new byte[7];
        for (int i = 0; i < byArray.length / byArray2.length; i += 2) {
            byteArrayImageInputStream.readFully(byArray2);
            byteArrayImageInputStream.skipBytes(byArray2.length);
            Assert.assertTrue((String)("Wrong data read: " + i), (boolean)BufferedImageInputStreamTest.rangeEquals(byArray, i * byArray2.length, byArray2, 0, byArray2.length));
        }
    }

    @Test
    public void testReadSeek() throws IOException {
        byte[] byArray = new byte[18432];
        this.random.nextBytes(byArray);
        ByteArrayImageInputStream byteArrayImageInputStream = new ByteArrayImageInputStream(byArray);
        Assert.assertEquals((String)"Data length should be same as stream length", (long)byArray.length, (long)byteArrayImageInputStream.length());
        byte[] byArray2 = new byte[9];
        for (int i = 0; i < byArray.length / byArray2.length; ++i) {
            long l = byteArrayImageInputStream.length() - (long)byArray2.length - (long)(i * byArray2.length);
            byteArrayImageInputStream.seek(l);
            Assert.assertEquals((String)"Wrong stream position", (long)l, (long)byteArrayImageInputStream.getStreamPosition());
            byteArrayImageInputStream.readFully(byArray2);
            Assert.assertTrue((String)("Wrong data read: " + i), (boolean)BufferedImageInputStreamTest.rangeEquals(byArray, (int)l, byArray2, 0, byArray2.length));
        }
    }
}

