/*
 * Decompiled with CFR 0.152.
 */
package com.twelvemonkeys.imageio.stream;

import com.twelvemonkeys.imageio.stream.BufferedImageInputStream;
import com.twelvemonkeys.imageio.stream.ByteArrayImageInputStream;
import com.twelvemonkeys.io.ole2.CompoundDocument;
import com.twelvemonkeys.io.ole2.Entry;
import java.io.IOException;
import java.nio.ByteOrder;
import java.util.Arrays;
import java.util.Random;
import javax.imageio.stream.ImageInputStream;
import javax.imageio.stream.MemoryCacheImageInputStream;
import org.junit.Assert;
import org.junit.Test;

public class BufferedImageInputStreamTest {
    private final Random random = new Random(3450972865211L);

    @Test
    public void testCreate() throws IOException {
        new BufferedImageInputStream((ImageInputStream)new ByteArrayImageInputStream(new byte[0]));
    }

    @Test
    public void testCreateNull() throws IOException {
        try {
            new BufferedImageInputStream(null);
            Assert.fail((String)"Expected IllegalArgumentException");
        }
        catch (IllegalArgumentException illegalArgumentException) {
            Assert.assertNotNull((String)"Null exception message", (Object)illegalArgumentException.getMessage());
            String string = illegalArgumentException.getMessage().toLowerCase();
            Assert.assertTrue((String)"Exception message does not contain parameter name", (boolean)string.contains("stream"));
            Assert.assertTrue((String)"Exception message does not contain null", (boolean)string.contains("null"));
        }
    }

    @Test
    public void testArrayIndexOutOfBoundsBufferedReadBug() throws IOException {
        BufferedImageInputStream bufferedImageInputStream = new BufferedImageInputStream((ImageInputStream)new MemoryCacheImageInputStream(this.getClass().getResourceAsStream("/Thumbs-camera.db")));
        bufferedImageInputStream.setByteOrder(ByteOrder.LITTLE_ENDIAN);
        Entry entry = new CompoundDocument((ImageInputStream)bufferedImageInputStream).getRootEntry();
        Entry entry2 = entry.getChildEntry("Catalog");
        Assert.assertNotNull((String)"Catalog should not be null", (Object)entry2);
        Assert.assertNotNull((String)"Input stream can never be null", (Object)entry2.getInputStream());
    }

    @Test
    public void testReadResetReadDirectBufferBug() throws IOException {
        int n = 8192;
        byte[] byArray = new byte[n * 2];
        this.random.nextBytes(byArray);
        BufferedImageInputStream bufferedImageInputStream = new BufferedImageInputStream((ImageInputStream)new ByteArrayImageInputStream(byArray));
        bufferedImageInputStream.readLong();
        bufferedImageInputStream.seek(0L);
        byte[] byArray2 = new byte[n];
        bufferedImageInputStream.readFully(byArray2);
        Assert.assertTrue((boolean)BufferedImageInputStreamTest.rangeEquals(byArray, 0, byArray2, 0, n));
        bufferedImageInputStream.readFully(byArray2);
        Assert.assertTrue((boolean)BufferedImageInputStreamTest.rangeEquals(byArray, n, byArray2, 0, n));
    }

    @Test
    public void testBufferPositionCorrect() throws IOException {
        byte[] byArray = new byte[1024];
        this.random.nextBytes(byArray);
        ByteArrayImageInputStream byteArrayImageInputStream = new ByteArrayImageInputStream(byArray);
        byteArrayImageInputStream.readByte();
        byteArrayImageInputStream.readByte();
        byteArrayImageInputStream.skipBytes(124);
        byteArrayImageInputStream.readByte();
        byteArrayImageInputStream.readByte();
        Assert.assertEquals((long)128L, (long)byteArrayImageInputStream.getStreamPosition());
        BufferedImageInputStream bufferedImageInputStream = new BufferedImageInputStream((ImageInputStream)byteArrayImageInputStream);
        Assert.assertEquals((long)byteArrayImageInputStream.getStreamPosition(), (long)bufferedImageInputStream.getStreamPosition());
        bufferedImageInputStream.skipBytes(128);
        Assert.assertEquals((long)256L, (long)bufferedImageInputStream.getStreamPosition());
        bufferedImageInputStream.seek(1020L);
        Assert.assertEquals((long)1020L, (long)bufferedImageInputStream.getStreamPosition());
    }

    @Test
    public void testReadIntegralOnBufferBoundary() throws IOException {
        int n = 8192;
        byte[] byArray = new byte[n * 2];
        Arrays.fill(byArray, n - 4, n + 4, (byte)-1);
        BufferedImageInputStream bufferedImageInputStream = new BufferedImageInputStream((ImageInputStream)new ByteArrayImageInputStream(byArray));
        Assert.assertEquals((long)0L, (long)bufferedImageInputStream.readInt());
        bufferedImageInputStream.seek((long)(n - 3));
        Assert.assertEquals((long)-1L, (long)bufferedImageInputStream.readInt());
        Assert.assertEquals((long)(n + 1), (long)bufferedImageInputStream.getStreamPosition());
    }

    static boolean rangeEquals(byte[] byArray, int n, byte[] byArray2, int n2, int n3) {
        if (byArray == byArray2 && n == n2) {
            return true;
        }
        if (byArray == null || byArray2 == null) {
            return false;
        }
        if (byArray.length < n + n3 || byArray2.length < n2 + n3) {
            return false;
        }
        for (int i = 0; i < n3; ++i) {
            if (byArray[n + i] == byArray2[n2 + i]) continue;
            return false;
        }
        return true;
    }
}

