/*
 * Decompiled with CFR 0.152.
 */
package com.twelvemonkeys.imageio.color;

import com.twelvemonkeys.imageio.color.UInt32ColorModel;
import java.awt.color.ColorSpace;
import org.junit.Assert;
import org.junit.Test;

public class UInt32ColorModelTest {
    private static final ColorSpace sRGB = ColorSpace.getInstance(1000);
    private static final ColorSpace GRAY = ColorSpace.getInstance(1003);

    @Test
    public void testGetNormalizedComponentsRGBBlack() {
        float[] fArray;
        UInt32ColorModel uInt32ColorModel = new UInt32ColorModel(sRGB, true, false);
        for (float f : fArray = uInt32ColorModel.getNormalizedComponents(new int[]{0, 0, 0, 0}, null, 0)) {
            Assert.assertEquals((double)0.0, (double)f, (double)0.0);
        }
    }

    @Test
    public void testGetNormalizedComponentsRGBGray() {
        float[] fArray;
        UInt32ColorModel uInt32ColorModel = new UInt32ColorModel(sRGB, true, false);
        for (float f : fArray = uInt32ColorModel.getNormalizedComponents(new int[]{Integer.MIN_VALUE, Integer.MIN_VALUE, Integer.MIN_VALUE, Integer.MIN_VALUE}, null, 0)) {
            Assert.assertEquals((double)0.5, (double)f, (double)0.0);
        }
    }

    @Test
    public void testGetNormalizedComponentsRGBWhite() {
        float[] fArray;
        UInt32ColorModel uInt32ColorModel = new UInt32ColorModel(sRGB, true, false);
        for (float f : fArray = uInt32ColorModel.getNormalizedComponents(new int[]{-1, -1, -1, -1}, null, 0)) {
            Assert.assertEquals((double)1.0, (double)f, (double)0.0);
        }
    }

    @Test
    public void testGetNormalizedComponentsRGB() {
        UInt32ColorModel uInt32ColorModel = new UInt32ColorModel(sRGB, true, false);
        int[] nArray = new int[4];
        float[] fArray = null;
        for (long i = 0L; i < 0x100000000L; i += 32767L) {
            float f = (float)(i & 0xFFFFFFFFL) / 4.2949673E9f;
            for (int j = 0; j < nArray.length; ++j) {
                nArray[j] = (int)i;
            }
            for (float f2 : fArray = uInt32ColorModel.getNormalizedComponents(nArray, fArray, 0)) {
                Assert.assertEquals((double)f, (double)f2, (double)0.0);
            }
        }
    }

    @Test
    public void testGetNormalizedComponentsGrayBlack() {
        float[] fArray;
        UInt32ColorModel uInt32ColorModel = new UInt32ColorModel(GRAY, false, false);
        for (float f : fArray = uInt32ColorModel.getNormalizedComponents(new int[]{0}, null, 0)) {
            Assert.assertEquals((double)0.0, (double)f, (double)0.0);
        }
    }

    @Test
    public void testGetNormalizedComponentsGrayGray() {
        float[] fArray;
        UInt32ColorModel uInt32ColorModel = new UInt32ColorModel(GRAY, false, false);
        for (float f : fArray = uInt32ColorModel.getNormalizedComponents(new int[]{Integer.MIN_VALUE}, null, 0)) {
            Assert.assertEquals((double)0.5, (double)f, (double)0.0);
        }
    }

    @Test
    public void testGetNormalizedComponentsGrayWhite() {
        float[] fArray;
        UInt32ColorModel uInt32ColorModel = new UInt32ColorModel(GRAY, false, false);
        for (float f : fArray = uInt32ColorModel.getNormalizedComponents(new int[]{-1}, null, 0)) {
            Assert.assertEquals((double)1.0, (double)f, (double)0.0);
        }
    }

    @Test
    public void testGetNormalizedComponentsGray() {
        UInt32ColorModel uInt32ColorModel = new UInt32ColorModel(GRAY, false, false);
        int[] nArray = new int[1];
        float[] fArray = null;
        for (long i = 0L; i < 0x100000000L; i += 32767L) {
            float f = (float)(i & 0xFFFFFFFFL) / 4.2949673E9f;
            nArray[0] = (int)i;
            fArray = uInt32ColorModel.getNormalizedComponents(nArray, fArray, 0);
            Assert.assertEquals((double)f, (double)fArray[0], (double)0.0);
        }
    }
}

