/*
 * Decompiled with CFR 0.152.
 */
package com.twelvemonkeys.imageio.util;

import com.twelvemonkeys.imageio.color.ColorSpaces;
import com.twelvemonkeys.imageio.util.UInt32ImageTypeSpecifier;
import java.awt.color.ColorSpace;
import java.awt.image.ComponentColorModel;
import java.awt.image.PixelInterleavedSampleModel;
import javax.imageio.ImageTypeSpecifier;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.junit.Assert;
import org.junit.Test;

public class UInt32ImageTypeSpecifierTest {
    private static final ColorSpace sRGB = ColorSpace.getInstance(1000);
    private static final ColorSpace GRAY = ColorSpace.getInstance(1003);
    private static final ColorSpace CMYK = ColorSpaces.getColorSpace((int)5001);

    @Test
    public void testGray() {
        ImageTypeSpecifier imageTypeSpecifier = UInt32ImageTypeSpecifier.createInterleaved((ColorSpace)GRAY, (int[])new int[]{0}, (boolean)false, (boolean)false);
        Assert.assertEquals((long)1L, (long)imageTypeSpecifier.getNumBands());
        Assert.assertEquals((long)1L, (long)imageTypeSpecifier.getNumComponents());
        Assert.assertEquals((long)32L, (long)imageTypeSpecifier.getBitsPerBand(0));
        MatcherAssert.assertThat((Object)imageTypeSpecifier.getColorModel(), (Matcher)CoreMatchers.instanceOf(ComponentColorModel.class));
        Assert.assertFalse((boolean)imageTypeSpecifier.getColorModel().hasAlpha());
        Assert.assertFalse((boolean)imageTypeSpecifier.getColorModel().isAlphaPremultiplied());
        Assert.assertEquals((long)1L, (long)imageTypeSpecifier.getColorModel().getNumComponents());
        Assert.assertEquals((long)1L, (long)imageTypeSpecifier.getColorModel().getNumColorComponents());
        MatcherAssert.assertThat((Object)imageTypeSpecifier.getSampleModel(), (Matcher)CoreMatchers.instanceOf(PixelInterleavedSampleModel.class));
        Assert.assertEquals((long)1L, (long)imageTypeSpecifier.getSampleModel().getNumBands());
        Assert.assertEquals((long)1L, (long)imageTypeSpecifier.getSampleModel().getNumDataElements());
    }

    @Test
    public void testGrayAlpha() {
        ImageTypeSpecifier imageTypeSpecifier = UInt32ImageTypeSpecifier.createInterleaved((ColorSpace)GRAY, (int[])new int[]{0, 1}, (boolean)true, (boolean)false);
        Assert.assertEquals((long)2L, (long)imageTypeSpecifier.getNumBands());
        Assert.assertEquals((long)2L, (long)imageTypeSpecifier.getNumComponents());
        Assert.assertEquals((long)32L, (long)imageTypeSpecifier.getBitsPerBand(0));
        Assert.assertEquals((long)32L, (long)imageTypeSpecifier.getBitsPerBand(1));
        MatcherAssert.assertThat((Object)imageTypeSpecifier.getColorModel(), (Matcher)CoreMatchers.instanceOf(ComponentColorModel.class));
        Assert.assertTrue((boolean)imageTypeSpecifier.getColorModel().hasAlpha());
        Assert.assertFalse((boolean)imageTypeSpecifier.getColorModel().isAlphaPremultiplied());
        Assert.assertEquals((long)2L, (long)imageTypeSpecifier.getColorModel().getNumComponents());
        Assert.assertEquals((long)1L, (long)imageTypeSpecifier.getColorModel().getNumColorComponents());
        MatcherAssert.assertThat((Object)imageTypeSpecifier.getSampleModel(), (Matcher)CoreMatchers.instanceOf(PixelInterleavedSampleModel.class));
        Assert.assertEquals((long)2L, (long)imageTypeSpecifier.getSampleModel().getNumBands());
        Assert.assertEquals((long)2L, (long)imageTypeSpecifier.getSampleModel().getNumDataElements());
    }

    @Test
    public void testRGB() {
        ImageTypeSpecifier imageTypeSpecifier = UInt32ImageTypeSpecifier.createInterleaved((ColorSpace)sRGB, (int[])new int[]{0, 1, 2}, (boolean)false, (boolean)false);
        Assert.assertEquals((long)3L, (long)imageTypeSpecifier.getNumBands());
        Assert.assertEquals((long)3L, (long)imageTypeSpecifier.getNumComponents());
        Assert.assertEquals((long)32L, (long)imageTypeSpecifier.getBitsPerBand(0));
        Assert.assertEquals((long)32L, (long)imageTypeSpecifier.getBitsPerBand(1));
        Assert.assertEquals((long)32L, (long)imageTypeSpecifier.getBitsPerBand(2));
        MatcherAssert.assertThat((Object)imageTypeSpecifier.getColorModel(), (Matcher)CoreMatchers.instanceOf(ComponentColorModel.class));
        Assert.assertFalse((boolean)imageTypeSpecifier.getColorModel().hasAlpha());
        Assert.assertFalse((boolean)imageTypeSpecifier.getColorModel().isAlphaPremultiplied());
        Assert.assertEquals((long)3L, (long)imageTypeSpecifier.getColorModel().getNumComponents());
        Assert.assertEquals((long)3L, (long)imageTypeSpecifier.getColorModel().getNumColorComponents());
        MatcherAssert.assertThat((Object)imageTypeSpecifier.getSampleModel(), (Matcher)CoreMatchers.instanceOf(PixelInterleavedSampleModel.class));
        Assert.assertEquals((long)3L, (long)imageTypeSpecifier.getSampleModel().getNumBands());
        Assert.assertEquals((long)3L, (long)imageTypeSpecifier.getSampleModel().getNumDataElements());
    }

    @Test
    public void testRGBAlpha() {
        ImageTypeSpecifier imageTypeSpecifier = UInt32ImageTypeSpecifier.createInterleaved((ColorSpace)sRGB, (int[])new int[]{0, 1, 2, 3}, (boolean)true, (boolean)false);
        Assert.assertEquals((long)4L, (long)imageTypeSpecifier.getNumBands());
        Assert.assertEquals((long)4L, (long)imageTypeSpecifier.getNumComponents());
        Assert.assertEquals((long)32L, (long)imageTypeSpecifier.getBitsPerBand(0));
        Assert.assertEquals((long)32L, (long)imageTypeSpecifier.getBitsPerBand(1));
        Assert.assertEquals((long)32L, (long)imageTypeSpecifier.getBitsPerBand(2));
        Assert.assertEquals((long)32L, (long)imageTypeSpecifier.getBitsPerBand(3));
        MatcherAssert.assertThat((Object)imageTypeSpecifier.getColorModel(), (Matcher)CoreMatchers.instanceOf(ComponentColorModel.class));
        Assert.assertTrue((boolean)imageTypeSpecifier.getColorModel().hasAlpha());
        Assert.assertFalse((boolean)imageTypeSpecifier.getColorModel().isAlphaPremultiplied());
        Assert.assertEquals((long)4L, (long)imageTypeSpecifier.getColorModel().getNumComponents());
        Assert.assertEquals((long)3L, (long)imageTypeSpecifier.getColorModel().getNumColorComponents());
        MatcherAssert.assertThat((Object)imageTypeSpecifier.getSampleModel(), (Matcher)CoreMatchers.instanceOf(PixelInterleavedSampleModel.class));
        Assert.assertEquals((long)4L, (long)imageTypeSpecifier.getSampleModel().getNumBands());
        Assert.assertEquals((long)4L, (long)imageTypeSpecifier.getSampleModel().getNumDataElements());
    }

    @Test
    public void testRGBAlphaPre() {
        ImageTypeSpecifier imageTypeSpecifier = UInt32ImageTypeSpecifier.createInterleaved((ColorSpace)sRGB, (int[])new int[]{0, 1, 2, 3}, (boolean)true, (boolean)true);
        Assert.assertEquals((long)4L, (long)imageTypeSpecifier.getNumBands());
        Assert.assertEquals((long)4L, (long)imageTypeSpecifier.getNumComponents());
        Assert.assertEquals((long)32L, (long)imageTypeSpecifier.getBitsPerBand(0));
        Assert.assertEquals((long)32L, (long)imageTypeSpecifier.getBitsPerBand(1));
        Assert.assertEquals((long)32L, (long)imageTypeSpecifier.getBitsPerBand(2));
        Assert.assertEquals((long)32L, (long)imageTypeSpecifier.getBitsPerBand(3));
        MatcherAssert.assertThat((Object)imageTypeSpecifier.getColorModel(), (Matcher)CoreMatchers.instanceOf(ComponentColorModel.class));
        Assert.assertTrue((boolean)imageTypeSpecifier.getColorModel().hasAlpha());
        Assert.assertTrue((boolean)imageTypeSpecifier.getColorModel().isAlphaPremultiplied());
        Assert.assertEquals((long)4L, (long)imageTypeSpecifier.getColorModel().getNumComponents());
        Assert.assertEquals((long)3L, (long)imageTypeSpecifier.getColorModel().getNumColorComponents());
        MatcherAssert.assertThat((Object)imageTypeSpecifier.getSampleModel(), (Matcher)CoreMatchers.instanceOf(PixelInterleavedSampleModel.class));
        Assert.assertEquals((long)4L, (long)imageTypeSpecifier.getSampleModel().getNumBands());
        Assert.assertEquals((long)4L, (long)imageTypeSpecifier.getSampleModel().getNumDataElements());
    }

    @Test
    public void testCMYK() {
        ImageTypeSpecifier imageTypeSpecifier = UInt32ImageTypeSpecifier.createInterleaved((ColorSpace)CMYK, (int[])new int[]{0, 1, 2, 3}, (boolean)false, (boolean)false);
        Assert.assertEquals((long)4L, (long)imageTypeSpecifier.getNumBands());
        Assert.assertEquals((long)4L, (long)imageTypeSpecifier.getNumComponents());
        Assert.assertEquals((long)32L, (long)imageTypeSpecifier.getBitsPerBand(0));
        Assert.assertEquals((long)32L, (long)imageTypeSpecifier.getBitsPerBand(1));
        Assert.assertEquals((long)32L, (long)imageTypeSpecifier.getBitsPerBand(2));
        Assert.assertEquals((long)32L, (long)imageTypeSpecifier.getBitsPerBand(3));
        MatcherAssert.assertThat((Object)imageTypeSpecifier.getColorModel(), (Matcher)CoreMatchers.instanceOf(ComponentColorModel.class));
        Assert.assertFalse((boolean)imageTypeSpecifier.getColorModel().hasAlpha());
        Assert.assertFalse((boolean)imageTypeSpecifier.getColorModel().isAlphaPremultiplied());
        Assert.assertEquals((long)4L, (long)imageTypeSpecifier.getColorModel().getNumComponents());
        Assert.assertEquals((long)4L, (long)imageTypeSpecifier.getColorModel().getNumColorComponents());
        MatcherAssert.assertThat((Object)imageTypeSpecifier.getSampleModel(), (Matcher)CoreMatchers.instanceOf(PixelInterleavedSampleModel.class));
        Assert.assertEquals((long)4L, (long)imageTypeSpecifier.getSampleModel().getNumBands());
        Assert.assertEquals((long)4L, (long)imageTypeSpecifier.getSampleModel().getNumDataElements());
    }

    @Test
    public void testCMYKAlpha() {
        ImageTypeSpecifier imageTypeSpecifier = UInt32ImageTypeSpecifier.createInterleaved((ColorSpace)CMYK, (int[])new int[]{0, 1, 2, 3, 4}, (boolean)true, (boolean)false);
        Assert.assertEquals((long)5L, (long)imageTypeSpecifier.getNumBands());
        Assert.assertEquals((long)5L, (long)imageTypeSpecifier.getNumComponents());
        Assert.assertEquals((long)32L, (long)imageTypeSpecifier.getBitsPerBand(0));
        Assert.assertEquals((long)32L, (long)imageTypeSpecifier.getBitsPerBand(1));
        Assert.assertEquals((long)32L, (long)imageTypeSpecifier.getBitsPerBand(2));
        Assert.assertEquals((long)32L, (long)imageTypeSpecifier.getBitsPerBand(3));
        Assert.assertEquals((long)32L, (long)imageTypeSpecifier.getBitsPerBand(4));
        MatcherAssert.assertThat((Object)imageTypeSpecifier.getColorModel(), (Matcher)CoreMatchers.instanceOf(ComponentColorModel.class));
        Assert.assertTrue((boolean)imageTypeSpecifier.getColorModel().hasAlpha());
        Assert.assertFalse((boolean)imageTypeSpecifier.getColorModel().isAlphaPremultiplied());
        Assert.assertEquals((long)5L, (long)imageTypeSpecifier.getColorModel().getNumComponents());
        Assert.assertEquals((long)4L, (long)imageTypeSpecifier.getColorModel().getNumColorComponents());
        MatcherAssert.assertThat((Object)imageTypeSpecifier.getSampleModel(), (Matcher)CoreMatchers.instanceOf(PixelInterleavedSampleModel.class));
        Assert.assertEquals((long)5L, (long)imageTypeSpecifier.getSampleModel().getNumBands());
        Assert.assertEquals((long)5L, (long)imageTypeSpecifier.getSampleModel().getNumDataElements());
    }

    @Test
    public void testEquals() {
        ImageTypeSpecifier imageTypeSpecifier = UInt32ImageTypeSpecifier.createInterleaved((ColorSpace)sRGB, (int[])new int[]{0, 1, 2}, (boolean)false, (boolean)false);
        ImageTypeSpecifier imageTypeSpecifier2 = UInt32ImageTypeSpecifier.createInterleaved((ColorSpace)sRGB, (int[])new int[]{0, 1, 2}, (boolean)false, (boolean)false);
        ImageTypeSpecifier imageTypeSpecifier3 = UInt32ImageTypeSpecifier.createInterleaved((ColorSpace)sRGB, (int[])new int[]{0, 1, 2, 3}, (boolean)true, (boolean)false);
        ImageTypeSpecifier imageTypeSpecifier4 = ImageTypeSpecifier.createInterleaved(sRGB, new int[]{0, 1, 2}, 3, false, false);
        Assert.assertEquals((Object)imageTypeSpecifier, (Object)imageTypeSpecifier2);
        Assert.assertEquals((Object)imageTypeSpecifier2, (Object)imageTypeSpecifier);
        Assert.assertTrue((boolean)imageTypeSpecifier.equals(imageTypeSpecifier2));
        Assert.assertTrue((boolean)imageTypeSpecifier2.equals(imageTypeSpecifier));
        Assert.assertFalse((boolean)imageTypeSpecifier.equals(imageTypeSpecifier3));
        Assert.assertFalse((boolean)imageTypeSpecifier3.equals(imageTypeSpecifier));
        Assert.assertFalse((boolean)imageTypeSpecifier.equals(imageTypeSpecifier4));
        Assert.assertFalse((boolean)imageTypeSpecifier4.equals(imageTypeSpecifier));
    }

    @Test
    public void testHashCode() {
        ImageTypeSpecifier imageTypeSpecifier = UInt32ImageTypeSpecifier.createInterleaved((ColorSpace)sRGB, (int[])new int[]{0, 1, 2}, (boolean)false, (boolean)false);
        ImageTypeSpecifier imageTypeSpecifier2 = UInt32ImageTypeSpecifier.createInterleaved((ColorSpace)sRGB, (int[])new int[]{0, 1, 2}, (boolean)false, (boolean)false);
        ImageTypeSpecifier imageTypeSpecifier3 = UInt32ImageTypeSpecifier.createInterleaved((ColorSpace)sRGB, (int[])new int[]{0, 1, 2, 3}, (boolean)true, (boolean)false);
        ImageTypeSpecifier imageTypeSpecifier4 = ImageTypeSpecifier.createInterleaved(sRGB, new int[]{0, 1, 2}, 3, false, false);
        Assert.assertEquals((long)imageTypeSpecifier.hashCode(), (long)imageTypeSpecifier2.hashCode());
        Assert.assertFalse((imageTypeSpecifier.hashCode() == imageTypeSpecifier3.hashCode() ? 1 : 0) != 0);
        Assert.assertFalse((imageTypeSpecifier.hashCode() == imageTypeSpecifier4.hashCode() ? 1 : 0) != 0);
    }
}

