/*
 * Decompiled with CFR 0.152.
 */
package com.twelvemonkeys.imageio.util;

import com.twelvemonkeys.imageio.util.RasterUtils;
import java.awt.Point;
import java.awt.color.ColorSpace;
import java.awt.image.BufferedImage;
import java.awt.image.PixelInterleavedSampleModel;
import java.awt.image.Raster;
import java.awt.image.WritableRaster;
import java.util.Random;
import javax.imageio.ImageTypeSpecifier;
import org.junit.Assert;
import org.junit.Test;

public class RasterUtilsTest {
    @Test(expected=NullPointerException.class)
    public void testAsByteRasterFromNull() {
        RasterUtils.asByteRaster((Raster)null);
    }

    @Test(expected=NullPointerException.class)
    public void testAsByteRasterWritableFromNull() {
        RasterUtils.asByteRaster((WritableRaster)null);
    }

    @Test
    public void testAsByteRasterPassThrough() {
        WritableRaster[] writableRasterArray;
        for (WritableRaster writableRaster : writableRasterArray = new WritableRaster[]{new BufferedImage(1, 1, 5).getRaster(), new BufferedImage(1, 1, 6).getRaster(), new BufferedImage(1, 1, 7).getRaster(), new BufferedImage(1, 1, 10).getRaster(), Raster.createBandedRaster(0, 1, 1, 7, null), Raster.createInterleavedRaster(0, 1, 1, 2, null), new WritableRaster(new PixelInterleavedSampleModel(0, 1, 1, 1, 1, new int[1]), new Point(0, 0)){}}) {
            Assert.assertSame((Object)writableRaster, (Object)RasterUtils.asByteRaster((Raster)writableRaster));
        }
        for (WritableRaster writableRaster : writableRasterArray) {
            Assert.assertSame((Object)writableRaster, (Object)RasterUtils.asByteRaster((WritableRaster)writableRaster));
        }
    }

    @Test
    public void testAsByteRasterWritableFromTYPE_INT_RGB() {
        BufferedImage bufferedImage = new BufferedImage(9, 11, 1);
        WritableRaster writableRaster = RasterUtils.asByteRaster((WritableRaster)bufferedImage.getRaster());
        Assert.assertEquals((long)0L, (long)writableRaster.getTransferType());
        Assert.assertEquals(PixelInterleavedSampleModel.class, writableRaster.getSampleModel().getClass());
        Assert.assertEquals((long)bufferedImage.getWidth(), (long)writableRaster.getWidth());
        Assert.assertEquals((long)bufferedImage.getHeight(), (long)writableRaster.getHeight());
        Assert.assertEquals((long)3L, (long)writableRaster.getNumBands());
        Assert.assertEquals((long)3L, (long)writableRaster.getNumDataElements());
        RasterUtilsTest.assertImageRasterEquals(bufferedImage, writableRaster);
    }

    @Test
    public void testAsByteRasterWritableFromTYPE_INT_ARGB() {
        BufferedImage bufferedImage = new BufferedImage(9, 11, 2);
        WritableRaster writableRaster = RasterUtils.asByteRaster((WritableRaster)bufferedImage.getRaster());
        Assert.assertEquals((long)0L, (long)writableRaster.getTransferType());
        Assert.assertEquals(PixelInterleavedSampleModel.class, writableRaster.getSampleModel().getClass());
        Assert.assertEquals((long)bufferedImage.getWidth(), (long)writableRaster.getWidth());
        Assert.assertEquals((long)bufferedImage.getHeight(), (long)writableRaster.getHeight());
        Assert.assertEquals((long)4L, (long)writableRaster.getNumBands());
        Assert.assertEquals((long)4L, (long)writableRaster.getNumDataElements());
        RasterUtilsTest.assertImageRasterEquals(bufferedImage, writableRaster);
    }

    @Test
    public void testAsByteRasterWritableFromTYPE_INT_ARGB_PRE() {
        BufferedImage bufferedImage = new BufferedImage(9, 11, 3);
        WritableRaster writableRaster = RasterUtils.asByteRaster((WritableRaster)bufferedImage.getRaster());
        Assert.assertEquals((long)0L, (long)writableRaster.getTransferType());
        Assert.assertEquals(PixelInterleavedSampleModel.class, writableRaster.getSampleModel().getClass());
        Assert.assertEquals((long)bufferedImage.getWidth(), (long)writableRaster.getWidth());
        Assert.assertEquals((long)bufferedImage.getHeight(), (long)writableRaster.getHeight());
        Assert.assertEquals((long)4L, (long)writableRaster.getNumBands());
        Assert.assertEquals((long)4L, (long)writableRaster.getNumDataElements());
    }

    @Test
    public void testAsByteRasterWritableFromTYPE_INT_BGR() {
        BufferedImage bufferedImage = new BufferedImage(9, 11, 4);
        WritableRaster writableRaster = RasterUtils.asByteRaster((WritableRaster)bufferedImage.getRaster());
        Assert.assertEquals((long)0L, (long)writableRaster.getTransferType());
        Assert.assertEquals(PixelInterleavedSampleModel.class, writableRaster.getSampleModel().getClass());
        Assert.assertEquals((long)bufferedImage.getWidth(), (long)writableRaster.getWidth());
        Assert.assertEquals((long)bufferedImage.getHeight(), (long)writableRaster.getHeight());
        Assert.assertEquals((long)3L, (long)writableRaster.getNumBands());
        Assert.assertEquals((long)3L, (long)writableRaster.getNumDataElements());
        RasterUtilsTest.assertImageRasterEquals(bufferedImage, writableRaster);
    }

    @Test
    public void testAsByteRasterWritableFromTYPE_CUSTOM_GRAB() {
        BufferedImage bufferedImage = ImageTypeSpecifier.createPacked(ColorSpace.getInstance(1000), 0xFF0000, -16777216, 255, 65280, 3, false).createBufferedImage(7, 13);
        WritableRaster writableRaster = RasterUtils.asByteRaster((WritableRaster)bufferedImage.getRaster());
        Assert.assertEquals((long)0L, (long)writableRaster.getTransferType());
        Assert.assertEquals(PixelInterleavedSampleModel.class, writableRaster.getSampleModel().getClass());
        Assert.assertEquals((long)bufferedImage.getWidth(), (long)writableRaster.getWidth());
        Assert.assertEquals((long)bufferedImage.getHeight(), (long)writableRaster.getHeight());
        Assert.assertEquals((long)4L, (long)writableRaster.getNumBands());
        Assert.assertEquals((long)4L, (long)writableRaster.getNumDataElements());
        RasterUtilsTest.assertImageRasterEquals(bufferedImage, writableRaster);
    }

    @Test
    public void testAsByteRasterWritableFromTYPE_CUSTOM_BxRG() {
        BufferedImage bufferedImage = ImageTypeSpecifier.createPacked(ColorSpace.getInstance(1000), 65280, 255, -16777216, 0, 3, false).createBufferedImage(7, 13);
        WritableRaster writableRaster = RasterUtils.asByteRaster((WritableRaster)bufferedImage.getRaster());
        Assert.assertEquals((long)0L, (long)writableRaster.getTransferType());
        Assert.assertEquals(PixelInterleavedSampleModel.class, writableRaster.getSampleModel().getClass());
        Assert.assertEquals((long)bufferedImage.getWidth(), (long)writableRaster.getWidth());
        Assert.assertEquals((long)bufferedImage.getHeight(), (long)writableRaster.getHeight());
        Assert.assertEquals((long)3L, (long)writableRaster.getNumBands());
        Assert.assertEquals((long)3L, (long)writableRaster.getNumDataElements());
        RasterUtilsTest.assertImageRasterEquals(bufferedImage, writableRaster);
    }

    private static void assertImageRasterEquals(BufferedImage bufferedImage, WritableRaster writableRaster) {
        int[] nArray = new int[]{16, 8, 0, 24};
        WritableRaster writableRaster2 = bufferedImage.getRaster();
        Random random = new Random(27365481723L);
        for (int i = 0; i < writableRaster.getHeight(); ++i) {
            for (int j = 0; j < writableRaster.getWidth(); ++j) {
                int n;
                int n2 = 0;
                for (n = 0; n < writableRaster.getNumBands(); ++n) {
                    int n3 = random.nextInt(255);
                    writableRaster.setSample(j, i, n, n3);
                    Assert.assertEquals((long)n3, (long)writableRaster.getSample(j, i, n));
                    Assert.assertEquals((long)n3, (long)writableRaster2.getSample(j, i, n));
                    n2 |= n3 << nArray[n];
                }
                if (writableRaster.getNumBands() < 4) {
                    n2 |= 0xFF000000;
                }
                if (n2 == (n = bufferedImage.getRGB(j, i))) continue;
                Assert.assertEquals((String)(j + ", " + i + ": "), (Object)String.format("#%08x", n), (Object)String.format("#%08x", n2));
            }
        }
    }
}

