/*
 * Decompiled with CFR 0.152.
 */
package com.twelvemonkeys.imageio.util;

import com.twelvemonkeys.imageio.stream.URLImageInputStreamSpi;
import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.LinearGradientPaint;
import java.awt.Polygon;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.lang.reflect.ParameterizedType;
import java.net.URL;
import java.util.List;
import javax.imageio.ImageIO;
import javax.imageio.ImageWriteParam;
import javax.imageio.ImageWriter;
import javax.imageio.event.IIOWriteProgressListener;
import javax.imageio.spi.IIORegistry;
import javax.imageio.spi.ImageWriterSpi;
import javax.imageio.stream.ImageOutputStream;
import org.junit.Assert;
import org.junit.Test;
import org.mockito.InOrder;
import org.mockito.Mockito;

public abstract class ImageWriterAbstractTest<T extends ImageWriter> {
    private final Class<T> writerClass = (Class)((ParameterizedType)this.getClass().getGenericSuperclass()).getActualTypeArguments()[0];
    protected final ImageWriterSpi provider = this.createProvider();

    protected abstract ImageWriterSpi createProvider();

    protected final T createWriter() throws IOException {
        return (T)((ImageWriter)this.writerClass.cast(this.provider.createWriterInstance()));
    }

    protected abstract List<? extends RenderedImage> getTestData();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected static BufferedImage drawSomething(BufferedImage bufferedImage) {
        Graphics2D graphics2D = bufferedImage.createGraphics();
        try {
            int n = bufferedImage.getWidth();
            int n2 = bufferedImage.getHeight();
            graphics2D.clearRect(0, 0, n, n2);
            graphics2D.setPaint(new LinearGradientPaint(0.0f, 0.0f, n, 0.0f, new float[]{0.2f, 1.0f}, new Color[]{new Color(0, true), Color.BLUE}));
            graphics2D.fillRect(0, 0, n, n2);
            graphics2D.setPaint(new LinearGradientPaint(0.0f, 0.0f, 0.0f, n2, new float[]{0.2f, 1.0f}, new Color[]{new Color(0, true), Color.RED}));
            graphics2D.fillRect(0, 0, n, n2);
            graphics2D.setPaint(new LinearGradientPaint(0.0f, 0.0f, 0.0f, n2, new float[]{0.0f, 1.0f}, new Color[]{new Color(0xFFFFFF, true), Color.WHITE}));
            graphics2D.fill(new Polygon(new int[]{0, n, n}, new int[]{0, n2, 0}, 3));
        }
        finally {
            graphics2D.dispose();
        }
        return bufferedImage;
    }

    protected final RenderedImage getTestData(int n) {
        return this.getTestData().get(n);
    }

    protected URL getClassLoaderResource(String string) {
        return this.getClass().getResource(string);
    }

    @Test
    public void testSetOutput() throws IOException {
        T t = this.createWriter();
        Assert.assertNotNull(t);
        ((ImageWriter)t).setOutput(ImageIO.createImageOutputStream(new ByteArrayOutputStream()));
    }

    @Test
    public void testSetOutputNull() throws IOException {
        T t = this.createWriter();
        Assert.assertNotNull(t);
        ((ImageWriter)t).setOutput(null);
    }

    @Test
    public void testWrite() throws IOException {
        T t = this.createWriter();
        for (RenderedImage renderedImage : this.getTestData()) {
            ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
            try (ImageOutputStream imageOutputStream = ImageIO.createImageOutputStream(byteArrayOutputStream);){
                ((ImageWriter)t).setOutput(imageOutputStream);
                ((ImageWriter)t).write(ImageWriterAbstractTest.drawSomething((BufferedImage)renderedImage));
            }
            catch (IOException iOException) {
                throw new AssertionError(iOException.getMessage(), iOException);
            }
            Assert.assertTrue((String)"No image data written", (byteArrayOutputStream.size() > 0 ? 1 : 0) != 0);
        }
    }

    @Test
    public void testWriteNull() throws IOException {
        T t = this.createWriter();
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        ((ImageWriter)t).setOutput(ImageIO.createImageOutputStream(byteArrayOutputStream));
        try {
            ((ImageWriter)t).write((RenderedImage)null);
        }
        catch (IllegalArgumentException illegalArgumentException) {
        }
        catch (IOException iOException) {
            throw new AssertionError(iOException.getMessage(), iOException);
        }
        Assert.assertEquals((String)"Image data written", (long)0L, (long)byteArrayOutputStream.size());
    }

    @Test(expected=IllegalStateException.class)
    public void testWriteNoOutput() throws IOException {
        T t = this.createWriter();
        try {
            ((ImageWriter)t).write(this.getTestData(0));
        }
        catch (IOException iOException) {
            Assert.fail((String)iOException.getMessage());
        }
    }

    @Test
    public void testGetDefaultWriteParam() throws IOException {
        T t = this.createWriter();
        ImageWriteParam imageWriteParam = ((ImageWriter)t).getDefaultWriteParam();
        Assert.assertNotNull((String)"Default ImageWriteParam is null", (Object)imageWriteParam);
    }

    @Test
    public void testAddIIOWriteProgressListener() throws IOException {
        T t = this.createWriter();
        ((ImageWriter)t).addIIOWriteProgressListener((IIOWriteProgressListener)Mockito.mock(IIOWriteProgressListener.class));
    }

    @Test
    public void testAddIIOWriteProgressListenerNull() throws IOException {
        T t = this.createWriter();
        ((ImageWriter)t).addIIOWriteProgressListener(null);
    }

    @Test
    public void testAddIIOWriteProgressListenerCallbacks() throws IOException {
        T t = this.createWriter();
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        ((ImageWriter)t).setOutput(ImageIO.createImageOutputStream(byteArrayOutputStream));
        IIOWriteProgressListener iIOWriteProgressListener = (IIOWriteProgressListener)Mockito.mock(IIOWriteProgressListener.class);
        ((ImageWriter)t).addIIOWriteProgressListener(iIOWriteProgressListener);
        try {
            ((ImageWriter)t).write(this.getTestData(0));
        }
        catch (IOException iOException) {
            Assert.fail((String)"Could not write image");
        }
        InOrder inOrder = Mockito.inOrder((Object[])new Object[]{iIOWriteProgressListener});
        ((IIOWriteProgressListener)inOrder.verify((Object)iIOWriteProgressListener)).imageStarted((ImageWriter)t, 0);
        ((IIOWriteProgressListener)inOrder.verify((Object)iIOWriteProgressListener, Mockito.atLeastOnce())).imageProgress((ImageWriter)Mockito.eq(t), Mockito.anyFloat());
        ((IIOWriteProgressListener)inOrder.verify((Object)iIOWriteProgressListener)).imageComplete((ImageWriter)t);
    }

    @Test
    public void testMultipleAddIIOWriteProgressListenerCallbacks() throws IOException {
        T t = this.createWriter();
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        ((ImageWriter)t).setOutput(ImageIO.createImageOutputStream(byteArrayOutputStream));
        IIOWriteProgressListener iIOWriteProgressListener = (IIOWriteProgressListener)Mockito.mock(IIOWriteProgressListener.class);
        IIOWriteProgressListener iIOWriteProgressListener2 = (IIOWriteProgressListener)Mockito.mock(IIOWriteProgressListener.class);
        IIOWriteProgressListener iIOWriteProgressListener3 = (IIOWriteProgressListener)Mockito.mock(IIOWriteProgressListener.class);
        ((ImageWriter)t).addIIOWriteProgressListener(iIOWriteProgressListener);
        ((ImageWriter)t).addIIOWriteProgressListener(iIOWriteProgressListener2);
        ((ImageWriter)t).addIIOWriteProgressListener(iIOWriteProgressListener3);
        try {
            ((ImageWriter)t).write(this.getTestData(0));
        }
        catch (IOException iOException) {
            Assert.fail((String)"Could not write image");
        }
        InOrder inOrder = Mockito.inOrder((Object[])new Object[]{iIOWriteProgressListener, iIOWriteProgressListener2, iIOWriteProgressListener3});
        ((IIOWriteProgressListener)inOrder.verify((Object)iIOWriteProgressListener)).imageStarted((ImageWriter)t, 0);
        ((IIOWriteProgressListener)inOrder.verify((Object)iIOWriteProgressListener2)).imageStarted((ImageWriter)t, 0);
        ((IIOWriteProgressListener)inOrder.verify((Object)iIOWriteProgressListener3)).imageStarted((ImageWriter)t, 0);
        ((IIOWriteProgressListener)inOrder.verify((Object)iIOWriteProgressListener, Mockito.atLeastOnce())).imageProgress((ImageWriter)Mockito.eq(t), Mockito.anyFloat());
        ((IIOWriteProgressListener)inOrder.verify((Object)iIOWriteProgressListener2, Mockito.atLeastOnce())).imageProgress((ImageWriter)Mockito.eq(t), Mockito.anyFloat());
        ((IIOWriteProgressListener)inOrder.verify((Object)iIOWriteProgressListener3, Mockito.atLeastOnce())).imageProgress((ImageWriter)Mockito.eq(t), Mockito.anyFloat());
        ((IIOWriteProgressListener)inOrder.verify((Object)iIOWriteProgressListener)).imageComplete((ImageWriter)t);
        ((IIOWriteProgressListener)inOrder.verify((Object)iIOWriteProgressListener2)).imageComplete((ImageWriter)t);
        ((IIOWriteProgressListener)inOrder.verify((Object)iIOWriteProgressListener3)).imageComplete((ImageWriter)t);
    }

    @Test
    public void testRemoveIIOWriteProgressListenerNull() throws IOException {
        T t = this.createWriter();
        ((ImageWriter)t).removeIIOWriteProgressListener(null);
    }

    @Test
    public void testRemoveIIOWriteProgressListenerNone() throws IOException {
        T t = this.createWriter();
        ((ImageWriter)t).removeIIOWriteProgressListener((IIOWriteProgressListener)Mockito.mock(IIOWriteProgressListener.class));
    }

    @Test
    public void testRemoveIIOWriteProgressListener() throws IOException {
        T t = this.createWriter();
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        ((ImageWriter)t).setOutput(ImageIO.createImageOutputStream(byteArrayOutputStream));
        IIOWriteProgressListener iIOWriteProgressListener = (IIOWriteProgressListener)Mockito.mock(IIOWriteProgressListener.class);
        ((ImageWriter)t).addIIOWriteProgressListener(iIOWriteProgressListener);
        ((ImageWriter)t).removeIIOWriteProgressListener(iIOWriteProgressListener);
        try {
            ((ImageWriter)t).write(this.getTestData(0));
        }
        catch (IOException iOException) {
            Assert.fail((String)"Could not write image");
        }
        Mockito.verifyNoInteractions((Object[])new Object[]{iIOWriteProgressListener});
    }

    @Test
    public void testRemoveIIOWriteProgressListenerMultiple() throws IOException {
        T t = this.createWriter();
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        ((ImageWriter)t).setOutput(ImageIO.createImageOutputStream(byteArrayOutputStream));
        IIOWriteProgressListener iIOWriteProgressListener = (IIOWriteProgressListener)Mockito.mock(IIOWriteProgressListener.class);
        ((ImageWriter)t).addIIOWriteProgressListener(iIOWriteProgressListener);
        IIOWriteProgressListener iIOWriteProgressListener2 = (IIOWriteProgressListener)Mockito.mock(IIOWriteProgressListener.class);
        ((ImageWriter)t).addIIOWriteProgressListener(iIOWriteProgressListener2);
        ((ImageWriter)t).removeIIOWriteProgressListener(iIOWriteProgressListener);
        try {
            ((ImageWriter)t).write(this.getTestData(0));
        }
        catch (IOException iOException) {
            Assert.fail((String)"Could not write image");
        }
        Mockito.verifyNoInteractions((Object[])new Object[]{iIOWriteProgressListener});
        InOrder inOrder = Mockito.inOrder((Object[])new Object[]{iIOWriteProgressListener2});
        ((IIOWriteProgressListener)inOrder.verify((Object)iIOWriteProgressListener2)).imageStarted((ImageWriter)t, 0);
        ((IIOWriteProgressListener)inOrder.verify((Object)iIOWriteProgressListener2, Mockito.atLeastOnce())).imageProgress((ImageWriter)Mockito.eq(t), Mockito.anyFloat());
        ((IIOWriteProgressListener)inOrder.verify((Object)iIOWriteProgressListener2)).imageComplete((ImageWriter)t);
    }

    @Test
    public void testRemoveAllIIOWriteProgressListeners() throws IOException {
        T t = this.createWriter();
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        ((ImageWriter)t).setOutput(ImageIO.createImageOutputStream(byteArrayOutputStream));
        IIOWriteProgressListener iIOWriteProgressListener = (IIOWriteProgressListener)Mockito.mock(IIOWriteProgressListener.class);
        ((ImageWriter)t).addIIOWriteProgressListener(iIOWriteProgressListener);
        ((ImageWriter)t).removeAllIIOWriteProgressListeners();
        try {
            ((ImageWriter)t).write(this.getTestData(0));
        }
        catch (IOException iOException) {
            Assert.fail((String)"Could not write image");
        }
        Mockito.verifyNoInteractions((Object[])new Object[]{iIOWriteProgressListener});
    }

    @Test
    public void testRemoveAllIIOWriteProgressListenersMultiple() throws IOException {
        T t = this.createWriter();
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        ((ImageWriter)t).setOutput(ImageIO.createImageOutputStream(byteArrayOutputStream));
        IIOWriteProgressListener iIOWriteProgressListener = (IIOWriteProgressListener)Mockito.mock(IIOWriteProgressListener.class);
        ((ImageWriter)t).addIIOWriteProgressListener(iIOWriteProgressListener);
        IIOWriteProgressListener iIOWriteProgressListener2 = (IIOWriteProgressListener)Mockito.mock(IIOWriteProgressListener.class);
        ((ImageWriter)t).addIIOWriteProgressListener(iIOWriteProgressListener2);
        ((ImageWriter)t).removeAllIIOWriteProgressListeners();
        try {
            ((ImageWriter)t).write(this.getTestData(0));
        }
        catch (IOException iOException) {
            Assert.fail((String)"Could not write image");
        }
        Mockito.verifyNoInteractions((Object[])new Object[]{iIOWriteProgressListener});
        Mockito.verifyNoInteractions((Object[])new Object[]{iIOWriteProgressListener2});
    }

    static {
        IIORegistry.getDefaultInstance().registerServiceProvider(new URLImageInputStreamSpi());
        ImageIO.setUseCache(false);
    }
}

