/*
 * Decompiled with CFR 0.152.
 */
package com.twelvemonkeys.imageio.util;

import com.twelvemonkeys.imageio.util.ImageTypeSpecifiers;
import com.twelvemonkeys.imageio.util.IndexedImageTypeSpecifier;
import com.twelvemonkeys.imageio.util.Int16ImageTypeSpecifier;
import com.twelvemonkeys.imageio.util.UInt32ImageTypeSpecifier;
import com.twelvemonkeys.lang.Validate;
import java.awt.color.ColorSpace;
import java.awt.image.BufferedImage;
import java.awt.image.ColorModel;
import java.awt.image.DirectColorModel;
import java.awt.image.IndexColorModel;
import java.awt.image.RenderedImage;
import javax.imageio.ImageTypeSpecifier;
import org.junit.Assert;
import org.junit.Test;

public class ImageTypeSpecifiersTest {
    private static final ColorSpace sRGB = ColorSpace.getInstance(1000);
    private static final ColorSpace GRAY = ColorSpace.getInstance(1003);
    private static final int DCM_RED_MASK = 0xFF0000;
    private static final int DCM_GREEN_MASK = 65280;
    private static final int DCM_BLUE_MASK = 255;
    private static final int DCM_ALPHA_MASK = -16777216;
    private static final int DCM_565_RED_MASK = 63488;
    private static final int DCM_565_GRN_MASK = 2016;
    private static final int DCM_565_BLU_MASK = 31;
    private static final int DCM_555_RED_MASK = 31744;
    private static final int DCM_555_GRN_MASK = 992;
    private static final int DCM_555_BLU_MASK = 31;
    private static final int DCM_BGR_RED_MASK = 255;
    private static final int DCM_BGR_GRN_MASK = 65280;
    private static final int DCM_BGR_BLU_MASK = 0xFF0000;

    @Test
    public void testCreateFromBufferedImageType() {
        for (int i = 1; i < 13; ++i) {
            ImageTypeSpecifier imageTypeSpecifier;
            switch (i) {
                case 1: {
                    imageTypeSpecifier = this.createPacked(sRGB, 24, 0xFF0000, 65280, 255, 0, 3, false);
                    break;
                }
                case 4: {
                    imageTypeSpecifier = this.createPacked(sRGB, 24, 255, 65280, 0xFF0000, 0, 3, false);
                    break;
                }
                case 8: {
                    imageTypeSpecifier = this.createPacked(sRGB, 16, 63488, 2016, 31, 0, 1, false);
                    break;
                }
                case 9: {
                    imageTypeSpecifier = this.createPacked(sRGB, 15, 31744, 992, 31, 0, 1, false);
                    break;
                }
                default: {
                    imageTypeSpecifier = ImageTypeSpecifier.createFromBufferedImageType(i);
                }
            }
            Assert.assertEquals((Object)imageTypeSpecifier, (Object)ImageTypeSpecifiers.createFromBufferedImageType((int)i));
        }
    }

    @Test
    public void testCreatePacked24() {
        Assert.assertEquals((Object)this.createPacked(sRGB, 24, 0xFF0000, 65280, 255, 0, 3, false), (Object)ImageTypeSpecifiers.createPacked((ColorSpace)sRGB, (int)0xFF0000, (int)65280, (int)255, (int)0, (int)3, (boolean)false));
        Assert.assertEquals((Object)this.createPacked(sRGB, 24, 255, 65280, 0xFF0000, 0, 3, false), (Object)ImageTypeSpecifiers.createPacked((ColorSpace)sRGB, (int)255, (int)65280, (int)0xFF0000, (int)0, (int)3, (boolean)false));
        Assert.assertEquals((long)24L, (long)ImageTypeSpecifiers.createPacked((ColorSpace)sRGB, (int)0xFF0000, (int)65280, (int)255, (int)0, (int)3, (boolean)false).getColorModel().getPixelSize());
    }

    @Test
    public void testCreatePacked32() {
        Assert.assertEquals((Object)ImageTypeSpecifier.createPacked(sRGB, 0xFF0000, 65280, 255, -16777216, 3, false), (Object)ImageTypeSpecifiers.createPacked((ColorSpace)sRGB, (int)0xFF0000, (int)65280, (int)255, (int)-16777216, (int)3, (boolean)false));
        Assert.assertEquals((Object)ImageTypeSpecifier.createPacked(sRGB, 0xFF0000, 65280, 255, -16777216, 3, true), (Object)ImageTypeSpecifiers.createPacked((ColorSpace)sRGB, (int)0xFF0000, (int)65280, (int)255, (int)-16777216, (int)3, (boolean)true));
    }

    @Test
    public void testCreatePacked15() {
        Assert.assertEquals((Object)this.createPacked(sRGB, 15, 31744, 992, 31, 0, 1, false), (Object)ImageTypeSpecifiers.createPacked((ColorSpace)sRGB, (int)31744, (int)992, (int)31, (int)0, (int)1, (boolean)false));
        Assert.assertEquals((long)15L, (long)ImageTypeSpecifiers.createPacked((ColorSpace)sRGB, (int)31744, (int)992, (int)31, (int)0, (int)1, (boolean)false).getColorModel().getPixelSize());
    }

    @Test
    public void testCreatePacked16() {
        Assert.assertEquals((Object)this.createPacked(sRGB, 16, 63488, 2016, 31, 0, 1, false), (Object)ImageTypeSpecifiers.createPacked((ColorSpace)sRGB, (int)63488, (int)2016, (int)31, (int)0, (int)1, (boolean)false));
        Assert.assertEquals((Object)this.createPacked(sRGB, 16, 3840, 240, 15, 61440, 1, false), (Object)ImageTypeSpecifiers.createPacked((ColorSpace)sRGB, (int)3840, (int)240, (int)15, (int)61440, (int)1, (boolean)false));
        Assert.assertEquals((Object)this.createPacked(sRGB, 16, 3840, 240, 15, 61440, 1, true), (Object)ImageTypeSpecifiers.createPacked((ColorSpace)sRGB, (int)3840, (int)240, (int)15, (int)61440, (int)1, (boolean)true));
        Assert.assertEquals((long)16L, (long)ImageTypeSpecifiers.createPacked((ColorSpace)sRGB, (int)63488, (int)2016, (int)31, (int)0, (int)1, (boolean)false).getColorModel().getPixelSize());
    }

    @Test
    public void testCreatePacked8() {
        Assert.assertEquals((Object)this.createPacked(sRGB, 8, 224, 28, 3, 0, 0, false), (Object)ImageTypeSpecifiers.createPacked((ColorSpace)sRGB, (int)224, (int)28, (int)3, (int)0, (int)0, (boolean)false));
        Assert.assertEquals((Object)this.createPacked(sRGB, 8, 192, 48, 12, 3, 0, false), (Object)ImageTypeSpecifiers.createPacked((ColorSpace)sRGB, (int)192, (int)48, (int)12, (int)3, (int)0, (boolean)false));
        Assert.assertEquals((Object)this.createPacked(sRGB, 8, 192, 48, 12, 3, 0, true), (Object)ImageTypeSpecifiers.createPacked((ColorSpace)sRGB, (int)192, (int)48, (int)12, (int)3, (int)0, (boolean)true));
        Assert.assertEquals((long)8L, (long)ImageTypeSpecifiers.createPacked((ColorSpace)sRGB, (int)192, (int)48, (int)12, (int)3, (int)0, (boolean)false).getColorModel().getPixelSize());
    }

    private ImageTypeSpecifier createPacked(ColorSpace colorSpace, int n, int n2, int n3, int n4, int n5, int n6, boolean bl) {
        Validate.isTrue((n6 == 0 || n6 == 1 || n6 == 3 ? 1 : 0) != 0, (Object)n6, (String)"transferType: %s");
        DirectColorModel directColorModel = new DirectColorModel(colorSpace, n, n2, n3, n4, n5, bl, n6);
        return new ImageTypeSpecifier(directColorModel, ((ColorModel)directColorModel).createCompatibleSampleModel(1, 1));
    }

    @Test
    public void testCreateInterleaved8() {
        Assert.assertEquals((Object)ImageTypeSpecifier.createInterleaved(GRAY, new int[]{0}, 0, false, false), (Object)ImageTypeSpecifiers.createInterleaved((ColorSpace)GRAY, (int[])new int[]{0}, (int)0, (boolean)false, (boolean)false));
        Assert.assertEquals((Object)ImageTypeSpecifier.createInterleaved(GRAY, new int[]{0, 1}, 0, true, false), (Object)ImageTypeSpecifiers.createInterleaved((ColorSpace)GRAY, (int[])new int[]{0, 1}, (int)0, (boolean)true, (boolean)false));
        Assert.assertEquals((Object)ImageTypeSpecifier.createInterleaved(sRGB, new int[]{0, 1, 2}, 0, false, false), (Object)ImageTypeSpecifiers.createInterleaved((ColorSpace)sRGB, (int[])new int[]{0, 1, 2}, (int)0, (boolean)false, (boolean)false));
        Assert.assertEquals((Object)ImageTypeSpecifier.createInterleaved(sRGB, new int[]{0, 1, 2, 3}, 0, true, false), (Object)ImageTypeSpecifiers.createInterleaved((ColorSpace)sRGB, (int[])new int[]{0, 1, 2, 3}, (int)0, (boolean)true, (boolean)false));
        Assert.assertEquals((Object)ImageTypeSpecifier.createInterleaved(sRGB, new int[]{0, 1, 2, 3}, 0, true, true), (Object)ImageTypeSpecifiers.createInterleaved((ColorSpace)sRGB, (int[])new int[]{0, 1, 2, 3}, (int)0, (boolean)true, (boolean)true));
    }

    @Test
    public void testCreateInterleaved16() {
        Assert.assertEquals((Object)ImageTypeSpecifier.createInterleaved(GRAY, new int[]{0}, 1, false, false), (Object)ImageTypeSpecifiers.createInterleaved((ColorSpace)GRAY, (int[])new int[]{0}, (int)1, (boolean)false, (boolean)false));
        Assert.assertEquals((Object)ImageTypeSpecifier.createInterleaved(GRAY, new int[]{0, 1}, 1, true, false), (Object)ImageTypeSpecifiers.createInterleaved((ColorSpace)GRAY, (int[])new int[]{0, 1}, (int)1, (boolean)true, (boolean)false));
        Assert.assertEquals((Object)ImageTypeSpecifier.createInterleaved(sRGB, new int[]{0, 1, 2}, 1, false, false), (Object)ImageTypeSpecifiers.createInterleaved((ColorSpace)sRGB, (int[])new int[]{0, 1, 2}, (int)1, (boolean)false, (boolean)false));
        Assert.assertEquals((Object)ImageTypeSpecifier.createInterleaved(sRGB, new int[]{0, 1, 2, 3}, 1, true, false), (Object)ImageTypeSpecifiers.createInterleaved((ColorSpace)sRGB, (int[])new int[]{0, 1, 2, 3}, (int)1, (boolean)true, (boolean)false));
        Assert.assertEquals((Object)ImageTypeSpecifier.createInterleaved(sRGB, new int[]{0, 1, 2, 3}, 1, true, true), (Object)ImageTypeSpecifiers.createInterleaved((ColorSpace)sRGB, (int[])new int[]{0, 1, 2, 3}, (int)1, (boolean)true, (boolean)true));
    }

    @Test
    public void testCreateInterleaved32() {
        Assert.assertEquals((Object)UInt32ImageTypeSpecifier.createInterleaved((ColorSpace)GRAY, (int[])new int[]{0}, (boolean)false, (boolean)false), (Object)ImageTypeSpecifiers.createInterleaved((ColorSpace)GRAY, (int[])new int[]{0}, (int)3, (boolean)false, (boolean)false));
        Assert.assertEquals((Object)UInt32ImageTypeSpecifier.createInterleaved((ColorSpace)GRAY, (int[])new int[]{0, 1}, (boolean)true, (boolean)false), (Object)ImageTypeSpecifiers.createInterleaved((ColorSpace)GRAY, (int[])new int[]{0, 1}, (int)3, (boolean)true, (boolean)false));
        Assert.assertEquals((Object)UInt32ImageTypeSpecifier.createInterleaved((ColorSpace)sRGB, (int[])new int[]{0, 1, 2}, (boolean)false, (boolean)false), (Object)ImageTypeSpecifiers.createInterleaved((ColorSpace)sRGB, (int[])new int[]{0, 1, 2}, (int)3, (boolean)false, (boolean)false));
        Assert.assertEquals((Object)UInt32ImageTypeSpecifier.createInterleaved((ColorSpace)sRGB, (int[])new int[]{0, 1, 2, 3}, (boolean)true, (boolean)false), (Object)ImageTypeSpecifiers.createInterleaved((ColorSpace)sRGB, (int[])new int[]{0, 1, 2, 3}, (int)3, (boolean)true, (boolean)false));
        Assert.assertEquals((Object)UInt32ImageTypeSpecifier.createInterleaved((ColorSpace)sRGB, (int[])new int[]{0, 1, 2, 3}, (boolean)true, (boolean)true), (Object)ImageTypeSpecifiers.createInterleaved((ColorSpace)sRGB, (int[])new int[]{0, 1, 2, 3}, (int)3, (boolean)true, (boolean)true));
    }

    @Test
    public void testCreateInterleaved32fp() {
        Assert.assertEquals((Object)ImageTypeSpecifier.createInterleaved(GRAY, new int[]{0}, 4, false, false), (Object)ImageTypeSpecifiers.createInterleaved((ColorSpace)GRAY, (int[])new int[]{0}, (int)4, (boolean)false, (boolean)false));
        Assert.assertEquals((Object)ImageTypeSpecifier.createInterleaved(GRAY, new int[]{0, 1}, 4, true, false), (Object)ImageTypeSpecifiers.createInterleaved((ColorSpace)GRAY, (int[])new int[]{0, 1}, (int)4, (boolean)true, (boolean)false));
        Assert.assertEquals((Object)ImageTypeSpecifier.createInterleaved(sRGB, new int[]{0, 1, 2}, 4, false, false), (Object)ImageTypeSpecifiers.createInterleaved((ColorSpace)sRGB, (int[])new int[]{0, 1, 2}, (int)4, (boolean)false, (boolean)false));
        Assert.assertEquals((Object)ImageTypeSpecifier.createInterleaved(sRGB, new int[]{0, 1, 2, 3}, 4, true, false), (Object)ImageTypeSpecifiers.createInterleaved((ColorSpace)sRGB, (int[])new int[]{0, 1, 2, 3}, (int)4, (boolean)true, (boolean)false));
        Assert.assertEquals((Object)ImageTypeSpecifier.createInterleaved(sRGB, new int[]{0, 1, 2, 3}, 4, true, true), (Object)ImageTypeSpecifiers.createInterleaved((ColorSpace)sRGB, (int[])new int[]{0, 1, 2, 3}, (int)4, (boolean)true, (boolean)true));
    }

    @Test
    public void testCreateInterleaved64fp() {
        Assert.assertEquals((Object)ImageTypeSpecifier.createInterleaved(GRAY, new int[]{0}, 5, false, false), (Object)ImageTypeSpecifiers.createInterleaved((ColorSpace)GRAY, (int[])new int[]{0}, (int)5, (boolean)false, (boolean)false));
        Assert.assertEquals((Object)ImageTypeSpecifier.createInterleaved(GRAY, new int[]{0, 1}, 5, true, false), (Object)ImageTypeSpecifiers.createInterleaved((ColorSpace)GRAY, (int[])new int[]{0, 1}, (int)5, (boolean)true, (boolean)false));
        Assert.assertEquals((Object)ImageTypeSpecifier.createInterleaved(sRGB, new int[]{0, 1, 2}, 5, false, false), (Object)ImageTypeSpecifiers.createInterleaved((ColorSpace)sRGB, (int[])new int[]{0, 1, 2}, (int)5, (boolean)false, (boolean)false));
        Assert.assertEquals((Object)ImageTypeSpecifier.createInterleaved(sRGB, new int[]{0, 1, 2, 3}, 5, true, false), (Object)ImageTypeSpecifiers.createInterleaved((ColorSpace)sRGB, (int[])new int[]{0, 1, 2, 3}, (int)5, (boolean)true, (boolean)false));
        Assert.assertEquals((Object)ImageTypeSpecifier.createInterleaved(sRGB, new int[]{0, 1, 2, 3}, 5, true, true), (Object)ImageTypeSpecifiers.createInterleaved((ColorSpace)sRGB, (int[])new int[]{0, 1, 2, 3}, (int)5, (boolean)true, (boolean)true));
    }

    @Test
    public void testCreateBanded8() {
        Assert.assertEquals((Object)ImageTypeSpecifier.createBanded(sRGB, new int[]{0, 1, 2}, new int[]{0, 0, 0}, 0, false, false), (Object)ImageTypeSpecifiers.createBanded((ColorSpace)sRGB, (int[])new int[]{0, 1, 2}, (int[])new int[]{0, 0, 0}, (int)0, (boolean)false, (boolean)false));
        Assert.assertEquals((Object)ImageTypeSpecifier.createBanded(sRGB, new int[]{0, 1, 2, 3}, new int[]{0, 0, 0, 0}, 0, true, false), (Object)ImageTypeSpecifiers.createBanded((ColorSpace)sRGB, (int[])new int[]{0, 1, 2, 3}, (int[])new int[]{0, 0, 0, 0}, (int)0, (boolean)true, (boolean)false));
        Assert.assertEquals((Object)ImageTypeSpecifier.createBanded(sRGB, new int[]{0, 1, 2, 3}, new int[]{0, 1000, 2000, 3000}, 0, true, true), (Object)ImageTypeSpecifiers.createBanded((ColorSpace)sRGB, (int[])new int[]{0, 1, 2, 3}, (int[])new int[]{0, 1000, 2000, 3000}, (int)0, (boolean)true, (boolean)true));
    }

    @Test
    public void testCreateBanded16() {
        Assert.assertEquals((Object)ImageTypeSpecifier.createBanded(sRGB, new int[]{0, 1, 2}, new int[]{0, 0, 0}, 1, false, false), (Object)ImageTypeSpecifiers.createBanded((ColorSpace)sRGB, (int[])new int[]{0, 1, 2}, (int[])new int[]{0, 0, 0}, (int)1, (boolean)false, (boolean)false));
        Assert.assertEquals((Object)ImageTypeSpecifier.createBanded(sRGB, new int[]{0, 1, 2, 3}, new int[]{0, 0, 0, 0}, 1, true, false), (Object)ImageTypeSpecifiers.createBanded((ColorSpace)sRGB, (int[])new int[]{0, 1, 2, 3}, (int[])new int[]{0, 0, 0, 0}, (int)1, (boolean)true, (boolean)false));
        Assert.assertEquals((Object)ImageTypeSpecifier.createBanded(sRGB, new int[]{0, 1, 2, 3}, new int[]{0, 1000, 2000, 3000}, 1, true, true), (Object)ImageTypeSpecifiers.createBanded((ColorSpace)sRGB, (int[])new int[]{0, 1, 2, 3}, (int[])new int[]{0, 1000, 2000, 3000}, (int)1, (boolean)true, (boolean)true));
        Assert.assertEquals((Object)ImageTypeSpecifier.createBanded(sRGB, new int[]{0, 1, 2}, new int[]{0, 0, 0}, 2, false, false), (Object)ImageTypeSpecifiers.createBanded((ColorSpace)sRGB, (int[])new int[]{0, 1, 2}, (int[])new int[]{0, 0, 0}, (int)2, (boolean)false, (boolean)false));
        Assert.assertEquals((Object)ImageTypeSpecifier.createBanded(sRGB, new int[]{0, 1, 2, 3}, new int[]{0, 0, 0, 0}, 2, true, false), (Object)ImageTypeSpecifiers.createBanded((ColorSpace)sRGB, (int[])new int[]{0, 1, 2, 3}, (int[])new int[]{0, 0, 0, 0}, (int)2, (boolean)true, (boolean)false));
        Assert.assertEquals((Object)ImageTypeSpecifier.createBanded(sRGB, new int[]{0, 1, 2, 3}, new int[]{0, 1000, 2000, 3000}, 2, true, true), (Object)ImageTypeSpecifiers.createBanded((ColorSpace)sRGB, (int[])new int[]{0, 1, 2, 3}, (int[])new int[]{0, 1000, 2000, 3000}, (int)2, (boolean)true, (boolean)true));
    }

    @Test
    public void testCreateBanded32() {
        Assert.assertEquals((Object)UInt32ImageTypeSpecifier.createBanded((ColorSpace)sRGB, (int[])new int[]{0, 1, 2}, (int[])new int[]{0, 0, 0}, (boolean)false, (boolean)false), (Object)ImageTypeSpecifiers.createBanded((ColorSpace)sRGB, (int[])new int[]{0, 1, 2}, (int[])new int[]{0, 0, 0}, (int)3, (boolean)false, (boolean)false));
        Assert.assertEquals((Object)UInt32ImageTypeSpecifier.createBanded((ColorSpace)sRGB, (int[])new int[]{0, 1, 2, 3}, (int[])new int[]{0, 0, 0, 0}, (boolean)true, (boolean)false), (Object)ImageTypeSpecifiers.createBanded((ColorSpace)sRGB, (int[])new int[]{0, 1, 2, 3}, (int[])new int[]{0, 0, 0, 0}, (int)3, (boolean)true, (boolean)false));
        Assert.assertEquals((Object)UInt32ImageTypeSpecifier.createBanded((ColorSpace)sRGB, (int[])new int[]{0, 1, 2, 3}, (int[])new int[]{0, 1000, 2000, 3000}, (boolean)true, (boolean)true), (Object)ImageTypeSpecifiers.createBanded((ColorSpace)sRGB, (int[])new int[]{0, 1, 2, 3}, (int[])new int[]{0, 1000, 2000, 3000}, (int)3, (boolean)true, (boolean)true));
    }

    @Test
    public void testCreateBanded32fp() {
        Assert.assertEquals((Object)ImageTypeSpecifier.createBanded(sRGB, new int[]{0, 1, 2}, new int[]{0, 0, 0}, 4, false, false), (Object)ImageTypeSpecifiers.createBanded((ColorSpace)sRGB, (int[])new int[]{0, 1, 2}, (int[])new int[]{0, 0, 0}, (int)4, (boolean)false, (boolean)false));
        Assert.assertEquals((Object)ImageTypeSpecifier.createBanded(sRGB, new int[]{0, 1, 2, 3}, new int[]{0, 0, 0, 0}, 4, true, false), (Object)ImageTypeSpecifiers.createBanded((ColorSpace)sRGB, (int[])new int[]{0, 1, 2, 3}, (int[])new int[]{0, 0, 0, 0}, (int)4, (boolean)true, (boolean)false));
        Assert.assertEquals((Object)ImageTypeSpecifier.createBanded(sRGB, new int[]{0, 1, 2, 3}, new int[]{0, 1000, 2000, 3000}, 4, true, true), (Object)ImageTypeSpecifiers.createBanded((ColorSpace)sRGB, (int[])new int[]{0, 1, 2, 3}, (int[])new int[]{0, 1000, 2000, 3000}, (int)4, (boolean)true, (boolean)true));
    }

    @Test
    public void testCreateBanded64fp() {
        Assert.assertEquals((Object)ImageTypeSpecifier.createBanded(sRGB, new int[]{0, 1, 2}, new int[]{0, 0, 0}, 5, false, false), (Object)ImageTypeSpecifiers.createBanded((ColorSpace)sRGB, (int[])new int[]{0, 1, 2}, (int[])new int[]{0, 0, 0}, (int)5, (boolean)false, (boolean)false));
        Assert.assertEquals((Object)ImageTypeSpecifier.createBanded(sRGB, new int[]{0, 1, 2, 3}, new int[]{0, 0, 0, 0}, 5, true, false), (Object)ImageTypeSpecifiers.createBanded((ColorSpace)sRGB, (int[])new int[]{0, 1, 2, 3}, (int[])new int[]{0, 0, 0, 0}, (int)5, (boolean)true, (boolean)false));
        Assert.assertEquals((Object)ImageTypeSpecifier.createBanded(sRGB, new int[]{0, 1, 2, 3}, new int[]{0, 1000, 2000, 3000}, 5, true, true), (Object)ImageTypeSpecifiers.createBanded((ColorSpace)sRGB, (int[])new int[]{0, 1, 2, 3}, (int[])new int[]{0, 1000, 2000, 3000}, (int)5, (boolean)true, (boolean)true));
    }

    @Test
    public void testCreateGrayscale1to8() {
        for (int i = 1; i <= 8; i <<= 1) {
            Assert.assertEquals((Object)ImageTypeSpecifier.createGrayscale(i, 0, false), (Object)ImageTypeSpecifiers.createGrayscale((int)i, (int)0));
            Assert.assertEquals((Object)ImageTypeSpecifier.createGrayscale(i, 0, true), (Object)ImageTypeSpecifiers.createGrayscale((int)i, (int)0));
        }
    }

    @Test
    public void testCreateGrayscale16() {
        Assert.assertEquals((Object)ImageTypeSpecifier.createGrayscale(16, 1, false), (Object)ImageTypeSpecifiers.createGrayscale((int)16, (int)1));
        Assert.assertEquals((Object)ImageTypeSpecifier.createGrayscale(16, 1, true), (Object)ImageTypeSpecifiers.createGrayscale((int)16, (int)1));
        Assert.assertEquals((Object)new Int16ImageTypeSpecifier(ColorSpace.getInstance(1003), new int[]{0}, false, false), (Object)ImageTypeSpecifiers.createGrayscale((int)16, (int)2));
    }

    @Test
    public void testCreateGrayscale32() {
        Assert.assertEquals((Object)UInt32ImageTypeSpecifier.createInterleaved((ColorSpace)GRAY, (int[])new int[]{0}, (boolean)false, (boolean)false), (Object)ImageTypeSpecifiers.createGrayscale((int)32, (int)3));
    }

    @Test
    public void testCreateGrayscaleFloat() {
        Assert.assertEquals((Object)ImageTypeSpecifier.createInterleaved(GRAY, new int[]{0}, 4, false, false), (Object)ImageTypeSpecifiers.createGrayscale((int)32, (int)4));
    }

    @Test
    public void testCreateGrayscaleDouble() {
        Assert.assertEquals((Object)ImageTypeSpecifier.createInterleaved(GRAY, new int[]{0}, 5, false, false), (Object)ImageTypeSpecifiers.createGrayscale((int)64, (int)5));
    }

    @Test
    public void testCreateGrayscaleAlpha1to8() {
        for (int i = 1; i <= 8; i <<= 1) {
            Assert.assertEquals((Object)ImageTypeSpecifier.createGrayscale(i, 0, false, false), (Object)ImageTypeSpecifiers.createGrayscale((int)i, (int)0, (boolean)false));
            Assert.assertEquals((Object)ImageTypeSpecifier.createGrayscale(i, 0, false, true), (Object)ImageTypeSpecifiers.createGrayscale((int)i, (int)0, (boolean)true));
            Assert.assertEquals((Object)ImageTypeSpecifier.createGrayscale(i, 0, true, false), (Object)ImageTypeSpecifiers.createGrayscale((int)i, (int)0, (boolean)false));
            Assert.assertEquals((Object)ImageTypeSpecifier.createGrayscale(i, 0, true, true), (Object)ImageTypeSpecifiers.createGrayscale((int)i, (int)0, (boolean)true));
        }
    }

    @Test
    public void testCreateGrayscaleAlpha16() {
        Assert.assertEquals((Object)ImageTypeSpecifier.createGrayscale(16, 1, false, false), (Object)ImageTypeSpecifiers.createGrayscale((int)16, (int)1, (boolean)false));
        Assert.assertEquals((Object)ImageTypeSpecifier.createGrayscale(16, 1, false, true), (Object)ImageTypeSpecifiers.createGrayscale((int)16, (int)1, (boolean)true));
        Assert.assertEquals((Object)ImageTypeSpecifier.createGrayscale(16, 1, true, false), (Object)ImageTypeSpecifiers.createGrayscale((int)16, (int)1, (boolean)false));
        Assert.assertEquals((Object)ImageTypeSpecifier.createGrayscale(16, 1, true, true), (Object)ImageTypeSpecifiers.createGrayscale((int)16, (int)1, (boolean)true));
        Assert.assertEquals((Object)new Int16ImageTypeSpecifier(ColorSpace.getInstance(1003), new int[]{0, 1}, true, false), (Object)ImageTypeSpecifiers.createGrayscale((int)16, (int)2, (boolean)false));
        Assert.assertEquals((Object)new Int16ImageTypeSpecifier(ColorSpace.getInstance(1003), new int[]{0, 1}, true, true), (Object)ImageTypeSpecifiers.createGrayscale((int)16, (int)2, (boolean)true));
    }

    @Test
    public void testCreateGrayscaleAlpha32() {
        Assert.assertEquals((Object)UInt32ImageTypeSpecifier.createInterleaved((ColorSpace)GRAY, (int[])new int[]{0, 1}, (boolean)true, (boolean)false), (Object)ImageTypeSpecifiers.createGrayscale((int)32, (int)3, (boolean)false));
        Assert.assertEquals((Object)UInt32ImageTypeSpecifier.createInterleaved((ColorSpace)GRAY, (int[])new int[]{0, 1}, (boolean)true, (boolean)false), (Object)ImageTypeSpecifiers.createGrayscale((int)32, (int)3, (boolean)false));
        Assert.assertEquals((Object)UInt32ImageTypeSpecifier.createInterleaved((ColorSpace)GRAY, (int[])new int[]{0, 1}, (boolean)true, (boolean)true), (Object)ImageTypeSpecifiers.createGrayscale((int)32, (int)3, (boolean)true));
        Assert.assertEquals((Object)UInt32ImageTypeSpecifier.createInterleaved((ColorSpace)GRAY, (int[])new int[]{0, 1}, (boolean)true, (boolean)true), (Object)ImageTypeSpecifiers.createGrayscale((int)32, (int)3, (boolean)true));
    }

    @Test
    public void testCreateGrayscaleAlphaFloat() {
        Assert.assertEquals((Object)ImageTypeSpecifier.createInterleaved(GRAY, new int[]{0, 1}, 4, true, false), (Object)ImageTypeSpecifiers.createGrayscale((int)32, (int)4, (boolean)false));
        Assert.assertEquals((Object)ImageTypeSpecifier.createInterleaved(GRAY, new int[]{0, 1}, 4, true, true), (Object)ImageTypeSpecifiers.createGrayscale((int)32, (int)4, (boolean)true));
    }

    @Test
    public void testCreateGrayscaleAlphaDouble() {
        Assert.assertEquals((Object)ImageTypeSpecifier.createInterleaved(GRAY, new int[]{0, 1}, 5, true, false), (Object)ImageTypeSpecifiers.createGrayscale((int)64, (int)5, (boolean)false));
        Assert.assertEquals((Object)ImageTypeSpecifier.createInterleaved(GRAY, new int[]{0, 1}, 5, true, true), (Object)ImageTypeSpecifiers.createGrayscale((int)64, (int)5, (boolean)true));
    }

    @Test
    public void testCreatePackedGrayscale1BPP() {
        Assert.assertEquals((Object)ImageTypeSpecifier.createGrayscale(1, 0, false), (Object)ImageTypeSpecifiers.createPackedGrayscale((ColorSpace)GRAY, (int)1, (int)0));
    }

    @Test
    public void testCreatePackedGrayscale2BPP() {
        Assert.assertEquals((Object)ImageTypeSpecifier.createGrayscale(2, 0, false), (Object)ImageTypeSpecifiers.createPackedGrayscale((ColorSpace)GRAY, (int)2, (int)0));
    }

    @Test
    public void testCreatePackedGrayscale4BPP() {
        Assert.assertEquals((Object)ImageTypeSpecifier.createGrayscale(4, 0, false), (Object)ImageTypeSpecifiers.createPackedGrayscale((ColorSpace)GRAY, (int)4, (int)0));
    }

    @Test
    public void testCreateIndexedByteArrays1to8() {
        for (int i = 1; i <= 8; i <<= 1) {
            byte[] byArray = ImageTypeSpecifiersTest.createByteLut(1 << i);
            Assert.assertEquals((Object)ImageTypeSpecifier.createIndexed(byArray, byArray, byArray, null, i, 0), (Object)ImageTypeSpecifiers.createIndexed((byte[])byArray, (byte[])byArray, (byte[])byArray, null, (int)i, (int)0));
            Assert.assertEquals((Object)ImageTypeSpecifier.createIndexed(byArray, byArray, byArray, byArray, i, 0), (Object)ImageTypeSpecifiers.createIndexed((byte[])byArray, (byte[])byArray, (byte[])byArray, (byte[])byArray, (int)i, (int)0));
        }
    }

    @Test
    public void testCreateIndexedByteArrays16() {
        for (int i = 1; i <= 8; i <<= 1) {
            byte[] byArray = ImageTypeSpecifiersTest.createByteLut(1 << i);
            Assert.assertEquals((Object)ImageTypeSpecifier.createIndexed(byArray, byArray, byArray, null, i, 1), (Object)ImageTypeSpecifiers.createIndexed((byte[])byArray, (byte[])byArray, (byte[])byArray, null, (int)i, (int)1));
            Assert.assertEquals((Object)ImageTypeSpecifier.createIndexed(byArray, byArray, byArray, byArray, i, 1), (Object)ImageTypeSpecifiers.createIndexed((byte[])byArray, (byte[])byArray, (byte[])byArray, (byte[])byArray, (int)i, (int)1));
        }
        byte[] byArray = ImageTypeSpecifiersTest.createByteLut(65536);
        Assert.assertEquals((Object)ImageTypeSpecifier.createIndexed(byArray, byArray, byArray, null, 16, 1), (Object)ImageTypeSpecifiers.createIndexed((byte[])byArray, (byte[])byArray, (byte[])byArray, null, (int)16, (int)1));
        Assert.assertEquals((Object)ImageTypeSpecifier.createIndexed(byArray, byArray, byArray, byArray, 16, 1), (Object)ImageTypeSpecifiers.createIndexed((byte[])byArray, (byte[])byArray, (byte[])byArray, (byte[])byArray, (int)16, (int)1));
        Assert.assertEquals((Object)ImageTypeSpecifier.createIndexed(byArray, byArray, byArray, null, 16, 2), (Object)ImageTypeSpecifiers.createIndexed((byte[])byArray, (byte[])byArray, (byte[])byArray, null, (int)16, (int)2));
        Assert.assertEquals((Object)ImageTypeSpecifier.createIndexed(byArray, byArray, byArray, byArray, 16, 2), (Object)ImageTypeSpecifiers.createIndexed((byte[])byArray, (byte[])byArray, (byte[])byArray, (byte[])byArray, (int)16, (int)2));
    }

    @Test
    public void testCreateIndexedByteArrays32() {
        for (int i = 1; i <= 8; i <<= 1) {
            byte[] byArray = ImageTypeSpecifiersTest.createByteLut(1 << i);
            Assert.assertEquals((Object)ImageTypeSpecifier.createIndexed(byArray, byArray, byArray, null, i, 3), (Object)ImageTypeSpecifiers.createIndexed((byte[])byArray, (byte[])byArray, (byte[])byArray, null, (int)i, (int)3));
            Assert.assertEquals((Object)ImageTypeSpecifier.createIndexed(byArray, byArray, byArray, byArray, i, 3), (Object)ImageTypeSpecifiers.createIndexed((byte[])byArray, (byte[])byArray, (byte[])byArray, (byte[])byArray, (int)i, (int)3));
        }
        byte[] byArray = ImageTypeSpecifiersTest.createByteLut(65536);
        Assert.assertEquals((Object)ImageTypeSpecifier.createIndexed(byArray, byArray, byArray, null, 16, 3), (Object)ImageTypeSpecifiers.createIndexed((byte[])byArray, (byte[])byArray, (byte[])byArray, null, (int)16, (int)3));
        Assert.assertEquals((Object)ImageTypeSpecifier.createIndexed(byArray, byArray, byArray, byArray, 16, 3), (Object)ImageTypeSpecifiers.createIndexed((byte[])byArray, (byte[])byArray, (byte[])byArray, (byte[])byArray, (int)16, (int)3));
    }

    @Test
    public void testCreateIndexedIntArray1to8() {
        for (int i = 1; i <= 8; i <<= 1) {
            int[] nArray = ImageTypeSpecifiersTest.createIntLut(1 << i);
            Assert.assertEquals((Object)new IndexedImageTypeSpecifier((ColorModel)new IndexColorModel(i, nArray.length, nArray, 0, false, -1, 0)), (Object)ImageTypeSpecifiers.createIndexed((int[])nArray, (boolean)false, (int)-1, (int)i, (int)0));
        }
    }

    @Test
    public void testCreateIndexedIntArray16() {
        int[] nArray = ImageTypeSpecifiersTest.createIntLut(65536);
        Assert.assertEquals((Object)new IndexedImageTypeSpecifier((ColorModel)new IndexColorModel(16, nArray.length, nArray, 0, false, -1, 1)), (Object)ImageTypeSpecifiers.createIndexed((int[])nArray, (boolean)false, (int)-1, (int)16, (int)1));
    }

    @Test
    public void testCreateFromIndexedColorModel1to8() {
        for (int i = 1; i <= 8; i <<= 1) {
            int[] nArray = ImageTypeSpecifiersTest.createIntLut(1 << i);
            IndexColorModel indexColorModel = new IndexColorModel(i, nArray.length, nArray, 0, false, -1, 0);
            Assert.assertEquals((Object)new IndexedImageTypeSpecifier((ColorModel)indexColorModel), (Object)ImageTypeSpecifiers.createFromIndexColorModel((IndexColorModel)indexColorModel));
        }
    }

    @Test
    public void testCreateFromIndexedColorModel16() {
        int[] nArray = ImageTypeSpecifiersTest.createIntLut(65536);
        IndexColorModel indexColorModel = new IndexColorModel(16, nArray.length, nArray, 0, false, -1, 1);
        Assert.assertEquals((Object)new IndexedImageTypeSpecifier((ColorModel)indexColorModel), (Object)ImageTypeSpecifiers.createFromIndexColorModel((IndexColorModel)indexColorModel));
    }

    @Test
    public void testCreateDiscreteAlphaIndexedFromIndexColorModel8() {
        int[] nArray = ImageTypeSpecifiersTest.createIntLut(256);
        IndexColorModel indexColorModel = new IndexColorModel(8, nArray.length, nArray, 0, false, -1, 0);
        Assert.assertEquals((Object)new ImageTypeSpecifier(indexColorModel, indexColorModel.createCompatibleSampleModel(1, 1)), (Object)ImageTypeSpecifiers.createFromIndexColorModel((IndexColorModel)indexColorModel));
    }

    @Test
    public void testCreateDiscreteAlphaIndexedFromIndexColorModel16() {
        int[] nArray = ImageTypeSpecifiersTest.createIntLut(65536);
        IndexColorModel indexColorModel = new IndexColorModel(16, nArray.length, nArray, 0, false, -1, 1);
        Assert.assertEquals((Object)new ImageTypeSpecifier(indexColorModel, indexColorModel.createCompatibleSampleModel(1, 1)), (Object)ImageTypeSpecifiers.createFromIndexColorModel((IndexColorModel)indexColorModel));
    }

    @Test
    public void testCreateFromBufferedImageTypeShouldEqualConstructor() {
        for (int i = 1; i < 13; ++i) {
            BufferedImage bufferedImage = new BufferedImage(1, 1, i);
            ImageTypeSpecifier imageTypeSpecifier = new ImageTypeSpecifier(bufferedImage);
            ImageTypeSpecifier imageTypeSpecifier2 = ImageTypeSpecifiers.createFromBufferedImageType((int)i);
            Assert.assertEquals((Object)imageTypeSpecifier.getColorModel(), (Object)imageTypeSpecifier2.getColorModel());
            Assert.assertEquals((Object)imageTypeSpecifier.getSampleModel(), (Object)imageTypeSpecifier2.getSampleModel());
        }
    }

    @Test
    public void testCreateFromRenderedImageShouldEqualConstructor() {
        for (int i = 1; i < 13; ++i) {
            BufferedImage bufferedImage = new BufferedImage(1, 1, i);
            ImageTypeSpecifier imageTypeSpecifier = new ImageTypeSpecifier(bufferedImage);
            ImageTypeSpecifier imageTypeSpecifier2 = ImageTypeSpecifiers.createFromRenderedImage((RenderedImage)bufferedImage);
            Assert.assertEquals((Object)imageTypeSpecifier.getColorModel(), (Object)imageTypeSpecifier2.getColorModel());
            Assert.assertEquals((Object)imageTypeSpecifier.getSampleModel(), (Object)imageTypeSpecifier2.getSampleModel());
        }
    }

    @Test
    public void testCreateFromRenderedImageIndexedBinaryShouldRetainPalette() {
        IndexColorModel indexColorModel = new IndexColorModel(1, 2, new int[]{-1, -16777216}, 0, false, -1, 0);
        BufferedImage bufferedImage = new BufferedImage(1, 1, 12, indexColorModel);
        ImageTypeSpecifier imageTypeSpecifier = ImageTypeSpecifiers.createFromRenderedImage((RenderedImage)bufferedImage);
        Assert.assertEquals((Object)indexColorModel, (Object)imageTypeSpecifier.getColorModel());
        Assert.assertSame((Object)indexColorModel, (Object)imageTypeSpecifier.getColorModel());
        Assert.assertEquals((Object)bufferedImage.getSampleModel(), (Object)imageTypeSpecifier.getSampleModel());
    }

    @Test
    public void testCreateFromRenderedImageIndexedShouldRetainPalette() {
        IndexColorModel indexColorModel = new IndexColorModel(4, 16, new int[]{-1, -6710887, -10066330, -13421773, -16777216, -16768978, -16760996, -13875083, -7712625, -4435824, -40095, -31439, -23040, -11392, -9131886, -16743035}, 0, false, -1, 0);
        BufferedImage bufferedImage = new BufferedImage(1, 1, 13, indexColorModel);
        ImageTypeSpecifier imageTypeSpecifier = ImageTypeSpecifiers.createFromRenderedImage((RenderedImage)bufferedImage);
        Assert.assertEquals((Object)indexColorModel, (Object)imageTypeSpecifier.getColorModel());
        Assert.assertSame((Object)indexColorModel, (Object)imageTypeSpecifier.getColorModel());
        Assert.assertEquals((Object)bufferedImage.getSampleModel(), (Object)imageTypeSpecifier.getSampleModel());
    }

    private static byte[] createByteLut(int n) {
        byte[] byArray = new byte[n];
        for (int i = 0; i < n; ++i) {
            byArray[i] = (byte)(i * 255 / n);
        }
        return byArray;
    }

    private static int[] createIntLut(int n) {
        int[] nArray = new int[n];
        for (int i = 0; i < n; ++i) {
            int n2 = i * 255 / n;
            nArray[i] = 0xFF000000 | n2 << 16 | n2 << 8 | n2;
        }
        return nArray;
    }
}

