/*
 * Decompiled with CFR 0.152.
 */
package com.twelvemonkeys.imageio.stream;

import java.io.IOException;
import java.lang.reflect.ParameterizedType;
import java.util.Locale;
import javax.imageio.ImageIO;
import javax.imageio.spi.ImageInputStreamSpi;
import org.junit.Assert;
import org.junit.Test;

abstract class ImageInputStreamSpiTest<T> {
    protected final ImageInputStreamSpi provider = this.createProvider();
    protected final Class<T> inputClass = (Class)((ParameterizedType)this.getClass().getGenericSuperclass()).getActualTypeArguments()[0];

    ImageInputStreamSpiTest() {
    }

    protected abstract ImageInputStreamSpi createProvider();

    protected abstract T createInput() throws IOException;

    @Test
    public void testInputClass() {
        Assert.assertEquals(this.inputClass, this.provider.getInputClass());
    }

    @Test
    public void testVendorName() {
        Assert.assertNotNull((Object)this.provider.getVendorName());
        Assert.assertEquals((Object)"TwelveMonkeys", (Object)this.provider.getVendorName());
    }

    @Test
    public void testVersion() {
        Assert.assertNotNull((Object)this.provider.getVersion());
    }

    @Test
    public void testDescription() {
        Assert.assertNotNull((Object)this.provider.getDescription(null));
        Assert.assertNotNull((Object)this.provider.getDescription(Locale.ENGLISH));
    }

    @Test(expected=IllegalArgumentException.class)
    public void createNull() throws IOException {
        this.provider.createInputStreamInstance(null);
    }

    @Test(expected=IllegalArgumentException.class)
    public void createNullCached() throws IOException {
        this.provider.createInputStreamInstance(null, true, ImageIO.getCacheDirectory());
    }

    @Test
    public void createCachedNullCache() throws IOException {
        try {
            this.provider.createInputStreamInstance(this.createInput(), true, null);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            Assert.assertFalse((boolean)this.provider.needsCacheFile());
        }
    }

    @Test
    public void create() throws IOException {
        Assert.assertNotNull((Object)this.provider.createInputStreamInstance(this.createInput()));
    }

    @Test
    public void createCached() throws IOException {
        if (this.provider.canUseCacheFile()) {
            Assert.assertNotNull((Object)this.provider.createInputStreamInstance(this.createInput(), true, ImageIO.getCacheDirectory()));
        }
    }

    @Test
    public void createNonCached() throws IOException {
        if (!this.provider.needsCacheFile()) {
            Assert.assertNotNull((Object)this.provider.createInputStreamInstance(this.createInput(), false, ImageIO.getCacheDirectory()));
        }
    }
}

