/*
 * Decompiled with CFR 0.152.
 */
package com.twelvemonkeys.imageio.stream;

import com.twelvemonkeys.imageio.stream.BufferedImageInputStreamTest;
import com.twelvemonkeys.imageio.stream.DirectImageInputStream;
import java.io.ByteArrayInputStream;
import java.io.EOFException;
import java.io.IOException;
import java.io.InputStream;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.util.Random;
import org.junit.Assert;
import org.junit.Ignore;
import org.junit.Test;
import org.junit.function.ThrowingRunnable;
import org.mockito.Mockito;
import org.mockito.verification.VerificationMode;

public class DirectImageInputStreamTest {
    private final Random random = new Random(170984354357234566L);

    private InputStream randomData(byte[] byArray) {
        this.random.nextBytes(byArray);
        return new ByteArrayInputStream(byArray);
    }

    @Test
    public void testCreate() throws IOException {
        try (DirectImageInputStream directImageInputStream = new DirectImageInputStream((InputStream)new ByteArrayInputStream(new byte[0]), 0L);){
            Assert.assertEquals((String)"Data length should be same as stream length", (long)0L, (long)directImageInputStream.length());
        }
    }

    @Test
    public void testCreateNullFile() throws IOException {
        try (DirectImageInputStream directImageInputStream = new DirectImageInputStream(null);){
            Assert.fail((String)"Expected IllegalArgumentException");
        }
        catch (IllegalArgumentException illegalArgumentException) {
            Assert.assertNotNull((String)"Null exception message", (Object)illegalArgumentException.getMessage());
            String string = illegalArgumentException.getMessage().toLowerCase();
            Assert.assertTrue((String)"Exception message does not contain parameter name", (boolean)string.contains("stream"));
            Assert.assertTrue((String)"Exception message does not contain null", (boolean)string.contains("null"));
        }
    }

    @Test
    public void testRead() throws IOException {
        byte[] byArray = new byte[0x100000];
        InputStream inputStream = this.randomData(byArray);
        try (DirectImageInputStream directImageInputStream = new DirectImageInputStream(inputStream);){
            for (byte by : byArray) {
                Assert.assertEquals((String)"Wrong data read", (long)(by & 0xFF), (long)directImageInputStream.read());
            }
        }
    }

    @Test
    public void testReadArray() throws IOException {
        byte[] byArray = new byte[10240];
        InputStream inputStream = this.randomData(byArray);
        try (DirectImageInputStream directImageInputStream = new DirectImageInputStream(inputStream);){
            byte[] byArray2 = new byte[1024];
            for (int i = 0; i < byArray.length / byArray2.length; ++i) {
                directImageInputStream.readFully(byArray2);
                Assert.assertTrue((String)("Wrong data read: " + i), (boolean)BufferedImageInputStreamTest.rangeEquals(byArray, i * byArray2.length, byArray2, 0, byArray2.length));
            }
        }
    }

    @Test
    public void testReadSkip() throws IOException {
        byte[] byArray = new byte[14336];
        InputStream inputStream = this.randomData(byArray);
        try (DirectImageInputStream directImageInputStream = new DirectImageInputStream(inputStream);){
            byte[] byArray2 = new byte[7];
            for (int i = 0; i < byArray.length / byArray2.length; i += 2) {
                directImageInputStream.readFully(byArray2);
                directImageInputStream.skipBytes(byArray2.length);
                Assert.assertTrue((String)("Wrong data read: " + i), (boolean)BufferedImageInputStreamTest.rangeEquals(byArray, i * byArray2.length, byArray2, 0, byArray2.length));
            }
        }
    }

    @Test
    public void testReadSeek() throws IOException {
        byte[] byArray = new byte[432];
        InputStream inputStream = this.randomData(byArray);
        try (DirectImageInputStream directImageInputStream = new DirectImageInputStream(inputStream);){
            byte[] byArray2 = new byte[9];
            for (int i = 0; i < byArray.length / (2 * byArray2.length); ++i) {
                long l = i * 2 * byArray2.length;
                directImageInputStream.seek(l);
                Assert.assertEquals((String)"Wrong stream position", (long)l, (long)directImageInputStream.getStreamPosition());
                directImageInputStream.readFully(byArray2);
                Assert.assertTrue((String)("Wrong data read: " + i), (boolean)BufferedImageInputStreamTest.rangeEquals(byArray, (int)l, byArray2, 0, byArray2.length));
            }
        }
    }

    @Ignore(value="Bit reading requires backwards seek or buffer...")
    @Test
    public void testReadBitRandom() throws IOException {
        byte[] byArray = new byte[8];
        InputStream inputStream = this.randomData(byArray);
        long l = ByteBuffer.wrap(byArray).getLong();
        try (DirectImageInputStream directImageInputStream = new DirectImageInputStream(inputStream);){
            for (int i = 1; i <= 64; ++i) {
                Assert.assertEquals((String)String.format("bit %d differ", i), (long)(l << (int)((long)i - 1L) >>> 63), (long)directImageInputStream.readBit());
            }
        }
    }

    @Ignore(value="Bit reading requires backwards seek or buffer...")
    @Test
    public void testReadBitsRandom() throws IOException {
        byte[] byArray = new byte[8];
        InputStream inputStream = this.randomData(byArray);
        long l = ByteBuffer.wrap(byArray).getLong();
        try (DirectImageInputStream directImageInputStream = new DirectImageInputStream(inputStream);){
            for (int i = 1; i <= 64; ++i) {
                directImageInputStream.seek(0L);
                Assert.assertEquals((String)String.format("bit %d differ", i), (long)(l >>> (int)(64L - (long)i)), (long)directImageInputStream.readBits(i));
                Assert.assertEquals((long)(i % 8), (long)directImageInputStream.getBitOffset());
            }
        }
    }

    @Ignore(value="Bit reading requires backwards seek or buffer...")
    @Test
    public void testReadBitsRandomOffset() throws IOException {
        byte[] byArray = new byte[8];
        InputStream inputStream = this.randomData(byArray);
        long l = ByteBuffer.wrap(byArray).getLong();
        try (DirectImageInputStream directImageInputStream = new DirectImageInputStream(inputStream);){
            for (int i = 1; i <= 60; ++i) {
                directImageInputStream.seek(0L);
                directImageInputStream.setBitOffset(i % 8);
                Assert.assertEquals((String)String.format("bit %d differ", i), (long)(l << i % 8 >>> (int)(64L - (long)i)), (long)directImageInputStream.readBits(i));
                Assert.assertEquals((long)((long)i * 2L % 8L), (long)directImageInputStream.getBitOffset());
            }
        }
    }

    @Test
    public void testReadShort() throws IOException {
        int n;
        byte[] byArray = new byte[31];
        InputStream inputStream = this.randomData(byArray);
        ByteBuffer byteBuffer = ByteBuffer.wrap(byArray).order(ByteOrder.BIG_ENDIAN);
        try (final DirectImageInputStream directImageInputStream = new DirectImageInputStream(inputStream);){
            directImageInputStream.setByteOrder(ByteOrder.BIG_ENDIAN);
            for (n = 0; n < byArray.length / 2; ++n) {
                Assert.assertEquals((long)byteBuffer.getShort(), (long)directImageInputStream.readShort());
            }
            Assert.assertThrows(EOFException.class, (ThrowingRunnable)new ThrowingRunnable(){

                public void run() throws Throwable {
                    directImageInputStream.readShort();
                }
            });
        }
        directImageInputStream = new DirectImageInputStream((InputStream)new ByteArrayInputStream(byArray));
        var5_5 = null;
        try {
            directImageInputStream.setByteOrder(ByteOrder.LITTLE_ENDIAN);
            byteBuffer.position(0);
            byteBuffer.order(ByteOrder.LITTLE_ENDIAN);
            for (n = 0; n < byArray.length / 2; ++n) {
                Assert.assertEquals((long)byteBuffer.getShort(), (long)directImageInputStream.readShort());
            }
            Assert.assertThrows(EOFException.class, (ThrowingRunnable)new ThrowingRunnable(){

                public void run() throws Throwable {
                    directImageInputStream.readShort();
                }
            });
        }
        catch (Throwable throwable) {
            var5_5 = throwable;
            throw throwable;
        }
        finally {
            if (directImageInputStream != null) {
                if (var5_5 != null) {
                    try {
                        directImageInputStream.close();
                    }
                    catch (Throwable throwable) {
                        var5_5.addSuppressed(throwable);
                    }
                } else {
                    directImageInputStream.close();
                }
            }
        }
    }

    @Test
    public void testReadInt() throws IOException {
        int n;
        byte[] byArray = new byte[31];
        InputStream inputStream = this.randomData(byArray);
        ByteBuffer byteBuffer = ByteBuffer.wrap(byArray).order(ByteOrder.BIG_ENDIAN);
        try (final DirectImageInputStream directImageInputStream = new DirectImageInputStream(inputStream);){
            directImageInputStream.setByteOrder(ByteOrder.BIG_ENDIAN);
            for (n = 0; n < byArray.length / 4; ++n) {
                Assert.assertEquals((long)byteBuffer.getInt(), (long)directImageInputStream.readInt());
            }
            Assert.assertThrows(EOFException.class, (ThrowingRunnable)new ThrowingRunnable(){

                public void run() throws Throwable {
                    directImageInputStream.readInt();
                }
            });
        }
        directImageInputStream = new DirectImageInputStream((InputStream)new ByteArrayInputStream(byArray));
        var5_5 = null;
        try {
            directImageInputStream.setByteOrder(ByteOrder.LITTLE_ENDIAN);
            byteBuffer.position(0);
            byteBuffer.order(ByteOrder.LITTLE_ENDIAN);
            for (n = 0; n < byArray.length / 4; ++n) {
                Assert.assertEquals((long)byteBuffer.getInt(), (long)directImageInputStream.readInt());
            }
            Assert.assertThrows(EOFException.class, (ThrowingRunnable)new ThrowingRunnable(){

                public void run() throws Throwable {
                    directImageInputStream.readInt();
                }
            });
        }
        catch (Throwable throwable) {
            var5_5 = throwable;
            throw throwable;
        }
        finally {
            if (directImageInputStream != null) {
                if (var5_5 != null) {
                    try {
                        directImageInputStream.close();
                    }
                    catch (Throwable throwable) {
                        var5_5.addSuppressed(throwable);
                    }
                } else {
                    directImageInputStream.close();
                }
            }
        }
    }

    @Test
    public void testReadLong() throws IOException {
        int n;
        byte[] byArray = new byte[8743];
        InputStream inputStream = this.randomData(byArray);
        ByteBuffer byteBuffer = ByteBuffer.wrap(byArray).order(ByteOrder.BIG_ENDIAN);
        try (final DirectImageInputStream directImageInputStream = new DirectImageInputStream(inputStream);){
            directImageInputStream.setByteOrder(ByteOrder.BIG_ENDIAN);
            for (n = 0; n < byArray.length / 8; ++n) {
                Assert.assertEquals((long)byteBuffer.getLong(), (long)directImageInputStream.readLong());
            }
            Assert.assertThrows(EOFException.class, (ThrowingRunnable)new ThrowingRunnable(){

                public void run() throws Throwable {
                    directImageInputStream.readLong();
                }
            });
        }
        directImageInputStream = new DirectImageInputStream((InputStream)new ByteArrayInputStream(byArray));
        var5_5 = null;
        try {
            directImageInputStream.setByteOrder(ByteOrder.LITTLE_ENDIAN);
            byteBuffer.position(0);
            byteBuffer.order(ByteOrder.LITTLE_ENDIAN);
            for (n = 0; n < byArray.length / 8; ++n) {
                Assert.assertEquals((long)byteBuffer.getLong(), (long)directImageInputStream.readLong());
            }
            Assert.assertThrows(EOFException.class, (ThrowingRunnable)new ThrowingRunnable(){

                public void run() throws Throwable {
                    directImageInputStream.readLong();
                }
            });
        }
        catch (Throwable throwable) {
            var5_5 = throwable;
            throw throwable;
        }
        finally {
            if (directImageInputStream != null) {
                if (var5_5 != null) {
                    try {
                        directImageInputStream.close();
                    }
                    catch (Throwable throwable) {
                        var5_5.addSuppressed(throwable);
                    }
                } else {
                    directImageInputStream.close();
                }
            }
        }
    }

    @Test
    public void testSeekPastEOF() throws IOException {
        byte[] byArray = new byte[9];
        InputStream inputStream = this.randomData(byArray);
        try (final DirectImageInputStream directImageInputStream = new DirectImageInputStream(inputStream);){
            directImageInputStream.seek(1000L);
            Assert.assertEquals((long)-1L, (long)directImageInputStream.read());
            Assert.assertEquals((long)-1L, (long)directImageInputStream.read(new byte[1], 0, 1));
            Assert.assertThrows(EOFException.class, (ThrowingRunnable)new ThrowingRunnable(){

                public void run() throws Throwable {
                    directImageInputStream.readFully(new byte[1]);
                }
            });
            Assert.assertThrows(EOFException.class, (ThrowingRunnable)new ThrowingRunnable(){

                public void run() throws Throwable {
                    directImageInputStream.readByte();
                }
            });
            Assert.assertThrows(EOFException.class, (ThrowingRunnable)new ThrowingRunnable(){

                public void run() throws Throwable {
                    directImageInputStream.readShort();
                }
            });
            Assert.assertThrows(EOFException.class, (ThrowingRunnable)new ThrowingRunnable(){

                public void run() throws Throwable {
                    directImageInputStream.readInt();
                }
            });
            Assert.assertThrows(EOFException.class, (ThrowingRunnable)new ThrowingRunnable(){

                public void run() throws Throwable {
                    directImageInputStream.readLong();
                }
            });
        }
        directImageInputStream = new DirectImageInputStream((InputStream)new ByteArrayInputStream(byArray));
        var4_4 = null;
        try {
            for (byte by : byArray) {
                Assert.assertEquals((long)by, (long)directImageInputStream.readByte());
            }
            Assert.assertEquals((long)-1L, (long)directImageInputStream.read());
        }
        catch (Throwable throwable) {
            var4_4 = throwable;
            throw throwable;
        }
        finally {
            if (directImageInputStream != null) {
                if (var4_4 != null) {
                    try {
                        directImageInputStream.close();
                    }
                    catch (Throwable throwable) {
                        var4_4.addSuppressed(throwable);
                    }
                } else {
                    directImageInputStream.close();
                }
            }
        }
    }

    @Test
    public void testClose() throws IOException {
        InputStream inputStream = (InputStream)Mockito.mock(InputStream.class);
        DirectImageInputStream directImageInputStream = new DirectImageInputStream(inputStream);
        directImageInputStream.close();
        ((InputStream)Mockito.verify((Object)inputStream, (VerificationMode)Mockito.only())).close();
    }
}

