/*
 * Decompiled with CFR 0.152.
 */
package com.twelvemonkeys.imageio.spi;

import com.twelvemonkeys.imageio.spi.ProviderInfo;
import java.net.URL;
import org.junit.Assert;
import org.junit.Test;

public class ProviderInfoTest {
    @Test
    public void testCreateNormal() {
        new ProviderInfo(Package.getPackage("java.util"));
    }

    @Test
    public void testCreateNullPackage() {
        try {
            new ProviderInfo(null);
            Assert.fail((String)"IllegalArgumentException expected for null package");
        }
        catch (IllegalArgumentException illegalArgumentException) {
            Assert.assertTrue((boolean)illegalArgumentException.getMessage().toLowerCase().contains("package"));
        }
    }

    @Test
    public void testGetVendorUnknownNonJARPackage() {
        ProviderInfo providerInfo = new ProviderInfo(this.mockNonJARPackage("org.foo"));
        String string = providerInfo.getVendorName();
        Assert.assertNotNull((Object)string);
        Assert.assertEquals((Object)"org.foo", (Object)string);
        String string2 = providerInfo.getVersion();
        Assert.assertNotNull((Object)string2);
        Assert.assertEquals((Object)"Unspecified", (Object)string2);
    }

    @Test
    public void testGetVendorNonJARTMPackage() {
        ProviderInfo providerInfo = new ProviderInfo(this.mockNonJARPackage("com.twelvemonkeys"));
        String string = providerInfo.getVendorName();
        Assert.assertNotNull((Object)string);
        Assert.assertEquals((Object)"TwelveMonkeys", (Object)string);
        String string2 = providerInfo.getVersion();
        Assert.assertNotNull((Object)string2);
        Assert.assertEquals((Object)"DEV", (Object)string2);
    }

    @Test
    public void testGetVendorKnownJARPackage() {
        ProviderInfo providerInfo = new ProviderInfo(this.mockJARPackage("com.acme", "1.7u4-BETA-b39", "Acme"));
        String string = providerInfo.getVendorName();
        Assert.assertNotNull((Object)string);
        Assert.assertEquals((Object)"Acme", (Object)string);
        String string2 = providerInfo.getVersion();
        Assert.assertNotNull((Object)string2);
        Assert.assertEquals((Object)"1.7u4-BETA-b39", (Object)string2);
    }

    private Package mockNonJARPackage(String string) {
        return new MockClassLoader().mockPackage(string, null, null, null, null, null, null, null);
    }

    private Package mockJARPackage(String string, String string2, String string3) {
        return new MockClassLoader().mockPackage(string, "The almighty specification", "1.0", "Acme Inc", "The buggy implementation", string2, string3, null);
    }

    private static class MockClassLoader
    extends ClassLoader {
        protected MockClassLoader() {
            super(null);
        }

        public Package mockPackage(String string, String string2, String string3, String string4, String string5, String string6, String string7, URL uRL) throws IllegalArgumentException {
            return this.definePackage(string, string2, string3, string4, string5, string6, string7, uRL);
        }

        @Override
        protected Package getPackage(String string) {
            return null;
        }
    }
}

