/*
 * Decompiled with CFR 0.152.
 */
package com.twelvemonkeys.imageio.color;

import com.twelvemonkeys.imageio.color.KCMSSanitizerStrategy;
import java.awt.color.ColorSpace;
import java.awt.color.ICC_ColorSpace;
import java.awt.color.ICC_Profile;
import java.io.IOException;
import java.lang.reflect.Method;
import java.util.Arrays;
import org.junit.Assert;
import org.junit.Assume;
import org.junit.Test;
import org.mockito.Mockito;

public class KCMSSanitizerStrategyTest {
    private static final byte[] XYZ = new byte[]{88, 89, 90, 32};

    @Test(expected=IllegalArgumentException.class)
    public void testFixProfileNullProfile() throws Exception {
        new KCMSSanitizerStrategy().fixProfile(null);
    }

    @Test
    public void testFixProfile() throws Exception {
        new KCMSSanitizerStrategy().fixProfile(((ICC_ColorSpace)ColorSpace.getInstance(1000)).getProfile());
    }

    @Test
    public void testFixProfileUpdateHeader() throws Exception {
        KCMSSanitizerStrategyTest.assumeICC_ProfileNotSealed();
        byte[] byArray = new byte[128];
        byArray[67] = 1;
        ICC_Profile iCC_Profile = (ICC_Profile)Mockito.mock(ICC_Profile.class);
        Mockito.when((Object)iCC_Profile.getData(1751474532)).thenReturn((Object)byArray);
        new KCMSSanitizerStrategy().fixProfile(iCC_Profile);
        ((ICC_Profile)Mockito.verify((Object)iCC_Profile)).setData(Mockito.eq((int)1751474532), (byte[])Mockito.any(byte[].class));
    }

    static void assumeICC_ProfileNotSealed() {
        try {
            Method method = Class.class.getMethod("isSealed", new Class[0]);
            Boolean bl = (Boolean)method.invoke(ICC_Profile.class, new Object[0]);
            Assume.assumeFalse((String)"Can't mock ICC_Profile, class is sealed (as of JDK 19).", (boolean)bl);
        }
        catch (ReflectiveOperationException reflectiveOperationException) {
            // empty catch block
        }
    }

    @Test
    public void testFixProfileCorbisRGB() throws IOException {
        ICC_Profile iCC_Profile = ICC_Profile.getInstance(this.getClass().getResourceAsStream("/profiles/Corbis RGB.icc"));
        new KCMSSanitizerStrategy().fixProfile(iCC_Profile);
        Assert.assertArrayEquals((byte[])XYZ, (byte[])Arrays.copyOfRange(iCC_Profile.getData(0x77747074), 0, 4));
        Assert.assertArrayEquals((byte[])XYZ, (byte[])Arrays.copyOfRange(iCC_Profile.getData(1918392666), 0, 4));
        Assert.assertArrayEquals((byte[])XYZ, (byte[])Arrays.copyOfRange(iCC_Profile.getData(1733843290), 0, 4));
        Assert.assertArrayEquals((byte[])XYZ, (byte[])Arrays.copyOfRange(iCC_Profile.getData(1649957210), 0, 4));
    }
}

