/*
 * Decompiled with CFR 0.152.
 */
package com.twelvemonkeys.imageio.color;

import com.twelvemonkeys.imageio.color.DiscreteAlphaIndexColorModel;
import java.awt.image.IndexColorModel;
import java.awt.image.PixelInterleavedSampleModel;
import java.awt.image.SampleModel;
import java.awt.image.WritableRaster;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.junit.Assert;
import org.junit.Test;

public class DiscreteAlphaIndexColorModelTest {
    @Test(expected=IllegalArgumentException.class)
    public void testCreateNull() {
        new DiscreteAlphaIndexColorModel(null);
    }

    @Test
    public void testCreateByte() {
        int[] nArray = DiscreteAlphaIndexColorModelTest.createIntLut(256);
        IndexColorModel indexColorModel = new IndexColorModel(8, nArray.length, nArray, 0, false, -1, 0);
        new DiscreteAlphaIndexColorModel(indexColorModel);
    }

    @Test
    public void testCreateUShort() {
        int[] nArray = DiscreteAlphaIndexColorModelTest.createIntLut(65536);
        IndexColorModel indexColorModel = new IndexColorModel(16, nArray.length, nArray, 0, false, -1, 1);
        new DiscreteAlphaIndexColorModel(indexColorModel);
    }

    @Test
    public void testGetRed() {
        int[] nArray = DiscreteAlphaIndexColorModelTest.createIntLut(256);
        nArray[0] = 0x336699;
        IndexColorModel indexColorModel = new IndexColorModel(8, nArray.length, nArray, 0, false, -1, 0);
        DiscreteAlphaIndexColorModel discreteAlphaIndexColorModel = new DiscreteAlphaIndexColorModel(indexColorModel);
        Assert.assertEquals((long)51L, (long)discreteAlphaIndexColorModel.getRed(0));
        Assert.assertEquals((long)51L, (long)discreteAlphaIndexColorModel.getRed((Object)new byte[]{0, 69}));
        for (int i = 1; i < nArray.length; ++i) {
            Assert.assertEquals((long)i, (long)discreteAlphaIndexColorModel.getRed(i));
            Assert.assertEquals((long)i, (long)discreteAlphaIndexColorModel.getRed((Object)new byte[]{(byte)i, -1}));
        }
    }

    @Test
    public void testGetGreen() {
        int[] nArray = DiscreteAlphaIndexColorModelTest.createIntLut(256);
        nArray[0] = 0x336699;
        IndexColorModel indexColorModel = new IndexColorModel(8, nArray.length, nArray, 0, false, -1, 0);
        DiscreteAlphaIndexColorModel discreteAlphaIndexColorModel = new DiscreteAlphaIndexColorModel(indexColorModel);
        Assert.assertEquals((long)102L, (long)discreteAlphaIndexColorModel.getGreen(0));
        Assert.assertEquals((long)102L, (long)discreteAlphaIndexColorModel.getGreen((Object)new byte[]{0, 69}));
        for (int i = 1; i < nArray.length; ++i) {
            Assert.assertEquals((long)i, (long)discreteAlphaIndexColorModel.getGreen(i));
            Assert.assertEquals((long)i, (long)discreteAlphaIndexColorModel.getGreen((Object)new byte[]{(byte)i, -1}));
        }
    }

    @Test
    public void testGetBlue() {
        int[] nArray = DiscreteAlphaIndexColorModelTest.createIntLut(256);
        nArray[0] = 0x336699;
        IndexColorModel indexColorModel = new IndexColorModel(8, nArray.length, nArray, 0, false, -1, 0);
        DiscreteAlphaIndexColorModel discreteAlphaIndexColorModel = new DiscreteAlphaIndexColorModel(indexColorModel);
        Assert.assertEquals((long)153L, (long)discreteAlphaIndexColorModel.getBlue(0));
        Assert.assertEquals((long)153L, (long)discreteAlphaIndexColorModel.getBlue((Object)new byte[]{0, 69}));
        for (int i = 1; i < nArray.length; ++i) {
            Assert.assertEquals((long)i, (long)discreteAlphaIndexColorModel.getBlue(i));
            Assert.assertEquals((long)i, (long)discreteAlphaIndexColorModel.getBlue((Object)new byte[]{(byte)i, -1}));
        }
    }

    @Test
    public void testGetAlpha() {
        int[] nArray = DiscreteAlphaIndexColorModelTest.createIntLut(256);
        IndexColorModel indexColorModel = new IndexColorModel(8, nArray.length, nArray, 0, false, -1, 0);
        DiscreteAlphaIndexColorModel discreteAlphaIndexColorModel = new DiscreteAlphaIndexColorModel(indexColorModel);
        Assert.assertEquals((long)69L, (long)discreteAlphaIndexColorModel.getAlpha(69));
        Assert.assertEquals((long)69L, (long)discreteAlphaIndexColorModel.getAlpha((Object)new byte[]{1, 69}));
        for (int i = 1; i < nArray.length; ++i) {
            Assert.assertEquals((long)i, (long)discreteAlphaIndexColorModel.getAlpha(i));
            Assert.assertEquals((long)i, (long)discreteAlphaIndexColorModel.getAlpha((Object)new byte[]{-1, (byte)i}));
        }
    }

    @Test
    public void testGetAlphaUShort() {
        int[] nArray = DiscreteAlphaIndexColorModelTest.createIntLut(65536);
        nArray[1] = 0x336699;
        IndexColorModel indexColorModel = new IndexColorModel(16, nArray.length, nArray, 0, false, -1, 1);
        DiscreteAlphaIndexColorModel discreteAlphaIndexColorModel = new DiscreteAlphaIndexColorModel(indexColorModel);
        Assert.assertEquals((long)69L, (long)discreteAlphaIndexColorModel.getAlpha(17664));
        Assert.assertEquals((long)69L, (long)discreteAlphaIndexColorModel.getAlpha(17791));
        Assert.assertEquals((long)70L, (long)discreteAlphaIndexColorModel.getAlpha(17862));
        Assert.assertEquals((long)70L, (long)discreteAlphaIndexColorModel.getAlpha(17919));
        Assert.assertEquals((long)69L, (long)discreteAlphaIndexColorModel.getAlpha((Object)new short[]{1, 17664}));
        Assert.assertEquals((long)69L, (long)discreteAlphaIndexColorModel.getAlpha((Object)new short[]{2, 17791}));
        Assert.assertEquals((long)70L, (long)discreteAlphaIndexColorModel.getAlpha((Object)new short[]{3, 17862}));
        Assert.assertEquals((long)70L, (long)discreteAlphaIndexColorModel.getAlpha((Object)new short[]{4, 17919}));
    }

    @Test
    public void testCreateCompatibleSampleModel() {
        int[] nArray = DiscreteAlphaIndexColorModelTest.createIntLut(256);
        IndexColorModel indexColorModel = new IndexColorModel(8, nArray.length, nArray, 0, false, -1, 0);
        DiscreteAlphaIndexColorModel discreteAlphaIndexColorModel = new DiscreteAlphaIndexColorModel(indexColorModel);
        SampleModel sampleModel = discreteAlphaIndexColorModel.createCompatibleSampleModel(3, 2);
        Assert.assertNotNull((Object)sampleModel);
        Assert.assertEquals((long)3L, (long)sampleModel.getWidth());
        Assert.assertEquals((long)2L, (long)sampleModel.getHeight());
        Assert.assertTrue((boolean)discreteAlphaIndexColorModel.isCompatibleSampleModel(sampleModel));
        MatcherAssert.assertThat((Object)sampleModel, (Matcher)CoreMatchers.instanceOf(PixelInterleavedSampleModel.class));
        MatcherAssert.assertThat((Object)sampleModel.getDataType(), (Matcher)CoreMatchers.equalTo((Object)0));
    }

    @Test
    public void testCreateCompatibleSampleModelUShort() {
        int[] nArray = DiscreteAlphaIndexColorModelTest.createIntLut(256);
        IndexColorModel indexColorModel = new IndexColorModel(8, nArray.length, nArray, 0, false, -1, 1);
        DiscreteAlphaIndexColorModel discreteAlphaIndexColorModel = new DiscreteAlphaIndexColorModel(indexColorModel);
        SampleModel sampleModel = discreteAlphaIndexColorModel.createCompatibleSampleModel(3, 2);
        Assert.assertNotNull((Object)sampleModel);
        Assert.assertEquals((long)3L, (long)sampleModel.getWidth());
        Assert.assertEquals((long)2L, (long)sampleModel.getHeight());
        Assert.assertTrue((boolean)discreteAlphaIndexColorModel.isCompatibleSampleModel(sampleModel));
        MatcherAssert.assertThat((Object)sampleModel, (Matcher)CoreMatchers.instanceOf(PixelInterleavedSampleModel.class));
        MatcherAssert.assertThat((Object)sampleModel.getDataType(), (Matcher)CoreMatchers.equalTo((Object)1));
    }

    @Test
    public void testCreateCompatibleRaster() {
        int[] nArray = DiscreteAlphaIndexColorModelTest.createIntLut(256);
        IndexColorModel indexColorModel = new IndexColorModel(8, nArray.length, nArray, 0, false, -1, 0);
        DiscreteAlphaIndexColorModel discreteAlphaIndexColorModel = new DiscreteAlphaIndexColorModel(indexColorModel);
        WritableRaster writableRaster = discreteAlphaIndexColorModel.createCompatibleWritableRaster(3, 2);
        Assert.assertNotNull((Object)writableRaster);
        Assert.assertEquals((long)3L, (long)writableRaster.getWidth());
        Assert.assertEquals((long)2L, (long)writableRaster.getHeight());
        Assert.assertTrue((boolean)discreteAlphaIndexColorModel.isCompatibleRaster(writableRaster));
        MatcherAssert.assertThat((Object)writableRaster, (Matcher)CoreMatchers.is(WritableRaster.class));
        MatcherAssert.assertThat((Object)writableRaster.getTransferType(), (Matcher)CoreMatchers.equalTo((Object)0));
    }

    @Test
    public void testNumComponents() {
        int[] nArray = DiscreteAlphaIndexColorModelTest.createIntLut(256);
        IndexColorModel indexColorModel = new IndexColorModel(8, nArray.length, nArray, 0, false, -1, 0);
        DiscreteAlphaIndexColorModel discreteAlphaIndexColorModel = new DiscreteAlphaIndexColorModel(indexColorModel, 1, true);
        DiscreteAlphaIndexColorModel discreteAlphaIndexColorModel2 = new DiscreteAlphaIndexColorModel(indexColorModel, 2, true);
        DiscreteAlphaIndexColorModel discreteAlphaIndexColorModel3 = new DiscreteAlphaIndexColorModel(indexColorModel, 42, false);
        Assert.assertEquals((long)3L, (long)discreteAlphaIndexColorModel.getNumColorComponents());
        Assert.assertEquals((long)4L, (long)discreteAlphaIndexColorModel.getNumComponents());
        Assert.assertEquals((long)3L, (long)discreteAlphaIndexColorModel2.getNumColorComponents());
        Assert.assertEquals((long)5L, (long)discreteAlphaIndexColorModel2.getNumComponents());
        Assert.assertEquals((long)3L, (long)discreteAlphaIndexColorModel3.getNumColorComponents());
        Assert.assertEquals((long)45L, (long)discreteAlphaIndexColorModel3.getNumComponents());
    }

    private static int[] createIntLut(int n) {
        int[] nArray = new int[n];
        for (int i = 0; i < n; ++i) {
            nArray[i] = 0xFF000000 | i << 16 | i << 8 | i;
        }
        return nArray;
    }
}

