/*
 * Decompiled with CFR 0.152.
 */
package com.twelvemonkeys.imageio.color;

import com.twelvemonkeys.imageio.color.ColorProfiles;
import com.twelvemonkeys.imageio.color.ColorSpaces;
import java.awt.color.ColorSpace;
import java.awt.color.ICC_ColorSpace;
import java.awt.color.ICC_Profile;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.Arrays;
import org.junit.Assert;
import org.junit.Test;

public class ColorProfilesTest {
    @Test
    public void testCreateColorSpaceFromBrokenProfileIsFixedCS_sRGB() {
        ICC_Profile iCC_Profile = ICC_Profile.getInstance(1000);
        ICC_Profile iCC_Profile2 = this.createBrokenProfile(iCC_Profile);
        Assert.assertNotSame((Object)iCC_Profile, (Object)iCC_Profile2);
        Assert.assertTrue((boolean)ColorProfiles.isOffendingColorProfile((ICC_Profile)iCC_Profile2));
        ICC_ColorSpace iCC_ColorSpace = ColorSpaces.createColorSpace((ICC_Profile)iCC_Profile2);
        Assert.assertSame((Object)ColorSpace.getInstance(1000), (Object)iCC_ColorSpace);
        Assert.assertTrue((boolean)iCC_ColorSpace.isCS_sRGB());
    }

    private ICC_Profile createBrokenProfile(ICC_Profile iCC_Profile) {
        byte[] byArray = iCC_Profile.getData();
        byArray[64] = 1;
        byArray[65] = 0;
        byArray[66] = 0;
        byArray[67] = 0;
        return ICC_Profile.getInstance(byArray);
    }

    @Test
    public void testIsOffendingColorProfile() {
        ICC_Profile iCC_Profile = this.createBrokenProfile(ICC_Profile.getInstance(1003));
        Assert.assertTrue((boolean)ColorProfiles.isOffendingColorProfile((ICC_Profile)iCC_Profile));
    }

    @Test
    public void testIsCS_sRGBTrue() {
        Assert.assertTrue((boolean)ColorProfiles.isCS_sRGB((ICC_Profile)ICC_Profile.getInstance(1000)));
    }

    @Test
    public void testIsCS_sRGBFalse() {
        Assert.assertFalse((boolean)ColorProfiles.isCS_sRGB((ICC_Profile)ICC_Profile.getInstance(1004)));
        Assert.assertFalse((boolean)ColorProfiles.isCS_sRGB((ICC_Profile)ICC_Profile.getInstance(1001)));
        Assert.assertFalse((boolean)ColorProfiles.isCS_sRGB((ICC_Profile)ICC_Profile.getInstance(1003)));
        Assert.assertFalse((boolean)ColorProfiles.isCS_sRGB((ICC_Profile)ICC_Profile.getInstance(1002)));
    }

    @Test(expected=IllegalArgumentException.class)
    public void testIsCS_sRGBNull() {
        ColorProfiles.isCS_sRGB(null);
    }

    @Test
    public void testIsCS_GRAYTrue() {
        Assert.assertTrue((boolean)ColorProfiles.isCS_GRAY((ICC_Profile)ICC_Profile.getInstance(1003)));
    }

    @Test
    public void testIsCS_GRAYFalse() {
        Assert.assertFalse((boolean)ColorProfiles.isCS_GRAY((ICC_Profile)ICC_Profile.getInstance(1000)));
        Assert.assertFalse((boolean)ColorProfiles.isCS_GRAY((ICC_Profile)ICC_Profile.getInstance(1004)));
        Assert.assertFalse((boolean)ColorProfiles.isCS_GRAY((ICC_Profile)ICC_Profile.getInstance(1001)));
        Assert.assertFalse((boolean)ColorProfiles.isCS_GRAY((ICC_Profile)ICC_Profile.getInstance(1002)));
    }

    @Test(expected=IllegalArgumentException.class)
    public void testIsCS_GRAYNull() {
        ColorProfiles.isCS_GRAY(null);
    }

    @Test(expected=IllegalArgumentException.class)
    public void testCreateProfileNull() {
        ColorProfiles.createProfile(null);
    }

    @Test(expected=IllegalArgumentException.class)
    public void testReadProfileNull() throws IOException {
        ColorProfiles.readProfile(null);
    }

    @Test(expected=IllegalArgumentException.class)
    public void testCreateProfileRawNull() {
        ColorProfiles.createProfileRaw(null);
    }

    @Test(expected=IllegalArgumentException.class)
    public void testReadProfileRawNull() throws IOException {
        ColorProfiles.readProfileRaw(null);
    }

    @Test
    public void testCreateProfileRaw() throws IOException {
        byte[] byArray = ICC_Profile.getInstance(this.getClass().getResourceAsStream("/profiles/adobe_rgb_1998.icc")).getData();
        ICC_Profile iCC_Profile = ColorProfiles.createProfileRaw((byte[])byArray);
        Assert.assertArrayEquals((byte[])byArray, (byte[])iCC_Profile.getData());
    }

    @Test
    public void testReadProfileRaw() throws IOException {
        byte[] byArray = ICC_Profile.getInstance(this.getClass().getResourceAsStream("/profiles/adobe_rgb_1998.icc")).getData();
        ICC_Profile iCC_Profile = ColorProfiles.readProfileRaw((InputStream)this.getClass().getResourceAsStream("/profiles/adobe_rgb_1998.icc"));
        Assert.assertArrayEquals((byte[])byArray, (byte[])iCC_Profile.getData());
    }

    @Test(expected=IllegalArgumentException.class)
    public void testCreateProfileRawBadData() {
        ColorProfiles.createProfileRaw((byte[])new byte[5]);
    }

    @Test(expected=IllegalArgumentException.class)
    public void testReadProfileRawBadData() throws IOException {
        ColorProfiles.readProfileRaw((InputStream)new ByteArrayInputStream(new byte[40]));
    }

    @Test(expected=IllegalArgumentException.class)
    public void testCreateProfileBadData() {
        ColorProfiles.createProfile((byte[])new byte[5]);
    }

    @Test(expected=IllegalArgumentException.class)
    public void testReadProfileBadData() throws IOException {
        ColorProfiles.readProfile((InputStream)new ByteArrayInputStream(new byte[5]));
    }

    @Test(expected=IllegalArgumentException.class)
    public void testCreateProfileRawTruncated() throws IOException {
        byte[] byArray = ICC_Profile.getInstance(this.getClass().getResourceAsStream("/profiles/adobe_rgb_1998.icc")).getData();
        ColorProfiles.createProfileRaw((byte[])Arrays.copyOf(byArray, 200));
    }

    @Test(expected=IllegalArgumentException.class)
    public void testReadProfileRawTruncated() throws IOException {
        byte[] byArray = ICC_Profile.getInstance(this.getClass().getResourceAsStream("/profiles/adobe_rgb_1998.icc")).getData();
        ColorProfiles.readProfileRaw((InputStream)new ByteArrayInputStream(byArray, 0, 200));
    }

    @Test(expected=IllegalArgumentException.class)
    public void testCreateProfileTruncated() throws IOException {
        byte[] byArray = ICC_Profile.getInstance(this.getClass().getResourceAsStream("/profiles/adobe_rgb_1998.icc")).getData();
        ColorProfiles.createProfile((byte[])Arrays.copyOf(byArray, 200));
    }

    @Test(expected=IllegalArgumentException.class)
    public void testReadProfileTruncated() throws IOException {
        byte[] byArray = ICC_Profile.getInstance(this.getClass().getResourceAsStream("/profiles/adobe_rgb_1998.icc")).getData();
        ColorProfiles.readProfile((InputStream)new ByteArrayInputStream(byArray, 0, 200));
    }

    @Test(expected=IllegalArgumentException.class)
    public void testCreateProfileRawTruncatedHeader() throws IOException {
        byte[] byArray = ICC_Profile.getInstance(this.getClass().getResourceAsStream("/profiles/adobe_rgb_1998.icc")).getData();
        ColorProfiles.createProfileRaw((byte[])Arrays.copyOf(byArray, 125));
    }

    @Test(expected=IllegalArgumentException.class)
    public void testReadProfileRawTruncatedHeader() throws IOException {
        byte[] byArray = ICC_Profile.getInstance(this.getClass().getResourceAsStream("/profiles/adobe_rgb_1998.icc")).getData();
        ColorProfiles.readProfileRaw((InputStream)new ByteArrayInputStream(byArray, 0, 125));
    }

    @Test(expected=IllegalArgumentException.class)
    public void testCreateProfileTruncatedHeader() throws IOException {
        byte[] byArray = ICC_Profile.getInstance(this.getClass().getResourceAsStream("/profiles/adobe_rgb_1998.icc")).getData();
        ColorProfiles.createProfile((byte[])Arrays.copyOf(byArray, 125));
    }

    @Test(expected=IllegalArgumentException.class)
    public void testReadProfileTruncatedHeader() throws IOException {
        byte[] byArray = ICC_Profile.getInstance(this.getClass().getResourceAsStream("/profiles/adobe_rgb_1998.icc")).getData();
        ColorProfiles.readProfile((InputStream)new ByteArrayInputStream(byArray, 0, 125));
    }

    @Test
    public void testCreateProfileBytesSame() throws IOException {
        ICC_Profile iCC_Profile = ICC_Profile.getInstance(this.getClass().getResourceAsStream("/profiles/adobe_rgb_1998.icc"));
        ICC_Profile iCC_Profile2 = ColorProfiles.createProfile((byte[])iCC_Profile.getData());
        ICC_Profile iCC_Profile3 = ColorProfiles.createProfile((byte[])iCC_Profile.getData());
        Assert.assertEquals((Object)iCC_Profile2, (Object)iCC_Profile3);
        Assert.assertSame((Object)iCC_Profile2, (Object)iCC_Profile3);
    }

    @Test
    public void testReadProfileInputStreamSame() throws IOException {
        ICC_Profile iCC_Profile = ColorProfiles.readProfile((InputStream)this.getClass().getResourceAsStream("/profiles/adobe_rgb_1998.icc"));
        ICC_Profile iCC_Profile2 = ColorProfiles.readProfile((InputStream)this.getClass().getResourceAsStream("/profiles/adobe_rgb_1998.icc"));
        Assert.assertEquals((Object)iCC_Profile, (Object)iCC_Profile2);
        Assert.assertSame((Object)iCC_Profile, (Object)iCC_Profile2);
    }

    @Test
    public void testReadProfileDifferent() throws IOException {
        ICC_Profile iCC_Profile = ColorProfiles.readProfile((InputStream)this.getClass().getResourceAsStream("/profiles/adobe_rgb_1998.icc"));
        ICC_Profile iCC_Profile2 = ColorProfiles.readProfile((InputStream)this.getClass().getResourceAsStream("/profiles/color_match_rgb.icc"));
        Assert.assertNotSame((Object)iCC_Profile, (Object)iCC_Profile2);
    }

    @Test
    public void testCreateProfileBytesSameAsCached() throws IOException {
        ICC_Profile iCC_Profile = ICC_Profile.getInstance(this.getClass().getResourceAsStream("/profiles/adobe_rgb_1998.icc"));
        ICC_ColorSpace iCC_ColorSpace = ColorSpaces.createColorSpace((ICC_Profile)iCC_Profile);
        ICC_Profile iCC_Profile2 = ColorProfiles.createProfile((byte[])iCC_Profile.getData());
        Assert.assertEquals((Object)iCC_ColorSpace.getProfile(), (Object)iCC_Profile2);
        Assert.assertSame((Object)iCC_ColorSpace.getProfile(), (Object)iCC_Profile2);
    }

    @Test
    public void testReadProfileInputStreamSameAsCached() throws IOException {
        ICC_ColorSpace iCC_ColorSpace = ColorSpaces.createColorSpace((ICC_Profile)ICC_Profile.getInstance(this.getClass().getResourceAsStream("/profiles/adobe_rgb_1998.icc")));
        ICC_Profile iCC_Profile = ColorProfiles.readProfile((InputStream)this.getClass().getResourceAsStream("/profiles/adobe_rgb_1998.icc"));
        Assert.assertEquals((Object)iCC_ColorSpace.getProfile(), (Object)iCC_Profile);
        Assert.assertSame((Object)iCC_ColorSpace.getProfile(), (Object)iCC_Profile);
    }

    @Test
    public void testCreateProfileBytesSameAsInternal() {
        ICC_Profile iCC_Profile = ICC_Profile.getInstance(1000);
        ICC_Profile iCC_Profile2 = ColorProfiles.createProfile((byte[])ICC_Profile.getInstance(1000).getData());
        Assert.assertEquals((Object)iCC_Profile, (Object)iCC_Profile2);
        Assert.assertSame((Object)iCC_Profile, (Object)iCC_Profile2);
    }

    @Test
    public void testReadProfileInputStreamSameAsInternal() throws IOException {
        ICC_Profile iCC_Profile = ICC_Profile.getInstance(1000);
        ICC_Profile iCC_Profile2 = ColorProfiles.readProfile((InputStream)new ByteArrayInputStream(ICC_Profile.getInstance(1000).getData()));
        Assert.assertEquals((Object)iCC_Profile, (Object)iCC_Profile2);
        Assert.assertSame((Object)iCC_Profile, (Object)iCC_Profile2);
    }
}

