/*
 * Decompiled with CFR 0.152.
 */
package com.twelvemonkeys.imageio;

import com.twelvemonkeys.imageio.StandardImageMetadataSupport;
import com.twelvemonkeys.imageio.util.ImageTypeSpecifiers;
import java.util.Arrays;
import java.util.Calendar;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import javax.imageio.ImageTypeSpecifier;
import javax.imageio.metadata.IIOMetadata;
import javax.imageio.metadata.IIOMetadataNode;
import org.junit.Assert;
import org.junit.Test;
import org.w3c.dom.NodeList;

public class StandardImageMetadataSupportTest {
    @Test(expected=IllegalArgumentException.class)
    public void createNullBuilder() {
        new StandardImageMetadataSupport(null);
    }

    @Test(expected=IllegalArgumentException.class)
    public void createNullType() {
        new StandardImageMetadataSupport(StandardImageMetadataSupport.builder(null));
    }

    @Test(expected=IllegalArgumentException.class)
    public void builderNullType() {
        StandardImageMetadataSupport.builder(null).build();
    }

    @Test
    public void createValid() {
        StandardImageMetadataSupport standardImageMetadataSupport = new StandardImageMetadataSupport(StandardImageMetadataSupport.builder((ImageTypeSpecifier)ImageTypeSpecifiers.createFromBufferedImageType((int)2)));
        Assert.assertNotNull((Object)standardImageMetadataSupport);
    }

    @Test
    public void builderValid() {
        IIOMetadata iIOMetadata = StandardImageMetadataSupport.builder((ImageTypeSpecifier)ImageTypeSpecifiers.createFromBufferedImageType((int)2)).build();
        Assert.assertNotNull((Object)iIOMetadata);
    }

    @Test
    public void compressionValuesUnspecified() {
        StandardImageMetadataSupport standardImageMetadataSupport = (StandardImageMetadataSupport)StandardImageMetadataSupport.builder((ImageTypeSpecifier)ImageTypeSpecifiers.createFromBufferedImageType((int)10)).build();
        Assert.assertNull((Object)standardImageMetadataSupport.getStandardCompressionNode());
    }

    @Test
    public void compressionValuesNone() {
        StandardImageMetadataSupport standardImageMetadataSupport = (StandardImageMetadataSupport)StandardImageMetadataSupport.builder((ImageTypeSpecifier)ImageTypeSpecifiers.createFromBufferedImageType((int)10)).withCompressionTypeName("nOnE").build();
        Assert.assertNull((Object)standardImageMetadataSupport.getStandardCompressionNode());
    }

    @Test
    public void compressionValuesName() {
        StandardImageMetadataSupport standardImageMetadataSupport = (StandardImageMetadataSupport)StandardImageMetadataSupport.builder((ImageTypeSpecifier)ImageTypeSpecifiers.createFromBufferedImageType((int)10)).withCompressionTypeName("foo").build();
        IIOMetadataNode iIOMetadataNode = standardImageMetadataSupport.getStandardCompressionNode();
        Assert.assertNotNull((Object)iIOMetadataNode);
        IIOMetadataNode iIOMetadataNode2 = (IIOMetadataNode)iIOMetadataNode.getElementsByTagName("CompressionTypeName").item(0);
        Assert.assertEquals((Object)"foo", (Object)iIOMetadataNode2.getAttribute("value"));
        IIOMetadataNode iIOMetadataNode3 = (IIOMetadataNode)iIOMetadataNode.getElementsByTagName("Lossless").item(0);
        Assert.assertEquals((Object)"TRUE", (Object)iIOMetadataNode3.getAttribute("value"));
    }

    @Test(expected=IllegalArgumentException.class)
    public void withCompressionLossyIllegal() {
        StandardImageMetadataSupport.builder((ImageTypeSpecifier)ImageTypeSpecifiers.createFromBufferedImageType((int)10)).withCompressionLossless(false);
    }

    @Test
    public void compressionValuesLossy() {
        StandardImageMetadataSupport standardImageMetadataSupport = (StandardImageMetadataSupport)StandardImageMetadataSupport.builder((ImageTypeSpecifier)ImageTypeSpecifiers.createFromBufferedImageType((int)10)).withCompressionTypeName("bar").withCompressionLossless(false).build();
        IIOMetadataNode iIOMetadataNode = standardImageMetadataSupport.getStandardCompressionNode();
        Assert.assertNotNull((Object)iIOMetadataNode);
        IIOMetadataNode iIOMetadataNode2 = (IIOMetadataNode)iIOMetadataNode.getElementsByTagName("CompressionTypeName").item(0);
        Assert.assertEquals((Object)"bar", (Object)iIOMetadataNode2.getAttribute("value"));
        IIOMetadataNode iIOMetadataNode3 = (IIOMetadataNode)iIOMetadataNode.getElementsByTagName("Lossless").item(0);
        Assert.assertEquals((Object)"FALSE", (Object)iIOMetadataNode3.getAttribute("value"));
    }

    @Test
    public void withDocumentValuesDefault() {
        StandardImageMetadataSupport standardImageMetadataSupport = (StandardImageMetadataSupport)StandardImageMetadataSupport.builder((ImageTypeSpecifier)ImageTypeSpecifiers.createFromBufferedImageType((int)10)).build();
        IIOMetadataNode iIOMetadataNode = standardImageMetadataSupport.getStandardDocumentNode();
        Assert.assertNull((Object)iIOMetadataNode);
    }

    @Test
    public void withDocumentValues() {
        Calendar calendar = Calendar.getInstance();
        calendar.set(2022, 8, 8, 14, 5, 0);
        StandardImageMetadataSupport standardImageMetadataSupport = (StandardImageMetadataSupport)StandardImageMetadataSupport.builder((ImageTypeSpecifier)ImageTypeSpecifiers.createFromBufferedImageType((int)10)).withFormatVersion("42").withDocumentCreationTime(calendar).build();
        IIOMetadataNode iIOMetadataNode = standardImageMetadataSupport.getStandardDocumentNode();
        Assert.assertNotNull((Object)iIOMetadataNode);
        IIOMetadataNode iIOMetadataNode2 = (IIOMetadataNode)iIOMetadataNode.getElementsByTagName("FormatVersion").item(0);
        Assert.assertEquals((Object)"42", (Object)iIOMetadataNode2.getAttribute("value"));
        IIOMetadataNode iIOMetadataNode3 = (IIOMetadataNode)iIOMetadataNode.getElementsByTagName("ImageCreationTime").item(0);
        Assert.assertEquals((Object)"2022", (Object)iIOMetadataNode3.getAttribute("year"));
        Assert.assertEquals((Object)"9", (Object)iIOMetadataNode3.getAttribute("month"));
        Assert.assertEquals((Object)"8", (Object)iIOMetadataNode3.getAttribute("day"));
        Assert.assertEquals((Object)"14", (Object)iIOMetadataNode3.getAttribute("hour"));
        Assert.assertEquals((Object)"5", (Object)iIOMetadataNode3.getAttribute("minute"));
        Assert.assertEquals((Object)"0", (Object)iIOMetadataNode3.getAttribute("second"));
    }

    @Test
    public void withTextValuesDefault() {
        StandardImageMetadataSupport standardImageMetadataSupport = (StandardImageMetadataSupport)StandardImageMetadataSupport.builder((ImageTypeSpecifier)ImageTypeSpecifiers.createFromBufferedImageType((int)10)).build();
        IIOMetadataNode iIOMetadataNode = standardImageMetadataSupport.getStandardTextNode();
        Assert.assertNull((Object)iIOMetadataNode);
    }

    @Test
    public void withTextValuesSingle() {
        StandardImageMetadataSupport standardImageMetadataSupport = (StandardImageMetadataSupport)StandardImageMetadataSupport.builder((ImageTypeSpecifier)ImageTypeSpecifiers.createFromBufferedImageType((int)10)).withTextEntry("foo", "bar").build();
        IIOMetadataNode iIOMetadataNode = standardImageMetadataSupport.getStandardTextNode();
        Assert.assertNotNull((Object)iIOMetadataNode);
        IIOMetadataNode iIOMetadataNode2 = (IIOMetadataNode)iIOMetadataNode.getElementsByTagName("TextEntry").item(0);
        Assert.assertEquals((Object)"foo", (Object)iIOMetadataNode2.getAttribute("keyword"));
        Assert.assertEquals((Object)"bar", (Object)iIOMetadataNode2.getAttribute("value"));
    }

    @Test
    public void withTextValuesMap() {
        LinkedHashMap<String, String> linkedHashMap = new LinkedHashMap<String, String>();
        linkedHashMap.put("foo", "bar");
        linkedHashMap.put("bar", "xyzzy");
        StandardImageMetadataSupport standardImageMetadataSupport = (StandardImageMetadataSupport)StandardImageMetadataSupport.builder((ImageTypeSpecifier)ImageTypeSpecifiers.createFromBufferedImageType((int)10)).withTextEntries(linkedHashMap).build();
        IIOMetadataNode iIOMetadataNode = standardImageMetadataSupport.getStandardTextNode();
        Assert.assertNotNull((Object)iIOMetadataNode);
        NodeList nodeList = iIOMetadataNode.getElementsByTagName("TextEntry");
        Assert.assertEquals((long)linkedHashMap.size(), (long)nodeList.getLength());
        int n = 0;
        for (Map.Entry entry : linkedHashMap.entrySet()) {
            IIOMetadataNode iIOMetadataNode2 = (IIOMetadataNode)nodeList.item(n);
            Assert.assertEquals(entry.getKey(), (Object)iIOMetadataNode2.getAttribute("keyword"));
            Assert.assertEquals(entry.getValue(), (Object)iIOMetadataNode2.getAttribute("value"));
            ++n;
        }
    }

    @Test
    public void withTextValuesList() {
        List<StandardImageMetadataSupport.TextEntry> list = Arrays.asList(new StandardImageMetadataSupport.TextEntry(null, "foo"), new StandardImageMetadataSupport.TextEntry("foo", "bar"), new StandardImageMetadataSupport.TextEntry("bar", "xyzzy"), new StandardImageMetadataSupport.TextEntry("bar", "nothing happens..."), new StandardImageMetadataSupport.TextEntry("everything", "v\u00e1l\u00fc\u00e8", "unknown", "UTF-8", "zip"));
        StandardImageMetadataSupport standardImageMetadataSupport = (StandardImageMetadataSupport)StandardImageMetadataSupport.builder((ImageTypeSpecifier)ImageTypeSpecifiers.createFromBufferedImageType((int)10)).withTextEntries(list).build();
        IIOMetadataNode iIOMetadataNode = standardImageMetadataSupport.getStandardTextNode();
        Assert.assertNotNull((Object)iIOMetadataNode);
        NodeList nodeList = iIOMetadataNode.getElementsByTagName("TextEntry");
        Assert.assertEquals((long)list.size(), (long)nodeList.getLength());
        for (int i = 0; i < list.size(); ++i) {
            StandardImageMetadataSupport.TextEntry textEntry = list.get(i);
            IIOMetadataNode iIOMetadataNode2 = (IIOMetadataNode)nodeList.item(i);
            StandardImageMetadataSupportTest.assertAttributeEqualOrAbsent(textEntry.keyword, iIOMetadataNode2, "keyword");
            Assert.assertEquals((Object)textEntry.value, (Object)iIOMetadataNode2.getAttribute("value"));
            StandardImageMetadataSupportTest.assertAttributeEqualOrAbsent(textEntry.language, iIOMetadataNode2, "language");
            StandardImageMetadataSupportTest.assertAttributeEqualOrAbsent(textEntry.encoding, iIOMetadataNode2, "encoding");
            StandardImageMetadataSupportTest.assertAttributeEqualOrAbsent(textEntry.compression, iIOMetadataNode2, "compression");
        }
    }

    private static void assertAttributeEqualOrAbsent(String string, IIOMetadataNode iIOMetadataNode, String string2) {
        if (string != null) {
            Assert.assertEquals((Object)string, (Object)iIOMetadataNode.getAttribute(string2));
        } else {
            Assert.assertFalse((boolean)iIOMetadataNode.hasAttribute(string2));
        }
    }

    @Test
    public void withPlanarColorspaceType() {
        List<String> list = Arrays.asList("XYZ", "Lab", "Luv", "YCbCr", "Yxy", "YCCK", "PhotoYCC", "RGB", "GRAY", "HSV", "HLS", "CMYK", "CMY", "2CLR", "3CLR", "4CLR", "5CLR", "6CLR", "7CLR", "8CLR", "9CLR", "ACLR", "BCLR", "CCLR", "DCLR", "ECLR", "FCLR");
        for (StandardImageMetadataSupport.ColorSpaceType colorSpaceType : StandardImageMetadataSupport.ColorSpaceType.values()) {
            StandardImageMetadataSupport standardImageMetadataSupport = (StandardImageMetadataSupport)StandardImageMetadataSupport.builder((ImageTypeSpecifier)ImageTypeSpecifiers.createFromBufferedImageType((int)10)).withColorSpaceType(colorSpaceType).build();
            Assert.assertNotNull((Object)standardImageMetadataSupport);
            IIOMetadataNode iIOMetadataNode = standardImageMetadataSupport.getStandardChromaNode();
            Assert.assertNotNull((Object)iIOMetadataNode);
            IIOMetadataNode iIOMetadataNode2 = (IIOMetadataNode)iIOMetadataNode.getElementsByTagName("ColorSpaceType").item(0);
            Assert.assertEquals((Object)colorSpaceType.toString(), (Object)iIOMetadataNode2.getAttribute("name"));
            Assert.assertTrue((boolean)list.contains(colorSpaceType.toString()));
        }
    }

    @Test
    public void withPlanarConfiguration() {
        List<String> list = Arrays.asList("PixelInterleaved", "PlaneInterleaved", "LineInterleaved", "TileInterleaved");
        for (StandardImageMetadataSupport.PlanarConfiguration planarConfiguration : StandardImageMetadataSupport.PlanarConfiguration.values()) {
            StandardImageMetadataSupport standardImageMetadataSupport = (StandardImageMetadataSupport)StandardImageMetadataSupport.builder((ImageTypeSpecifier)ImageTypeSpecifiers.createFromBufferedImageType((int)5)).withPlanarConfiguration(planarConfiguration).build();
            Assert.assertNotNull((Object)standardImageMetadataSupport);
            IIOMetadataNode iIOMetadataNode = standardImageMetadataSupport.getStandardDataNode();
            Assert.assertNotNull((Object)iIOMetadataNode);
            IIOMetadataNode iIOMetadataNode2 = (IIOMetadataNode)iIOMetadataNode.getElementsByTagName("PlanarConfiguration").item(0);
            Assert.assertEquals((Object)planarConfiguration.toString(), (Object)iIOMetadataNode2.getAttribute("value"));
            Assert.assertTrue((boolean)list.contains(planarConfiguration.toString()));
        }
    }

    @Test
    public void withImageOrientation() {
        List<String> list = Arrays.asList("Normal", "Rotate90", "Rotate180", "Rotate270", "FlipH", "FlipV", "FlipHRotate90", "FlipVRotate90");
        for (StandardImageMetadataSupport.ImageOrientation imageOrientation : StandardImageMetadataSupport.ImageOrientation.values()) {
            StandardImageMetadataSupport standardImageMetadataSupport = (StandardImageMetadataSupport)StandardImageMetadataSupport.builder((ImageTypeSpecifier)ImageTypeSpecifiers.createFromBufferedImageType((int)10)).withOrientation(imageOrientation).build();
            Assert.assertNotNull((Object)standardImageMetadataSupport);
            IIOMetadataNode iIOMetadataNode = standardImageMetadataSupport.getStandardDimensionNode();
            Assert.assertNotNull((Object)iIOMetadataNode);
            IIOMetadataNode iIOMetadataNode2 = (IIOMetadataNode)iIOMetadataNode.getElementsByTagName("ImageOrientation").item(0);
            Assert.assertEquals((Object)imageOrientation.toString(), (Object)iIOMetadataNode2.getAttribute("value"));
            Assert.assertTrue((boolean)list.contains(imageOrientation.toString()));
        }
    }

    @Test
    public void withSubimageInterpretation() {
        List<String> list = Arrays.asList("Standalone", "SinglePage", "FullResolution", "ReducedResolution", "PyramidLayer", "Preview", "VolumeSlice", "ObjectView", "Panorama", "AnimationFrame", "TransparencyMask", "CompositingLayer", "SpectralSlice", "Unknown");
        for (StandardImageMetadataSupport.SubimageInterpretation subimageInterpretation : StandardImageMetadataSupport.SubimageInterpretation.values()) {
            StandardImageMetadataSupport standardImageMetadataSupport = (StandardImageMetadataSupport)StandardImageMetadataSupport.builder((ImageTypeSpecifier)ImageTypeSpecifiers.createFromBufferedImageType((int)1)).withSubimageInterpretation(subimageInterpretation).build();
            Assert.assertNotNull((Object)standardImageMetadataSupport);
            IIOMetadataNode iIOMetadataNode = standardImageMetadataSupport.getStandardDocumentNode();
            Assert.assertNotNull((Object)iIOMetadataNode);
            IIOMetadataNode iIOMetadataNode2 = (IIOMetadataNode)iIOMetadataNode.getElementsByTagName("SubimageInterpretation").item(0);
            Assert.assertEquals((Object)subimageInterpretation.toString(), (Object)iIOMetadataNode2.getAttribute("value"));
            Assert.assertTrue((boolean)list.contains(subimageInterpretation.toString()));
        }
    }
}

