/*
 * Decompiled with CFR 0.152.
 */
package com.twelvemonkeys.imageio.color;

import com.twelvemonkeys.imageio.color.CMYKColorSpace;
import com.twelvemonkeys.imageio.color.ICCProfileSanitizer;
import com.twelvemonkeys.io.FileUtil;
import com.twelvemonkeys.lang.Platform;
import com.twelvemonkeys.lang.SystemUtil;
import com.twelvemonkeys.lang.Validate;
import com.twelvemonkeys.util.LRUHashMap;
import java.awt.color.ColorSpace;
import java.awt.color.ICC_ColorSpace;
import java.awt.color.ICC_Profile;
import java.io.IOException;
import java.io.InputStream;
import java.lang.ref.WeakReference;
import java.util.Arrays;
import java.util.Map;
import java.util.Properties;

public final class ColorSpaces {
    static final boolean DEBUG = "true".equalsIgnoreCase(System.getProperty("com.twelvemonkeys.imageio.color.debug"));
    private static final ICCProfileSanitizer profileCleaner = ICCProfileSanitizer.Factory.get();
    public static final int CS_ADOBE_RGB_1998 = 5000;
    public static final int CS_GENERIC_CMYK = 5001;
    private static WeakReference<ICC_Profile> adobeRGB1998 = new WeakReference<Object>(null);
    private static WeakReference<ICC_Profile> genericCMYK = new WeakReference<Object>(null);
    private static final Map<Key, ICC_ColorSpace> cache = new LRUHashMap(10);

    private ColorSpaces() {
    }

    public static ICC_ColorSpace createColorSpace(ICC_Profile iCC_Profile) {
        Validate.notNull((Object)iCC_Profile, (String)"profile");
        byte[] byArray = iCC_Profile.getData(1751474532);
        ICC_ColorSpace iCC_ColorSpace = ColorSpaces.getInternalCS(iCC_Profile.getColorSpaceType(), byArray);
        if (iCC_ColorSpace != null) {
            return iCC_ColorSpace;
        }
        if (byArray[64] != 0) {
            byArray[64] = 0;
            iCC_ColorSpace = ColorSpaces.getInternalCS(iCC_Profile.getColorSpaceType(), byArray);
            if (iCC_ColorSpace != null) {
                return iCC_ColorSpace;
            }
            profileCleaner.fixProfile(iCC_Profile, byArray);
        } else {
            profileCleaner.fixProfile(iCC_Profile, null);
        }
        return ColorSpaces.getCachedOrCreateCS(iCC_Profile, byArray);
    }

    private static ICC_ColorSpace getInternalCS(int n, byte[] byArray) {
        if (n == 5 && Arrays.equals(byArray, sRGB.header)) {
            return (ICC_ColorSpace)ColorSpace.getInstance(1000);
        }
        if (n == 6 && Arrays.equals(byArray, GRAY.header)) {
            return (ICC_ColorSpace)ColorSpace.getInstance(1003);
        }
        if (n == 13 && Arrays.equals(byArray, PYCC.header)) {
            return (ICC_ColorSpace)ColorSpace.getInstance(1002);
        }
        if (n == 5 && Arrays.equals(byArray, LINEAR_RGB.header)) {
            return (ICC_ColorSpace)ColorSpace.getInstance(1004);
        }
        if (n == 0 && Arrays.equals(byArray, CIEXYZ.header)) {
            return (ICC_ColorSpace)ColorSpace.getInstance(1001);
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static ICC_ColorSpace getCachedOrCreateCS(ICC_Profile iCC_Profile, byte[] byArray) {
        Key key = new Key(byArray);
        Map<Key, ICC_ColorSpace> map = cache;
        synchronized (map) {
            ICC_ColorSpace iCC_ColorSpace = cache.get(key);
            if (iCC_ColorSpace == null) {
                iCC_ColorSpace = new ICC_ColorSpace(iCC_Profile);
                cache.put(key, iCC_ColorSpace);
            }
            return iCC_ColorSpace;
        }
    }

    public static boolean isCS_sRGB(ICC_Profile iCC_Profile) {
        Validate.notNull((Object)iCC_Profile, (String)"profile");
        return iCC_Profile.getColorSpaceType() == 5 && Arrays.equals(iCC_Profile.getData(1751474532), sRGB.header);
    }

    public static boolean isOffendingColorProfile(ICC_Profile iCC_Profile) {
        Validate.notNull((Object)iCC_Profile, (String)"profile");
        byte[] byArray = iCC_Profile.getData(1751474532);
        return byArray[64] != 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static ColorSpace getColorSpace(int n) {
        switch (n) {
            case 5000: {
                Class<ColorSpaces> clazz = ColorSpaces.class;
                synchronized (ColorSpaces.class) {
                    ICC_Profile iCC_Profile = (ICC_Profile)adobeRGB1998.get();
                    if (iCC_Profile == null) {
                        iCC_Profile = ColorSpaces.readProfileFromPath(Profiles.getPath("ADOBE_RGB_1998"));
                        if (iCC_Profile == null && (iCC_Profile = ColorSpaces.readProfileFromClasspathResource("/profiles/ClayRGB1998.icc")) == null) {
                            throw new IllegalStateException("Could not read AdobeRGB1998 profile");
                        }
                        adobeRGB1998 = new WeakReference<ICC_Profile>(iCC_Profile);
                    }
                    // ** MonitorExit[var2_1] (shouldn't be in output)
                    return ColorSpaces.createColorSpace(iCC_Profile);
                }
            }
            case 5001: {
                Class<ColorSpaces> clazz = ColorSpaces.class;
                synchronized (ColorSpaces.class) {
                    ICC_Profile iCC_Profile = (ICC_Profile)genericCMYK.get();
                    if (iCC_Profile == null) {
                        iCC_Profile = ColorSpaces.readProfileFromPath(Profiles.getPath("GENERIC_CMYK"));
                        if (iCC_Profile == null) {
                            if (DEBUG) {
                                System.out.println("Using fallback profile");
                            }
                            // ** MonitorExit[var2_2] (shouldn't be in output)
                            return CMYKColorSpace.getInstance();
                        }
                        genericCMYK = new WeakReference<ICC_Profile>(iCC_Profile);
                    }
                    // ** MonitorExit[var2_2] (shouldn't be in output)
                    return ColorSpaces.createColorSpace(iCC_Profile);
                }
            }
        }
        return ColorSpace.getInstance(n);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static ICC_Profile readProfileFromClasspathResource(String string) {
        InputStream inputStream = ColorSpaces.class.getResourceAsStream(string);
        if (inputStream != null) {
            if (DEBUG) {
                System.out.println("Loading profile from classpath resource: " + string);
            }
            try {
                ICC_Profile iCC_Profile = ICC_Profile.getInstance(inputStream);
                return iCC_Profile;
            }
            catch (IOException iOException) {
                if (DEBUG) {
                    iOException.printStackTrace();
                }
            }
            finally {
                FileUtil.close((InputStream)inputStream);
            }
        }
        return null;
    }

    private static ICC_Profile readProfileFromPath(String string) {
        block4: {
            if (string != null) {
                if (DEBUG) {
                    System.out.println("Loading profile from: " + string);
                }
                try {
                    return ICC_Profile.getInstance(string);
                }
                catch (IOException iOException) {
                    if (!DEBUG) break block4;
                    iOException.printStackTrace();
                }
            }
        }
        return null;
    }

    private static class Profiles {
        private static final Properties PROFILES = Profiles.loadProfiles();

        private Profiles() {
        }

        private static Properties loadProfiles() {
            Properties properties;
            try {
                properties = SystemUtil.loadProperties(ColorSpaces.class, (String)("com/twelvemonkeys/imageio/color/icc_profiles_" + Platform.os().id()));
            }
            catch (IOException | SecurityException exception) {
                System.err.printf("Warning: Could not load system default ICC profile locations from %s, will use bundled fallback profiles.\n", exception.getMessage());
                if (DEBUG) {
                    exception.printStackTrace();
                }
                properties = null;
            }
            Properties properties2 = new Properties(properties);
            try {
                Properties properties3 = SystemUtil.loadProperties(ColorSpaces.class, (String)"com/twelvemonkeys/imageio/color/icc_profiles");
                properties2.putAll((Map<?, ?>)properties3);
            }
            catch (IOException | SecurityException exception) {
                // empty catch block
            }
            if (DEBUG) {
                System.out.println("User ICC profiles: " + properties2);
                System.out.println("System ICC profiles : " + properties);
            }
            return properties2;
        }

        public static String getPath(String string) {
            return PROFILES.getProperty(string);
        }
    }

    private static class LINEAR_RGB {
        private static final byte[] header = ICC_Profile.getInstance(1004).getData(1751474532);

        private LINEAR_RGB() {
        }
    }

    private static class GRAY {
        private static final byte[] header = ICC_Profile.getInstance(1003).getData(1751474532);

        private GRAY() {
        }
    }

    private static class PYCC {
        private static final byte[] header = ICC_Profile.getInstance(1002).getData(1751474532);

        private PYCC() {
        }
    }

    private static class CIEXYZ {
        private static final byte[] header = ICC_Profile.getInstance(1001).getData(1751474532);

        private CIEXYZ() {
        }
    }

    private static class sRGB {
        private static final byte[] header = ICC_Profile.getInstance(1000).getData(1751474532);

        private sRGB() {
        }
    }

    private static final class Key {
        private final byte[] data;

        public Key(byte[] byArray) {
            this.data = byArray;
        }

        public boolean equals(Object object) {
            return object instanceof Key && Arrays.equals(this.data, ((Key)object).data);
        }

        public int hashCode() {
            return Arrays.hashCode(this.data);
        }
    }
}

