/*
 * Decompiled with CFR 0.152.
 */
package com.twelvemonkeys.imageio.path;

import com.twelvemonkeys.imageio.path.AdobePathReader;
import com.twelvemonkeys.imageio.path.AdobePathSegment;
import com.twelvemonkeys.lang.Validate;
import java.awt.Rectangle;
import java.awt.Shape;
import java.awt.geom.PathIterator;
import java.io.ByteArrayOutputStream;
import java.io.DataOutput;
import java.io.DataOutputStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;

public final class AdobePathWriter {
    private static final double COLLINEARITY_THRESHOLD = 1.0E-8;
    private final List<AdobePathSegment> segments;

    public AdobePathWriter(Shape shape) {
        Validate.notNull((Object)shape, (String)"path");
        Validate.isTrue((boolean)new Rectangle(0, 0, 1, 1).contains(shape.getBounds2D()), (Object)shape.getBounds2D(), (String)"Path bounds must be within [x=0,y=0,w=1,h=1]: %s");
        this.segments = AdobePathWriter.pathToSegments(shape.getPathIterator(null));
    }

    private static List<AdobePathSegment> pathToSegments(PathIterator pathIterator) {
        Validate.isTrue((pathIterator.getWindingRule() == 0 ? 1 : 0) != 0, (Object)pathIterator.getWindingRule(), (String)"Only even/odd winding rule supported: %d");
        double[] dArray = new double[6];
        AdobePathSegment adobePathSegment = new AdobePathSegment(1, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0);
        ArrayList<AdobePathSegment> arrayList = new ArrayList<AdobePathSegment>();
        ArrayList<AdobePathSegment> arrayList2 = new ArrayList<AdobePathSegment>();
        arrayList2.add(new AdobePathSegment(6, 0));
        arrayList2.add(new AdobePathSegment(8, 0));
        while (!pathIterator.isDone()) {
            int n = pathIterator.currentSegment(dArray);
            if (AdobePathReader.DEBUG) {
                System.out.println("segmentType: " + n);
                System.out.println("coords: " + Arrays.toString(dArray));
            }
            boolean bl = AdobePathWriter.isCollinear(adobePathSegment.cppx, adobePathSegment.cppy, adobePathSegment.apx, adobePathSegment.apy, dArray[0], dArray[1]);
            switch (n) {
                case 0: {
                    adobePathSegment = new AdobePathSegment(1, 0.0, 0.0, dArray[1], dArray[0], 0.0, 0.0);
                    break;
                }
                case 1: {
                    arrayList.add(new AdobePathSegment(bl ? 1 : 2, adobePathSegment.cppy, adobePathSegment.cppx, adobePathSegment.apy, adobePathSegment.apx, dArray[1], dArray[0]));
                    adobePathSegment = new AdobePathSegment(1, dArray[1], dArray[0], dArray[1], dArray[0], 0.0, 0.0);
                    break;
                }
                case 2: {
                    arrayList.add(new AdobePathSegment(bl ? 1 : 2, adobePathSegment.cppy, adobePathSegment.cppx, adobePathSegment.apy, adobePathSegment.apx, dArray[1], dArray[0]));
                    adobePathSegment = new AdobePathSegment(1, dArray[3], dArray[2], dArray[3], dArray[2], 0.0, 0.0);
                    break;
                }
                case 3: {
                    arrayList.add(new AdobePathSegment(bl ? 1 : 2, adobePathSegment.cppy, adobePathSegment.cppx, adobePathSegment.apy, adobePathSegment.apx, dArray[1], dArray[0]));
                    adobePathSegment = new AdobePathSegment(1, dArray[3], dArray[2], dArray[5], dArray[4], 0.0, 0.0);
                    break;
                }
                case 4: {
                    AdobePathSegment adobePathSegment2 = (AdobePathSegment)arrayList.get(0);
                    if (adobePathSegment2.apx != adobePathSegment.apx || adobePathSegment2.apy != adobePathSegment.apy) {
                        bl = AdobePathWriter.isCollinear(adobePathSegment.cppx, adobePathSegment.cppy, adobePathSegment2.apx, adobePathSegment2.apy, adobePathSegment2.apx, adobePathSegment2.apy);
                        arrayList.add(new AdobePathSegment(bl ? 1 : 2, adobePathSegment.cppy, adobePathSegment.cppx, adobePathSegment.apy, adobePathSegment.apx, adobePathSegment2.apy, adobePathSegment2.apx));
                        adobePathSegment = new AdobePathSegment(1, adobePathSegment2.apy, adobePathSegment2.apx, adobePathSegment2.apy, adobePathSegment2.apx, 0.0, 0.0);
                    }
                    AdobePathWriter.close(adobePathSegment2, adobePathSegment, arrayList, arrayList2);
                    arrayList.clear();
                }
            }
            pathIterator.next();
        }
        if (!arrayList.isEmpty()) {
            AdobePathSegment adobePathSegment3 = (AdobePathSegment)arrayList.get(0);
            if (adobePathSegment3.apx != adobePathSegment.apx || adobePathSegment3.apy != adobePathSegment.apy) {
                throw new IllegalArgumentException("Path must be closed");
            }
            AdobePathWriter.close(adobePathSegment3, adobePathSegment, arrayList, arrayList2);
        }
        return arrayList2;
    }

    private static void close(AdobePathSegment adobePathSegment, AdobePathSegment adobePathSegment2, List<AdobePathSegment> list, List<AdobePathSegment> list2) {
        boolean bl = AdobePathWriter.isCollinear(adobePathSegment2.cppx, adobePathSegment2.cppy, adobePathSegment.apx, adobePathSegment.apy, adobePathSegment.cplx, adobePathSegment.cply);
        list.set(0, new AdobePathSegment(bl ? 1 : 2, adobePathSegment2.cppy, adobePathSegment2.cppx, adobePathSegment.apy, adobePathSegment.apx, adobePathSegment.cply, adobePathSegment.cplx));
        list2.add(new AdobePathSegment(0, list.size()));
        list2.addAll(list);
    }

    private static boolean isCollinear(double d, double d2, double d3, double d4, double d5, double d6) {
        return d == d3 && d3 == d5 && d2 == d4 && d4 == d6 || (d != d3 || d2 != d4) && (d3 != d5 || d4 != d6) && Math.abs(d * (d4 - d6) + d3 * (d6 - d2) + d5 * (d2 - d4)) <= 1.0E-8;
    }

    public void writePathResource(int n, DataOutput dataOutput) throws IOException {
        dataOutput.writeInt(943868237);
        dataOutput.writeShort(n);
        dataOutput.writeShort(0);
        dataOutput.writeInt(this.segments.size() * 26);
        this.writePath(dataOutput);
    }

    public void writePath(DataOutput dataOutput) throws IOException {
        if (AdobePathReader.DEBUG) {
            System.out.println("segments: " + this.segments.size());
            System.out.println(this.segments);
        }
        block4: for (AdobePathSegment adobePathSegment : this.segments) {
            switch (adobePathSegment.selector) {
                case 6: 
                case 8: {
                    dataOutput.writeShort(adobePathSegment.selector);
                    dataOutput.write(new byte[24]);
                    continue block4;
                }
                case 0: 
                case 3: {
                    dataOutput.writeShort(adobePathSegment.selector);
                    dataOutput.writeShort(adobePathSegment.lengthOrRule);
                    dataOutput.write(new byte[22]);
                    continue block4;
                }
            }
            dataOutput.writeShort(adobePathSegment.selector);
            dataOutput.writeInt(AdobePathSegment.toFixedPoint(adobePathSegment.cppy));
            dataOutput.writeInt(AdobePathSegment.toFixedPoint(adobePathSegment.cppx));
            dataOutput.writeInt(AdobePathSegment.toFixedPoint(adobePathSegment.apy));
            dataOutput.writeInt(AdobePathSegment.toFixedPoint(adobePathSegment.apx));
            dataOutput.writeInt(AdobePathSegment.toFixedPoint(adobePathSegment.cply));
            dataOutput.writeInt(AdobePathSegment.toFixedPoint(adobePathSegment.cplx));
        }
    }

    public byte[] writePathResource(int n) {
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        try (DataOutputStream dataOutputStream = new DataOutputStream(byteArrayOutputStream);){
            this.writePathResource(n, dataOutputStream);
        }
        catch (IOException iOException) {
            throw new AssertionError("ByteArrayOutputStream threw IOException", iOException);
        }
        return byteArrayOutputStream.toByteArray();
    }

    public byte[] writePath() {
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        try (DataOutputStream dataOutputStream = new DataOutputStream(byteArrayOutputStream);){
            this.writePath(dataOutputStream);
        }
        catch (IOException iOException) {
            throw new AssertionError("ByteArrayOutputStream threw IOException", iOException);
        }
        return byteArrayOutputStream.toByteArray();
    }
}

