/*
 * Decompiled with CFR 0.152.
 */
package com.twelvemonkeys.imageio.plugins.svg;

import com.twelvemonkeys.imageio.plugins.svg.SVGImageReader;
import com.twelvemonkeys.imageio.plugins.svg.SVGProviderInfo;
import com.twelvemonkeys.imageio.spi.ImageReaderSpiBase;
import com.twelvemonkeys.imageio.spi.ReaderWriterProviderInfo;
import com.twelvemonkeys.imageio.util.IIOUtil;
import com.twelvemonkeys.lang.SystemUtil;
import java.io.ByteArrayOutputStream;
import java.io.EOFException;
import java.io.IOException;
import java.util.Locale;
import java.util.function.Predicate;
import javax.imageio.ImageReader;
import javax.imageio.spi.IIOServiceProvider;
import javax.imageio.spi.ImageReaderSpi;
import javax.imageio.spi.ServiceRegistry;
import javax.imageio.stream.ImageInputStream;

public final class SVGImageReaderSpi
extends ImageReaderSpiBase {
    static final boolean SVG_READER_AVAILABLE = SystemUtil.isClassAvailable((String)"com.twelvemonkeys.imageio.plugins.svg.SVGImageReader", SVGImageReaderSpi.class);

    public SVGImageReaderSpi() {
        super((ReaderWriterProviderInfo)new SVGProviderInfo());
    }

    public boolean canDecodeInput(Object object) throws IOException {
        return object instanceof ImageInputStream && SVGImageReaderSpi.canDecode((ImageInputStream)object);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static boolean canDecode(ImageInputStream imageInputStream) throws IOException {
        int n2;
        int n3;
        ByteArrayOutputStream byteArrayOutputStream2;
        byte[] byArray;
        try {
            int n;
            imageInputStream.mark();
            while (Character.isWhitespace((char)(n = imageInputStream.read()))) {
            }
            if (n != 60) {
                boolean bl = false;
                return bl;
            }
            byArray = new byte[4];
            block12: while (true) {
                imageInputStream.readFully(byArray);
                if (byArray[0] == 63) {
                    while ((imageInputStream.readByte() & 0xFF) != 63 || imageInputStream.read() != 62) {
                    }
                } else {
                    if (byArray[0] != 33) {
                        if (byArray[0] == 115 && byArray[1] == 118 && byArray[2] == 103 && (Character.isWhitespace((char)byArray[3]) || byArray[3] == 58)) {
                            boolean bl = true;
                            return bl;
                        }
                        byteArrayOutputStream2 = new ByteArrayOutputStream(256);
                        break;
                    }
                    if (byArray[1] == 45 && byArray[2] == 45) {
                        while ((imageInputStream.readByte() & 0xFF) != 45 || imageInputStream.read() != 45 || imageInputStream.read() != 62) {
                        }
                    } else if (byArray[1] == 68 && byArray[2] == 79 && byArray[3] == 67 && imageInputStream.read() == 84 && imageInputStream.read() == 89 && imageInputStream.read() == 80 && imageInputStream.read() == 69) {
                        while (Character.isWhitespace((char)(n = imageInputStream.read()))) {
                        }
                        if (n == 115 && imageInputStream.read() == 118 && imageInputStream.read() == 103) {
                            boolean bl = true;
                            return bl;
                        }
                        boolean bl = false;
                        return bl;
                    }
                }
                while (true) {
                    if ((imageInputStream.readByte() & 0xFF) == 60) continue block12;
                }
                break;
            }
        }
        catch (EOFException eOFException) {
            boolean bl = false;
            return bl;
        }
        finally {
            imageInputStream.reset();
        }
        for (n3 = 0; n3 < byArray.length && (n2 = byArray[n3]) != 62 && !Character.isWhitespace((char)n2) && n2 != 47; ++n3) {
            byteArrayOutputStream2.write(n2);
        }
        n2 = n3 == byArray.length ? 1 : 0;
        SVGImageReaderSpi.readBuffer(imageInputStream, byteArrayOutputStream2, arg_0 -> SVGImageReaderSpi.lambda$canDecode$0(n2 != 0, arg_0), by -> by == 62 || Character.isWhitespace(by.byteValue()) || by == 47);
        String string = byteArrayOutputStream2.toString("US-ASCII");
        if (!string.toLowerCase(Locale.ENGLISH).endsWith(":svg")) return false;
        ByteArrayOutputStream byteArrayOutputStream3 = new ByteArrayOutputStream();
        SVGImageReaderSpi.readBuffer(imageInputStream, byteArrayOutputStream3, byteArrayOutputStream -> byteArrayOutputStream.size() < 1024, by -> by == 62);
        if (!byteArrayOutputStream3.toString("US-ASCII").matches(".*xmlns:" + string.split(":")[0] + "\\s*=\\s*\"http://www.w3.org/2000/svg\".*")) return false;
        return true;
    }

    private static void readBuffer(ImageInputStream imageInputStream, ByteArrayOutputStream byteArrayOutputStream, Predicate<ByteArrayOutputStream> predicate, Predicate<Byte> predicate2) throws IOException {
        byte by;
        while (predicate.test(byteArrayOutputStream) && !predicate2.test(by = imageInputStream.readByte())) {
            byteArrayOutputStream.write(by);
        }
    }

    public ImageReader createReaderInstance(Object object) throws IOException {
        return new SVGImageReader((ImageReaderSpi)((Object)this));
    }

    public String getDescription(Locale locale) {
        return "Scalable Vector Graphics (SVG) format image reader";
    }

    public void onRegistration(ServiceRegistry serviceRegistry, Class<?> clazz) {
        if (!SVG_READER_AVAILABLE) {
            System.err.println("Could not instantiate SVGImageReader (missing support classes).");
            try {
                new SVGImageReader((ImageReaderSpi)((Object)this));
            }
            catch (Throwable throwable) {
                throwable.printStackTrace();
            }
            IIOUtil.deregisterProvider((ServiceRegistry)serviceRegistry, (IIOServiceProvider)((Object)this), clazz);
        }
    }

    private static /* synthetic */ boolean lambda$canDecode$0(boolean bl, ByteArrayOutputStream byteArrayOutputStream) {
        return bl && byteArrayOutputStream.size() < 256;
    }
}

