/*
 * Decompiled with CFR 0.152.
 */
package com.twelvemonkeys.util.regex;

import com.twelvemonkeys.util.TokenIterator;
import com.twelvemonkeys.util.TokenIteratorAbstractTest;
import com.twelvemonkeys.util.regex.RegExTokenIterator;
import org.junit.Assert;
import org.junit.Test;

public class RegExTokenIteratorTest
extends TokenIteratorAbstractTest {
    @Override
    protected TokenIterator createTokenIterator(String string) {
        return new RegExTokenIterator(string);
    }

    @Override
    protected TokenIterator createTokenIterator(String string, String string2) {
        return new RegExTokenIterator(string, string2);
    }

    @Test
    public void testEmptyDelimiter() {
    }

    @Test
    public void testSingleToken() {
        TokenIterator tokenIterator = this.createTokenIterator("A");
        Assert.assertTrue((String)"String has no elements", (boolean)tokenIterator.hasNext());
        Assert.assertEquals((Object)"A", tokenIterator.next());
        Assert.assertFalse((String)"String has more than one element", (boolean)tokenIterator.hasNext());
    }

    @Test
    public void testSingleTokenEmptyDelimiter() {
    }

    @Test
    public void testSingleTokenSingleDelimiter() {
        TokenIterator tokenIterator = this.createTokenIterator("A", "[^,]+");
        Assert.assertTrue((String)"String has no elements", (boolean)tokenIterator.hasNext());
        Assert.assertEquals((Object)"A", tokenIterator.next());
        Assert.assertFalse((String)"String has more than one element", (boolean)tokenIterator.hasNext());
    }

    @Test
    public void testSingleSeparatorDefaultDelimiter() {
        TokenIterator tokenIterator = this.createTokenIterator("A B C D");
        Assert.assertTrue((String)"String has no elements", (boolean)tokenIterator.hasNext());
        Assert.assertEquals((Object)"A", tokenIterator.next());
        Assert.assertTrue((String)"String has no elements", (boolean)tokenIterator.hasNext());
        Assert.assertEquals((Object)"B", tokenIterator.next());
        Assert.assertTrue((String)"String has no elements", (boolean)tokenIterator.hasNext());
        Assert.assertEquals((Object)"C", tokenIterator.next());
        Assert.assertTrue((String)"String has no elements", (boolean)tokenIterator.hasNext());
        Assert.assertEquals((Object)"D", tokenIterator.next());
        Assert.assertFalse((String)"String has more than one element", (boolean)tokenIterator.hasNext());
    }

    @Test
    public void testSingleSeparator() {
        TokenIterator tokenIterator = this.createTokenIterator("A,B,C", "[^,]+");
        Assert.assertTrue((String)"String has no elements", (boolean)tokenIterator.hasNext());
        Assert.assertEquals((Object)"A", tokenIterator.next());
        Assert.assertTrue((String)"String has no elements", (boolean)tokenIterator.hasNext());
        Assert.assertEquals((Object)"B", tokenIterator.next());
        Assert.assertTrue((String)"String has no elements", (boolean)tokenIterator.hasNext());
        Assert.assertEquals((Object)"C", tokenIterator.next());
        Assert.assertFalse((String)"String has more than one element", (boolean)tokenIterator.hasNext());
    }

    @Test
    public void testMultipleSeparatorDefaultDelimiter() {
        TokenIterator tokenIterator = this.createTokenIterator("A B   C\nD\t\t \nE");
        Assert.assertTrue((String)"String has no elements", (boolean)tokenIterator.hasNext());
        Assert.assertEquals((Object)"A", tokenIterator.next());
        Assert.assertTrue((String)"String has no elements", (boolean)tokenIterator.hasNext());
        Assert.assertEquals((Object)"B", tokenIterator.next());
        Assert.assertTrue((String)"String has no elements", (boolean)tokenIterator.hasNext());
        Assert.assertEquals((Object)"C", tokenIterator.next());
        Assert.assertTrue((String)"String has no elements", (boolean)tokenIterator.hasNext());
        Assert.assertEquals((Object)"D", tokenIterator.next());
        Assert.assertTrue((String)"String has no elements", (boolean)tokenIterator.hasNext());
        Assert.assertEquals((Object)"E", tokenIterator.next());
        Assert.assertFalse((String)"String has more than one element", (boolean)tokenIterator.hasNext());
    }

    @Test
    public void testMultipleSeparator() {
        TokenIterator tokenIterator = this.createTokenIterator("A,B,;,C...D, ., ,E", "[^ ,.;:]+");
        Assert.assertTrue((String)"String has no elements", (boolean)tokenIterator.hasNext());
        Object e = tokenIterator.next();
        Assert.assertEquals((Object)"A", e);
        Assert.assertTrue((String)"String has no elements", (boolean)tokenIterator.hasNext());
        Assert.assertEquals((Object)"B", tokenIterator.next());
        Assert.assertTrue((String)"String has no elements", (boolean)tokenIterator.hasNext());
        Assert.assertEquals((Object)"C", tokenIterator.next());
        Assert.assertTrue((String)"String has no elements", (boolean)tokenIterator.hasNext());
        Assert.assertEquals((Object)"D", tokenIterator.next());
        Assert.assertTrue((String)"String has no elements", (boolean)tokenIterator.hasNext());
        Assert.assertEquals((Object)"E", tokenIterator.next());
        Assert.assertFalse((String)"String has more than one element", (boolean)tokenIterator.hasNext());
    }
}

