/*
 * Decompiled with CFR 0.152.
 */
package com.twelvemonkeys.util.convert;

import com.twelvemonkeys.lang.Validate;
import com.twelvemonkeys.util.convert.DefaultConverter;
import com.twelvemonkeys.util.convert.PropertyConverter;
import com.twelvemonkeys.util.convert.PropertyConverterAbstractTest;
import java.io.File;
import java.net.URI;
import org.junit.Assert;
import org.junit.Ignore;
import org.junit.Test;

public class DefaultConverterTest
extends PropertyConverterAbstractTest {
    @Override
    protected PropertyConverter makePropertyConverter() {
        return new DefaultConverter();
    }

    @Override
    protected PropertyConverterAbstractTest.Conversion[] getTestConversions() {
        return new PropertyConverterAbstractTest.Conversion[]{new PropertyConverterAbstractTest.Conversion("true", Boolean.TRUE), new PropertyConverterAbstractTest.Conversion("TRUE", Boolean.TRUE, null, "true"), new PropertyConverterAbstractTest.Conversion("false", Boolean.FALSE), new PropertyConverterAbstractTest.Conversion("FALSE", false, null, "false"), new PropertyConverterAbstractTest.Conversion("2", 2), new PropertyConverterAbstractTest.Conversion("fooBar", "fooBar"), new PropertyConverterAbstractTest.Conversion("fooBar", new FooBar("fooBar")), new PropertyConverterAbstractTest.Conversion("foo, bar, baz", new String[]{"foo", "bar", "baz"}), new PropertyConverterAbstractTest.Conversion("foo", new String[]{"foo"}), new PropertyConverterAbstractTest.Conversion("foo;bar; baz", new String[]{"foo", "bar", "baz"}, "; ", "foo; bar; baz"), new PropertyConverterAbstractTest.Conversion("1, 2, 3", new int[]{1, 2, 3}), new PropertyConverterAbstractTest.Conversion("-1, 42, 0", new long[]{-1L, 42L, 0L}), new PropertyConverterAbstractTest.Conversion("true, true, false", new boolean[]{true, true, false}), new PropertyConverterAbstractTest.Conversion(".3, 4E7, .97", new float[]{0.3f, 4.0E7f, 0.97f}, ", ", "0.3, 4.0E7, 0.97"), new PropertyConverterAbstractTest.Conversion("foo, bar", new FooBar[]{new FooBar("foo"), new FooBar("bar")}), new PropertyConverterAbstractTest.Conversion("/temp, /usr/local/bin".replace('/', File.separatorChar), new File[]{new File("/temp"), new File("/usr/local/bin")}), new PropertyConverterAbstractTest.Conversion("file:/temp, http://java.net/", new URI[]{URI.create("file:/temp"), URI.create("http://java.net/")})};
    }

    @Test
    public void testConvertBooleanPrimitive() {
        PropertyConverter propertyConverter = this.makePropertyConverter();
        Assert.assertTrue((boolean)((Boolean)propertyConverter.toObject("true", Boolean.TYPE, null)));
        Assert.assertFalse((boolean)((Boolean)propertyConverter.toObject("FalsE", Boolean.TYPE, null)));
    }

    @Test
    public void testConvertShortPrimitive() {
        PropertyConverter propertyConverter = this.makePropertyConverter();
        Assert.assertEquals((long)1L, (long)((Short)propertyConverter.toObject("1", Short.TYPE, null)).shortValue());
        Assert.assertEquals((long)-2L, (long)((Short)propertyConverter.toObject("-2", Short.TYPE, null)).shortValue());
    }

    @Test
    public void testConvertIntPrimitive() {
        PropertyConverter propertyConverter = this.makePropertyConverter();
        Assert.assertEquals((long)1L, (long)((Integer)propertyConverter.toObject("1", Integer.TYPE, null)).intValue());
        Assert.assertEquals((long)-2L, (long)((Integer)propertyConverter.toObject("-2", Integer.TYPE, null)).intValue());
    }

    @Test
    public void testConvertLongPrimitive() {
        PropertyConverter propertyConverter = this.makePropertyConverter();
        Assert.assertEquals((long)Long.MAX_VALUE, (long)((Long)propertyConverter.toObject("9223372036854775807", Long.TYPE, null)));
        Assert.assertEquals((long)-2L, (long)((Long)propertyConverter.toObject("-2", Long.TYPE, null)));
    }

    @Test
    public void testConvertBytePrimitive() {
        PropertyConverter propertyConverter = this.makePropertyConverter();
        Assert.assertEquals((long)1L, (long)((Byte)propertyConverter.toObject("1", Byte.TYPE, null)).byteValue());
        Assert.assertEquals((long)-2L, (long)((Byte)propertyConverter.toObject("-2", Byte.TYPE, null)).byteValue());
    }

    @Test
    public void testConvertFloatPrimitive() {
        PropertyConverter propertyConverter = this.makePropertyConverter();
        Assert.assertEquals((float)1.0f, (float)((Float)propertyConverter.toObject("1.0", Float.TYPE, null)).floatValue(), (float)0.0f);
        Assert.assertEquals((float)-2.3456f, (float)((Float)propertyConverter.toObject("-2.3456", Float.TYPE, null)).floatValue(), (float)0.0f);
    }

    @Test
    public void testConvertDoublePrimitive() {
        PropertyConverter propertyConverter = this.makePropertyConverter();
        Assert.assertEquals((double)1.0, (double)((Double)propertyConverter.toObject("1.0", Double.TYPE, null)), (double)0.0);
        Assert.assertEquals((double)-2.3456, (double)((Double)propertyConverter.toObject("-2.3456", Double.TYPE, null)), (double)0.0);
    }

    @Ignore(value="Known issue. Why would anyone do something like this?")
    @Test
    public void testConvertCharPrimitive() {
        PropertyConverter propertyConverter = this.makePropertyConverter();
        Assert.assertEquals((long)65L, (long)((Character)propertyConverter.toObject("A", Character.TYPE, null)).charValue());
        Assert.assertEquals((long)90L, (long)((Character)propertyConverter.toObject("Z", Character.TYPE, null)).charValue());
    }

    public static class FooBar {
        private final String bar;

        public FooBar(String string) {
            Validate.notNull((Object)string, (String)"foo");
            this.bar = this.reverse(string);
        }

        private String reverse(String string) {
            StringBuilder stringBuilder = new StringBuilder(string.length());
            for (int i = string.length() - 1; i >= 0; --i) {
                stringBuilder.append(string.charAt(i));
            }
            return stringBuilder.toString();
        }

        public String toString() {
            return this.reverse(this.bar);
        }

        public boolean equals(Object object) {
            return object == this || object != null && object.getClass() == this.getClass() && ((FooBar)object).bar.equals(this.bar);
        }

        public int hashCode() {
            return 7 * this.bar.hashCode();
        }
    }
}

