/*
 * Decompiled with CFR 0.152.
 */
package com.twelvemonkeys.util.convert;

import com.twelvemonkeys.lang.ObjectAbstractTest;
import com.twelvemonkeys.lang.Validate;
import com.twelvemonkeys.util.convert.ConversionException;
import com.twelvemonkeys.util.convert.PropertyConverter;
import java.util.Arrays;
import org.junit.Assert;
import org.junit.Test;

public abstract class PropertyConverterAbstractTest
extends ObjectAbstractTest {
    @Override
    protected Object makeObject() {
        return this.makePropertyConverter();
    }

    protected abstract PropertyConverter makePropertyConverter();

    protected abstract Conversion[] getTestConversions();

    @Test
    public void testConvert() {
        Conversion[] conversionArray;
        PropertyConverter propertyConverter = this.makePropertyConverter();
        for (Conversion conversion : conversionArray = this.getTestConversions()) {
            try {
                Object object = propertyConverter.toObject(conversion.original(), conversion.type(), conversion.format());
                Assert.assertEquals((String)String.format("'%s' converted to incorrect type", conversion.original()), (Object)conversion.type(), object.getClass());
                if (conversion.type().isArray()) {
                    PropertyConverterAbstractTest.assertArrayEquals0(String.format("'%s' not converted", conversion.original()), conversion.value(), object);
                } else {
                    Assert.assertEquals((String)String.format("'%s' not converted", conversion.original()), (Object)conversion.value(), (Object)object);
                }
                String string = propertyConverter.toString(conversion.value(), conversion.format());
                Assert.assertEquals((String)String.format("'%s' does not match", conversion.converted()), (Object)conversion.converted(), (Object)string);
                object = propertyConverter.toObject(string, conversion.type(), conversion.format());
                Assert.assertEquals((String)String.format("'%s' converted to incorrect type", conversion.original()), (Object)conversion.type(), object.getClass());
                if (conversion.type().isArray()) {
                    PropertyConverterAbstractTest.assertArrayEquals0(String.format("'%s' did not survive round trip conversion", conversion.original()), conversion.value(), object);
                    continue;
                }
                Assert.assertEquals((String)String.format("'%s' did not survive round trip conversion", conversion.original()), (Object)conversion.value(), (Object)object);
            }
            catch (ConversionException conversionException) {
                PropertyConverterAbstractTest.failBecause(String.format("Converting '%s' to %s failed", conversion.original(), conversion.type()), conversionException);
            }
        }
    }

    private static void assertArrayEquals0(String string, Object object, Object object2) {
        Class<?> clazz = object.getClass().getComponentType();
        if (clazz.isPrimitive()) {
            if (Integer.TYPE == clazz) {
                Assert.assertArrayEquals((String)string, (int[])((int[])object), (int[])((int[])object2));
            } else if (Short.TYPE == clazz) {
                Assert.assertArrayEquals((String)string, (short[])((short[])object), (short[])((short[])object2));
            } else if (Long.TYPE == clazz) {
                Assert.assertArrayEquals((String)string, (long[])((long[])object), (long[])((long[])object2));
            } else if (Float.TYPE == clazz) {
                Assert.assertArrayEquals((String)string, (float[])((float[])object), (float[])((float[])object2), (float)0.0f);
            } else if (Double.TYPE == clazz) {
                Assert.assertArrayEquals((String)string, (double[])((double[])object), (double[])((double[])object2), (double)0.0);
            } else if (Boolean.TYPE == clazz) {
                Assert.assertTrue((String)string, (boolean)Arrays.equals((boolean[])object, (boolean[])object2));
            } else if (Byte.TYPE == clazz) {
                Assert.assertArrayEquals((String)string, (byte[])((byte[])object), (byte[])((byte[])object2));
            } else if (Character.TYPE == clazz) {
                Assert.assertArrayEquals((String)string, (char[])((char[])object), (char[])((char[])object2));
            } else {
                Assert.fail((String)String.format("Unknown primitive type: %s", clazz));
            }
        } else {
            Assert.assertArrayEquals((String)string, (Object[])((Object[])object), (Object[])((Object[])object2));
        }
    }

    private static void failBecause(String string, Throwable throwable) {
        AssertionError assertionError = new AssertionError((Object)string);
        ((Throwable)((Object)assertionError)).initCause(throwable);
        throw assertionError;
    }

    public static final class Conversion {
        private final String strVal;
        private final Object objVal;
        private final String format;
        private final String convertedStrVal;

        public Conversion(String string, Object object) {
            this(string, object, null);
        }

        public Conversion(String string, Object object, String string2) {
            this(string, object, string2, string);
        }

        public Conversion(String string, Object object, String string2, String string3) {
            Validate.notNull((Object)string, (String)"strVal");
            Validate.notNull((Object)object, (String)"objVal");
            Validate.notNull((Object)string3, (String)"convertedStrVal");
            this.strVal = string;
            this.objVal = object;
            this.format = string2;
            this.convertedStrVal = string3;
        }

        public String original() {
            return this.strVal;
        }

        public Object value() {
            return this.objVal;
        }

        public Class type() {
            return this.objVal.getClass();
        }

        public String format() {
            return this.format;
        }

        public String converted() {
            return this.convertedStrVal;
        }
    }
}

