/*
 * Decompiled with CFR 0.152.
 */
package com.twelvemonkeys.util;

import com.twelvemonkeys.util.LRUMap;
import com.twelvemonkeys.util.MapAbstractTest;
import com.twelvemonkeys.util.TimeoutMap;
import java.util.Collection;
import java.util.Iterator;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.TreeMap;
import org.junit.Assert;
import org.junit.Test;

public class TimeoutMapTest
extends MapAbstractTest {
    @Override
    public Map makeEmptyMap() {
        return new TimeoutMap(3600000L);
    }

    @Test
    public void testBasicMap() {
        TimeoutMap timeoutMap = new TimeoutMap(60000L);
        String string = "key";
        Integer n = new Integer(3);
        timeoutMap.put(string, n);
        Assert.assertEquals((Object)n, timeoutMap.get(string));
    }

    @Test
    public void testBasicMapReturnsNullForMissingKey() {
        TimeoutMap timeoutMap = new TimeoutMap(60000L);
        Assert.assertNull(timeoutMap.get("key"));
    }

    @Test
    public void testBasicMapAllowsNull() {
        TimeoutMap timeoutMap = new TimeoutMap(60000L);
        String string = "key";
        Object v = null;
        timeoutMap.put(string, v);
        Assert.assertNull(timeoutMap.get(string));
    }

    @Test
    public void testBasicMapAllowsMultipleTypes() {
        TimeoutMap timeoutMap = new TimeoutMap(60000L);
        timeoutMap.put("key-1", "value-1");
        timeoutMap.put(new Integer(2), "value-2");
        timeoutMap.put("key-3", new Integer(3));
        timeoutMap.put(new Integer(4), new Integer(4));
        timeoutMap.put(Boolean.FALSE, "");
        Assert.assertEquals((Object)"value-1", timeoutMap.get("key-1"));
        Assert.assertEquals((Object)"value-2", timeoutMap.get(new Integer(2)));
        Assert.assertEquals((Object)new Integer(3), timeoutMap.get("key-3"));
        Assert.assertEquals((Object)new Integer(4), timeoutMap.get(new Integer(4)));
        Assert.assertEquals((Object)"", timeoutMap.get(Boolean.FALSE));
    }

    @Test
    public void testBasicMapStoresOnlyOneValuePerKey() {
        TimeoutMap timeoutMap = new TimeoutMap(60000L);
        Assert.assertNull((Object)timeoutMap.put("key", "value-1"));
        Assert.assertEquals((Object)"value-1", timeoutMap.get("key"));
        Assert.assertEquals((Object)"value-1", (Object)timeoutMap.put("key", "value-2"));
        Assert.assertEquals((Object)"value-2", timeoutMap.get("key"));
    }

    @Test
    public void testBasicMapValuesView() {
        TimeoutMap timeoutMap = new TimeoutMap(60000L);
        Assert.assertNull((Object)timeoutMap.put("key-1", new Integer(1)));
        Assert.assertNull((Object)timeoutMap.put("key-2", new Integer(2)));
        Assert.assertNull((Object)timeoutMap.put("key-3", new Integer(3)));
        Assert.assertNull((Object)timeoutMap.put("key-4", new Integer(4)));
        Assert.assertEquals((long)4L, (long)timeoutMap.size());
        Collection collection = timeoutMap.values();
        Assert.assertEquals((long)4L, (long)collection.size());
        Iterator iterator = collection.iterator();
        Assert.assertNotNull(iterator);
        int n = 0;
        while (iterator.hasNext()) {
            Object v = iterator.next();
            Assert.assertNotNull(v);
            Assert.assertTrue((boolean)(v instanceof Integer));
            ++n;
        }
        Assert.assertEquals((long)4L, (long)n);
    }

    @Test
    public void testBasicMapKeySetView() {
        TimeoutMap timeoutMap = new TimeoutMap(60000L);
        Assert.assertNull((Object)timeoutMap.put("key-1", "value-1"));
        Assert.assertNull((Object)timeoutMap.put("key-2", "value-2"));
        Assert.assertNull((Object)timeoutMap.put("key-3", "value-3"));
        Assert.assertNull((Object)timeoutMap.put("key-4", "value-4"));
        Assert.assertEquals((long)4L, (long)timeoutMap.size());
        Iterator iterator = timeoutMap.keySet().iterator();
        Assert.assertNotNull(iterator);
        int n = 0;
        while (iterator.hasNext()) {
            Object k = iterator.next();
            Assert.assertNotNull(k);
            Assert.assertTrue((boolean)(k instanceof String));
            ++n;
        }
        Assert.assertEquals((long)4L, (long)n);
    }

    @Test
    public void testBasicMapEntrySetView() {
        TimeoutMap timeoutMap = new TimeoutMap(60000L);
        Assert.assertNull((Object)timeoutMap.put("key-1", new Integer(1)));
        Assert.assertNull((Object)timeoutMap.put("key-2", "value-2"));
        Assert.assertNull((Object)timeoutMap.put("key-3", new Object()));
        Assert.assertNull((Object)timeoutMap.put("key-4", Boolean.FALSE));
        Assert.assertEquals((long)4L, (long)timeoutMap.size());
        Iterator iterator = timeoutMap.entrySet().iterator();
        Assert.assertNotNull(iterator);
        int n = 0;
        while (iterator.hasNext()) {
            Map.Entry entry = iterator.next();
            Assert.assertNotNull(entry);
            Assert.assertTrue((boolean)(entry instanceof Map.Entry));
            ++n;
        }
        Assert.assertEquals((long)4L, (long)n);
    }

    @Test
    public void testBasicMapValuesViewRemoval() {
        TimeoutMap timeoutMap = new TimeoutMap(60000L);
        Assert.assertNull((Object)timeoutMap.put("key-1", new Integer(1)));
        Assert.assertNull((Object)timeoutMap.put("key-2", new Integer(2)));
        Assert.assertNull((Object)timeoutMap.put("key-3", new Integer(3)));
        Assert.assertNull((Object)timeoutMap.put("key-4", new Integer(4)));
        Assert.assertEquals((long)4L, (long)timeoutMap.size());
        Iterator iterator = timeoutMap.values().iterator();
        Assert.assertNotNull(iterator);
        int n = 0;
        while (iterator.hasNext()) {
            Object v = iterator.next();
            Assert.assertNotNull(v);
            Assert.assertTrue((boolean)(v instanceof Integer));
            try {
                iterator.remove();
            }
            catch (UnsupportedOperationException unsupportedOperationException) {
                Assert.fail((String)"Removal failed");
            }
            ++n;
        }
        Assert.assertEquals((long)4L, (long)n);
    }

    @Test
    public void testBasicMapKeySetViewRemoval() {
        TimeoutMap timeoutMap = new TimeoutMap(60000L);
        Assert.assertNull((Object)timeoutMap.put("key-1", "value-1"));
        Assert.assertNull((Object)timeoutMap.put("key-2", "value-2"));
        Assert.assertNull((Object)timeoutMap.put("key-3", "value-3"));
        Assert.assertNull((Object)timeoutMap.put("key-4", "value-4"));
        Assert.assertEquals((long)4L, (long)timeoutMap.size());
        Iterator iterator = timeoutMap.keySet().iterator();
        Assert.assertNotNull(iterator);
        int n = 0;
        while (iterator.hasNext()) {
            Object k = iterator.next();
            Assert.assertNotNull(k);
            Assert.assertTrue((boolean)(k instanceof String));
            try {
                iterator.remove();
            }
            catch (UnsupportedOperationException unsupportedOperationException) {
                Assert.fail((String)"Removal failed");
            }
            ++n;
        }
        Assert.assertEquals((long)4L, (long)n);
    }

    @Test
    public void testBasicMapEntrySetViewRemoval() {
        TimeoutMap timeoutMap = new TimeoutMap(60000L);
        Assert.assertNull((Object)timeoutMap.put("key-1", new Integer(1)));
        Assert.assertNull((Object)timeoutMap.put("key-2", "value-2"));
        Assert.assertNull((Object)timeoutMap.put("key-3", new Object()));
        Assert.assertNull((Object)timeoutMap.put("key-4", Boolean.FALSE));
        Assert.assertEquals((long)4L, (long)timeoutMap.size());
        Iterator iterator = timeoutMap.entrySet().iterator();
        Assert.assertNotNull(iterator);
        int n = 0;
        while (iterator.hasNext()) {
            Map.Entry entry = iterator.next();
            Assert.assertNotNull(entry);
            Assert.assertTrue((boolean)(entry instanceof Map.Entry));
            try {
                iterator.remove();
            }
            catch (UnsupportedOperationException unsupportedOperationException) {
                Assert.fail((String)"Removal failed");
            }
            ++n;
        }
        Assert.assertEquals((long)4L, (long)n);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testTimeoutReturnNull() {
        TimeoutMap timeoutMap = new TimeoutMap(100L);
        Assert.assertNull((Object)timeoutMap.put("key", "value-1"));
        Assert.assertEquals((Object)"value-1", timeoutMap.get("key"));
        Assert.assertNull((Object)timeoutMap.put("another", "value-2"));
        Assert.assertEquals((Object)"value-2", timeoutMap.get("another"));
        TimeoutMapTest timeoutMapTest = this;
        synchronized (timeoutMapTest) {
            try {
                Thread.sleep(110L);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        }
        Assert.assertNull(timeoutMap.get("key"));
        Assert.assertNull(timeoutMap.get("another"));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testTimeoutIsEmpty() {
        TimeoutMap timeoutMap = new TimeoutMap(50L);
        Assert.assertNull((Object)timeoutMap.put((Object)"key", (Object)"value-1"));
        Assert.assertEquals((Object)"value-1", (Object)timeoutMap.get((Object)"key"));
        Assert.assertNull((Object)timeoutMap.put((Object)"another", (Object)"value-2"));
        Assert.assertEquals((Object)"value-2", (Object)timeoutMap.get((Object)"another"));
        Object object = this;
        synchronized (object) {
            try {
                Thread.sleep(100L);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        }
        object = timeoutMap.keySet();
        Assert.assertEquals((long)0L, (long)object.size());
        Iterator iterator = object.iterator();
        while (iterator.hasNext()) {
            System.out.println(iterator.next());
        }
        Assert.assertEquals((long)0L, (long)timeoutMap.size());
        Assert.assertTrue((boolean)timeoutMap.isEmpty());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testTimeoutWrapIsEmpty() {
        TimeoutMap timeoutMap = new TimeoutMap((Map)new LRUMap(2), null, 100L);
        Assert.assertNull((Object)timeoutMap.put("key", "value-1"));
        Assert.assertEquals((Object)"value-1", timeoutMap.get("key"));
        Assert.assertNull((Object)timeoutMap.put("another", "value-2"));
        Assert.assertEquals((Object)"value-2", timeoutMap.get("another"));
        Assert.assertNull((Object)timeoutMap.put("third", "value-3"));
        Assert.assertEquals((Object)"value-3", timeoutMap.get("third"));
        Object object = this;
        synchronized (object) {
            try {
                Thread.sleep(110L);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        }
        object = timeoutMap.keySet();
        Assert.assertEquals((long)0L, (long)object.size());
        Iterator iterator = object.iterator();
        while (iterator.hasNext()) {
            System.out.println(iterator.next());
        }
        Assert.assertEquals((long)0L, (long)timeoutMap.size());
        Assert.assertTrue((boolean)timeoutMap.isEmpty());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testTimeoutWrapReturnNull() {
        TimeoutMap timeoutMap = new TimeoutMap((Map)new LRUMap(), null, 100L);
        Assert.assertNull((Object)timeoutMap.put("key", "value-1"));
        Assert.assertEquals((Object)"value-1", timeoutMap.get("key"));
        Assert.assertNull((Object)timeoutMap.put("another", "value-2"));
        Assert.assertEquals((Object)"value-2", timeoutMap.get("another"));
        TimeoutMapTest timeoutMapTest = this;
        synchronized (timeoutMapTest) {
            try {
                Thread.sleep(110L);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        }
        Assert.assertNull(timeoutMap.get("key"));
        Assert.assertNull(timeoutMap.get("another"));
    }

    @Test
    public void testWrapMaxSize() {
        LRUMap lRUMap = new LRUMap();
        lRUMap.setMaxSize(2);
        TimeoutMap timeoutMap = new TimeoutMap((Map)lRUMap, null, 1000L);
        Assert.assertNull((Object)timeoutMap.put((Object)"key", (Object)"value-1"));
        Assert.assertEquals((Object)"value-1", (Object)timeoutMap.get((Object)"key"));
        Assert.assertNull((Object)timeoutMap.put((Object)"another", (Object)"value-2"));
        Assert.assertEquals((Object)"value-2", (Object)timeoutMap.get((Object)"another"));
        Assert.assertNull((Object)timeoutMap.put((Object)"third", (Object)"value-3"));
        Assert.assertEquals((Object)"value-3", (Object)timeoutMap.get((Object)"third"));
        Assert.assertNull((Object)timeoutMap.get((Object)"key"));
        Assert.assertEquals((Object)"value-2", (Object)timeoutMap.get((Object)"another"));
        Assert.assertEquals((Object)"value-3", (Object)timeoutMap.get((Object)"third"));
    }

    @Test
    public void testWrapMapContainingValues() {
        TreeMap<String, String> treeMap = new TreeMap<String, String>();
        treeMap.put("key", "original");
        TimeoutMap timeoutMap = null;
        try {
            timeoutMap = new TimeoutMap(treeMap, treeMap, 1000L);
            Object object = timeoutMap.put((Object)"key", (Object)"value-1");
            Assert.assertNotNull((Object)object);
            Assert.assertEquals((Object)"original", (Object)object);
        }
        catch (ClassCastException classCastException) {
            classCastException.printStackTrace();
            Assert.fail((String)"Content not converted to TimedEntries properly!");
        }
        Assert.assertEquals((Object)"value-1", (Object)timeoutMap.get((Object)"key"));
        Assert.assertNull((Object)timeoutMap.put((Object)"another", (Object)"value-2"));
        Assert.assertEquals((Object)"value-2", (Object)timeoutMap.get((Object)"another"));
        Assert.assertNull((Object)timeoutMap.put((Object)"third", (Object)"value-3"));
        Assert.assertEquals((Object)"value-3", (Object)timeoutMap.get((Object)"third"));
    }

    @Test
    public void testIteratorRemove() {
        Map map = this.makeFullMap();
        Iterator iterator = map.entrySet().iterator();
        while (iterator.hasNext()) {
            iterator.remove();
        }
        Assert.assertEquals((long)0L, (long)map.size());
        map = this.makeFullMap();
        iterator = map.entrySet().iterator();
        while (iterator.hasNext()) {
            iterator.next();
            iterator.remove();
        }
        Assert.assertEquals((long)0L, (long)map.size());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testIteratorPredictableNext() {
        TimeoutMap timeoutMap = (TimeoutMap)this.makeFullMap();
        timeoutMap.setExpiryTime(50L);
        Assert.assertFalse((boolean)timeoutMap.isEmpty());
        int n = 0;
        Iterator iterator = timeoutMap.entrySet().iterator();
        while (iterator.hasNext()) {
            Object object;
            if (n == 0) {
                object = this;
                synchronized (object) {
                    try {
                        this.wait(60L);
                    }
                    catch (InterruptedException interruptedException) {
                        // empty catch block
                    }
                }
            }
            try {
                object = (Map.Entry)iterator.next();
                Assert.assertNotNull((Object)object);
                ++n;
            }
            catch (NoSuchElementException noSuchElementException) {
                Assert.fail((String)"Elements expire between Interator.hasNext() and Iterator.next()");
            }
        }
        Assert.assertTrue((String)"Elements expired too early, test did not run as expected.", (n > 0 ? 1 : 0) != 0);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testIteratorPredictableRemove() {
        TimeoutMap timeoutMap = (TimeoutMap)this.makeFullMap();
        timeoutMap.setExpiryTime(50L);
        Assert.assertFalse((boolean)timeoutMap.isEmpty());
        int n = 0;
        Iterator iterator = timeoutMap.entrySet().iterator();
        while (iterator.hasNext()) {
            if (n == 0) {
                TimeoutMapTest timeoutMapTest = this;
                synchronized (timeoutMapTest) {
                    try {
                        this.wait(60L);
                    }
                    catch (InterruptedException interruptedException) {
                        // empty catch block
                    }
                }
            }
            try {
                iterator.remove();
                ++n;
            }
            catch (NoSuchElementException noSuchElementException) {
                Assert.fail((String)"Elements expired between Interator.hasNext() and Iterator.remove()");
            }
        }
        Assert.assertTrue((String)"Elements expired too early, test did not run as expected.", (n > 0 ? 1 : 0) != 0);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testIteratorPredictableNextRemove() {
        TimeoutMap timeoutMap = (TimeoutMap)this.makeFullMap();
        timeoutMap.setExpiryTime(50L);
        Assert.assertFalse((boolean)timeoutMap.isEmpty());
        int n = 0;
        Iterator iterator = timeoutMap.entrySet().iterator();
        while (iterator.hasNext()) {
            Object object;
            if (n == 0) {
                object = this;
                synchronized (object) {
                    try {
                        this.wait(60L);
                    }
                    catch (InterruptedException interruptedException) {
                        // empty catch block
                    }
                }
            }
            try {
                object = (Map.Entry)iterator.next();
                Assert.assertNotNull((Object)object);
            }
            catch (NoSuchElementException noSuchElementException) {
                Assert.fail((String)"Elements expired between Interator.hasNext() and Iterator.next()");
            }
            try {
                iterator.remove();
                ++n;
            }
            catch (NoSuchElementException noSuchElementException) {
                Assert.fail((String)"Elements expired between Interator.hasNext() and Iterator.remove()");
            }
        }
        Assert.assertTrue((String)"Elements expired too early, test did not run as expected.", (n > 0 ? 1 : 0) != 0);
    }

    @Test
    public void testIteratorPredictableRemovedEntry() {
        TimeoutMap timeoutMap = (TimeoutMap)this.makeEmptyMap();
        timeoutMap.setExpiryTime(1000L);
        timeoutMap.put((Object)"key-1", (Object)new Integer(1));
        timeoutMap.put((Object)"key-2", (Object)new Integer(2));
        Assert.assertFalse((boolean)timeoutMap.isEmpty());
        Object var2_2 = null;
        String string = null;
        Iterator iterator = timeoutMap.entrySet().iterator();
        Assert.assertTrue((String)"Iterator was empty", (boolean)iterator.hasNext());
        try {
            Map.Entry entry = (Map.Entry)iterator.next();
            Assert.assertNotNull((Object)entry);
            var2_2 = entry.getKey();
            string = "key-1".equals(var2_2) ? "key-2" : "key-1";
        }
        catch (NoSuchElementException noSuchElementException) {
            Assert.fail((String)"Elements expired between Interator.hasNext() and Iterator.next()");
        }
        try {
            iterator.remove();
        }
        catch (NoSuchElementException noSuchElementException) {
            Assert.fail((String)"Elements expired between Interator.hasNext() and Iterator.remove()");
        }
        Assert.assertTrue((String)"Wrong entry removed, keySet().iterator() is broken.", (!timeoutMap.containsKey(var2_2) ? 1 : 0) != 0);
        Assert.assertTrue((String)"Wrong entry removed, keySet().iterator() is broken.", (boolean)timeoutMap.containsKey((Object)string));
    }
}

