/*
 * Decompiled with CFR 0.152.
 */
package com.twelvemonkeys.util;

import com.twelvemonkeys.util.MapAbstractTest;
import com.twelvemonkeys.util.NullMap;
import java.util.HashMap;
import java.util.Map;
import org.junit.Assert;
import org.junit.Test;

public class NullMapTest
extends MapAbstractTest {
    private boolean empty = true;

    @Override
    public Map makeEmptyMap() {
        return new NullMap();
    }

    @Override
    public Map makeFullMap() {
        return new NullMap();
    }

    @Override
    public Map makeConfirmedMap() {
        return new HashMap();
    }

    @Override
    public void resetEmpty() {
        this.empty = true;
        super.resetEmpty();
    }

    @Override
    public void resetFull() {
        this.empty = false;
        super.resetFull();
    }

    @Override
    public void verifyAll() {
        if (this.empty) {
            super.verifyAll();
        }
    }

    @Override
    @Test
    public void testMapIsEmpty() {
        this.resetEmpty();
        Assert.assertEquals((String)"Map.isEmpty() should return true with an empty map", (Object)true, (Object)this.map.isEmpty());
        this.verifyAll();
        this.resetFull();
        Assert.assertEquals((String)"Map.isEmpty() should return true with a full map", (Object)true, (Object)this.map.isEmpty());
    }

    @Override
    @Test
    public void testMapSize() {
        this.resetEmpty();
        Assert.assertEquals((String)"Map.size() should be 0 with an empty map", (long)0L, (long)this.map.size());
        this.verifyAll();
        this.resetFull();
        Assert.assertEquals((String)"Map.size() should equal the number of entries in the map", (long)0L, (long)this.map.size());
    }

    @Override
    @Test
    public void testMapContainsKey() {
        Object[] objectArray = this.getSampleKeys();
        this.resetEmpty();
        for (Object object : objectArray) {
            Assert.assertTrue((String)"Map must not contain key when map is empty", (!this.map.containsKey(object) ? 1 : 0) != 0);
        }
        this.verifyAll();
    }

    @Override
    @Test
    public void testMapContainsValue() {
        Object[] objectArray = this.getSampleValues();
        this.resetEmpty();
        for (Object object : objectArray) {
            Assert.assertTrue((String)"Empty map must not contain value", (!this.map.containsValue(object) ? 1 : 0) != 0);
        }
        this.verifyAll();
    }

    @Override
    @Test
    public void testMapEquals() {
        this.resetEmpty();
        Assert.assertTrue((String)"Empty maps unequal.", (boolean)this.map.equals(this.confirmed));
        this.verifyAll();
    }

    @Override
    @Test
    public void testMapHashCode() {
        this.resetEmpty();
        Assert.assertTrue((String)"Empty maps have different hashCodes.", (this.map.hashCode() == this.confirmed.hashCode() ? 1 : 0) != 0);
    }

    @Override
    @Test
    public void testMapGet() {
        Object[] objectArray;
        this.resetEmpty();
        for (Object object : objectArray = this.getSampleKeys()) {
            Assert.assertTrue((String)"Empty map.get() should return null.", (this.map.get(object) == null ? 1 : 0) != 0);
        }
        this.verifyAll();
    }

    @Override
    @Test
    public void testMapPut() {
        int n;
        this.resetEmpty();
        Object[] objectArray = this.getSampleKeys();
        Object[] objectArray2 = this.getSampleValues();
        Object[] objectArray3 = this.getNewSampleValues();
        for (n = 0; n < objectArray.length; ++n) {
            Object object = this.map.put(objectArray[n], objectArray2[n]);
            this.verifyAll();
            Assert.assertTrue((String)"First map.put should return null", (object == null ? 1 : 0) != 0);
        }
        for (n = 0; n < objectArray.length; ++n) {
            this.map.put(objectArray[n], objectArray3[n]);
            this.verifyAll();
        }
    }

    @Override
    @Test
    public void testMapToString() {
        this.resetEmpty();
        Assert.assertTrue((String)"Empty map toString() should not return null", (this.map.toString() != null ? 1 : 0) != 0);
        this.verifyAll();
    }

    @Override
    @Test
    public void testMapPutAll() {
    }

    @Override
    @Test
    public void testMapRemove() {
        this.resetEmpty();
        Object[] objectArray = this.getSampleKeys();
        for (int i = 0; i < objectArray.length; ++i) {
            Object v = this.map.remove(objectArray[i]);
            Assert.assertTrue((String)"First map.remove should return null", (v == null ? 1 : 0) != 0);
        }
        this.verifyAll();
    }

    @Override
    @Test
    public void testEntrySetClearChangesMap() {
    }

    @Override
    @Test
    public void testKeySetClearChangesMap() {
    }

    @Override
    @Test
    public void testKeySetRemoveChangesMap() {
    }

    @Override
    @Test
    public void testValuesClearChangesMap() {
    }

    @Override
    @Test
    public void testEntrySetContains1() {
    }

    @Override
    @Test
    public void testEntrySetContains2() {
    }

    @Override
    @Test
    public void testEntrySetContains3() {
    }

    @Override
    @Test
    public void testEntrySetRemove1() {
    }

    @Override
    @Test
    public void testEntrySetRemove2() {
    }

    @Override
    @Test
    public void testEntrySetRemove3() {
    }
}

