/*
 * Decompiled with CFR 0.152.
 */
package com.twelvemonkeys.util;

import com.twelvemonkeys.util.LRUMap;
import com.twelvemonkeys.util.LinkedMapTest;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.junit.Assert;
import org.junit.Test;

public class LRUMapTest
extends LinkedMapTest {
    @Override
    public boolean isGetStructuralModify() {
        return true;
    }

    @Override
    public Map makeEmptyMap() {
        return new LRUMap();
    }

    @Test
    public void testRemoveLRU() {
        LRUMap lRUMap = new LRUMap(3);
        lRUMap.put((Object)1, (Object)"foo");
        lRUMap.put((Object)2, (Object)"foo");
        lRUMap.put((Object)3, (Object)"foo");
        lRUMap.put((Object)4, (Object)"foo");
        lRUMap.removeLRU();
        Assert.assertTrue((String)"Second to last value should exist", (boolean)((String)lRUMap.get((Object)new Integer(3))).equals("foo"));
        Assert.assertTrue((String)"First value inserted should not exist", (lRUMap.get((Object)new Integer(1)) == null ? 1 : 0) != 0);
    }

    @Test
    public void testMultiplePuts() {
        LRUMap lRUMap = new LRUMap(2);
        lRUMap.put((Object)1, (Object)"foo");
        lRUMap.put((Object)2, (Object)"bar");
        lRUMap.put((Object)3, (Object)"foo");
        lRUMap.put((Object)4, (Object)"bar");
        Assert.assertTrue((String)"last value should exist", (boolean)((String)lRUMap.get((Object)new Integer(4))).equals("bar"));
        Assert.assertTrue((String)"LRU should not exist", (lRUMap.get((Object)new Integer(1)) == null ? 1 : 0) != 0);
    }

    @Test
    public void testPutAll() {
        LRUMap lRUMap = new LRUMap(3);
        lRUMap.put((Object)1, (Object)"foo");
        lRUMap.put((Object)2, (Object)"foo");
        lRUMap.put((Object)3, (Object)"foo");
        HashMap<Integer, String> hashMap = new HashMap<Integer, String>();
        hashMap.put(4, "foo");
        lRUMap.putAll(hashMap);
        Assert.assertTrue((String)("max size is 3, but actual size is " + lRUMap.size()), (lRUMap.size() == 3 ? 1 : 0) != 0);
        Assert.assertTrue((String)"map should contain the Integer(4) object", (boolean)lRUMap.containsKey((Object)new Integer(4)));
    }

    @Test
    public void testSetMaximumSize() {
        LRUMap lRUMap = new LRUMap(6);
        lRUMap.put((Object)"1", (Object)"1");
        lRUMap.put((Object)"2", (Object)"2");
        lRUMap.put((Object)"3", (Object)"3");
        lRUMap.put((Object)"4", (Object)"4");
        lRUMap.put((Object)"5", (Object)"5");
        lRUMap.put((Object)"6", (Object)"6");
        lRUMap.setMaxSize(3);
        Assert.assertTrue((String)("map should have size = 3, but actually = " + lRUMap.size()), (lRUMap.size() == 3 ? 1 : 0) != 0);
    }

    @Test
    public void testGetPromotion() {
        LRUMap lRUMap = new LRUMap(3);
        lRUMap.put((Object)"1", (Object)"1");
        lRUMap.put((Object)"2", (Object)"2");
        lRUMap.put((Object)"3", (Object)"3");
        lRUMap.get((Object)"1");
        lRUMap.put((Object)"4", (Object)"4");
        Iterator iterator = lRUMap.keySet().iterator();
        Object[] objectArray = new Object[3];
        int n = 0;
        while (iterator.hasNext()) {
            objectArray[n] = iterator.next();
            ++n;
        }
        Assert.assertTrue((String)("first evicted should be 3, was " + objectArray[0]), (boolean)objectArray[0].equals("3"));
        Assert.assertTrue((String)("second evicted should be 1, was " + objectArray[1]), (boolean)objectArray[1].equals("1"));
        Assert.assertTrue((String)("third evicted should be 4, was " + objectArray[2]), (boolean)objectArray[2].equals("4"));
    }

    @Test
    public void testLRUSubclass() {
        LRUCounter lRUCounter = new LRUCounter(3);
        lRUCounter.put("1", "foo");
        lRUCounter.put("2", "foo");
        lRUCounter.put("3", "foo");
        lRUCounter.put("1", "foo");
        lRUCounter.put("4", "foo");
        lRUCounter.put("5", "foo");
        lRUCounter.put("2", "foo");
        lRUCounter.remove("5");
        Assert.assertTrue((String)("size should be 2, but was " + lRUCounter.size()), (lRUCounter.size() == 2 ? 1 : 0) != 0);
        Assert.assertTrue((String)("removedCount should be 3 but was " + lRUCounter.removedCount), (lRUCounter.removedCount == 3 ? 1 : 0) != 0);
        Assert.assertTrue((String)"first removed was '2'", (boolean)lRUCounter.list.get(0).equals("2"));
        Assert.assertTrue((String)"second removed was '3'", (boolean)lRUCounter.list.get(1).equals("3"));
        Assert.assertTrue((String)"third removed was '1'", (boolean)lRUCounter.list.get(2).equals("1"));
    }

    private class LRUCounter<K, V>
    extends LRUMap<K, V> {
        int removedCount;
        List<Object> list;

        LRUCounter(int n) {
            super(n);
            this.removedCount = 0;
            this.list = new ArrayList<Object>(3);
        }

        public void processRemoved(Map.Entry entry) {
            ++this.removedCount;
            this.list.add(entry.getKey());
        }
    }
}

