/*
 * Decompiled with CFR 0.152.
 */
package com.twelvemonkeys.util;

import com.twelvemonkeys.util.CollectionUtil;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import java.util.NoSuchElementException;
import java.util.Random;
import java.util.Set;
import java.util.StringTokenizer;
import org.junit.Assert;
import org.junit.Ignore;
import org.junit.Test;

public class CollectionUtilTest {
    private static final Object[] stringObjects = new Object[]{"foo", "bar", "baz"};
    private static final Object[] integerObjects = new Object[]{1, 2, 3};

    @Test
    public void testMergeArraysObject() {
        Object[] objectArray = (Object[])CollectionUtil.mergeArrays((Object)stringObjects, (Object)integerObjects);
        Assert.assertArrayEquals((Object[])new Object[]{"foo", "bar", "baz", 1, 2, 3}, (Object[])objectArray);
    }

    @Test
    public void testMergeArraysObjectOffset() {
        Object[] objectArray = (Object[])CollectionUtil.mergeArrays((Object)stringObjects, (int)1, (int)2, (Object)integerObjects, (int)2, (int)1);
        Assert.assertArrayEquals((Object[])new Object[]{"bar", "baz", 3}, (Object[])objectArray);
    }

    @Test(expected=IndexOutOfBoundsException.class)
    public void testMergeArraysObjectBadOffset() {
        CollectionUtil.mergeArrays((Object)stringObjects, (int)4, (int)2, (Object)integerObjects, (int)2, (int)1);
    }

    @Test(expected=IndexOutOfBoundsException.class)
    public void testMergeArraysObjectBadSecondOffset() {
        CollectionUtil.mergeArrays((Object)stringObjects, (int)1, (int)2, (Object)integerObjects, (int)4, (int)1);
    }

    @Test(expected=IndexOutOfBoundsException.class)
    public void testMergeArraysObjectBadLength() {
        CollectionUtil.mergeArrays((Object)stringObjects, (int)1, (int)4, (Object)integerObjects, (int)2, (int)1);
    }

    @Test(expected=IndexOutOfBoundsException.class)
    public void testMergeArraysObjectBadSecondLength() {
        CollectionUtil.mergeArrays((Object)stringObjects, (int)1, (int)2, (Object)integerObjects, (int)2, (int)2);
    }

    @Test(expected=IndexOutOfBoundsException.class)
    public void testMergeArraysObjectNegativeOffset() {
        CollectionUtil.mergeArrays((Object)stringObjects, (int)-1, (int)2, (Object)integerObjects, (int)2, (int)1);
    }

    @Test(expected=IndexOutOfBoundsException.class)
    public void testMergeArraysObjectNegativeSecondOffset() {
        CollectionUtil.mergeArrays((Object)stringObjects, (int)1, (int)2, (Object)integerObjects, (int)-1, (int)1);
    }

    @Test(expected=IndexOutOfBoundsException.class)
    public void testMergeArraysObjectNegativeLength() {
        CollectionUtil.mergeArrays((Object)stringObjects, (int)1, (int)-1, (Object)integerObjects, (int)2, (int)1);
    }

    @Test(expected=IndexOutOfBoundsException.class)
    public void testMergeArraysObjectNegativeSecondLength() {
        CollectionUtil.mergeArrays((Object)stringObjects, (int)1, (int)2, (Object)integerObjects, (int)2, (int)-1);
    }

    @Test
    public void testMergeArraysObjectAssignable() {
        Integer[] integerArray = new Integer[]{1, 2, 3};
        Object[] objectArray = (Object[])CollectionUtil.mergeArrays((Object)stringObjects, (Object)integerArray);
        Assert.assertArrayEquals((Object[])new Object[]{"foo", "bar", "baz", 1, 2, 3}, (Object[])objectArray);
    }

    @Test(expected=ArrayStoreException.class)
    public void testMergeArraysObjectIllegalType() {
        String[] stringArray = new String[]{"foo", "bar", "baz"};
        Integer[] integerArray = new Integer[]{1, 2, 3};
        CollectionUtil.mergeArrays((Object)stringArray, (Object)integerArray);
    }

    @Test(expected=ArrayStoreException.class)
    public void testMergeArraysNativeIllegalType() {
        char[] cArray = new char[]{'a', 'b', 'c'};
        int[] nArray = new int[]{1, 2, 3};
        CollectionUtil.mergeArrays((Object)cArray, (Object)nArray);
    }

    @Test
    public void testMergeArraysNative() {
        char[] cArray = new char[]{'a', 'b', 'c'};
        char[] cArray2 = new char[]{'x', 'y', 'z'};
        char[] cArray3 = (char[])CollectionUtil.mergeArrays((Object)cArray, (Object)cArray2);
        Assert.assertArrayEquals((char[])new char[]{'a', 'b', 'c', 'x', 'y', 'z'}, (char[])cArray3);
    }

    @Test
    public void testSubArrayObject() {
        Object[] objectArray = (String[])CollectionUtil.subArray((Object[])new String[]{"foo", "bar", "baz", "xyzzy"}, (int)1, (int)2);
        Assert.assertArrayEquals((Object[])new String[]{"bar", "baz"}, (Object[])objectArray);
    }

    @Test
    public void testSubArrayNative() {
        int[] nArray = (int[])CollectionUtil.subArray((Object)new int[]{1, 2, 3, 4, 5}, (int)1, (int)3);
        Assert.assertArrayEquals((int[])new int[]{2, 3, 4}, (int[])nArray);
    }

    @Test(expected=IllegalArgumentException.class)
    public void testEnumIteratorNull() {
        CollectionUtil.iterator((Enumeration)null);
    }

    @Test
    public void testEnumIterator() {
        Iterator iterator = CollectionUtil.iterator((Enumeration)new StringTokenizer("foo, bar, baz", ", "));
        int n = 0;
        for (Object object : stringObjects) {
            Assert.assertTrue((boolean)iterator.hasNext());
            Assert.assertEquals((Object)object, iterator.next());
            try {
                iterator.remove();
                Assert.fail((String)"Enumeration has no remove method, iterator.remove() must throw exception");
            }
            catch (UnsupportedOperationException unsupportedOperationException) {
                // empty catch block
            }
            ++n;
        }
        Assert.assertEquals((long)3L, (long)n);
        Assert.assertFalse((boolean)iterator.hasNext());
        try {
            iterator.next();
            Assert.fail((String)"Iterator has more elements than enumeration");
        }
        catch (NoSuchElementException noSuchElementException) {
            // empty catch block
        }
    }

    @Test(expected=IllegalArgumentException.class)
    public void testArrayIteratorNull() {
        CollectionUtil.iterator((Object[])null);
    }

    @Test
    public void testArrayIterator() {
        ListIterator listIterator = CollectionUtil.iterator((Object[])new String[]{"foo", "bar", "baz"});
        int n = 0;
        for (Object object : stringObjects) {
            Assert.assertTrue((boolean)listIterator.hasNext());
            Assert.assertEquals((Object)object, listIterator.next());
            try {
                listIterator.remove();
                Assert.fail((String)"Array have fixed length, iterator.remove() must throw exception");
            }
            catch (UnsupportedOperationException unsupportedOperationException) {
                // empty catch block
            }
            ++n;
        }
        Assert.assertEquals((long)3L, (long)n);
        Assert.assertFalse((boolean)listIterator.hasNext());
        try {
            listIterator.next();
            Assert.fail((String)"Iterator has more elements than array");
        }
        catch (NoSuchElementException noSuchElementException) {
            // empty catch block
        }
    }

    @Test
    public void testArrayListIterator() {
        this.assertCorrectListIterator(CollectionUtil.iterator((Object[])new String[]{"foo", "bar", "baz"}), stringObjects);
    }

    @Test
    public void testArrayListIteratorRange() {
        this.assertCorrectListIterator(CollectionUtil.iterator((Object[])new String[]{"foo", "bar", "baz", "boo"}, (int)1, (int)2), new String[]{"bar", "baz"});
    }

    @Test
    public void testArrayListIteratorSanityCheckArraysAsList() {
        this.assertCorrectListIterator(Arrays.asList("foo", "bar", "baz").listIterator(), stringObjects);
    }

    @Test
    public void testArrayListIteratorSanityCheckArraysAsListRange() {
        this.assertCorrectListIterator(Arrays.asList("foo", "bar", "baz", "boo").subList(1, 3).listIterator(0), new String[]{"bar", "baz"}, false, true);
    }

    @Test
    public void testArrayListIteratorSanityCheckArraysList() {
        this.assertCorrectListIterator(new ArrayList<String>(Arrays.asList("foo", "bar", "baz")).listIterator(), stringObjects, true, true);
    }

    @Test
    public void testArrayListIteratorSanityCheckArraysListRange() {
        this.assertCorrectListIterator(new ArrayList<String>(Arrays.asList("foo", "bar", "baz", "boo")).subList(1, 3).listIterator(0), new String[]{"bar", "baz"}, true, true);
    }

    private void assertCorrectListIterator(ListIterator<String> listIterator, Object[] objectArray) {
        this.assertCorrectListIterator(listIterator, objectArray, false, false);
    }

    private void assertCorrectListIterator(ListIterator<String> listIterator, Object[] objectArray, boolean bl, boolean bl2) {
        Assert.assertEquals((long)-1L, (long)listIterator.previousIndex());
        Assert.assertEquals((long)0L, (long)listIterator.nextIndex());
        int n = 0;
        for (Object object : objectArray) {
            Assert.assertTrue((String)("No next element for element '" + object + "' at index: " + n), (boolean)listIterator.hasNext());
            Assert.assertEquals((Object)(n > 0 ? 1 : 0), (Object)listIterator.hasPrevious());
            Assert.assertEquals((long)n, (long)listIterator.nextIndex());
            Assert.assertEquals((long)(n - 1), (long)listIterator.previousIndex());
            Assert.assertEquals((Object)object, (Object)listIterator.next());
            ++n;
            if (!bl) {
                try {
                    listIterator.remove();
                    Assert.fail((String)"Array has fixed length, iterator.remove() must throw exception");
                }
                catch (UnsupportedOperationException unsupportedOperationException) {
                    // empty catch block
                }
                Assert.assertEquals((long)n, (long)listIterator.nextIndex());
                Assert.assertEquals((long)(n - 1), (long)listIterator.previousIndex());
            }
            if (!bl2 && !"java.util.AbstractList$ListItr".equals(listIterator.getClass().getName())) {
                try {
                    listIterator.add("xyzzy");
                    Assert.fail((String)"Array has fixed length, iterator.add() must throw exception");
                }
                catch (UnsupportedOperationException unsupportedOperationException) {
                    // empty catch block
                }
                Assert.assertEquals((long)n, (long)listIterator.nextIndex());
                Assert.assertEquals((long)(n - 1), (long)listIterator.previousIndex());
            }
            listIterator.set(String.valueOf(n));
        }
        Assert.assertEquals((long)objectArray.length, (long)n);
        Assert.assertFalse((boolean)listIterator.hasNext());
        try {
            listIterator.next();
            Assert.fail((String)"Iterator has more elements than array");
        }
        catch (NoSuchElementException noSuchElementException) {
            // empty catch block
        }
        Assert.assertEquals((long)(objectArray.length - 1), (long)listIterator.previousIndex());
        Assert.assertEquals((long)objectArray.length, (long)listIterator.nextIndex());
        for (int i = n; i > 0; --i) {
            Assert.assertTrue((String)("No previous element for element '" + objectArray[i - 1] + "' at index: " + (i - 1)), (boolean)listIterator.hasPrevious());
            Assert.assertEquals((Object)(i < objectArray.length ? 1 : 0), (Object)listIterator.hasNext());
            Assert.assertEquals((long)(i - 1), (long)listIterator.previousIndex());
            Assert.assertEquals((long)i, (long)listIterator.nextIndex());
            Assert.assertEquals((Object)String.valueOf(i), (Object)listIterator.previous());
        }
        Assert.assertEquals((long)-1L, (long)listIterator.previousIndex());
        Assert.assertEquals((long)0L, (long)listIterator.nextIndex());
        Assert.assertFalse((boolean)listIterator.hasPrevious());
        try {
            listIterator.previous();
            Assert.fail((String)"Iterator has more elements than array");
        }
        catch (NoSuchElementException noSuchElementException) {
            // empty catch block
        }
    }

    @Test(expected=IllegalArgumentException.class)
    public void testArrayIteratorRangeNull() {
        CollectionUtil.iterator(null, (int)0, (int)0);
    }

    @Test(expected=IllegalArgumentException.class)
    public void testArrayIteratorRangeBadStart() {
        CollectionUtil.iterator((Object[])stringObjects, (int)(stringObjects.length + 1), (int)2);
    }

    @Test(expected=IllegalArgumentException.class)
    public void testArrayIteratorRangeBadLength() {
        CollectionUtil.iterator((Object[])stringObjects, (int)1, (int)stringObjects.length);
    }

    @Test
    public void testArrayIteratorRange() {
        ListIterator listIterator = CollectionUtil.iterator((Object[])new String[]{"foo", "bar", "baz", "xyzzy"}, (int)1, (int)2);
        for (int i = 1; i < 3; ++i) {
            Assert.assertTrue((boolean)listIterator.hasNext());
            Assert.assertEquals((Object)stringObjects[i], listIterator.next());
            try {
                listIterator.remove();
                Assert.fail((String)"Array has no remove method, iterator.remove() must throw exception");
                continue;
            }
            catch (UnsupportedOperationException unsupportedOperationException) {
                // empty catch block
            }
        }
        Assert.assertFalse((boolean)listIterator.hasNext());
        try {
            listIterator.next();
            Assert.fail((String)"Iterator has more elements than array range");
        }
        catch (NoSuchElementException noSuchElementException) {
            // empty catch block
        }
    }

    @Test(expected=IllegalArgumentException.class)
    public void testReverseOrderNull() {
        CollectionUtil.reverseOrder(null);
    }

    @Test
    public void testReverseOrder() {
        NaturalOrder<String> naturalOrder = new NaturalOrder<String>();
        Comparator comparator = CollectionUtil.reverseOrder(naturalOrder);
        Assert.assertNotNull((Object)comparator);
        Assert.assertEquals((long)0L, (long)naturalOrder.compare("foo", "foo"));
        Assert.assertEquals((long)0L, (long)comparator.compare("foo", "foo"));
        Assert.assertTrue((naturalOrder.compare("bar", "baz") < 0 ? 1 : 0) != 0);
        Assert.assertTrue((comparator.compare("bar", "baz") > 0 ? 1 : 0) != 0);
        Assert.assertTrue((naturalOrder.compare("baz", "bar") > 0 ? 1 : 0) != 0);
        Assert.assertTrue((comparator.compare("baz", "bar") < 0 ? 1 : 0) != 0);
    }

    @Test
    public void testReverseOrderRandomIntegers() {
        NaturalOrder<Integer> naturalOrder = new NaturalOrder<Integer>();
        Comparator comparator = CollectionUtil.reverseOrder(naturalOrder);
        Random random = new Random(243249878L);
        for (int i = 0; i < 65536; ++i) {
            int n = random.nextInt();
            int n2 = random.nextInt();
            Assert.assertEquals((long)0L, (long)comparator.compare(n, n));
            Assert.assertEquals((long)0L, (long)comparator.compare(n2, n2));
            int n3 = naturalOrder.compare(n, n2);
            if (n3 == 0) {
                Assert.assertEquals((long)0L, (long)comparator.compare(n, n2));
                continue;
            }
            if (n3 < 0) {
                Assert.assertTrue((comparator.compare(n, n2) > 0 ? 1 : 0) != 0);
                continue;
            }
            Assert.assertTrue((comparator.compare(n, n2) < 0 ? 1 : 0) != 0);
        }
    }

    @Ignore(value="For development only")
    @Test
    public void testGenerify() {
        Collection collection;
        Collection collection2;
        List<String> list = Collections.singletonList("foo");
        HashSet<String> hashSet = new HashSet<String>(list);
        List list2 = (List)CollectionUtil.generify(list, String.class);
        List list3 = (List)CollectionUtil.generify(list, String.class);
        try {
            collection2 = (List)CollectionUtil.generify(hashSet, String.class);
        }
        catch (RuntimeException runtimeException) {
            runtimeException.printStackTrace();
        }
        try {
            collection2 = (ArrayList)CollectionUtil.generify(list, String.class);
        }
        catch (RuntimeException runtimeException) {
            runtimeException.printStackTrace();
        }
        collection2 = (Set)CollectionUtil.generify(hashSet, String.class);
        Set set = (Set)CollectionUtil.generify(hashSet, String.class);
        try {
            collection = (Set)CollectionUtil.generify(list, String.class);
        }
        catch (RuntimeException runtimeException) {
            runtimeException.printStackTrace();
        }
        collection = (List)CollectionUtil.generify2(list);
        List list4 = (List)CollectionUtil.generify2(list);
        try {
            List list5 = (List)CollectionUtil.generify2(hashSet);
        }
        catch (RuntimeException runtimeException) {
            runtimeException.printStackTrace();
        }
    }

    private static class NaturalOrder<T extends Comparable<T>>
    implements Comparator<T> {
        private NaturalOrder() {
        }

        @Override
        public int compare(T t, T t2) {
            return t.compareTo(t2);
        }
    }
}

