/*
 * Decompiled with CFR 0.152.
 */
package com.twelvemonkeys.util;

import com.twelvemonkeys.util.ObjectAbstractTest;
import java.lang.reflect.Array;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.ConcurrentModificationException;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;
import org.junit.Assert;
import org.junit.Test;

public abstract class CollectionAbstractTest
extends ObjectAbstractTest {
    public Collection collection;
    public Collection confirmed;

    public boolean areEqualElementsDistinguishable() {
        return false;
    }

    public boolean isAddSupported() {
        return true;
    }

    public boolean isRemoveSupported() {
        return true;
    }

    public boolean isNullSupported() {
        return true;
    }

    public boolean isFailFastSupported() {
        return false;
    }

    @Override
    public boolean isEqualsCheckable() {
        return false;
    }

    public void verifyAll() {
        int n = this.confirmed.size();
        Assert.assertEquals((String)"Collection size should match confirmed collection's", (long)n, (long)this.collection.size());
        Assert.assertEquals((String)"Collection isEmpty() result should match confirmed  collection's", (Object)this.confirmed.isEmpty(), (Object)this.collection.isEmpty());
        Object[] objectArray = new Object[n];
        Iterator iterator = this.confirmed.iterator();
        int n2 = 0;
        while (iterator.hasNext()) {
            objectArray[n2++] = iterator.next();
        }
        boolean[] blArray = new boolean[n];
        for (Object e : this.collection) {
            boolean bl = false;
            for (int i = 0; i < n; ++i) {
                if (blArray[i] || e != objectArray[i] && (e == null || !e.equals(objectArray[i]))) continue;
                blArray[i] = true;
                bl = true;
                break;
            }
            if (bl) continue;
            Assert.fail((String)("Collection should not contain a value that the confirmed collection does not have: " + e + "\nTest: " + this.collection + "\nReal: " + this.confirmed));
        }
        for (int i = 0; i < n; ++i) {
            if (blArray[i]) continue;
            Assert.fail((String)("Collection should contain all values that are in the confirmed collection\nTest: " + this.collection + "\nReal: " + this.confirmed));
        }
    }

    public void resetEmpty() {
        this.collection = this.makeCollection();
        this.confirmed = this.makeConfirmedCollection();
    }

    public void resetFull() {
        this.collection = this.makeFullCollection();
        this.confirmed = this.makeConfirmedFullCollection();
    }

    public abstract Collection makeConfirmedCollection();

    public abstract Collection makeConfirmedFullCollection();

    public abstract Collection makeCollection();

    public Collection makeFullCollection() {
        Collection collection = this.makeCollection();
        collection.addAll(Arrays.asList(this.getFullElements()));
        return collection;
    }

    @Override
    public Object makeObject() {
        return this.makeCollection();
    }

    public Map.Entry cloneMapEntry(Map.Entry entry) {
        HashMap hashMap = new HashMap();
        hashMap.put(entry.getKey(), entry.getValue());
        return hashMap.entrySet().iterator().next();
    }

    public Object[] getFullElements() {
        if (this.isNullSupported()) {
            ArrayList<Object> arrayList = new ArrayList<Object>();
            arrayList.addAll(Arrays.asList(this.getFullNonNullElements()));
            arrayList.add(4, null);
            return arrayList.toArray();
        }
        return (Object[])this.getFullNonNullElements().clone();
    }

    public Object[] getOtherElements() {
        return this.getOtherNonNullElements();
    }

    public Object[] getFullNonNullElements() {
        return new Object[]{new String(""), new String("One"), new Integer(2), "Three", new Integer(4), "One", new Double(5.0), new Float(6.0f), "Seven", "Eight", new String("Nine"), new Integer(10), new Short(11), new Long(12L), "Thirteen", "14", "15", new Byte(16)};
    }

    public Object[] getOtherNonNullElements() {
        return new Object[]{new Integer(0), new Float(0.0f), new Double(0.0), "Zero", new Short(0), new Byte(0), new Long(0L), new Character('\u0000'), "0"};
    }

    public Object[] getFullNonNullStringElements() {
        return new Object[]{"If", "the", "dull", "substance", "of", "my", "flesh", "were", "thought", "Injurious", "distance", "could", "not", "stop", "my", "way"};
    }

    public Object[] getOtherNonNullStringElements() {
        return new Object[]{"For", "then", "despite", "space", "I", "would", "be", "brought", "From", "limits", "far", "remote", "where", "thou", "dost", "stay"};
    }

    @Test
    public void testCollectionAdd() {
        int n;
        int n2;
        if (!this.isAddSupported()) {
            return;
        }
        Object[] objectArray = this.getFullElements();
        for (n2 = 0; n2 < objectArray.length; ++n2) {
            this.resetEmpty();
            n = this.collection.add(objectArray[n2]);
            this.confirmed.add(objectArray[n2]);
            this.verifyAll();
            Assert.assertTrue((String)"Empty collection changed after add", n != 0);
            Assert.assertEquals((String)"Collection size is 1 after first add", (long)1L, (long)this.collection.size());
        }
        this.resetEmpty();
        n2 = 0;
        for (n = 0; n < objectArray.length; ++n) {
            boolean bl = this.collection.add(objectArray[n]);
            this.confirmed.add(objectArray[n]);
            this.verifyAll();
            if (bl) {
                ++n2;
            }
            Assert.assertEquals((String)"Collection size should grow after add", (long)n2, (long)this.collection.size());
            Assert.assertTrue((String)"Collection should contain added element", (boolean)this.collection.contains(objectArray[n]));
        }
    }

    @Test
    public void testCollectionAddAll() {
        int n;
        if (!this.isAddSupported()) {
            return;
        }
        this.resetEmpty();
        Object[] objectArray = this.getFullElements();
        boolean bl = this.collection.addAll(Arrays.asList(objectArray));
        this.confirmed.addAll(Arrays.asList(objectArray));
        this.verifyAll();
        Assert.assertTrue((String)"Empty collection should change after addAll", (boolean)bl);
        for (n = 0; n < objectArray.length; ++n) {
            Assert.assertTrue((String)"Collection should contain added element", (boolean)this.collection.contains(objectArray[n]));
        }
        this.resetFull();
        n = this.collection.size();
        objectArray = this.getOtherElements();
        bl = this.collection.addAll(Arrays.asList(objectArray));
        this.confirmed.addAll(Arrays.asList(objectArray));
        this.verifyAll();
        Assert.assertTrue((String)"Full collection should change after addAll", (boolean)bl);
        for (int i = 0; i < objectArray.length; ++i) {
            Assert.assertTrue((String)"Full collection should contain added element", (boolean)this.collection.contains(objectArray[i]));
        }
        Assert.assertEquals((String)"Size should increase after addAll", (long)(n + objectArray.length), (long)this.collection.size());
        this.resetFull();
        n = this.collection.size();
        bl = this.collection.addAll(Arrays.asList(this.getFullElements()));
        this.confirmed.addAll(Arrays.asList(this.getFullElements()));
        this.verifyAll();
        if (bl) {
            Assert.assertTrue((String)"Size should increase if addAll returns true", (n < this.collection.size() ? 1 : 0) != 0);
        } else {
            Assert.assertEquals((String)"Size should not change if addAll returns false", (long)n, (long)this.collection.size());
        }
    }

    @Test
    public void testUnsupportedAdd() {
        if (this.isAddSupported()) {
            return;
        }
        this.resetEmpty();
        try {
            this.collection.add(new Object());
            Assert.fail((String)"Emtpy collection should not support add.");
        }
        catch (UnsupportedOperationException unsupportedOperationException) {
            // empty catch block
        }
        this.verifyAll();
        try {
            this.collection.addAll(Arrays.asList(this.getFullElements()));
            Assert.fail((String)"Emtpy collection should not support addAll.");
        }
        catch (UnsupportedOperationException unsupportedOperationException) {
            // empty catch block
        }
        this.verifyAll();
        this.resetFull();
        try {
            this.collection.add(new Object());
            Assert.fail((String)"Full collection should not support add.");
        }
        catch (UnsupportedOperationException unsupportedOperationException) {
            // empty catch block
        }
        this.verifyAll();
        try {
            this.collection.addAll(Arrays.asList(this.getOtherElements()));
            Assert.fail((String)"Full collection should not support addAll.");
        }
        catch (UnsupportedOperationException unsupportedOperationException) {
            // empty catch block
        }
        this.verifyAll();
    }

    @Test
    public void testCollectionClear() {
        if (!this.isRemoveSupported()) {
            return;
        }
        this.resetEmpty();
        this.collection.clear();
        this.verifyAll();
        this.resetFull();
        this.collection.clear();
        this.confirmed.clear();
        this.verifyAll();
    }

    public void testCollectionContains() {
        int n;
        this.resetEmpty();
        Object[] objectArray = this.getFullElements();
        for (n = 0; n < objectArray.length; ++n) {
            Assert.assertTrue((String)("Empty collection shouldn't contain element[" + n + "]"), (!this.collection.contains(objectArray[n]) ? 1 : 0) != 0);
        }
        this.verifyAll();
        objectArray = this.getOtherElements();
        for (n = 0; n < objectArray.length; ++n) {
            Assert.assertTrue((String)("Empty collection shouldn't contain element[" + n + "]"), (!this.collection.contains(objectArray[n]) ? 1 : 0) != 0);
        }
        this.verifyAll();
        this.resetFull();
        objectArray = this.getFullElements();
        for (n = 0; n < objectArray.length; ++n) {
            Assert.assertTrue((String)("Full collection should contain element[" + n + "]"), (boolean)this.collection.contains(objectArray[n]));
        }
        this.verifyAll();
        this.resetFull();
        objectArray = this.getOtherElements();
        for (n = 0; n < objectArray.length; ++n) {
            Assert.assertTrue((String)"Full collection shouldn't contain element", (!this.collection.contains(objectArray[n]) ? 1 : 0) != 0);
        }
    }

    @Test
    public void testCollectionContainsAll() {
        int n;
        this.resetEmpty();
        Collection<Object> collection = new HashSet<Object>();
        Assert.assertTrue((String)"Every Collection should contain all elements of an empty Collection.", (boolean)this.collection.containsAll(collection));
        collection.addAll(Arrays.asList(this.getOtherElements()));
        Assert.assertTrue((String)"Empty Collection shouldn't contain all elements of a non-empty Collection.", (!this.collection.containsAll(collection) ? 1 : 0) != 0);
        this.verifyAll();
        this.resetFull();
        Assert.assertTrue((String)"Full collection shouldn't contain other elements", (!this.collection.containsAll(collection) ? 1 : 0) != 0);
        collection.clear();
        collection.addAll(Arrays.asList(this.getFullElements()));
        Assert.assertTrue((String)"Full collection should containAll full elements", (boolean)this.collection.containsAll(collection));
        this.verifyAll();
        int n2 = n = this.getFullElements().length < 2 ? 0 : 2;
        int n3 = this.getFullElements().length == 1 ? 1 : (this.getFullElements().length <= 5 ? this.getFullElements().length - 1 : 5);
        collection = Arrays.asList(this.getFullElements()).subList(n, n3);
        Assert.assertTrue((String)"Full collection should containAll partial full elements", (boolean)this.collection.containsAll(collection));
        Assert.assertTrue((String)"Full collection should containAll itself", (boolean)this.collection.containsAll(this.collection));
        this.verifyAll();
        collection = new ArrayList();
        collection.addAll(Arrays.asList(this.getFullElements()));
        collection.addAll(Arrays.asList(this.getFullElements()));
        Assert.assertTrue((String)"Full collection should containAll duplicate full elements", (boolean)this.collection.containsAll(collection));
        this.verifyAll();
    }

    @Test
    public void testCollectionIsEmpty() {
        this.resetEmpty();
        Assert.assertEquals((String)"New Collection should be empty.", (Object)true, (Object)this.collection.isEmpty());
        this.verifyAll();
        this.resetFull();
        Assert.assertEquals((String)"Full collection shouldn't be empty", (Object)false, (Object)this.collection.isEmpty());
        this.verifyAll();
    }

    @Test
    public void testCollectionIterator() {
        this.resetEmpty();
        Iterator iterator = this.collection.iterator();
        Assert.assertEquals((String)"Iterator for empty Collection shouldn't have next.", (Object)false, (Object)iterator.hasNext());
        try {
            iterator.next();
            Assert.fail((String)"Iterator at end of Collection should throw NoSuchElementException when next is called.");
        }
        catch (NoSuchElementException noSuchElementException) {
            // empty catch block
        }
        this.verifyAll();
        this.resetFull();
        iterator = this.collection.iterator();
        for (int i = 0; i < this.collection.size(); ++i) {
            Assert.assertTrue((String)"Iterator for full collection should haveNext", (boolean)iterator.hasNext());
            iterator.next();
        }
        Assert.assertTrue((String)"Iterator should be finished", (!iterator.hasNext() ? 1 : 0) != 0);
        ArrayList arrayList = new ArrayList();
        iterator = this.collection.iterator();
        for (int i = 0; i < this.collection.size(); ++i) {
            Object e = iterator.next();
            Assert.assertTrue((String)"Collection should contain element returned by its iterator", (boolean)this.collection.contains(e));
            arrayList.add(e);
        }
        try {
            iterator.next();
            Assert.fail((String)"iterator.next() should raise NoSuchElementException after it finishes");
        }
        catch (NoSuchElementException noSuchElementException) {
            // empty catch block
        }
        this.verifyAll();
    }

    @Test
    public void testCollectionIteratorRemove() {
        if (!this.isRemoveSupported()) {
            return;
        }
        this.resetEmpty();
        try {
            this.collection.iterator().remove();
            Assert.fail((String)"New iterator.remove should raise IllegalState");
        }
        catch (IllegalStateException illegalStateException) {
            // empty catch block
        }
        this.verifyAll();
        try {
            Iterator iterator = this.collection.iterator();
            iterator.hasNext();
            iterator.remove();
            Assert.fail((String)"New iterator.remove should raise IllegalState even after hasNext");
        }
        catch (IllegalStateException illegalStateException) {
            // empty catch block
        }
        this.verifyAll();
        this.resetFull();
        int n = this.collection.size();
        Iterator iterator = this.collection.iterator();
        while (iterator.hasNext()) {
            Object object = iterator.next();
            if (object instanceof Map.Entry) {
                object = this.cloneMapEntry((Map.Entry)object);
            }
            iterator.remove();
            if (!this.areEqualElementsDistinguishable()) {
                this.confirmed.remove(object);
                this.verifyAll();
            }
            Assert.assertEquals((String)"Collection should shrink by one after iterator.remove", (long)(--n), (long)this.collection.size());
        }
        Assert.assertTrue((String)"Collection should be empty after iterator purge", (boolean)this.collection.isEmpty());
        this.resetFull();
        iterator = this.collection.iterator();
        iterator.next();
        iterator.remove();
        try {
            iterator.remove();
            Assert.fail((String)"Second iter.remove should raise IllegalState");
        }
        catch (IllegalStateException illegalStateException) {
            // empty catch block
        }
    }

    @Test
    public void testCollectionRemove() {
        int n;
        if (!this.isRemoveSupported()) {
            return;
        }
        this.resetEmpty();
        Object[] objectArray = this.getFullElements();
        for (int i = 0; i < objectArray.length; ++i) {
            Assert.assertTrue((String)"Shouldn't remove nonexistent element", (!this.collection.remove(objectArray[i]) ? 1 : 0) != 0);
            this.verifyAll();
        }
        Object[] objectArray2 = this.getOtherElements();
        this.resetFull();
        for (n = 0; n < objectArray2.length; ++n) {
            Assert.assertTrue((String)"Shouldn't remove nonexistent other element", (!this.collection.remove(objectArray2[n]) ? 1 : 0) != 0);
            this.verifyAll();
        }
        n = this.collection.size();
        for (int i = 0; i < objectArray.length; ++i) {
            this.resetFull();
            Assert.assertTrue((String)("Collection should remove extant element: " + objectArray[i]), (boolean)this.collection.remove(objectArray[i]));
            if (!this.areEqualElementsDistinguishable()) {
                this.confirmed.remove(objectArray[i]);
                this.verifyAll();
            }
            Assert.assertEquals((String)"Collection should shrink after remove", (long)(n - 1), (long)this.collection.size());
        }
    }

    @Test
    public void testCollectionRemoveAll() {
        int n;
        if (!this.isRemoveSupported()) {
            return;
        }
        this.resetEmpty();
        Assert.assertTrue((String)"Emtpy collection removeAll should return false for empty input", (!this.collection.removeAll(Collections.EMPTY_SET) ? 1 : 0) != 0);
        this.verifyAll();
        Assert.assertTrue((String)"Emtpy collection removeAll should return false for nonempty input", (!this.collection.removeAll(new ArrayList(this.collection)) ? 1 : 0) != 0);
        this.verifyAll();
        this.resetFull();
        Assert.assertTrue((String)"Full collection removeAll should return false for empty input", (!this.collection.removeAll(Collections.EMPTY_SET) ? 1 : 0) != 0);
        this.verifyAll();
        Assert.assertTrue((String)"Full collection removeAll should return false for other elements", (!this.collection.removeAll(Arrays.asList(this.getOtherElements())) ? 1 : 0) != 0);
        this.verifyAll();
        Assert.assertTrue((String)"Full collection removeAll should return true for full elements", (boolean)this.collection.removeAll(new HashSet(this.collection)));
        this.confirmed.removeAll(new HashSet(this.confirmed));
        this.verifyAll();
        this.resetFull();
        int n2 = this.collection.size();
        int n3 = n = this.getFullElements().length < 2 ? 0 : 2;
        int n4 = this.getFullElements().length == 1 ? 1 : (this.getFullElements().length <= 5 ? this.getFullElements().length - 1 : 5);
        List<Object> list = Arrays.asList(this.getFullElements()).subList(n, n4);
        Assert.assertTrue((String)"Full collection removeAll should work", (boolean)this.collection.removeAll(list));
        this.confirmed.removeAll(list);
        this.verifyAll();
        Assert.assertTrue((String)"Collection should shrink after removeAll", (this.collection.size() < n2 ? 1 : 0) != 0);
        Iterator iterator = list.iterator();
        while (iterator.hasNext()) {
            Assert.assertTrue((String)"Collection shouldn't contain removed element", (!this.collection.contains(iterator.next()) ? 1 : 0) != 0);
        }
    }

    @Test
    public void testCollectionRetainAll() {
        if (!this.isRemoveSupported()) {
            return;
        }
        this.resetEmpty();
        List<Object> list = Arrays.asList(this.getFullElements());
        List<Object> list2 = Arrays.asList(this.getOtherElements());
        Assert.assertTrue((String)"Empty retainAll() should return false", (!this.collection.retainAll(Collections.EMPTY_SET) ? 1 : 0) != 0);
        this.verifyAll();
        Assert.assertTrue((String)"Empty retainAll() should return false", (!this.collection.retainAll(list) ? 1 : 0) != 0);
        this.verifyAll();
        this.resetFull();
        Assert.assertTrue((String)"Collection should change from retainAll empty", (boolean)this.collection.retainAll(Collections.EMPTY_SET));
        this.confirmed.retainAll(Collections.EMPTY_SET);
        this.verifyAll();
        this.resetFull();
        Assert.assertTrue((String)"Collection changed from retainAll other", (boolean)this.collection.retainAll(list2));
        this.confirmed.retainAll(list2);
        this.verifyAll();
        this.resetFull();
        int n = this.collection.size();
        Assert.assertTrue((String)"Collection shouldn't change from retainAll elements", (!this.collection.retainAll(list) ? 1 : 0) != 0);
        this.verifyAll();
        Assert.assertEquals((String)"Collection size shouldn't change", (long)n, (long)this.collection.size());
        if (this.getFullElements().length > 1) {
            this.resetFull();
            n = this.collection.size();
            int n2 = this.getFullElements().length < 2 ? 0 : 2;
            int n3 = this.getFullElements().length <= 5 ? this.getFullElements().length - 1 : 5;
            Assert.assertTrue((String)"Collection should changed by partial retainAll", (boolean)this.collection.retainAll(list.subList(n2, n3)));
            this.confirmed.retainAll(list.subList(n2, n3));
            this.verifyAll();
            Iterator iterator = this.collection.iterator();
            while (iterator.hasNext()) {
                Assert.assertTrue((String)"Collection only contains retained element", (boolean)list.subList(n2, n3).contains(iterator.next()));
            }
        }
        this.resetFull();
        HashSet<Object> hashSet = new HashSet<Object>(list);
        n = this.collection.size();
        Assert.assertTrue((String)"Collection shouldn't change from retainAll without duplicate elements", (!this.collection.retainAll(hashSet) ? 1 : 0) != 0);
        this.verifyAll();
        Assert.assertEquals((String)"Collection size didn't change from nonduplicate retainAll", (long)n, (long)this.collection.size());
    }

    @Test
    public void testCollectionSize() {
        this.resetEmpty();
        Assert.assertEquals((String)"Size of new Collection is 0.", (long)0L, (long)this.collection.size());
        this.resetFull();
        Assert.assertTrue((String)"Size of full collection should be greater than zero", (this.collection.size() > 0 ? 1 : 0) != 0);
    }

    public void testCollectionToArray() {
        int n;
        this.resetEmpty();
        Assert.assertEquals((String)"Empty Collection should return empty array for toArray", (long)0L, (long)this.collection.toArray().length);
        this.resetFull();
        Object[] objectArray = this.collection.toArray();
        Assert.assertEquals((String)"Full collection toArray should be same size as collection", (long)objectArray.length, (long)this.collection.size());
        Object[] objectArray2 = this.confirmed.toArray();
        Assert.assertEquals((String)"length of array from confirmed collection should match the length of the collection's array", (long)objectArray2.length, (long)objectArray.length);
        boolean[] blArray = new boolean[objectArray.length];
        for (n = 0; n < objectArray.length; ++n) {
            Assert.assertTrue((String)"Collection should contain element in toArray", (boolean)this.collection.contains(objectArray[n]));
            boolean bl = false;
            for (int i = 0; i < objectArray.length; ++i) {
                if (blArray[i] || objectArray[n] != objectArray2[i] && (objectArray[n] == null || !objectArray[n].equals(objectArray2[i]))) continue;
                blArray[i] = true;
                bl = true;
                break;
            }
            if (bl) continue;
            Assert.fail((String)("element " + n + " in returned array should be found " + "in the confirmed collection's array"));
        }
        for (n = 0; n < blArray.length; ++n) {
            Assert.assertEquals((String)"Collection should return all its elements in toArray", (Object)true, (Object)blArray[n]);
        }
    }

    @Test
    public void testCollectionToArray2() {
        this.resetEmpty();
        Object[] objectArray = new Object[]{new Object(), null, null};
        Object[] objectArray2 = this.collection.toArray(objectArray);
        Assert.assertEquals((String)"Given array shouldn't shrink", (Object[])objectArray2, (Object[])objectArray);
        Assert.assertEquals((String)"Last element should be set to null", (Object)objectArray[0], null);
        this.verifyAll();
        this.resetFull();
        try {
            objectArray2 = this.collection.toArray(new Void[0]);
            Assert.fail((String)"toArray(new Void[0]) should raise ArrayStore");
        }
        catch (ArrayStoreException arrayStoreException) {
            // empty catch block
        }
        this.verifyAll();
        try {
            objectArray2 = this.collection.toArray((T[])null);
            Assert.fail((String)"toArray(null) should raise NPE");
        }
        catch (NullPointerException nullPointerException) {
            // empty catch block
        }
        this.verifyAll();
        objectArray2 = this.collection.toArray(new Object[0]);
        objectArray = this.collection.toArray();
        Assert.assertEquals((String)"toArrays should be equal", Arrays.asList(objectArray2), Arrays.asList(objectArray));
        HashSet hashSet = new HashSet();
        for (int i = 0; i < objectArray2.length; ++i) {
            hashSet.add(objectArray2[i] == null ? null : objectArray2[i].getClass());
        }
        if (hashSet.size() > 1) {
            return;
        }
        Class<Map.Entry> clazz = (Class<Map.Entry>)hashSet.iterator().next();
        if (Map.Entry.class.isAssignableFrom(clazz)) {
            clazz = Map.Entry.class;
        }
        objectArray = (Object[])Array.newInstance(clazz, 0);
        objectArray2 = this.collection.toArray(objectArray);
        Assert.assertEquals((String)"toArray(Object[]) should return correct array type", objectArray.getClass(), objectArray2.getClass());
        Assert.assertEquals((String)"type-specific toArrays should be equal", Arrays.asList(objectArray2), Arrays.asList(this.collection.toArray()));
        this.verifyAll();
    }

    @Test
    public void testCollectionToString() {
        this.resetEmpty();
        Assert.assertTrue((String)"toString shouldn't return null", (this.collection.toString() != null ? 1 : 0) != 0);
        this.resetFull();
        Assert.assertTrue((String)"toString shouldn't return null", (this.collection.toString() != null ? 1 : 0) != 0);
    }

    @Test
    public void testUnsupportedRemove() {
        if (this.isRemoveSupported()) {
            return;
        }
        this.resetEmpty();
        try {
            this.collection.clear();
            Assert.fail((String)"clear should raise UnsupportedOperationException");
        }
        catch (UnsupportedOperationException unsupportedOperationException) {
            // empty catch block
        }
        this.verifyAll();
        try {
            this.collection.remove(null);
            Assert.fail((String)"remove should raise UnsupportedOperationException");
        }
        catch (UnsupportedOperationException unsupportedOperationException) {
            // empty catch block
        }
        this.verifyAll();
        try {
            this.collection.removeAll(null);
            Assert.fail((String)"removeAll should raise UnsupportedOperationException");
        }
        catch (UnsupportedOperationException unsupportedOperationException) {
            // empty catch block
        }
        this.verifyAll();
        try {
            this.collection.retainAll(null);
            Assert.fail((String)"removeAll should raise UnsupportedOperationException");
        }
        catch (UnsupportedOperationException unsupportedOperationException) {
            // empty catch block
        }
        this.verifyAll();
        this.resetFull();
        try {
            Iterator iterator = this.collection.iterator();
            iterator.next();
            iterator.remove();
            Assert.fail((String)"iterator.remove should raise UnsupportedOperationException");
        }
        catch (UnsupportedOperationException unsupportedOperationException) {
            // empty catch block
        }
        this.verifyAll();
    }

    @Test
    public void testCollectionIteratorFailFast() {
        List<Object> list;
        Iterator iterator;
        if (!this.isFailFastSupported()) {
            return;
        }
        if (this.isAddSupported()) {
            this.resetFull();
            try {
                iterator = this.collection.iterator();
                list = this.getOtherElements()[0];
                this.collection.add(list);
                this.confirmed.add(list);
                iterator.next();
                Assert.fail((String)"next after add should raise ConcurrentModification");
            }
            catch (ConcurrentModificationException concurrentModificationException) {
                // empty catch block
            }
            this.verifyAll();
            this.resetFull();
            try {
                iterator = this.collection.iterator();
                this.collection.addAll(Arrays.asList(this.getOtherElements()));
                this.confirmed.addAll(Arrays.asList(this.getOtherElements()));
                iterator.next();
                Assert.fail((String)"next after addAll should raise ConcurrentModification");
            }
            catch (ConcurrentModificationException concurrentModificationException) {
                // empty catch block
            }
            this.verifyAll();
        }
        if (!this.isRemoveSupported()) {
            return;
        }
        this.resetFull();
        try {
            iterator = this.collection.iterator();
            this.collection.clear();
            iterator.next();
            Assert.fail((String)"next after clear should raise ConcurrentModification");
        }
        catch (ConcurrentModificationException concurrentModificationException) {
        }
        catch (NoSuchElementException noSuchElementException) {
            // empty catch block
        }
        this.resetFull();
        try {
            iterator = this.collection.iterator();
            this.collection.remove(this.getFullElements()[0]);
            iterator.next();
            Assert.fail((String)"next after remove should raise ConcurrentModification");
        }
        catch (ConcurrentModificationException concurrentModificationException) {
            // empty catch block
        }
        this.resetFull();
        try {
            iterator = this.collection.iterator();
            list = Arrays.asList(this.getFullElements()).subList(2, 5);
            this.collection.removeAll(list);
            iterator.next();
            Assert.fail((String)"next after removeAll should raise ConcurrentModification");
        }
        catch (ConcurrentModificationException concurrentModificationException) {
            // empty catch block
        }
        this.resetFull();
        try {
            iterator = this.collection.iterator();
            list = Arrays.asList(this.getFullElements()).subList(2, 5);
            this.collection.retainAll(list);
            iterator.next();
            Assert.fail((String)"next after retainAll should raise ConcurrentModification");
        }
        catch (ConcurrentModificationException concurrentModificationException) {
            // empty catch block
        }
    }
}

