/*
 * Decompiled with CFR 0.152.
 */
package com.twelvemonkeys.lang;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.OutputStream;
import java.io.Serializable;
import java.lang.reflect.Method;
import org.junit.Assert;
import org.junit.Test;

public abstract class ObjectAbstractTest {
    protected abstract Object makeObject();

    @Test
    public void testToString() {
        Assert.assertNotNull((Object)this.makeObject().toString());
    }

    @Test
    public void testEqualsHashCode() {
        Object object = this.makeObject();
        Class<?> clazz = object.getClass();
        if (ObjectAbstractTest.isEqualsOverriden(clazz)) {
            Assert.assertTrue((String)("Class " + clazz.getName() + " implements equals but not hashCode"), (boolean)ObjectAbstractTest.isHashCodeOverriden(clazz));
        } else if (ObjectAbstractTest.isHashCodeOverriden(clazz)) {
            Assert.assertTrue((String)("Class " + clazz.getName() + " implements hashCode but not equals"), (boolean)ObjectAbstractTest.isEqualsOverriden(clazz));
        }
    }

    protected static boolean isEqualsOverriden(Class clazz) {
        return ObjectAbstractTest.getDeclaredMethod(clazz, "equals", new Class[]{Object.class}) != null;
    }

    protected static boolean isHashCodeOverriden(Class clazz) {
        return ObjectAbstractTest.getDeclaredMethod(clazz, "hashCode", null) != null;
    }

    private static Method getDeclaredMethod(Class clazz, String string, Class[] classArray) {
        try {
            return clazz.getDeclaredMethod(string, classArray);
        }
        catch (NoSuchMethodException noSuchMethodException) {
            return null;
        }
    }

    @Test
    public void testObjectEqualsSelf() {
        Object object = this.makeObject();
        Assert.assertEquals((String)"An Object should equal itself", (Object)object, (Object)object);
    }

    @Test
    public void testEqualsNull() {
        Object object = this.makeObject();
        Assert.assertFalse((String)"An object should never equal null", (boolean)object.equals(null));
    }

    @Test
    public void testObjectHashCodeEqualsSelfHashCode() {
        Object object = this.makeObject();
        Assert.assertEquals((String)"hashCode should be repeatable", (long)object.hashCode(), (long)object.hashCode());
    }

    @Test
    public void testObjectHashCodeEqualsContract() {
        Object object;
        Object object2 = this.makeObject();
        if (object2.equals(object2)) {
            Assert.assertEquals((String)"[1] When two objects are equal, their hashCodes should be also.", (long)object2.hashCode(), (long)object2.hashCode());
        }
        if (object2.equals(object = this.makeObject())) {
            Assert.assertEquals((String)"[2] When two objects are equal, their hashCodes should be also.", (long)object2.hashCode(), (long)object.hashCode());
            Assert.assertTrue((String)"When obj1.equals(obj2) is true, then obj2.equals(obj1) should also be true", (boolean)object.equals(object2));
        }
    }

    @Test
    public void testClone() throws Exception {
        Object object = this.makeObject();
        if (object instanceof Cloneable) {
            Class<?> clazz = object.getClass();
            Method method = ObjectAbstractTest.findMethod(clazz, "clone");
            if (!method.isAccessible()) {
                method.setAccessible(true);
            }
            Object object2 = method.invoke(object, new Object[0]);
            Assert.assertNotNull((String)"Cloned object should never be null", (Object)object2);
            if (ObjectAbstractTest.isHashCodeOverriden(clazz)) {
                Assert.assertEquals((String)"Cloned object not equal", (Object)object, (Object)object2);
            }
        }
    }

    private static Method findMethod(Class clazz, String string) throws NoSuchMethodException {
        if (clazz == null) {
            throw new IllegalArgumentException("class == null");
        }
        if (string == null) {
            throw new IllegalArgumentException("name == null");
        }
        for (Class clazz2 = clazz; clazz2 != null; clazz2 = clazz2.getSuperclass()) {
            try {
                return clazz2.getDeclaredMethod(string, new Class[0]);
            }
            catch (NoSuchMethodException noSuchMethodException) {
                continue;
            }
            catch (SecurityException securityException) {
                // empty catch block
            }
        }
        throw new NoSuchMethodException(string + " in class " + clazz.getName());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testSerializeDeserializeThenCompare() throws Exception {
        Object object = this.makeObject();
        if (object instanceof Serializable) {
            Object object2;
            ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
            try (ObjectOutputStream objectOutputStream = new ObjectOutputStream(byteArrayOutputStream);){
                objectOutputStream.writeObject(object);
            }
            try (ObjectInputStream objectInputStream = new ObjectInputStream(new ByteArrayInputStream(byteArrayOutputStream.toByteArray()));){
                object2 = objectInputStream.readObject();
            }
            if (ObjectAbstractTest.isEqualsOverriden(object.getClass())) {
                Assert.assertEquals((String)"obj != deserialize(serialize(obj))", (Object)object, (Object)object2);
            }
        }
    }

    @Test
    public void testSimpleSerialization() throws Exception {
        Object object = this.makeObject();
        if (object instanceof Serializable) {
            byte[] byArray = this.writeExternalFormToBytes((Serializable)object);
            this.readExternalFormFromBytes(byArray);
        }
    }

    protected void writeExternalFormToDisk(Serializable serializable, String string) throws IOException {
        FileOutputStream fileOutputStream = new FileOutputStream(string);
        this.writeExternalFormToStream(serializable, fileOutputStream);
    }

    protected byte[] writeExternalFormToBytes(Serializable serializable) throws IOException {
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        this.writeExternalFormToStream(serializable, byteArrayOutputStream);
        return byteArrayOutputStream.toByteArray();
    }

    protected Object readExternalFormFromDisk(String string) throws IOException, ClassNotFoundException {
        FileInputStream fileInputStream = new FileInputStream(string);
        return this.readExternalFormFromStream(fileInputStream);
    }

    protected Object readExternalFormFromBytes(byte[] byArray) throws IOException, ClassNotFoundException {
        ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(byArray);
        return this.readExternalFormFromStream(byteArrayInputStream);
    }

    private Object readExternalFormFromStream(InputStream inputStream) throws IOException, ClassNotFoundException {
        ObjectInputStream objectInputStream = new ObjectInputStream(inputStream);
        return objectInputStream.readObject();
    }

    private void writeExternalFormToStream(Serializable serializable, OutputStream outputStream) throws IOException {
        ObjectOutputStream objectOutputStream = new ObjectOutputStream(outputStream);
        objectOutputStream.writeObject(serializable);
    }

    public static final class SanityTestTest
    extends ObjectAbstractTest {
        @Override
        protected Object makeObject() {
            return new Cloneable(){};
        }
    }
}

