/*
 * Decompiled with CFR 0.152.
 */
package com.twelvemonkeys.util.convert;

import com.twelvemonkeys.lang.DateUtil;
import com.twelvemonkeys.util.convert.DateConverter;
import com.twelvemonkeys.util.convert.PropertyConverter;
import com.twelvemonkeys.util.convert.PropertyConverterAbstractTest;
import java.text.DateFormat;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.TimeZone;
import org.junit.Test;

public class DateConverterTest
extends PropertyConverterAbstractTest {
    protected static final String FORMAT_STR_1 = "dd.MM.yyyy HH:mm:ss";
    protected static final String FORMAT_STR_2 = "dd-MM-yyyy hh:mm:ss a";

    @Override
    protected PropertyConverter makePropertyConverter() {
        return new DateConverter();
    }

    @Override
    protected PropertyConverterAbstractTest.Conversion[] getTestConversions() {
        long l = System.currentTimeMillis();
        Date date = new Date(DateUtil.roundToSecond((long)l));
        DateFormat dateFormat = DateFormat.getDateTimeInstance();
        return new PropertyConverterAbstractTest.Conversion[]{new PropertyConverterAbstractTest.Conversion("01.11.2006 15:26:23", new GregorianCalendar(2006, 10, 1, 15, 26, 23).getTime(), FORMAT_STR_1), new PropertyConverterAbstractTest.Conversion(dateFormat.format(date), date), new PropertyConverterAbstractTest.Conversion("01-11-2006 03:27:44 pm", new GregorianCalendar(2006, 10, 1, 15, 27, 44).getTime(), FORMAT_STR_2, "01-11-2006 03:27:44 PM"), new PropertyConverterAbstractTest.Conversion("42", new Date(42L), "S"), new PropertyConverterAbstractTest.Conversion(String.valueOf(l % 1000L), new Date(l % 1000L), "S")};
    }

    @Override
    @Test
    public void testConvert() {
        TimeZone timeZone = TimeZone.getDefault();
        try {
            TimeZone.setDefault(TimeZone.getTimeZone("GMT"));
            super.testConvert();
        }
        finally {
            TimeZone.setDefault(timeZone);
        }
    }
}

