/*
 * Decompiled with CFR 0.152.
 */
package com.twelvemonkeys.util;

import com.twelvemonkeys.util.LinkedMap;
import com.twelvemonkeys.util.MapAbstractTest;
import java.util.Iterator;
import java.util.Map;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class LinkedMapTest
extends MapAbstractTest {
    protected LinkedMap labRat;

    @Before
    public void setUp() throws Exception {
        this.labRat = (LinkedMap)this.makeEmptyMap();
    }

    @Override
    public Map makeEmptyMap() {
        return new LinkedMap();
    }

    protected Object[] getKeys() {
        return new Object[]{"foo", "baz", "eek"};
    }

    protected Object[] getValues() {
        return new Object[]{"bar", "frob", new Object()};
    }

    @Test
    public void testSequenceMap() throws Throwable {
        Object[] objectArray = this.getKeys();
        int n = objectArray.length;
        Object[] objectArray2 = this.getValues();
        for (int i = 0; i < n; ++i) {
            this.labRat.put(objectArray[i], objectArray2[i]);
        }
        Assert.assertEquals((String)"size() does not match expected size", (long)n, (long)this.labRat.size());
        LinkedMap linkedMap = (LinkedMap)this.labRat.clone();
        Assert.assertEquals((String)"Size of clone does not match original", (long)this.labRat.size(), (long)linkedMap.size());
        Iterator iterator = this.labRat.entrySet().iterator();
        Iterator iterator2 = linkedMap.entrySet().iterator();
        while (iterator.hasNext()) {
            Map.Entry entry = (Map.Entry)iterator.next();
            Map.Entry entry2 = (Map.Entry)iterator2.next();
            Assert.assertEquals((String)"Cloned key does not match original", entry.getKey(), entry2.getKey());
            Assert.assertEquals((String)"Cloned value does not match original", entry.getValue(), entry2.getValue());
            Assert.assertEquals((String)"Cloned entry does not match original", (Object)entry, (Object)entry2);
        }
        Assert.assertTrue((String)"iterator() returned different number of elements than keys()", (!iterator2.hasNext() ? 1 : 0) != 0);
    }

    @Override
    @After
    public void tearDown() throws Exception {
        this.labRat = null;
    }
}

