/*
 * Decompiled with CFR 0.152.
 */
package com.twelvemonkeys.lang;

import com.twelvemonkeys.lang.StringUtil;
import java.awt.Color;
import java.sql.Timestamp;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.Locale;
import org.junit.Assert;
import org.junit.Test;

public class StringUtilTest {
    static final Object TEST_OBJECT = new Object();
    static final Integer TEST_INTEGER = 42;
    static final String TEST_STRING = "TheQuickBrownFox";
    static final String TEST_SUB_STRING = "TheQuickBrownFox".substring(2, 5);
    static final String TEST_DELIM_STRING = "one,two, three\n four\tfive six";
    static final String[] STRING_ARRAY = new String[]{"one", "two", "three", "four", "five", "six"};
    static final String TEST_INT_DELIM_STRING = "1,2, 3\n 4\t5 6";
    static final int[] INT_ARRAY = new int[]{1, 2, 3, 4, 5, 6};
    static final String TEST_DOUBLE_DELIM_STRING = "1.4,2.1, 3\n .4\t-5 6e5";
    static final double[] DOUBLE_ARRAY = new double[]{1.4, 2.1, 3.0, 0.4, -5.0, 600000.0};
    static final String EMPTY_STRING = "";
    static final String WHITESPACE_STRING = " \t \r \n  ";

    @Test
    public void testValueOfObject() {
        Assert.assertNotNull((Object)StringUtil.valueOf((Object)TEST_OBJECT));
        Assert.assertEquals((Object)StringUtil.valueOf((Object)TEST_OBJECT), (Object)TEST_OBJECT.toString());
        Assert.assertEquals((Object)StringUtil.valueOf((Object)TEST_INTEGER), (Object)TEST_INTEGER.toString());
        Assert.assertEquals((Object)StringUtil.valueOf((Object)TEST_STRING), (Object)TEST_STRING);
        Assert.assertSame((Object)StringUtil.valueOf((Object)TEST_STRING), (Object)TEST_STRING);
        Assert.assertNull((Object)StringUtil.valueOf(null));
    }

    @Test
    public void testToUpperCase() {
        String string = StringUtil.toUpperCase((String)TEST_STRING);
        Assert.assertNotNull((Object)string);
        Assert.assertEquals((Object)TEST_STRING.toUpperCase(), (Object)string);
        Assert.assertNull((Object)StringUtil.toUpperCase(null));
    }

    @Test
    public void testToLowerCase() {
        String string = StringUtil.toLowerCase((String)TEST_STRING);
        Assert.assertNotNull((Object)string);
        Assert.assertEquals((Object)TEST_STRING.toLowerCase(), (Object)string);
        Assert.assertNull((Object)StringUtil.toLowerCase(null));
    }

    @Test
    public void testIsEmpty() {
        Assert.assertTrue((boolean)StringUtil.isEmpty((String)null));
        Assert.assertTrue((boolean)StringUtil.isEmpty((String)EMPTY_STRING));
        Assert.assertTrue((boolean)StringUtil.isEmpty((String)WHITESPACE_STRING));
        Assert.assertFalse((boolean)StringUtil.isEmpty((String)TEST_STRING));
    }

    @Test
    public void testIsEmptyArray() {
        Assert.assertTrue((boolean)StringUtil.isEmpty((String[])null));
        Assert.assertTrue((boolean)StringUtil.isEmpty((String[])new String[]{EMPTY_STRING}));
        Assert.assertTrue((boolean)StringUtil.isEmpty((String[])new String[]{EMPTY_STRING, WHITESPACE_STRING}));
        Assert.assertFalse((boolean)StringUtil.isEmpty((String[])new String[]{EMPTY_STRING, TEST_STRING}));
        Assert.assertFalse((boolean)StringUtil.isEmpty((String[])new String[]{WHITESPACE_STRING, TEST_STRING}));
    }

    @Test
    public void testContains() {
        Assert.assertTrue((boolean)StringUtil.contains((String)TEST_STRING, (String)TEST_STRING));
        Assert.assertTrue((boolean)StringUtil.contains((String)TEST_STRING, (String)TEST_SUB_STRING));
        Assert.assertTrue((boolean)StringUtil.contains((String)TEST_STRING, (String)EMPTY_STRING));
        Assert.assertFalse((boolean)StringUtil.contains((String)TEST_STRING, (String)WHITESPACE_STRING));
        Assert.assertFalse((boolean)StringUtil.contains((String)TEST_SUB_STRING, (String)TEST_STRING));
        Assert.assertFalse((boolean)StringUtil.contains((String)EMPTY_STRING, (String)TEST_STRING));
        Assert.assertFalse((boolean)StringUtil.contains((String)WHITESPACE_STRING, (String)TEST_STRING));
        Assert.assertFalse((boolean)StringUtil.contains(null, (String)TEST_STRING));
        Assert.assertFalse((boolean)StringUtil.contains(null, null));
    }

    @Test
    public void testContainsIgnoreCase() {
        Assert.assertTrue((boolean)StringUtil.containsIgnoreCase((String)TEST_STRING, (String)TEST_STRING));
        Assert.assertTrue((boolean)StringUtil.containsIgnoreCase((String)TEST_STRING.toUpperCase(), (String)TEST_STRING));
        Assert.assertTrue((boolean)StringUtil.containsIgnoreCase((String)TEST_STRING.toLowerCase(), (String)TEST_STRING));
        Assert.assertTrue((boolean)StringUtil.containsIgnoreCase((String)TEST_STRING, (String)TEST_STRING.toUpperCase()));
        Assert.assertTrue((boolean)StringUtil.containsIgnoreCase((String)TEST_STRING, (String)TEST_SUB_STRING));
        Assert.assertTrue((boolean)StringUtil.containsIgnoreCase((String)TEST_STRING.toUpperCase(), (String)TEST_SUB_STRING));
        Assert.assertTrue((boolean)StringUtil.containsIgnoreCase((String)TEST_STRING.toLowerCase(), (String)TEST_SUB_STRING));
        Assert.assertTrue((boolean)StringUtil.containsIgnoreCase((String)TEST_STRING, (String)TEST_SUB_STRING.toUpperCase()));
        Assert.assertTrue((boolean)StringUtil.containsIgnoreCase((String)TEST_STRING, (String)EMPTY_STRING));
        Assert.assertFalse((boolean)StringUtil.containsIgnoreCase((String)TEST_STRING, (String)WHITESPACE_STRING));
        Assert.assertFalse((boolean)StringUtil.containsIgnoreCase((String)TEST_SUB_STRING, (String)TEST_STRING));
        Assert.assertFalse((boolean)StringUtil.containsIgnoreCase((String)EMPTY_STRING, (String)TEST_STRING));
        Assert.assertFalse((boolean)StringUtil.containsIgnoreCase((String)WHITESPACE_STRING, (String)TEST_STRING));
        Assert.assertFalse((boolean)StringUtil.containsIgnoreCase(null, (String)TEST_STRING));
        Assert.assertFalse((boolean)StringUtil.containsIgnoreCase(null, null));
    }

    @Test
    public void testContainsChar() {
        int n;
        for (n = 0; n < TEST_STRING.length(); ++n) {
            Assert.assertTrue((boolean)StringUtil.contains((String)TEST_STRING, (int)TEST_STRING.charAt(n)));
            Assert.assertFalse((boolean)StringUtil.contains((String)EMPTY_STRING, (int)TEST_STRING.charAt(n)));
            Assert.assertFalse((boolean)StringUtil.contains((String)WHITESPACE_STRING, (int)TEST_STRING.charAt(n)));
            Assert.assertFalse((boolean)StringUtil.contains(null, (int)TEST_STRING.charAt(n)));
        }
        for (n = 0; n < TEST_SUB_STRING.length(); ++n) {
            Assert.assertTrue((boolean)StringUtil.contains((String)TEST_STRING, (int)TEST_SUB_STRING.charAt(n)));
        }
        for (n = 0; n < WHITESPACE_STRING.length(); ++n) {
            Assert.assertFalse((boolean)StringUtil.contains((String)TEST_STRING, (int)WHITESPACE_STRING.charAt(n)));
        }
        for (n = 97; n < 122; ++n) {
            if (TEST_STRING.indexOf(n) < 0) {
                Assert.assertFalse((String)("TheQuickBrownFox seems to contain '" + (char)n + "', at index " + TEST_STRING.indexOf(n)), (boolean)StringUtil.contains((String)TEST_STRING, (int)n));
                continue;
            }
            Assert.assertTrue((String)("TheQuickBrownFox seems to not contain '" + (char)n + "', at index " + TEST_STRING.indexOf(n)), (boolean)StringUtil.contains((String)TEST_STRING, (int)n));
        }
    }

    @Test
    public void testContainsIgnoreCaseChar() {
        int n;
        for (n = 0; n < TEST_STRING.length(); ++n) {
            Assert.assertTrue((boolean)StringUtil.containsIgnoreCase((String)TEST_STRING, (int)TEST_STRING.charAt(n)));
            Assert.assertTrue((boolean)StringUtil.containsIgnoreCase((String)TEST_STRING.toUpperCase(), (int)TEST_STRING.charAt(n)));
            Assert.assertTrue((boolean)StringUtil.containsIgnoreCase((String)TEST_STRING.toLowerCase(), (int)TEST_STRING.charAt(n)));
            Assert.assertTrue((boolean)StringUtil.containsIgnoreCase((String)TEST_STRING, (int)Character.toUpperCase(TEST_STRING.charAt(n))));
            Assert.assertFalse((boolean)StringUtil.containsIgnoreCase((String)EMPTY_STRING, (int)TEST_STRING.charAt(n)));
            Assert.assertFalse((boolean)StringUtil.containsIgnoreCase((String)WHITESPACE_STRING, (int)TEST_STRING.charAt(n)));
            Assert.assertFalse((boolean)StringUtil.containsIgnoreCase(null, (int)TEST_STRING.charAt(n)));
        }
        for (n = 0; n < TEST_SUB_STRING.length(); ++n) {
            Assert.assertTrue((boolean)StringUtil.containsIgnoreCase((String)TEST_STRING, (int)TEST_SUB_STRING.charAt(n)));
            Assert.assertTrue((boolean)StringUtil.containsIgnoreCase((String)TEST_STRING.toUpperCase(), (int)TEST_SUB_STRING.charAt(n)));
            Assert.assertTrue((boolean)StringUtil.containsIgnoreCase((String)TEST_STRING.toLowerCase(), (int)TEST_SUB_STRING.charAt(n)));
            Assert.assertTrue((boolean)StringUtil.containsIgnoreCase((String)TEST_STRING, (int)TEST_SUB_STRING.toUpperCase().charAt(n)));
        }
        for (n = 0; n < WHITESPACE_STRING.length(); ++n) {
            Assert.assertFalse((boolean)StringUtil.containsIgnoreCase((String)TEST_STRING, (int)WHITESPACE_STRING.charAt(n)));
        }
        for (n = 97; n < 122; ++n) {
            if (TEST_STRING.indexOf(n) < 0 && TEST_STRING.indexOf(Character.toUpperCase((char)n)) < 0) {
                Assert.assertFalse((String)("TheQuickBrownFox seems to contain '" + (char)n + "', at index " + Math.max(TEST_STRING.indexOf(n), TEST_STRING.indexOf(Character.toUpperCase((char)n)))), (boolean)StringUtil.containsIgnoreCase((String)TEST_STRING, (int)n));
                continue;
            }
            Assert.assertTrue((String)("TheQuickBrownFox seems to not contain '" + (char)n + "', at index " + TEST_STRING.indexOf(n)), (boolean)StringUtil.containsIgnoreCase((String)TEST_STRING, (int)n));
        }
    }

    @Test
    public void testIndexOfIgnoreCase() {
        int n;
        Assert.assertEquals((long)0L, (long)StringUtil.indexOfIgnoreCase((String)TEST_STRING, (String)TEST_STRING));
        Assert.assertEquals((long)0L, (long)StringUtil.indexOfIgnoreCase((String)TEST_STRING.toUpperCase(), (String)TEST_STRING));
        Assert.assertEquals((long)0L, (long)StringUtil.indexOfIgnoreCase((String)TEST_STRING.toLowerCase(), (String)TEST_STRING));
        Assert.assertEquals((long)0L, (long)StringUtil.indexOfIgnoreCase((String)TEST_STRING, (String)TEST_STRING.toUpperCase()));
        Assert.assertEquals((long)0L, (long)StringUtil.indexOfIgnoreCase((String)TEST_STRING, (String)TEST_STRING.toLowerCase()));
        for (n = 1; n < TEST_STRING.length(); ++n) {
            Assert.assertEquals((long)n, (long)StringUtil.indexOfIgnoreCase((String)TEST_STRING, (String)TEST_STRING.substring(n)));
            Assert.assertEquals((long)n, (long)StringUtil.indexOfIgnoreCase((String)TEST_STRING.toUpperCase(), (String)TEST_STRING.substring(n)));
            Assert.assertEquals((long)n, (long)StringUtil.indexOfIgnoreCase((String)TEST_STRING.toLowerCase(), (String)TEST_STRING.substring(n)));
            Assert.assertEquals((long)n, (long)StringUtil.indexOfIgnoreCase((String)TEST_STRING, (String)TEST_STRING.toUpperCase().substring(n)));
            Assert.assertEquals((long)n, (long)StringUtil.indexOfIgnoreCase((String)TEST_STRING, (String)TEST_STRING.toLowerCase().substring(n)));
        }
        Assert.assertTrue((0 <= StringUtil.indexOfIgnoreCase((String)TEST_STRING, (String)TEST_SUB_STRING) ? 1 : 0) != 0);
        Assert.assertTrue((0 <= StringUtil.indexOfIgnoreCase((String)TEST_STRING.toUpperCase(), (String)TEST_SUB_STRING) ? 1 : 0) != 0);
        Assert.assertTrue((0 <= StringUtil.indexOfIgnoreCase((String)TEST_STRING.toLowerCase(), (String)TEST_SUB_STRING) ? 1 : 0) != 0);
        Assert.assertTrue((0 <= StringUtil.indexOfIgnoreCase((String)TEST_STRING, (String)TEST_SUB_STRING.toUpperCase()) ? 1 : 0) != 0);
        Assert.assertTrue((0 <= StringUtil.indexOfIgnoreCase((String)TEST_STRING, (String)TEST_SUB_STRING.toLowerCase()) ? 1 : 0) != 0);
        for (n = 1; n < TEST_STRING.length(); ++n) {
            Assert.assertEquals((long)-1L, (long)StringUtil.indexOfIgnoreCase((String)TEST_STRING.substring(n), (String)TEST_STRING));
            Assert.assertEquals((long)-1L, (long)StringUtil.indexOfIgnoreCase((String)TEST_STRING.substring(n), (String)TEST_STRING));
        }
        Assert.assertEquals((long)-1L, (long)StringUtil.indexOfIgnoreCase(null, (String)TEST_STRING));
        Assert.assertEquals((long)-1L, (long)StringUtil.indexOfIgnoreCase(null, null));
    }

    @Test
    public void testIndexOfIgnoreCasePos() {
        Assert.assertEquals((long)-1L, (long)StringUtil.indexOfIgnoreCase((String)TEST_STRING, (String)TEST_STRING, (int)1));
        Assert.assertEquals((long)-1L, (long)StringUtil.indexOfIgnoreCase((String)TEST_STRING.toUpperCase(), (String)TEST_STRING, (int)2));
        Assert.assertEquals((long)-1L, (long)StringUtil.indexOfIgnoreCase((String)TEST_STRING.toLowerCase(), (String)TEST_STRING, (int)3));
        Assert.assertEquals((long)-1L, (long)StringUtil.indexOfIgnoreCase((String)TEST_STRING, (String)TEST_STRING.toUpperCase(), (int)4));
        Assert.assertEquals((long)-1L, (long)StringUtil.indexOfIgnoreCase((String)TEST_STRING, (String)TEST_STRING.toLowerCase(), (int)5));
        for (int i = 1; i < TEST_STRING.length(); ++i) {
            Assert.assertEquals((long)i, (long)StringUtil.indexOfIgnoreCase((String)TEST_STRING, (String)TEST_STRING.substring(i), (int)(i - 1)));
            Assert.assertEquals((long)i, (long)StringUtil.indexOfIgnoreCase((String)TEST_STRING.toUpperCase(), (String)TEST_STRING.substring(i), (int)(i - 1)));
            Assert.assertEquals((long)i, (long)StringUtil.indexOfIgnoreCase((String)TEST_STRING.toLowerCase(), (String)TEST_STRING.substring(i), (int)(i - 1)));
            Assert.assertEquals((long)i, (long)StringUtil.indexOfIgnoreCase((String)TEST_STRING, (String)TEST_STRING.toUpperCase().substring(i), (int)(i - 1)));
            Assert.assertEquals((long)i, (long)StringUtil.indexOfIgnoreCase((String)TEST_STRING, (String)TEST_STRING.toLowerCase().substring(i), (int)(i - 1)));
        }
        Assert.assertTrue((0 <= StringUtil.indexOfIgnoreCase((String)TEST_STRING, (String)TEST_SUB_STRING, (int)1) ? 1 : 0) != 0);
        Assert.assertTrue((0 <= StringUtil.indexOfIgnoreCase((String)TEST_STRING.toUpperCase(), (String)TEST_SUB_STRING, (int)1) ? 1 : 0) != 0);
        Assert.assertTrue((0 <= StringUtil.indexOfIgnoreCase((String)TEST_STRING.toLowerCase(), (String)TEST_SUB_STRING, (int)2) ? 1 : 0) != 0);
        Assert.assertTrue((0 <= StringUtil.indexOfIgnoreCase((String)TEST_STRING, (String)TEST_SUB_STRING.toUpperCase(), (int)1) ? 1 : 0) != 0);
        Assert.assertTrue((0 <= StringUtil.indexOfIgnoreCase((String)TEST_STRING, (String)TEST_SUB_STRING.toLowerCase(), (int)2) ? 1 : 0) != 0);
        Assert.assertEquals((long)-1L, (long)StringUtil.indexOfIgnoreCase(null, (String)TEST_STRING, (int)234));
        Assert.assertEquals((long)-1L, (long)StringUtil.indexOfIgnoreCase(null, null, (int)-45));
    }

    @Test
    public void testLastIndexOfIgnoreCase() {
        int n;
        Assert.assertEquals((long)0L, (long)StringUtil.lastIndexOfIgnoreCase((String)TEST_STRING, (String)TEST_STRING));
        Assert.assertEquals((long)0L, (long)StringUtil.lastIndexOfIgnoreCase((String)TEST_STRING.toUpperCase(), (String)TEST_STRING));
        Assert.assertEquals((long)0L, (long)StringUtil.lastIndexOfIgnoreCase((String)TEST_STRING.toLowerCase(), (String)TEST_STRING));
        Assert.assertEquals((long)0L, (long)StringUtil.lastIndexOfIgnoreCase((String)TEST_STRING, (String)TEST_STRING.toUpperCase()));
        Assert.assertEquals((long)0L, (long)StringUtil.lastIndexOfIgnoreCase((String)TEST_STRING, (String)TEST_STRING.toLowerCase()));
        for (n = 1; n < TEST_STRING.length(); ++n) {
            Assert.assertEquals((long)n, (long)StringUtil.lastIndexOfIgnoreCase((String)TEST_STRING, (String)TEST_STRING.substring(n)));
            Assert.assertEquals((long)n, (long)StringUtil.lastIndexOfIgnoreCase((String)TEST_STRING.toUpperCase(), (String)TEST_STRING.substring(n)));
            Assert.assertEquals((long)n, (long)StringUtil.lastIndexOfIgnoreCase((String)TEST_STRING.toLowerCase(), (String)TEST_STRING.substring(n)));
            Assert.assertEquals((long)n, (long)StringUtil.lastIndexOfIgnoreCase((String)TEST_STRING, (String)TEST_STRING.toUpperCase().substring(n)));
            Assert.assertEquals((long)n, (long)StringUtil.lastIndexOfIgnoreCase((String)TEST_STRING, (String)TEST_STRING.toLowerCase().substring(n)));
        }
        Assert.assertTrue((0 <= StringUtil.lastIndexOfIgnoreCase((String)TEST_STRING, (String)TEST_SUB_STRING) ? 1 : 0) != 0);
        Assert.assertTrue((0 <= StringUtil.lastIndexOfIgnoreCase((String)TEST_STRING.toUpperCase(), (String)TEST_SUB_STRING) ? 1 : 0) != 0);
        Assert.assertTrue((0 <= StringUtil.lastIndexOfIgnoreCase((String)TEST_STRING.toLowerCase(), (String)TEST_SUB_STRING) ? 1 : 0) != 0);
        Assert.assertTrue((0 <= StringUtil.lastIndexOfIgnoreCase((String)TEST_STRING, (String)TEST_SUB_STRING.toUpperCase()) ? 1 : 0) != 0);
        Assert.assertTrue((0 <= StringUtil.lastIndexOfIgnoreCase((String)TEST_STRING, (String)TEST_SUB_STRING.toLowerCase()) ? 1 : 0) != 0);
        for (n = 1; n < TEST_STRING.length(); ++n) {
            Assert.assertEquals((long)-1L, (long)StringUtil.lastIndexOfIgnoreCase((String)TEST_STRING.substring(n), (String)TEST_STRING));
            Assert.assertEquals((long)-1L, (long)StringUtil.lastIndexOfIgnoreCase((String)TEST_STRING.substring(n), (String)TEST_STRING));
        }
        Assert.assertEquals((long)-1L, (long)StringUtil.lastIndexOfIgnoreCase(null, (String)TEST_STRING));
        Assert.assertEquals((long)-1L, (long)StringUtil.lastIndexOfIgnoreCase(null, null));
    }

    @Test
    public void testLastIndexOfIgnoreCasePos() {
        Assert.assertEquals((long)0L, (long)StringUtil.lastIndexOfIgnoreCase((String)TEST_STRING, (String)TEST_STRING, (int)1));
        Assert.assertEquals((long)0L, (long)StringUtil.lastIndexOfIgnoreCase((String)TEST_STRING.toUpperCase(), (String)TEST_STRING, (int)2));
        Assert.assertEquals((long)0L, (long)StringUtil.lastIndexOfIgnoreCase((String)TEST_STRING.toLowerCase(), (String)TEST_STRING, (int)3));
        Assert.assertEquals((long)0L, (long)StringUtil.lastIndexOfIgnoreCase((String)TEST_STRING, (String)TEST_STRING.toUpperCase(), (int)4));
        Assert.assertEquals((long)0L, (long)StringUtil.lastIndexOfIgnoreCase((String)TEST_STRING, (String)TEST_STRING.toLowerCase(), (int)5));
        for (int i = 1; i < TEST_STRING.length(); ++i) {
            Assert.assertEquals((long)0L, (long)StringUtil.lastIndexOfIgnoreCase((String)TEST_STRING, (String)TEST_STRING.substring(0, i), (int)(i - 1)));
            Assert.assertEquals((long)0L, (long)StringUtil.lastIndexOfIgnoreCase((String)TEST_STRING.toUpperCase(), (String)TEST_STRING.substring(0, i), (int)(i - 1)));
            Assert.assertEquals((long)0L, (long)StringUtil.lastIndexOfIgnoreCase((String)TEST_STRING.toLowerCase(), (String)TEST_STRING.substring(0, i), (int)(i - 1)));
            Assert.assertEquals((long)0L, (long)StringUtil.lastIndexOfIgnoreCase((String)TEST_STRING, (String)TEST_STRING.toUpperCase().substring(0, i), (int)(i - 1)));
            Assert.assertEquals((long)0L, (long)StringUtil.lastIndexOfIgnoreCase((String)TEST_STRING, (String)TEST_STRING.toLowerCase().substring(0, i), (int)(i - 1)));
        }
        Assert.assertTrue((0 <= StringUtil.lastIndexOfIgnoreCase((String)TEST_STRING, (String)TEST_SUB_STRING, (int)(TEST_SUB_STRING.length() + 3)) ? 1 : 0) != 0);
        Assert.assertTrue((0 <= StringUtil.lastIndexOfIgnoreCase((String)TEST_STRING.toUpperCase(), (String)TEST_SUB_STRING, (int)(TEST_SUB_STRING.length() + 3)) ? 1 : 0) != 0);
        Assert.assertTrue((0 <= StringUtil.lastIndexOfIgnoreCase((String)TEST_STRING.toLowerCase(), (String)TEST_SUB_STRING, (int)(TEST_SUB_STRING.length() + 4)) ? 1 : 0) != 0);
        Assert.assertTrue((0 <= StringUtil.lastIndexOfIgnoreCase((String)TEST_STRING, (String)TEST_SUB_STRING.toUpperCase(), (int)(TEST_SUB_STRING.length() + 3)) ? 1 : 0) != 0);
        Assert.assertTrue((0 <= StringUtil.lastIndexOfIgnoreCase((String)TEST_STRING, (String)TEST_SUB_STRING.toLowerCase(), (int)(TEST_SUB_STRING.length() + 4)) ? 1 : 0) != 0);
        Assert.assertEquals((long)-1L, (long)StringUtil.lastIndexOfIgnoreCase(null, (String)TEST_STRING, (int)234));
        Assert.assertEquals((long)-1L, (long)StringUtil.lastIndexOfIgnoreCase(null, null, (int)-45));
    }

    @Test
    public void testIndexOfIgnoreCaseChar() {
        int n;
        for (n = 0; n < TEST_STRING.length(); ++n) {
            Assert.assertTrue((0 <= StringUtil.indexOfIgnoreCase((String)TEST_STRING, (int)TEST_STRING.charAt(n)) ? 1 : 0) != 0);
            Assert.assertTrue((0 <= StringUtil.indexOfIgnoreCase((String)TEST_STRING.toUpperCase(), (int)TEST_STRING.charAt(n)) ? 1 : 0) != 0);
            Assert.assertTrue((0 <= StringUtil.indexOfIgnoreCase((String)TEST_STRING.toLowerCase(), (int)TEST_STRING.charAt(n)) ? 1 : 0) != 0);
            Assert.assertTrue((0 <= StringUtil.indexOfIgnoreCase((String)TEST_STRING, (int)Character.toUpperCase(TEST_STRING.charAt(n))) ? 1 : 0) != 0);
            Assert.assertEquals((long)-1L, (long)StringUtil.indexOfIgnoreCase((String)EMPTY_STRING, (int)TEST_STRING.charAt(n)));
            Assert.assertEquals((long)-1L, (long)StringUtil.indexOfIgnoreCase((String)WHITESPACE_STRING, (int)TEST_STRING.charAt(n)));
            Assert.assertEquals((long)-1L, (long)StringUtil.indexOfIgnoreCase(null, (int)TEST_STRING.charAt(n)));
        }
        for (n = 0; n < TEST_SUB_STRING.length(); ++n) {
            Assert.assertTrue((0 <= StringUtil.indexOfIgnoreCase((String)TEST_STRING, (int)TEST_SUB_STRING.charAt(n)) ? 1 : 0) != 0);
            Assert.assertTrue((0 <= StringUtil.indexOfIgnoreCase((String)TEST_STRING.toUpperCase(), (int)TEST_SUB_STRING.charAt(n)) ? 1 : 0) != 0);
            Assert.assertTrue((0 <= StringUtil.indexOfIgnoreCase((String)TEST_STRING.toLowerCase(), (int)TEST_SUB_STRING.charAt(n)) ? 1 : 0) != 0);
            Assert.assertTrue((0 <= StringUtil.indexOfIgnoreCase((String)TEST_STRING, (int)TEST_SUB_STRING.toUpperCase().charAt(n)) ? 1 : 0) != 0);
        }
        for (n = 0; n < WHITESPACE_STRING.length(); ++n) {
            Assert.assertEquals((long)-1L, (long)StringUtil.indexOfIgnoreCase((String)TEST_STRING, (int)WHITESPACE_STRING.charAt(n)));
        }
        for (n = 97; n < 122; ++n) {
            if (TEST_STRING.indexOf(n) < 0 && TEST_STRING.indexOf(Character.toUpperCase((char)n)) < 0) {
                Assert.assertEquals((String)("TheQuickBrownFox seems to contain '" + (char)n + "', at index " + Math.max(TEST_STRING.indexOf(n), TEST_STRING.indexOf(Character.toUpperCase((char)n)))), (long)-1L, (long)StringUtil.indexOfIgnoreCase((String)TEST_STRING, (int)n));
                continue;
            }
            Assert.assertTrue((String)("TheQuickBrownFox seems to not contain '" + (char)n + "', at index " + TEST_STRING.indexOf(n)), (0 <= StringUtil.indexOfIgnoreCase((String)TEST_STRING, (int)n) ? 1 : 0) != 0);
        }
    }

    @Test
    public void testIndexOfIgnoreCaseCharPos() {
        int n;
        for (n = 0; n < TEST_STRING.length(); ++n) {
            Assert.assertTrue((0 <= StringUtil.indexOfIgnoreCase((String)TEST_STRING, (int)TEST_STRING.charAt(n), (int)n) ? 1 : 0) != 0);
            Assert.assertTrue((0 <= StringUtil.indexOfIgnoreCase((String)TEST_STRING.toUpperCase(), (int)TEST_STRING.charAt(n), (int)n) ? 1 : 0) != 0);
            Assert.assertTrue((0 <= StringUtil.indexOfIgnoreCase((String)TEST_STRING.toLowerCase(), (int)TEST_STRING.charAt(n), (int)n) ? 1 : 0) != 0);
            Assert.assertTrue((0 <= StringUtil.indexOfIgnoreCase((String)TEST_STRING, (int)Character.toUpperCase(TEST_STRING.charAt(n)), (int)n) ? 1 : 0) != 0);
            Assert.assertEquals((long)-1L, (long)StringUtil.indexOfIgnoreCase((String)EMPTY_STRING, (int)TEST_STRING.charAt(n), (int)n));
            Assert.assertEquals((long)-1L, (long)StringUtil.indexOfIgnoreCase((String)WHITESPACE_STRING, (int)TEST_STRING.charAt(n), (int)n));
            Assert.assertEquals((long)-1L, (long)StringUtil.indexOfIgnoreCase(null, (int)TEST_STRING.charAt(n), (int)n));
        }
        for (n = 0; n < TEST_SUB_STRING.length(); ++n) {
            Assert.assertTrue((0 <= StringUtil.indexOfIgnoreCase((String)TEST_STRING, (int)TEST_SUB_STRING.charAt(n), (int)n) ? 1 : 0) != 0);
            Assert.assertTrue((0 <= StringUtil.indexOfIgnoreCase((String)TEST_STRING.toUpperCase(), (int)TEST_SUB_STRING.charAt(n), (int)n) ? 1 : 0) != 0);
            Assert.assertTrue((0 <= StringUtil.indexOfIgnoreCase((String)TEST_STRING.toLowerCase(), (int)TEST_SUB_STRING.charAt(n), (int)n) ? 1 : 0) != 0);
            Assert.assertTrue((0 <= StringUtil.indexOfIgnoreCase((String)TEST_STRING, (int)TEST_SUB_STRING.toUpperCase().charAt(n), (int)n) ? 1 : 0) != 0);
        }
        for (n = 0; n < WHITESPACE_STRING.length(); ++n) {
            Assert.assertEquals((long)-1L, (long)StringUtil.indexOfIgnoreCase((String)TEST_STRING, (int)WHITESPACE_STRING.charAt(n), (int)n));
        }
        for (n = 97; n < 122; ++n) {
            if (TEST_STRING.indexOf(n) < 0 && TEST_STRING.indexOf(Character.toUpperCase((char)n)) < 0) {
                Assert.assertEquals((String)("TheQuickBrownFox seems to contain '" + (char)n + "', at index " + Math.max(TEST_STRING.indexOf(n), TEST_STRING.indexOf(Character.toUpperCase((char)n)))), (long)-1L, (long)StringUtil.indexOfIgnoreCase((String)TEST_STRING, (int)n, (int)0));
                continue;
            }
            Assert.assertTrue((String)("TheQuickBrownFox seems to not contain '" + (char)n + "', at index " + TEST_STRING.indexOf(n)), (0 <= StringUtil.indexOfIgnoreCase((String)TEST_STRING, (int)n, (int)0) ? 1 : 0) != 0);
        }
    }

    @Test
    public void testLastIndexOfIgnoreCaseChar() {
        int n;
        for (n = 0; n < TEST_STRING.length(); ++n) {
            Assert.assertTrue((0 <= StringUtil.lastIndexOfIgnoreCase((String)TEST_STRING, (int)TEST_STRING.charAt(n)) ? 1 : 0) != 0);
            Assert.assertTrue((0 <= StringUtil.lastIndexOfIgnoreCase((String)TEST_STRING.toUpperCase(), (int)TEST_STRING.charAt(n)) ? 1 : 0) != 0);
            Assert.assertTrue((0 <= StringUtil.lastIndexOfIgnoreCase((String)TEST_STRING.toLowerCase(), (int)TEST_STRING.charAt(n)) ? 1 : 0) != 0);
            Assert.assertTrue((0 <= StringUtil.lastIndexOfIgnoreCase((String)TEST_STRING, (int)Character.toUpperCase(TEST_STRING.charAt(n))) ? 1 : 0) != 0);
            Assert.assertEquals((long)-1L, (long)StringUtil.lastIndexOfIgnoreCase((String)EMPTY_STRING, (int)TEST_STRING.charAt(n)));
            Assert.assertEquals((long)-1L, (long)StringUtil.lastIndexOfIgnoreCase((String)WHITESPACE_STRING, (int)TEST_STRING.charAt(n)));
            Assert.assertEquals((long)-1L, (long)StringUtil.lastIndexOfIgnoreCase(null, (int)TEST_STRING.charAt(n)));
        }
        for (n = 0; n < TEST_SUB_STRING.length(); ++n) {
            Assert.assertTrue((0 <= StringUtil.lastIndexOfIgnoreCase((String)TEST_STRING, (int)TEST_SUB_STRING.charAt(n)) ? 1 : 0) != 0);
            Assert.assertTrue((0 <= StringUtil.lastIndexOfIgnoreCase((String)TEST_STRING.toUpperCase(), (int)TEST_SUB_STRING.charAt(n)) ? 1 : 0) != 0);
            Assert.assertTrue((0 <= StringUtil.lastIndexOfIgnoreCase((String)TEST_STRING.toLowerCase(), (int)TEST_SUB_STRING.charAt(n)) ? 1 : 0) != 0);
            Assert.assertTrue((0 <= StringUtil.lastIndexOfIgnoreCase((String)TEST_STRING, (int)TEST_SUB_STRING.toUpperCase().charAt(n)) ? 1 : 0) != 0);
        }
        for (n = 0; n < WHITESPACE_STRING.length(); ++n) {
            Assert.assertEquals((long)-1L, (long)StringUtil.lastIndexOfIgnoreCase((String)TEST_STRING, (int)WHITESPACE_STRING.charAt(n)));
        }
        for (n = 97; n < 122; ++n) {
            if (TEST_STRING.indexOf(n) < 0 && TEST_STRING.indexOf(Character.toUpperCase((char)n)) < 0) {
                Assert.assertEquals((String)("TheQuickBrownFox seems to contain '" + (char)n + "', at index " + Math.max(TEST_STRING.indexOf(n), TEST_STRING.indexOf(Character.toUpperCase((char)n)))), (long)-1L, (long)StringUtil.lastIndexOfIgnoreCase((String)TEST_STRING, (int)n));
                continue;
            }
            Assert.assertTrue((String)("TheQuickBrownFox seems to not contain '" + (char)n + "', at index " + TEST_STRING.indexOf(n)), (0 <= StringUtil.lastIndexOfIgnoreCase((String)TEST_STRING, (int)n) ? 1 : 0) != 0);
        }
    }

    @Test
    public void testLastIndexOfIgnoreCaseCharPos() {
        int n;
        for (n = 0; n < TEST_STRING.length(); ++n) {
            Assert.assertTrue((0 <= StringUtil.lastIndexOfIgnoreCase((String)TEST_STRING, (int)TEST_STRING.charAt(n), (int)n) ? 1 : 0) != 0);
            Assert.assertTrue((0 <= StringUtil.lastIndexOfIgnoreCase((String)TEST_STRING.toUpperCase(), (int)TEST_STRING.charAt(n), (int)n) ? 1 : 0) != 0);
            Assert.assertTrue((0 <= StringUtil.lastIndexOfIgnoreCase((String)TEST_STRING.toLowerCase(), (int)TEST_STRING.charAt(n), (int)n) ? 1 : 0) != 0);
            Assert.assertTrue((0 <= StringUtil.lastIndexOfIgnoreCase((String)TEST_STRING, (int)Character.toUpperCase(TEST_STRING.charAt(n)), (int)n) ? 1 : 0) != 0);
            Assert.assertEquals((long)-1L, (long)StringUtil.lastIndexOfIgnoreCase((String)EMPTY_STRING, (int)TEST_STRING.charAt(n), (int)n));
            Assert.assertEquals((long)-1L, (long)StringUtil.lastIndexOfIgnoreCase((String)WHITESPACE_STRING, (int)TEST_STRING.charAt(n), (int)n));
            Assert.assertEquals((long)-1L, (long)StringUtil.lastIndexOfIgnoreCase(null, (int)TEST_STRING.charAt(n), (int)n));
        }
        for (n = 0; n < TEST_SUB_STRING.length(); ++n) {
            Assert.assertTrue((0 <= StringUtil.lastIndexOfIgnoreCase((String)TEST_STRING, (int)TEST_SUB_STRING.charAt(n), (int)TEST_STRING.length()) ? 1 : 0) != 0);
            Assert.assertTrue((0 <= StringUtil.lastIndexOfIgnoreCase((String)TEST_STRING.toUpperCase(), (int)TEST_SUB_STRING.charAt(n), (int)TEST_STRING.length()) ? 1 : 0) != 0);
            Assert.assertTrue((0 <= StringUtil.lastIndexOfIgnoreCase((String)TEST_STRING.toLowerCase(), (int)TEST_SUB_STRING.charAt(n), (int)TEST_STRING.length()) ? 1 : 0) != 0);
            Assert.assertTrue((0 <= StringUtil.lastIndexOfIgnoreCase((String)TEST_STRING, (int)TEST_SUB_STRING.toUpperCase().charAt(n), (int)TEST_STRING.length()) ? 1 : 0) != 0);
        }
        for (n = 0; n < WHITESPACE_STRING.length(); ++n) {
            Assert.assertEquals((long)-1L, (long)StringUtil.lastIndexOfIgnoreCase((String)TEST_STRING, (int)WHITESPACE_STRING.charAt(n), (int)TEST_STRING.length()));
        }
        for (n = 97; n < 122; ++n) {
            if (TEST_STRING.indexOf(n) < 0 && TEST_STRING.indexOf(Character.toUpperCase((char)n)) < 0) {
                Assert.assertEquals((String)("TheQuickBrownFox seems to contain '" + (char)n + "', at index " + Math.max(TEST_STRING.indexOf(n), TEST_STRING.indexOf(Character.toUpperCase((char)n)))), (long)-1L, (long)StringUtil.lastIndexOfIgnoreCase((String)TEST_STRING, (int)n, (int)TEST_STRING.length()));
                continue;
            }
            Assert.assertTrue((String)("TheQuickBrownFox seems to not contain '" + (char)n + "', at index " + TEST_STRING.indexOf(n)), (0 <= StringUtil.lastIndexOfIgnoreCase((String)TEST_STRING, (int)n, (int)TEST_STRING.length()) ? 1 : 0) != 0);
        }
    }

    @Test
    public void testLtrim() {
        Assert.assertEquals((Object)TEST_STRING, (Object)StringUtil.ltrim((String)TEST_STRING));
        Assert.assertEquals((Object)TEST_STRING, (Object)StringUtil.ltrim((String)"  TheQuickBrownFox"));
        Assert.assertEquals((Object)TEST_STRING, (Object)StringUtil.ltrim((String)" \t \r \n  TheQuickBrownFox"));
        Assert.assertNotEquals((Object)TEST_STRING, (Object)StringUtil.ltrim((String)"TheQuickBrownFox \t \r \n  "));
    }

    @Test
    public void testRtrim() {
        Assert.assertEquals((Object)TEST_STRING, (Object)StringUtil.rtrim((String)TEST_STRING));
        Assert.assertEquals((Object)TEST_STRING, (Object)StringUtil.rtrim((String)"TheQuickBrownFox  "));
        Assert.assertEquals((Object)TEST_STRING, (Object)StringUtil.rtrim((String)"TheQuickBrownFox \t \r \n  "));
        Assert.assertNotEquals((Object)TEST_STRING, (Object)StringUtil.rtrim((String)" \t \r \n  TheQuickBrownFox"));
    }

    @Test
    public void testReplace() {
        Assert.assertEquals((Object)EMPTY_STRING, (Object)StringUtil.replace((String)TEST_STRING, (String)TEST_STRING, (String)EMPTY_STRING));
        Assert.assertEquals((Object)EMPTY_STRING, (Object)StringUtil.replace((String)EMPTY_STRING, (String)EMPTY_STRING, (String)EMPTY_STRING));
        Assert.assertEquals((Object)EMPTY_STRING, (Object)StringUtil.replace((String)EMPTY_STRING, (String)"xyzzy", (String)"xyzzy"));
        Assert.assertEquals((Object)TEST_STRING, (Object)StringUtil.replace((String)TEST_STRING, (String)EMPTY_STRING, (String)"xyzzy"));
        Assert.assertEquals((Object)"aabbdd", (Object)StringUtil.replace((String)"aabbccdd", (String)"c", (String)EMPTY_STRING));
        Assert.assertEquals((Object)"aabbccdd", (Object)StringUtil.replace((String)"aabbdd", (String)"bd", (String)"bccd"));
    }

    @Test
    public void testReplaceIgnoreCase() {
        Assert.assertEquals((Object)EMPTY_STRING, (Object)StringUtil.replaceIgnoreCase((String)TEST_STRING, (String)TEST_STRING.toUpperCase(), (String)EMPTY_STRING));
        Assert.assertEquals((Object)EMPTY_STRING, (Object)StringUtil.replaceIgnoreCase((String)EMPTY_STRING, (String)EMPTY_STRING, (String)EMPTY_STRING));
        Assert.assertEquals((Object)EMPTY_STRING, (Object)StringUtil.replaceIgnoreCase((String)EMPTY_STRING, (String)"xyzzy", (String)"xyzzy"));
        Assert.assertEquals((Object)TEST_STRING, (Object)StringUtil.replaceIgnoreCase((String)TEST_STRING, (String)EMPTY_STRING, (String)"xyzzy"));
        Assert.assertEquals((Object)"aabbdd", (Object)StringUtil.replaceIgnoreCase((String)"aabbCCdd", (String)"c", (String)EMPTY_STRING));
        Assert.assertEquals((Object)"aabbdd", (Object)StringUtil.replaceIgnoreCase((String)"aabbccdd", (String)"C", (String)EMPTY_STRING));
        Assert.assertEquals((Object)"aabbccdd", (Object)StringUtil.replaceIgnoreCase((String)"aabbdd", (String)"BD", (String)"bccd"));
        Assert.assertEquals((Object)"aabbccdd", (Object)StringUtil.replaceIgnoreCase((String)"aabBDd", (String)"bd", (String)"bccd"));
    }

    @Test
    public void testCut() {
        Assert.assertEquals((Object)TEST_STRING, (Object)StringUtil.cut((String)TEST_STRING, (int)TEST_STRING.length(), (String)".."));
        Assert.assertEquals((Object)"This is a test..", (Object)StringUtil.cut((String)"This is a test of how this works", (int)16, (String)".."));
        Assert.assertEquals((Object)"This is a test", (Object)StringUtil.cut((String)"This is a test of how this works", (int)16, null));
        Assert.assertEquals((Object)"This is a test", (Object)StringUtil.cut((String)"This is a test of how this works", (int)16, (String)EMPTY_STRING));
    }

    @Test
    public void testCaptialize() {
        Assert.assertNull((Object)StringUtil.capitalize(null));
        Assert.assertEquals((Object)TEST_STRING.toUpperCase(), (Object)StringUtil.capitalize((String)TEST_STRING.toUpperCase()));
        Assert.assertEquals((long)65L, (long)StringUtil.capitalize((String)"abc").charAt(0));
    }

    @Test
    public void testCaptializePos() {
        Assert.assertNull((Object)StringUtil.capitalize(null, (int)45));
        Assert.assertEquals((Object)TEST_STRING, (Object)StringUtil.capitalize((String)TEST_STRING, (int)(TEST_STRING.length() + 45)));
        for (int i = 0; i < TEST_STRING.length(); ++i) {
            Assert.assertTrue((boolean)Character.isUpperCase(StringUtil.capitalize((String)TEST_STRING, (int)i).charAt(i)));
        }
    }

    @Test
    public void testPad() {
        Assert.assertEquals((Object)"TheQuickBrownFox...", (Object)StringUtil.pad((String)TEST_STRING, (int)(TEST_STRING.length() + 3), (String)"..", (boolean)false));
        Assert.assertEquals((Object)TEST_STRING, (Object)StringUtil.pad((String)TEST_STRING, (int)4, (String)".", (boolean)false));
        Assert.assertEquals((Object)TEST_STRING, (Object)StringUtil.pad((String)TEST_STRING, (int)4, (String)".", (boolean)true));
        Assert.assertEquals((Object)"...TheQuickBrownFox", (Object)StringUtil.pad((String)TEST_STRING, (int)(TEST_STRING.length() + 3), (String)"..", (boolean)true));
    }

    @Test
    public void testToDate() {
        long l = System.currentTimeMillis();
        Date date = new Date(l - l % 60000L);
        Date date2 = StringUtil.toDate((String)DateFormat.getInstance().format(date));
        Assert.assertNotNull((Object)date2);
        Assert.assertEquals((Object)date, (Object)date2);
    }

    @Test
    public void testToDateWithFormatString() {
        GregorianCalendar gregorianCalendar = new GregorianCalendar();
        gregorianCalendar.clear();
        gregorianCalendar.set(1976, 2, 16);
        Date date = StringUtil.toDate((String)"16.03.1976", (String)"dd.MM.yyyy");
        Assert.assertNotNull((Object)date);
        Assert.assertEquals((Object)gregorianCalendar.getTime(), (Object)date);
        gregorianCalendar.clear();
        gregorianCalendar.set(2004, 4, 13, 23, 51, 3);
        date = StringUtil.toDate((String)"2004-5-13 23:51 (03)", (String)"yyyy-MM-dd hh:mm (ss)");
        Assert.assertNotNull((Object)date);
        Assert.assertEquals((Object)gregorianCalendar.getTime(), (Object)date);
        gregorianCalendar.clear();
        gregorianCalendar.set(10, 1);
        gregorianCalendar.set(12, 2);
        gregorianCalendar.set(13, 3);
        date = StringUtil.toDate((String)"123", (String)"hms");
        Assert.assertNotNull((Object)date);
        Assert.assertEquals((Object)gregorianCalendar.getTime(), (Object)date);
    }

    @Test
    public void testToDateWithFormat() {
        GregorianCalendar gregorianCalendar = new GregorianCalendar();
        gregorianCalendar.clear();
        gregorianCalendar.set(1976, 2, 16);
        Date date = StringUtil.toDate((String)"16.03.1976", (DateFormat)new SimpleDateFormat("dd.MM.yyyy"));
        Assert.assertNotNull((Object)date);
        Assert.assertEquals((Object)gregorianCalendar.getTime(), (Object)date);
        gregorianCalendar.clear();
        gregorianCalendar.set(2004, 4, 13, 23, 51);
        DateFormat dateFormat = DateFormat.getDateTimeInstance(3, 3, new Locale("no", "NO"));
        date = StringUtil.toDate((String)dateFormat.format(gregorianCalendar.getTime()), (DateFormat)dateFormat);
        Assert.assertNotNull((Object)date);
        Assert.assertEquals((Object)gregorianCalendar.getTime(), (Object)date);
        gregorianCalendar.clear();
        gregorianCalendar.set(10, 1);
        gregorianCalendar.set(12, 2);
        dateFormat = new SimpleDateFormat("HH:mm");
        date = StringUtil.toDate((String)"1:02", (DateFormat)dateFormat);
        Assert.assertNotNull((Object)date);
        Assert.assertEquals((Object)gregorianCalendar.getTime(), (Object)date);
    }

    @Test
    public void testToTimestamp() {
        GregorianCalendar gregorianCalendar = new GregorianCalendar();
        gregorianCalendar.clear();
        gregorianCalendar.set(1976, 2, 16, 21, 28, 4);
        Timestamp timestamp = StringUtil.toTimestamp((String)"1976-03-16 21:28:04");
        Assert.assertNotNull((Object)timestamp);
        Assert.assertEquals((Object)gregorianCalendar.getTime(), (Object)timestamp);
    }

    @Test
    public void testToStringArray() {
        String[] stringArray = StringUtil.toStringArray((String)TEST_DELIM_STRING);
        Assert.assertNotNull((Object)stringArray);
        Assert.assertEquals((long)STRING_ARRAY.length, (long)stringArray.length);
        for (int i = 0; i < stringArray.length; ++i) {
            Assert.assertEquals((Object)STRING_ARRAY[i], (Object)stringArray[i]);
        }
    }

    @Test
    public void testToStringArrayDelim() {
        int n;
        String[] stringArray = StringUtil.toStringArray((String)"-1---2-3--4-5", (String)"---");
        String[] stringArray2 = new String[]{"1", "2", "3", "4", "5"};
        Assert.assertNotNull((Object)stringArray);
        Assert.assertEquals((long)stringArray2.length, (long)stringArray.length);
        for (n = 0; n < stringArray.length; ++n) {
            Assert.assertEquals((Object)stringArray2[n], (Object)stringArray[n]);
        }
        stringArray = StringUtil.toStringArray((String)"1, 2, 3; 4 5", (String)",; ");
        Assert.assertNotNull((Object)stringArray);
        Assert.assertEquals((long)stringArray2.length, (long)stringArray.length);
        for (n = 0; n < stringArray.length; ++n) {
            Assert.assertEquals((Object)stringArray2[n], (Object)stringArray[n]);
        }
    }

    @Test
    public void testToIntArray() {
        int[] nArray = StringUtil.toIntArray((String)TEST_INT_DELIM_STRING);
        Assert.assertNotNull((Object)nArray);
        Assert.assertEquals((long)INT_ARRAY.length, (long)nArray.length);
        for (int i = 0; i < nArray.length; ++i) {
            Assert.assertEquals((long)INT_ARRAY[i], (long)nArray[i]);
        }
    }

    @Test
    public void testToIntArrayDelim() {
        int n;
        int[] nArray = StringUtil.toIntArray((String)"-1---2-3--4-5", (String)"---");
        int[] nArray2 = new int[]{1, 2, 3, 4, 5};
        Assert.assertNotNull((Object)nArray);
        Assert.assertEquals((long)nArray2.length, (long)nArray.length);
        for (n = 0; n < nArray.length; ++n) {
            Assert.assertEquals((long)nArray2[n], (long)nArray[n]);
        }
        nArray = StringUtil.toIntArray((String)"1, 2, 3; 4 5", (String)",; ");
        Assert.assertNotNull((Object)nArray);
        Assert.assertEquals((long)nArray2.length, (long)nArray.length);
        for (n = 0; n < nArray.length; ++n) {
            Assert.assertEquals((long)nArray2[n], (long)nArray[n]);
        }
    }

    @Test
    public void testToIntArrayDelimBase() {
        int n;
        int[] nArray = StringUtil.toIntArray((String)"-1___2_3__F_a", (String)"___", (int)16);
        int[] nArray2 = new int[]{-1, 2, 3, 15, 10};
        Assert.assertNotNull((Object)nArray);
        Assert.assertEquals((long)nArray2.length, (long)nArray.length);
        for (n = 0; n < nArray.length; ++n) {
            Assert.assertEquals((long)nArray2[n], (long)nArray[n]);
        }
        nArray = StringUtil.toIntArray((String)"-1, 2, 3; 17 12", (String)",; ", (int)8);
        Assert.assertNotNull((Object)nArray);
        Assert.assertEquals((long)nArray2.length, (long)nArray.length);
        for (n = 0; n < nArray.length; ++n) {
            Assert.assertEquals((long)nArray2[n], (long)nArray[n]);
        }
    }

    @Test
    public void testToLongArray() {
        long[] lArray = StringUtil.toLongArray((String)TEST_INT_DELIM_STRING);
        Assert.assertNotNull((Object)lArray);
        Assert.assertEquals((long)INT_ARRAY.length, (long)lArray.length);
        for (int i = 0; i < lArray.length; ++i) {
            Assert.assertEquals((long)INT_ARRAY[i], (long)lArray[i]);
        }
    }

    @Test
    public void testToLongArrayDelim() {
        int n;
        long[] lArray = StringUtil.toLongArray((String)"-12854928752983___2_3__4_5", (String)"___");
        long[] lArray2 = new long[]{-12854928752983L, 2L, 3L, 4L, 5L};
        Assert.assertNotNull((Object)lArray);
        Assert.assertEquals((long)lArray2.length, (long)lArray.length);
        for (n = 0; n < lArray.length; ++n) {
            Assert.assertEquals((long)lArray2[n], (long)lArray[n]);
        }
        lArray = StringUtil.toLongArray((String)"-12854928752983, 2, 3; 4 5", (String)",; ");
        Assert.assertNotNull((Object)lArray);
        Assert.assertEquals((long)lArray2.length, (long)lArray.length);
        for (n = 0; n < lArray.length; ++n) {
            Assert.assertEquals((long)lArray2[n], (long)lArray[n]);
        }
    }

    @Test
    public void testToDoubleArray() {
        double[] dArray = StringUtil.toDoubleArray((String)TEST_DOUBLE_DELIM_STRING);
        Assert.assertNotNull((Object)dArray);
        Assert.assertEquals((long)DOUBLE_ARRAY.length, (long)dArray.length);
        for (int i = 0; i < dArray.length; ++i) {
            Assert.assertEquals((double)DOUBLE_ARRAY[i], (double)dArray[i], (double)0.0);
        }
    }

    @Test
    public void testToDoubleArrayDelim() {
        int n;
        double[] dArray = StringUtil.toDoubleArray((String)"-12854928752983___.2_3__4_5e4", (String)"___");
        double[] dArray2 = new double[]{-1.2854928752983E13, 0.2, 3.0, 4.0, 50000.0};
        Assert.assertNotNull((Object)dArray);
        Assert.assertEquals((long)dArray2.length, (long)dArray.length);
        for (n = 0; n < dArray.length; ++n) {
            Assert.assertEquals((double)dArray2[n], (double)dArray[n], (double)0.0);
        }
        dArray = StringUtil.toDoubleArray((String)"-12854928752983, .2, 3; 4 5E4", (String)",; ");
        Assert.assertNotNull((Object)dArray);
        Assert.assertEquals((long)dArray2.length, (long)dArray.length);
        for (n = 0; n < dArray.length; ++n) {
            Assert.assertEquals((double)dArray2[n], (double)dArray[n], (double)0.0);
        }
    }

    @Test
    public void testTestToColor() {
        Assert.assertEquals((Object)Color.black, (Object)StringUtil.toColor((String)"black"));
        Assert.assertEquals((Object)Color.black, (Object)StringUtil.toColor((String)"BLACK"));
        Assert.assertEquals((Object)Color.blue, (Object)StringUtil.toColor((String)"blue"));
        Assert.assertEquals((Object)Color.blue, (Object)StringUtil.toColor((String)"BLUE"));
        Assert.assertEquals((Object)Color.cyan, (Object)StringUtil.toColor((String)"cyan"));
        Assert.assertEquals((Object)Color.cyan, (Object)StringUtil.toColor((String)"CYAN"));
        Assert.assertEquals((Object)Color.darkGray, (Object)StringUtil.toColor((String)"darkGray"));
        Assert.assertEquals((Object)Color.darkGray, (Object)StringUtil.toColor((String)"DARK_GRAY"));
        Assert.assertEquals((Object)Color.gray, (Object)StringUtil.toColor((String)"gray"));
        Assert.assertEquals((Object)Color.gray, (Object)StringUtil.toColor((String)"GRAY"));
        Assert.assertEquals((Object)Color.green, (Object)StringUtil.toColor((String)"green"));
        Assert.assertEquals((Object)Color.green, (Object)StringUtil.toColor((String)"GREEN"));
        Assert.assertEquals((Object)Color.lightGray, (Object)StringUtil.toColor((String)"lightGray"));
        Assert.assertEquals((Object)Color.lightGray, (Object)StringUtil.toColor((String)"LIGHT_GRAY"));
        Assert.assertEquals((Object)Color.magenta, (Object)StringUtil.toColor((String)"magenta"));
        Assert.assertEquals((Object)Color.magenta, (Object)StringUtil.toColor((String)"MAGENTA"));
        Assert.assertEquals((Object)Color.orange, (Object)StringUtil.toColor((String)"orange"));
        Assert.assertEquals((Object)Color.orange, (Object)StringUtil.toColor((String)"ORANGE"));
        Assert.assertEquals((Object)Color.pink, (Object)StringUtil.toColor((String)"pink"));
        Assert.assertEquals((Object)Color.pink, (Object)StringUtil.toColor((String)"PINK"));
        Assert.assertEquals((Object)Color.red, (Object)StringUtil.toColor((String)"red"));
        Assert.assertEquals((Object)Color.red, (Object)StringUtil.toColor((String)"RED"));
        Assert.assertEquals((Object)Color.white, (Object)StringUtil.toColor((String)"white"));
        Assert.assertEquals((Object)Color.white, (Object)StringUtil.toColor((String)"WHITE"));
        Assert.assertEquals((Object)Color.yellow, (Object)StringUtil.toColor((String)"yellow"));
        Assert.assertEquals((Object)Color.yellow, (Object)StringUtil.toColor((String)"YELLOW"));
        for (int i = 0; i < 256; ++i) {
            int n = i;
            if (i < 16) {
                n = i * 16;
            }
            String string = "#" + Integer.toHexString(i) + Integer.toHexString(i) + Integer.toHexString(i);
            String string2 = "#" + Integer.toHexString(i) + Integer.toHexString(i) + Integer.toHexString(i) + Integer.toHexString(i);
            Assert.assertEquals((Object)new Color(n, n, n), (Object)StringUtil.toColor((String)string));
            Assert.assertEquals((Object)new Color(n, n, n, n), (Object)StringUtil.toColor((String)string2));
        }
        Assert.assertNull((Object)StringUtil.toColor(null));
        try {
            StringUtil.toColor((String)"illegal-color-value");
            Assert.fail((String)"toColor with illegal color value should throw IllegalArgumentException.");
        }
        catch (IllegalArgumentException illegalArgumentException) {
            Assert.assertNotNull((Object)illegalArgumentException.getMessage());
        }
    }

    @Test
    public void testToColorString() {
        Assert.assertEquals((Object)"#ff0000", (Object)StringUtil.toColorString((Color)Color.red));
        Assert.assertEquals((Object)"#00ff00", (Object)StringUtil.toColorString((Color)Color.green));
        Assert.assertEquals((Object)"#0000ff", (Object)StringUtil.toColorString((Color)Color.blue));
        Assert.assertEquals((Object)"#101010", (Object)StringUtil.toColorString((Color)new Color(16, 16, 16)));
        for (int i = 0; i < 256; ++i) {
            String string = (i < 16 ? "0" : EMPTY_STRING) + Integer.toHexString(i);
            Assert.assertEquals((Object)("#" + string + string + string), (Object)StringUtil.toColorString((Color)new Color(i, i, i)));
        }
        Assert.assertNull((Object)StringUtil.toColorString(null));
    }

    @Test
    public void testIsNumber() {
        Assert.assertTrue((boolean)StringUtil.isNumber((String)"0"));
        Assert.assertTrue((boolean)StringUtil.isNumber((String)"12345"));
        Assert.assertTrue((boolean)StringUtil.isNumber((String)TEST_INTEGER.toString()));
        Assert.assertTrue((boolean)StringUtil.isNumber((String)"1234567890123456789012345678901234567890"));
        Assert.assertTrue((boolean)StringUtil.isNumber((String)(String.valueOf(Long.MAX_VALUE) + Long.MAX_VALUE)));
        Assert.assertFalse((boolean)StringUtil.isNumber((String)"abc"));
        Assert.assertFalse((boolean)StringUtil.isNumber((String)TEST_STRING));
    }

    @Test
    public void testIsNumberNegative() {
        Assert.assertTrue((boolean)StringUtil.isNumber((String)"-12345"));
        Assert.assertTrue((boolean)StringUtil.isNumber((String)('-' + TEST_INTEGER.toString())));
        Assert.assertTrue((boolean)StringUtil.isNumber((String)"-1234567890123456789012345678901234567890"));
        Assert.assertTrue((boolean)StringUtil.isNumber((String)('-' + String.valueOf(Long.MAX_VALUE) + Long.MAX_VALUE)));
        Assert.assertFalse((boolean)StringUtil.isNumber((String)"-abc"));
        Assert.assertFalse((boolean)StringUtil.isNumber((String)"-TheQuickBrownFox"));
    }

    @Test
    public void testCamelToLispNull() {
        try {
            StringUtil.camelToLisp(null);
            Assert.fail((String)"should not accept null");
        }
        catch (IllegalArgumentException illegalArgumentException) {
            Assert.assertNotNull((Object)illegalArgumentException.getMessage());
        }
    }

    @Test
    public void testCamelToLispNoConversion() {
        Assert.assertEquals((Object)EMPTY_STRING, (Object)StringUtil.camelToLisp((String)EMPTY_STRING));
        Assert.assertEquals((Object)"equal", (Object)StringUtil.camelToLisp((String)"equal"));
        Assert.assertEquals((Object)"allready-lisp", (Object)StringUtil.camelToLisp((String)"allready-lisp"));
    }

    @Test
    public void testCamelToLispSimple() {
        Assert.assertEquals((Object)"foo-bar", (Object)StringUtil.camelToLisp((String)"fooBar"));
    }

    @Test
    public void testCamelToLispCase() {
        Assert.assertEquals((Object)"my-url", (Object)StringUtil.camelToLisp((String)"myURL"));
        Assert.assertEquals((Object)"another-url", (Object)StringUtil.camelToLisp((String)"AnotherURL"));
    }

    @Test
    public void testCamelToLispMulti() {
        Assert.assertEquals((Object)"http-request-wrapper", (Object)StringUtil.camelToLisp((String)"HttpRequestWrapper"));
        String string = StringUtil.camelToLisp((String)"HttpURLConnection");
        Assert.assertEquals((Object)"http-url-connection", (Object)string);
        Assert.assertEquals((Object)"welcome-to-my-world", (Object)StringUtil.camelToLisp((String)"WELCOMEToMYWorld"));
    }

    @Test
    public void testCamelToLispLeaveUntouched() {
        Assert.assertEquals((Object)"a-slightly-longer-and-more-bumpy-string?.,[]()", (Object)StringUtil.camelToLisp((String)"ASlightlyLongerANDMoreBumpyString?.,[]()"));
    }

    @Test
    public void testCamelToLispNumbers() {
        String string = StringUtil.camelToLisp((String)"my45Caliber");
        Assert.assertEquals((Object)"my-45-caliber", (Object)string);
        Assert.assertEquals((Object)"hello-12345-world-67890", (Object)StringUtil.camelToLisp((String)"Hello12345world67890"));
        Assert.assertEquals((Object)"hello-12345-my-world-67890-this-time", (Object)StringUtil.camelToLisp((String)"HELLO12345MyWorld67890thisTime"));
        Assert.assertEquals((Object)"hello-12345-world-67890-too", (Object)StringUtil.camelToLisp((String)"Hello12345WORLD67890too"));
    }

    @Test
    public void testLispToCamelNull() {
        try {
            StringUtil.lispToCamel(null);
            Assert.fail((String)"should not accept null");
        }
        catch (IllegalArgumentException illegalArgumentException) {
            Assert.assertNotNull((Object)illegalArgumentException.getMessage());
        }
    }

    @Test
    public void testLispToCamelNoConversion() {
        Assert.assertEquals((Object)EMPTY_STRING, (Object)StringUtil.lispToCamel((String)EMPTY_STRING));
        Assert.assertEquals((Object)"equal", (Object)StringUtil.lispToCamel((String)"equal"));
        Assert.assertEquals((Object)"alreadyCamel", (Object)StringUtil.lispToCamel((String)"alreadyCamel"));
    }

    @Test
    public void testLispToCamelSimple() {
        Assert.assertEquals((Object)"fooBar", (Object)StringUtil.lispToCamel((String)"foo-bar"));
        Assert.assertEquals((Object)"myUrl", (Object)StringUtil.lispToCamel((String)"my-URL"));
        Assert.assertEquals((Object)"anotherUrl", (Object)StringUtil.lispToCamel((String)"ANOTHER-URL"));
    }

    @Test
    public void testLispToCamelCase() {
        Assert.assertEquals((Object)"Object", (Object)StringUtil.lispToCamel((String)"object", (boolean)true));
        Assert.assertEquals((Object)"object", (Object)StringUtil.lispToCamel((String)"Object", (boolean)false));
    }

    @Test
    public void testLispToCamelMulti() {
        Assert.assertEquals((Object)"HttpRequestWrapper", (Object)StringUtil.lispToCamel((String)"http-request-wrapper", (boolean)true));
    }

    @Test
    public void testLispToCamelLeaveUntouched() {
        Assert.assertEquals((Object)"ASlightlyLongerAndMoreBumpyString?.,[]()", (Object)StringUtil.lispToCamel((String)"a-slightly-longer-and-more-bumpy-string?.,[]()", (boolean)true));
    }

    @Test
    public void testLispToCamelNumber() {
        Assert.assertEquals((Object)"my45Caliber", (Object)StringUtil.lispToCamel((String)"my-45-caliber"));
    }
}

