/*
 * Decompiled with CFR 0.152.
 */
package com.twelvemonkeys.lang;

import com.twelvemonkeys.lang.Platform;
import java.util.Properties;
import org.junit.Assert;
import org.junit.Ignore;
import org.junit.Test;

public class PlatformTest {
    @Test
    public void testGet() {
        Assert.assertNotNull((Object)Platform.get());
    }

    @Test
    public void testOS() {
        Assert.assertNotNull((Object)Platform.os());
        Assert.assertEquals((Object)Platform.get().getOS(), (Object)Platform.os());
    }

    @Test
    public void testVersion() {
        Assert.assertNotNull((Object)Platform.version());
        Assert.assertEquals((Object)Platform.get().getVersion(), (Object)Platform.version());
        Assert.assertEquals((Object)System.getProperty("os.version"), (Object)Platform.version());
    }

    @Test
    public void testArch() {
        Assert.assertNotNull((Object)Platform.arch());
        Assert.assertEquals((Object)Platform.get().getArchitecture(), (Object)Platform.arch());
    }

    private static Properties createProperties(String string, String string2, String string3) {
        Properties properties = new Properties();
        properties.put("os.name", string);
        properties.put("os.version", string2);
        properties.put("os.arch", string3);
        return properties;
    }

    @Test
    public void testCreateOSXx86_64() {
        Platform platform = new Platform(PlatformTest.createProperties("Mac OS X", "10.7.3", "x86_64"));
        Assert.assertEquals((Object)Platform.OperatingSystem.MacOS, (Object)platform.getOS());
        Assert.assertEquals((Object)Platform.Architecture.X86, (Object)platform.getArchitecture());
    }

    @Test
    public void testCreateOSXDarwinx86() {
        Platform platform = new Platform(PlatformTest.createProperties("Darwin", "0.0.0", "x86"));
        Assert.assertEquals((Object)Platform.OperatingSystem.MacOS, (Object)platform.getOS());
        Assert.assertEquals((Object)Platform.Architecture.X86, (Object)platform.getArchitecture());
    }

    @Test
    public void testCreateOSXPPC() {
        Platform platform = new Platform(PlatformTest.createProperties("Mac OS X", "10.5.4", "PPC"));
        Assert.assertEquals((Object)Platform.OperatingSystem.MacOS, (Object)platform.getOS());
        Assert.assertEquals((Object)Platform.Architecture.PPC, (Object)platform.getArchitecture());
    }

    @Test
    public void testCreateWindows386() {
        Platform platform = new Platform(PlatformTest.createProperties("Windows", "7.0.1.1", "i386"));
        Assert.assertEquals((Object)Platform.OperatingSystem.Windows, (Object)platform.getOS());
        Assert.assertEquals((Object)Platform.Architecture.X86, (Object)platform.getArchitecture());
    }

    @Ignore(value="Known issue, needs resolve")
    @Test
    public void testCreateWindows686() {
        Platform platform = new Platform(PlatformTest.createProperties("Windows", "5.1", "686"));
        Assert.assertEquals((Object)Platform.OperatingSystem.Windows, (Object)platform.getOS());
        Assert.assertEquals((Object)Platform.Architecture.X86, (Object)platform.getArchitecture());
    }

    @Ignore(value="Known issue, needs resolve")
    @Test
    public void testCreateLinuxX86() {
        Platform platform = new Platform(PlatformTest.createProperties("Linux", "3.0.18", "x86"));
        Assert.assertEquals((Object)Platform.OperatingSystem.Linux, (Object)platform.getOS());
        Assert.assertEquals((Object)Platform.Architecture.X86, (Object)platform.getArchitecture());
    }

    @Test
    public void testCreateLinuxPPC() {
        Platform platform = new Platform(PlatformTest.createProperties("Linux", "2.6.11", "PPC"));
        Assert.assertEquals((Object)Platform.OperatingSystem.Linux, (Object)platform.getOS());
        Assert.assertEquals((Object)Platform.Architecture.PPC, (Object)platform.getArchitecture());
    }

    @Test
    public void testCreateSolarisSparc() {
        Platform platform = new Platform(PlatformTest.createProperties("SunOS", "6.0", "Sparc"));
        Assert.assertEquals((Object)Platform.OperatingSystem.Solaris, (Object)platform.getOS());
        Assert.assertEquals((Object)Platform.Architecture.SPARC, (Object)platform.getArchitecture());
    }

    @Test
    public void testCreateSolarisX86() {
        Platform platform = new Platform(PlatformTest.createProperties("Solaris", "5.0", "x86"));
        Assert.assertEquals((Object)Platform.OperatingSystem.Solaris, (Object)platform.getOS());
        Assert.assertEquals((Object)Platform.Architecture.X86, (Object)platform.getArchitecture());
    }

    @Test
    public void testCreateUnknownUnknown() {
        Platform platform = new Platform(PlatformTest.createProperties("Amiga OS", "5.0", "68k"));
        Assert.assertEquals((Object)Platform.OperatingSystem.Unknown, (Object)platform.getOS());
        Assert.assertEquals((Object)Platform.Architecture.Unknown, (Object)platform.getArchitecture());
    }
}

