/*
 * Decompiled with CFR 0.152.
 */
package com.twelvemonkeys.io.enc;

import com.twelvemonkeys.io.enc.Encoder;
import com.twelvemonkeys.io.enc.EncoderStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.nio.ByteBuffer;
import java.util.Arrays;
import java.util.Random;
import org.junit.Assert;
import org.junit.Test;

public class EncoderStreamTest {
    private final Random rng = new Random(5467809876546L);

    private byte[] createData(int n) {
        byte[] byArray = new byte[n];
        this.rng.nextBytes(byArray);
        return byArray;
    }

    @Test
    public void testEncodeSingleBytes() throws IOException {
        byte[] byArray = this.createData(1327);
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        try (EncoderStream encoderStream = new EncoderStream((OutputStream)byteArrayOutputStream, (Encoder)new NullEncoder());){
            for (byte by : byArray) {
                encoderStream.write(by);
            }
        }
        Assert.assertArrayEquals((byte[])byArray, (byte[])byteArrayOutputStream.toByteArray());
    }

    @Test
    public void testEncodeArray() throws IOException {
        byte[] byArray = this.createData(1793);
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        try (Object object = new EncoderStream((OutputStream)byteArrayOutputStream, (Encoder)new NullEncoder());){
            for (int i = 0; i < 10; ++i) {
                ((OutputStream)object).write(byArray);
            }
        }
        object = byteArrayOutputStream.toByteArray();
        for (int i = 0; i < 10; ++i) {
            Assert.assertArrayEquals((byte[])byArray, (byte[])Arrays.copyOfRange((byte[])object, i * byArray.length, (i + 1) * byArray.length));
        }
    }

    @Test
    public void testEncodeArrayOffset() throws IOException {
        int n;
        byte[] byArray = this.createData(87);
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        Object object = new EncoderStream((OutputStream)byteArrayOutputStream, (Encoder)new NullEncoder());
        Object object2 = null;
        try {
            for (n = 0; n < 10; ++n) {
                object.write(byArray, 13, 59);
            }
        }
        catch (Throwable throwable) {
            object2 = throwable;
            throw throwable;
        }
        finally {
            if (object != null) {
                if (object2 != null) {
                    try {
                        object.close();
                    }
                    catch (Throwable throwable) {
                        ((Throwable)object2).addSuppressed(throwable);
                    }
                } else {
                    object.close();
                }
            }
        }
        object = Arrays.copyOfRange(byArray, 13, 72);
        object2 = byteArrayOutputStream.toByteArray();
        for (n = 0; n < 10; ++n) {
            Assert.assertArrayEquals((byte[])object, (byte[])Arrays.copyOfRange((byte[])object2, n * ((EncoderStream)object).length, (n + 1) * ((EncoderStream)object).length));
        }
    }

    private static final class NullEncoder
    implements Encoder {
        private NullEncoder() {
        }

        public void encode(OutputStream outputStream, ByteBuffer byteBuffer) throws IOException {
            outputStream.write(byteBuffer.array(), byteBuffer.arrayOffset(), byteBuffer.remaining());
        }
    }
}

