/*
 * Decompiled with CFR 0.152.
 */
package com.twelvemonkeys.io;

import com.twelvemonkeys.io.FileUtil;
import com.twelvemonkeys.io.InputStreamAbstractTest;
import com.twelvemonkeys.io.Seekable;
import com.twelvemonkeys.io.SeekableAbstractTest;
import com.twelvemonkeys.io.SeekableInputStream;
import com.twelvemonkeys.io.SeekableInterfaceTest;
import java.io.ByteArrayInputStream;
import java.io.EOFException;
import java.io.IOException;
import java.io.InputStream;
import org.junit.Assert;
import org.junit.Test;

public abstract class SeekableInputStreamAbstractTest
extends InputStreamAbstractTest
implements SeekableInterfaceTest {
    final SeekableAbstractTest seekableTestCase = new SeekableAbstractTest(){

        @Override
        protected Seekable createSeekable() {
            return SeekableInputStreamAbstractTest.this.makeInputStream();
        }
    };

    protected SeekableInputStream makeInputStream() {
        return (SeekableInputStream)super.makeInputStream();
    }

    protected SeekableInputStream makeInputStream(int n) {
        return (SeekableInputStream)super.makeInputStream(n);
    }

    protected SeekableInputStream makeInputStream(byte[] byArray) {
        return this.makeInputStream(new ByteArrayInputStream(byArray));
    }

    protected abstract SeekableInputStream makeInputStream(InputStream var1);

    @Override
    @Test
    public void testResetAfterReset() throws Exception {
        SeekableInputStream seekableInputStream = this.makeInputStream(this.makeOrderedArray(25));
        if (!seekableInputStream.markSupported()) {
            return;
        }
        Assert.assertTrue((String)"Expected to read positive value", (seekableInputStream.read() >= 0 ? 1 : 0) != 0);
        int n = 5;
        seekableInputStream.mark(n);
        int n2 = seekableInputStream.read();
        Assert.assertTrue((String)"Expected to read positive value", (n2 >= 0 ? 1 : 0) != 0);
        seekableInputStream.reset();
        Assert.assertEquals((String)"Expected value read differs from actual", (long)n2, (long)seekableInputStream.read());
        try {
            seekableInputStream.reset();
            Assert.assertEquals((String)"Re-read of reset data should be first", (long)0L, (long)seekableInputStream.read());
        }
        catch (Exception exception) {
            Assert.assertTrue((String)"Wrong read-limit IOException message", (boolean)exception.getMessage().contains("mark"));
        }
    }

    @Override
    @Test
    public void testSeekable() {
        this.seekableTestCase.testSeekable();
    }

    @Test
    public void testFlushBeyondCurrentPos() throws Exception {
        SeekableInputStream seekableInputStream = this.makeInputStream(20);
        int n = 10;
        try {
            seekableInputStream.flushBefore((long)n);
            Assert.fail((String)"Flush beyond current position should throw IndexOutOfBoundsException");
        }
        catch (IndexOutOfBoundsException indexOutOfBoundsException) {
            // empty catch block
        }
    }

    @Test
    public void testSeek() throws Exception {
        SeekableInputStream seekableInputStream = this.makeInputStream(55);
        int n = 37;
        seekableInputStream.seek((long)n);
        long l = seekableInputStream.getStreamPosition();
        Assert.assertEquals((String)"Stream positon should match seeked position", (long)n, (long)l);
    }

    @Test
    public void testSeekFlush() throws Exception {
        SeekableInputStream seekableInputStream = this.makeInputStream(133);
        int n = 45;
        seekableInputStream.seek((long)n);
        seekableInputStream.flushBefore((long)n);
        long l = seekableInputStream.getFlushedPosition();
        Assert.assertEquals((String)"Flushed positon should match position", (long)n, (long)l);
        try {
            seekableInputStream.seek((long)(n - 1));
            Assert.fail((String)"Read before flushed position succeeded");
        }
        catch (IndexOutOfBoundsException indexOutOfBoundsException) {
            // empty catch block
        }
    }

    @Test
    public void testMarkFlushReset() throws Exception {
        SeekableInputStream seekableInputStream = this.makeInputStream(77);
        seekableInputStream.mark();
        int n = 55;
        seekableInputStream.seek((long)n);
        seekableInputStream.flushBefore((long)n);
        try {
            seekableInputStream.reset();
            Assert.fail((String)"Reset before flushed position succeeded");
        }
        catch (IOException iOException) {
            // empty catch block
        }
        Assert.assertEquals((long)n, (long)seekableInputStream.getStreamPosition());
    }

    @Test
    public void testSeekSkipRead() throws Exception {
        SeekableInputStream seekableInputStream = this.makeInputStream(133);
        int n = 45;
        for (int i = 0; i < 10; ++i) {
            seekableInputStream.seek((long)n);
            seekableInputStream.skip((long)i);
            byte[] byArray = FileUtil.read((InputStream)seekableInputStream);
            Assert.assertEquals((long)133L, (long)seekableInputStream.getStreamPosition());
            Assert.assertEquals((long)(88 - i), (long)byArray.length);
        }
    }

    protected void testSeekSkip(SeekableInputStream seekableInputStream, String string) throws IOException {
        int n;
        System.out.println();
        seekableInputStream.seek((long)string.length());
        FileUtil.read((InputStream)seekableInputStream);
        for (n = 0; n < 10; ++n) {
            byte[] byArray = FileUtil.read((InputStream)seekableInputStream);
            int n2 = byArray.length;
            if (n2 == 0) continue;
            System.err.println("Error in buffer length after full read...");
            System.err.println("len: " + n2);
            System.err.println("bytes: \"" + new String(byArray) + "\"");
            break;
        }
        System.out.println();
        for (n = 0; n < 10; ++n) {
            seekableInputStream.seek(0L);
            int n3 = n * 3;
            seekableInputStream.skip((long)n3);
            String string2 = new String(FileUtil.read((InputStream)seekableInputStream));
            System.out.println(string2);
            if (string2.length() == string.length() - n3) continue;
            throw new Error("Error in buffer length after skip");
        }
        System.out.println();
        System.out.println("seek/skip ok!");
        System.out.println();
    }

    protected static void markReset(SeekableInputStream seekableInputStream) throws IOException {
        for (int i = 0; i < 10; ++i) {
            seekableInputStream.mark();
            System.out.println(new String(FileUtil.read((InputStream)seekableInputStream)));
            seekableInputStream.reset();
        }
        System.out.println();
        System.out.println("mark/reset ok!");
    }

    protected static void timeRead(SeekableInputStream seekableInputStream) throws IOException {
        for (int i = 0; i < 5000; ++i) {
            seekableInputStream.mark();
            FileUtil.read((InputStream)seekableInputStream);
            seekableInputStream.reset();
        }
        long l = System.currentTimeMillis();
        for (int i = 0; i < 200000; ++i) {
            seekableInputStream.mark();
            FileUtil.read((InputStream)seekableInputStream);
            seekableInputStream.reset();
        }
        long l2 = System.currentTimeMillis() - l;
        System.out.println("Time; " + l2 + "ms (" + (float)l2 / 200000.0f + "ms/inv)");
    }

    @Test
    public void testReadResetReadDirectBufferBug() throws IOException {
        byte[] byArray = new byte[2048];
        sRandom.nextBytes(byArray);
        SeekableInputStream seekableInputStream = this.makeInputStream(byArray);
        int n = seekableInputStream.read();
        Assert.assertFalse((String)"Unexepected EOF", (n == -1 ? 1 : 0) != 0);
        n = seekableInputStream.read();
        Assert.assertFalse((String)"Unexepected EOF", (n == -1 ? 1 : 0) != 0);
        n = seekableInputStream.read();
        Assert.assertFalse((String)"Unexepected EOF", (n == -1 ? 1 : 0) != 0);
        n = seekableInputStream.read();
        Assert.assertFalse((String)"Unexepected EOF", (n == -1 ? 1 : 0) != 0);
        seekableInputStream.seek(0L);
        byte[] byArray2 = new byte[1024];
        this.readFully((InputStream)seekableInputStream, byArray2);
        Assert.assertTrue((boolean)SeekableInputStreamAbstractTest.rangeEquals(byArray, 0, byArray2, 0, 1024));
        this.readFully((InputStream)seekableInputStream, byArray2);
        Assert.assertTrue((boolean)SeekableInputStreamAbstractTest.rangeEquals(byArray, 1024, byArray2, 0, 1024));
    }

    @Test
    public void testReadAllByteValuesRegression() throws IOException {
        int n;
        int n2;
        byte[] byArray = new byte[256];
        for (int i = 0; i < byArray.length; ++i) {
            byArray[i] = (byte)i;
        }
        SeekableInputStream seekableInputStream = this.makeInputStream(byArray);
        byte[] byArray2 = new byte[128];
        while (seekableInputStream.read(byArray2) >= 0) {
        }
        seekableInputStream.seek(0L);
        for (n2 = 0; n2 < byArray.length; n2 += 2) {
            Assert.assertEquals((String)"Wrong stream position", (long)n2, (long)seekableInputStream.getStreamPosition());
            n = seekableInputStream.read(byArray2, 0, 2);
            Assert.assertEquals((long)2L, (long)n);
            Assert.assertEquals((String)String.format("Wrong value read at pos %d", seekableInputStream.getStreamPosition()), (long)byArray[n2], (long)byArray2[0]);
            Assert.assertEquals((String)String.format("Wrong value read at pos %d", seekableInputStream.getStreamPosition()), (long)byArray[n2 + 1], (long)byArray2[1]);
        }
        seekableInputStream.seek(0L);
        for (n2 = 0; n2 < byArray.length; ++n2) {
            Assert.assertEquals((String)"Wrong stream position", (long)n2, (long)seekableInputStream.getStreamPosition());
            n = seekableInputStream.read();
            Assert.assertEquals((String)String.format("Wrong value read at pos %d", seekableInputStream.getStreamPosition()), (long)(byArray[n2] & 0xFF), (long)n);
            Assert.assertEquals((String)String.format("Wrong value read at pos %d", seekableInputStream.getStreamPosition()), (long)byArray[n2], (long)((byte)n));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testCloseUnderlyingStream() throws IOException {
        final boolean[] blArray = new boolean[1];
        ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(this.makeRandomArray(256)){

            @Override
            public void close() throws IOException {
                blArray[0] = true;
                super.close();
            }
        };
        try (SeekableInputStream seekableInputStream = this.makeInputStream(byteArrayInputStream);){
            FileUtil.read((InputStream)seekableInputStream);
            Assert.assertEquals((String)"EOF not reached (test case broken)", (long)-1L, (long)seekableInputStream.read());
            Assert.assertFalse((String)"Underlying stream closed before close", (boolean)blArray[0]);
        }
        Assert.assertTrue((String)"Underlying stream not closed", (boolean)blArray[0]);
    }

    private void readFully(InputStream inputStream, byte[] byArray) throws IOException {
        int n;
        for (int i = 0; i < byArray.length; i += n) {
            n = inputStream.read(byArray, i, byArray.length - i);
            if (n != -1) continue;
            throw new EOFException();
        }
    }

    static boolean rangeEquals(byte[] byArray, int n, byte[] byArray2, int n2, int n3) {
        if (byArray == byArray2 && n == n2) {
            return true;
        }
        if (byArray == null || byArray2 == null) {
            return false;
        }
        if (byArray.length < n + n3 || byArray2.length < n2 + n3) {
            return false;
        }
        for (int i = 0; i < n3; ++i) {
            if (byArray[n + i] == byArray2[n2 + i]) continue;
            return false;
        }
        return true;
    }
}

