/*
 * Decompiled with CFR 0.152.
 */
package com.twelvemonkeys.io.ole2;

import com.twelvemonkeys.io.InputStreamAbstractTest;
import com.twelvemonkeys.io.LittleEndianDataOutputStream;
import com.twelvemonkeys.io.MemoryCacheSeekableStream;
import com.twelvemonkeys.io.SeekableInputStream;
import com.twelvemonkeys.io.ole2.CompoundDocument;
import com.twelvemonkeys.io.ole2.Entry;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URISyntaxException;
import java.net.URL;
import java.nio.charset.Charset;
import java.util.Arrays;
import org.junit.Assert;
import org.junit.Test;

public class CompoundDocument_StreamTest
extends InputStreamAbstractTest {
    private static final String SAMPLE_DATA = "/Thumbs-camera.db";

    protected final CompoundDocument createTestDocument() throws IOException {
        URL uRL = ((Object)((Object)this)).getClass().getResource(SAMPLE_DATA);
        Assert.assertNotNull((String)"Missing test resource!", (Object)uRL);
        Assert.assertEquals((String)"Test resource not a file:// resource", (Object)"file", (Object)uRL.getProtocol());
        try {
            return new CompoundDocument(new File(uRL.toURI()));
        }
        catch (URISyntaxException uRISyntaxException) {
            throw new AssertionError((Object)uRISyntaxException);
        }
    }

    private SeekableInputStream createRealInputStream() {
        try {
            Entry entry = (Entry)this.createTestDocument().getRootEntry().getChildEntries().first();
            Assert.assertNotNull((Object)entry);
            return entry.getInputStream();
        }
        catch (IOException iOException) {
            throw new AssertionError((Object)iOException);
        }
    }

    @Override
    protected InputStream makeInputStream(byte[] byArray) {
        try {
            ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
            LittleEndianDataOutputStream littleEndianDataOutputStream = new LittleEndianDataOutputStream((OutputStream)byteArrayOutputStream);
            littleEndianDataOutputStream.write(CompoundDocument.MAGIC);
            littleEndianDataOutputStream.write(new byte[16]);
            littleEndianDataOutputStream.write(new byte[]{62, 0, 3, 0});
            littleEndianDataOutputStream.write(new byte[]{-2, -1});
            littleEndianDataOutputStream.write(new byte[]{9, 0, 6, 0});
            littleEndianDataOutputStream.write(new byte[10]);
            littleEndianDataOutputStream.writeInt(1);
            littleEndianDataOutputStream.writeInt(1);
            littleEndianDataOutputStream.write(new byte[4]);
            littleEndianDataOutputStream.writeInt(4096);
            littleEndianDataOutputStream.writeInt(3);
            littleEndianDataOutputStream.writeInt(1);
            littleEndianDataOutputStream.writeInt(-2);
            littleEndianDataOutputStream.writeInt(0);
            littleEndianDataOutputStream.writeInt(0);
            littleEndianDataOutputStream.writeInt(128);
            littleEndianDataOutputStream.write(this.createPad(428, (byte)-1));
            littleEndianDataOutputStream.writeInt(-3);
            littleEndianDataOutputStream.writeInt(-2);
            littleEndianDataOutputStream.write(this.createPad(504, (byte)-1));
            byte[] byArray2 = "Root Entry".getBytes(Charset.forName("UTF-16LE"));
            littleEndianDataOutputStream.write(byArray2);
            littleEndianDataOutputStream.write(this.createPad(64 - byArray2.length, (byte)0));
            littleEndianDataOutputStream.writeShort((int)((short)(byArray2.length + 2)));
            littleEndianDataOutputStream.write(new byte[]{5, 0});
            littleEndianDataOutputStream.writeInt(-1);
            littleEndianDataOutputStream.writeInt(-1);
            littleEndianDataOutputStream.writeInt(1);
            littleEndianDataOutputStream.write(this.createPad(36, (byte)0));
            littleEndianDataOutputStream.writeInt(2);
            littleEndianDataOutputStream.writeInt(8);
            littleEndianDataOutputStream.writeInt(0);
            byArray2 = "data".getBytes(Charset.forName("UTF-16LE"));
            littleEndianDataOutputStream.write(byArray2);
            littleEndianDataOutputStream.write(this.createPad(64 - byArray2.length, (byte)0));
            littleEndianDataOutputStream.writeShort((int)((short)(byArray2.length + 2)));
            littleEndianDataOutputStream.write(new byte[]{2, 0});
            littleEndianDataOutputStream.writeInt(-1);
            littleEndianDataOutputStream.writeInt(-1);
            littleEndianDataOutputStream.writeInt(-1);
            littleEndianDataOutputStream.write(this.createPad(36, (byte)0));
            littleEndianDataOutputStream.writeInt(0);
            littleEndianDataOutputStream.writeInt(byArray.length);
            littleEndianDataOutputStream.writeInt(0);
            littleEndianDataOutputStream.write(this.createPad(256, (byte)-1));
            littleEndianDataOutputStream.write(byArray);
            littleEndianDataOutputStream.write(this.createPad(512 - byArray.length, (byte)-1));
            littleEndianDataOutputStream.writeInt(2);
            littleEndianDataOutputStream.writeInt(-2);
            littleEndianDataOutputStream.write(this.createPad(504, (byte)-1));
            ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(byteArrayOutputStream.toByteArray());
            CompoundDocument compoundDocument = new CompoundDocument((SeekableInputStream)new MemoryCacheSeekableStream((InputStream)byteArrayInputStream));
            Entry entry = (Entry)compoundDocument.getRootEntry().getChildEntries().first();
            return entry.getInputStream();
        }
        catch (IOException iOException) {
            throw new AssertionError((Object)iOException);
        }
    }

    private byte[] createPad(int n, byte by) {
        byte[] byArray = new byte[n];
        Arrays.fill(byArray, by);
        return byArray;
    }

    @Test
    public void testDev() throws IOException {
        int n;
        InputStream inputStream = this.makeInputStream(this.makeOrderedArray(32));
        int n2 = 0;
        while ((n = inputStream.read()) >= 0) {
            Assert.assertEquals((long)n2, (long)n);
            ++n2;
        }
        Assert.assertFalse((String)"Short stream", (n2 < 32 ? 1 : 0) != 0);
        Assert.assertFalse((String)"Stream overrun", (n2 > 32 ? 1 : 0) != 0);
    }

    @Test
    public void testInputStreamSkip() throws IOException {
        InputStream inputStream = this.makeInputStream();
        Assert.assertTrue((inputStream.skip(10L) > 0L ? 1 : 0) != 0);
    }
}

