/*
 * Decompiled with CFR 0.152.
 */
package com.twelvemonkeys.io.enc;

import com.twelvemonkeys.io.FileUtil;
import com.twelvemonkeys.io.enc.Decoder;
import com.twelvemonkeys.io.enc.DecoderStream;
import com.twelvemonkeys.io.enc.Encoder;
import com.twelvemonkeys.io.enc.EncoderStream;
import com.twelvemonkeys.lang.ObjectAbstractTest;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Arrays;
import java.util.Random;
import org.junit.Assert;
import org.junit.Test;

public abstract class EncoderAbstractTest
extends ObjectAbstractTest {
    static final long SEED = 12345678L;
    static final Random RANDOM = new Random(12345678L);

    protected abstract Encoder createEncoder();

    protected abstract Decoder createCompatibleDecoder();

    protected Object makeObject() {
        return this.createEncoder();
    }

    @Test
    public final void testNullEncode() throws IOException {
        Encoder encoder = this.createEncoder();
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        try {
            encoder.encode((OutputStream)byteArrayOutputStream, null);
            Assert.fail((String)"null should throw NullPointerException");
        }
        catch (NullPointerException nullPointerException) {
            // empty catch block
        }
    }

    private byte[] createData(int n) throws Exception {
        byte[] byArray = new byte[n];
        RANDOM.nextBytes(byArray);
        return byArray;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void runStreamTest(int n) throws Exception {
        byte[] byArray = this.createData(n);
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        try (EncoderStream encoderStream = new EncoderStream((OutputStream)byteArrayOutputStream, this.createEncoder(), true);){
            int n2 = (byArray.length + 1) / 2;
            encoderStream.write(byArray, 0, n2);
            if (byArray.length > n2) {
                encoderStream.write(byArray, n2, byArray.length - n2);
            }
        }
        byte[] byArray2 = byteArrayOutputStream.toByteArray();
        byte[] byArray3 = FileUtil.read((InputStream)new DecoderStream((InputStream)new ByteArrayInputStream(byArray2), this.createCompatibleDecoder()));
        Assert.assertTrue((boolean)Arrays.equals(byArray, byArray3));
        DecoderStream decoderStream = new DecoderStream((InputStream)new ByteArrayInputStream(byArray2), this.createCompatibleDecoder());
        byteArrayOutputStream = new ByteArrayOutputStream();
        try {
            FileUtil.copy((InputStream)decoderStream, (OutputStream)byteArrayOutputStream);
        }
        finally {
            byteArrayOutputStream.close();
            decoderStream.close();
        }
        byArray3 = byteArrayOutputStream.toByteArray();
        Assert.assertTrue((boolean)Arrays.equals(byArray, byArray3));
    }

    @Test
    public final void testStreams() throws Exception {
        int n;
        for (n = 0; n < 100; ++n) {
            try {
                this.runStreamTest(n);
                continue;
            }
            catch (IOException iOException) {
                iOException.printStackTrace();
                Assert.fail((String)(iOException.getMessage() + ": " + n));
                continue;
            }
            catch (Exception exception) {
                exception.printStackTrace();
                Assert.fail((String)(exception.getMessage() + ": " + n));
            }
        }
        for (n = 100; n < 2000; n += 250) {
            try {
                this.runStreamTest(n);
                continue;
            }
            catch (IOException iOException) {
                iOException.printStackTrace();
                Assert.fail((String)(iOException.getMessage() + ": " + n));
                continue;
            }
            catch (Exception exception) {
                exception.printStackTrace();
                Assert.fail((String)(exception.getMessage() + ": " + n));
            }
        }
        for (n = 2000; n < 80000; n += 1000) {
            try {
                this.runStreamTest(n);
                continue;
            }
            catch (IOException iOException) {
                iOException.printStackTrace();
                Assert.fail((String)(iOException.getMessage() + ": " + n));
                continue;
            }
            catch (Exception exception) {
                exception.printStackTrace();
                Assert.fail((String)(exception.getMessage() + ": " + n));
            }
        }
    }
}

