/*
 * Decompiled with CFR 0.152.
 */
package com.twelvemonkeys.io;

import com.twelvemonkeys.lang.ObjectAbstractTest;
import java.io.IOException;
import java.io.OutputStream;
import org.junit.Assert;
import org.junit.Test;

public abstract class OutputStreamAbstractTest
extends ObjectAbstractTest {
    protected abstract OutputStream makeObject();

    @Test
    public void testWrite() throws IOException {
        OutputStream outputStream = this.makeObject();
        for (int i = 0; i < 256; ++i) {
            outputStream.write((byte)i);
        }
    }

    @Test
    public void testWriteByteArray() throws IOException {
        OutputStream outputStream = this.makeObject();
        outputStream.write(new byte[256]);
    }

    @Test
    public void testWriteByteArrayNull() {
        OutputStream outputStream = this.makeObject();
        try {
            outputStream.write(null);
            Assert.fail((String)"Should not accept null-argument");
        }
        catch (IOException iOException) {
            Assert.fail((String)("Should not throw IOException of null-arguemnt: " + iOException.getMessage()));
        }
        catch (NullPointerException nullPointerException) {
            Assert.assertNotNull((Object)nullPointerException);
        }
        catch (RuntimeException runtimeException) {
            Assert.fail((String)("Should only throw NullPointerException: " + runtimeException.getClass() + ": " + runtimeException.getMessage()));
        }
    }

    @Test
    public void testWriteByteArrayOffsetLength() throws IOException {
        int n;
        byte[] byArray = new byte[256];
        OutputStream outputStream = this.makeObject();
        for (n = 0; n < 256; ++n) {
            byArray[n] = (byte)n;
        }
        for (n = 0; n < 256; ++n) {
            outputStream.write(byArray, n, 256 - n);
        }
        for (n = 0; n < 4; ++n) {
            outputStream.write(byArray, n * 64, 64);
        }
    }

    @Test
    public void testWriteByteArrayZeroLength() {
        OutputStream outputStream = this.makeObject();
        try {
            outputStream.write(new byte[1], 0, 0);
        }
        catch (Exception exception) {
            Assert.fail((String)("Should not throw Exception: " + exception.getMessage()));
        }
    }

    @Test
    public void testWriteByteArrayOffsetLengthNull() {
        OutputStream outputStream = this.makeObject();
        try {
            outputStream.write(null, 5, 10);
            Assert.fail((String)"Should not accept null-argument");
        }
        catch (IOException iOException) {
            Assert.fail((String)("Should not throw IOException of null-arguemnt: " + iOException.getMessage()));
        }
        catch (NullPointerException nullPointerException) {
            Assert.assertNotNull((Object)nullPointerException);
        }
        catch (RuntimeException runtimeException) {
            Assert.fail((String)("Should only throw NullPointerException: " + runtimeException.getClass() + ": " + runtimeException.getMessage()));
        }
    }

    @Test
    public void testWriteByteArrayNegativeOffset() {
        OutputStream outputStream = this.makeObject();
        try {
            outputStream.write(new byte[5], -3, 5);
            Assert.fail((String)"Should not accept negative offset");
        }
        catch (IOException iOException) {
            Assert.fail((String)("Should not throw IOException negative offset: " + iOException.getMessage()));
        }
        catch (IndexOutOfBoundsException indexOutOfBoundsException) {
            Assert.assertNotNull((Object)indexOutOfBoundsException);
        }
        catch (RuntimeException runtimeException) {
            Assert.fail((String)("Should only throw IndexOutOfBoundsException: " + runtimeException.getClass() + ": " + runtimeException.getMessage()));
        }
    }

    @Test
    public void testWriteByteArrayNegativeLength() {
        OutputStream outputStream = this.makeObject();
        try {
            outputStream.write(new byte[5], 2, -5);
            Assert.fail((String)"Should not accept negative length");
        }
        catch (IOException iOException) {
            Assert.fail((String)("Should not throw IOException negative length: " + iOException.getMessage()));
        }
        catch (IndexOutOfBoundsException indexOutOfBoundsException) {
            Assert.assertNotNull((Object)indexOutOfBoundsException);
        }
        catch (RuntimeException runtimeException) {
            Assert.fail((String)("Should only throw IndexOutOfBoundsException: " + runtimeException.getClass() + ": " + runtimeException.getMessage()));
        }
    }

    @Test
    public void testWriteByteArrayOffsetOutOfBounds() {
        OutputStream outputStream = this.makeObject();
        try {
            outputStream.write(new byte[5], 5, 1);
            Assert.fail((String)"Should not accept offset out of bounds");
        }
        catch (IOException iOException) {
            Assert.fail((String)("Should not throw IOException offset out of bounds: " + iOException.getMessage()));
        }
        catch (IndexOutOfBoundsException indexOutOfBoundsException) {
            Assert.assertNotNull((Object)indexOutOfBoundsException);
        }
        catch (RuntimeException runtimeException) {
            Assert.fail((String)("Should only throw IndexOutOfBoundsException: " + runtimeException.getClass() + ": " + runtimeException.getMessage()));
        }
    }

    @Test
    public void testWriteByteArrayLengthOutOfBounds() {
        OutputStream outputStream = this.makeObject();
        try {
            outputStream.write(new byte[5], 1, 5);
            Assert.fail((String)"Should not accept length out of bounds");
        }
        catch (IOException iOException) {
            Assert.fail((String)("Should not throw IOException length out of bounds: " + iOException.getMessage()));
        }
        catch (IndexOutOfBoundsException indexOutOfBoundsException) {
            Assert.assertNotNull((Object)indexOutOfBoundsException);
        }
        catch (RuntimeException runtimeException) {
            Assert.fail((String)("Should only throw IndexOutOfBoundsException: " + runtimeException.getClass() + ": " + runtimeException.getMessage()));
        }
    }

    @Test
    public void testFlush() {
    }

    @Test
    public void testClose() {
    }

    @Test
    public void testWriteAfterClose() throws IOException {
        block5: {
            OutputStream outputStream = this.makeObject();
            outputStream.close();
            boolean bl = false;
            try {
                outputStream.write(0);
                bl = true;
            }
            catch (IOException iOException) {
                Assert.assertNotNull((Object)iOException.getMessage());
            }
            try {
                outputStream.write(new byte[16]);
                if (!bl) {
                    Assert.fail((String)"Inconsistent write(int)/write(byte[]) after close");
                }
            }
            catch (IOException iOException) {
                Assert.assertNotNull((Object)iOException.getMessage());
                if (!bl) break block5;
                Assert.fail((String)"Inconsistent write(int)/write(byte[]) after close");
            }
        }
    }

    @Test
    public void testFlushAfterClose() throws IOException {
        OutputStream outputStream = this.makeObject();
        outputStream.close();
        try {
            outputStream.flush();
            try {
                outputStream.write(0);
            }
            catch (IOException iOException) {
                Assert.fail((String)"Inconsistent write/flush after close");
            }
        }
        catch (IOException iOException) {
            Assert.assertNotNull((Object)iOException.getMessage());
        }
    }

    @Test
    public void testCloseAfterClose() throws IOException {
        OutputStream outputStream = this.makeObject();
        outputStream.close();
        try {
            outputStream.close();
        }
        catch (IOException iOException) {
            Assert.fail((String)("Close after close, failed: " + iOException.getMessage()));
        }
    }
}

