/*
 * Decompiled with CFR 0.152.
 */
package com.twelvemonkeys.io;

import com.twelvemonkeys.io.FileSeekableStream;
import com.twelvemonkeys.io.FileUtil;
import com.twelvemonkeys.io.SeekableInputStream;
import com.twelvemonkeys.io.SeekableInputStreamAbstractTest;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.RandomAccessFile;
import org.junit.Assert;
import org.junit.Test;

public class FileSeekableStreamTest
extends SeekableInputStreamAbstractTest {
    @Override
    protected SeekableInputStream makeInputStream(InputStream inputStream) {
        try {
            return new FileSeekableStream(this.createFileWithContent(inputStream));
        }
        catch (IOException iOException) {
            throw new RuntimeException(iOException);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private File createFileWithContent(InputStream inputStream) throws IOException {
        File file = File.createTempFile("tm-io-junit", null);
        file.deleteOnExit();
        FileOutputStream fileOutputStream = new FileOutputStream(file);
        try {
            FileUtil.copy((InputStream)inputStream, (OutputStream)fileOutputStream);
        }
        finally {
            ((OutputStream)fileOutputStream).close();
            inputStream.close();
        }
        return file;
    }

    @Override
    @Test
    public void testCloseUnderlyingStream() throws IOException {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testCloseUnderlyingFile() throws IOException {
        final boolean[] blArray = new boolean[1];
        File file = this.createFileWithContent(new ByteArrayInputStream(this.makeRandomArray(256)));
        RandomAccessFile randomAccessFile = new RandomAccessFile(file, "r"){

            @Override
            public void close() throws IOException {
                blArray[0] = true;
                super.close();
            }
        };
        try (FileSeekableStream fileSeekableStream = new FileSeekableStream(randomAccessFile);){
            FileUtil.read((InputStream)fileSeekableStream);
            Assert.assertEquals((String)"EOF not reached (test case broken)", (long)-1L, (long)fileSeekableStream.read());
            Assert.assertFalse((String)"Underlying stream closed before close", (boolean)blArray[0]);
        }
        Assert.assertTrue((String)"Underlying stream not closed", (boolean)blArray[0]);
    }
}

