/*
 * Decompiled with CFR 0.152.
 */
package com.twelvemonkeys.io;

import com.twelvemonkeys.io.CompoundReader;
import com.twelvemonkeys.io.ReaderAbstractTest;
import com.twelvemonkeys.lang.StringUtil;
import com.twelvemonkeys.util.CollectionUtil;
import java.io.IOException;
import java.io.Reader;
import java.io.StringReader;
import java.util.ArrayList;
import java.util.Iterator;
import org.junit.Assert;
import org.junit.Test;

public class CompoundReaderTest
extends ReaderAbstractTest {
    @Override
    protected Reader makeReader(String string) {
        String[] stringArray = StringUtil.toStringArray((String)string, (String)" ");
        ArrayList<StringReader> arrayList = new ArrayList<StringReader>(stringArray.length);
        for (int i = 0; i < stringArray.length; ++i) {
            if (i != 0) {
                stringArray[i] = " " + stringArray[i];
            }
            arrayList.add(new StringReader(stringArray[i]));
        }
        return new CompoundReader(arrayList.iterator());
    }

    @Test
    public void testNullConstructor() {
        try {
            new CompoundReader(null);
            Assert.fail((String)"Should not allow null argument");
        }
        catch (RuntimeException runtimeException) {
            Assert.assertNotNull((Object)runtimeException.getMessage());
        }
    }

    @Test
    public void testEmptyIteratorConstructor() throws IOException {
        CompoundReader compoundReader = new CompoundReader((Iterator)CollectionUtil.iterator((Object[])new Reader[0]));
        Assert.assertEquals((long)-1L, (long)compoundReader.read());
    }

    @Test
    public void testIteratorWithNullConstructor() throws IOException {
        try {
            new CompoundReader((Iterator)CollectionUtil.iterator((Object[])new Reader[]{null}));
            Assert.fail((String)"Should not allow null in iterator argument");
        }
        catch (RuntimeException runtimeException) {
            Assert.assertNotNull((Object)runtimeException.getMessage());
        }
    }
}

