/*
 * Decompiled with CFR 0.152.
 */
package com.twelvemonkeys.io.ole2;

import com.twelvemonkeys.io.MemoryCacheSeekableStream;
import com.twelvemonkeys.io.SeekableInputStream;
import com.twelvemonkeys.io.ole2.CompoundDocument;
import com.twelvemonkeys.io.ole2.Entry;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.URISyntaxException;
import java.net.URL;
import java.nio.ByteOrder;
import java.util.SortedSet;
import java.util.TreeSet;
import javax.imageio.stream.ImageInputStream;
import javax.imageio.stream.MemoryCacheImageInputStream;
import org.junit.Assert;
import org.junit.Test;

public class CompoundDocumentTest {
    private static final String SAMPLE_DATA = "/Thumbs-camera.db";

    protected final CompoundDocument createTestDocument() throws IOException {
        URL uRL = this.getClass().getResource(SAMPLE_DATA);
        Assert.assertNotNull((String)"Missing test resource!", (Object)uRL);
        Assert.assertEquals((String)"Test resource not a file:// resource", (Object)"file", (Object)uRL.getProtocol());
        try {
            return new CompoundDocument(new File(uRL.toURI()));
        }
        catch (URISyntaxException uRISyntaxException) {
            throw new AssertionError((Object)uRISyntaxException);
        }
    }

    @Test
    public void testRoot() throws IOException {
        try (CompoundDocument compoundDocument = this.createTestDocument();){
            Entry entry = compoundDocument.getRootEntry();
            Assert.assertNotNull((Object)entry);
            Assert.assertEquals((Object)"Root Entry", (Object)entry.getName());
            Assert.assertTrue((boolean)entry.isRoot());
            Assert.assertFalse((boolean)entry.isFile());
            Assert.assertFalse((boolean)entry.isDirectory());
            Assert.assertEquals((long)0L, (long)entry.length());
            Assert.assertNull((Object)entry.getInputStream());
        }
    }

    @Test
    public void testContents() throws IOException {
        try (CompoundDocument compoundDocument = this.createTestDocument();){
            Entry entry = compoundDocument.getRootEntry();
            Assert.assertNotNull((Object)entry);
            TreeSet treeSet = new TreeSet(entry.getChildEntries());
            Assert.assertEquals((long)25L, (long)treeSet.size());
            for (String string : "1,2,3,4,5,6,7,8,9,01,02,11,12,21,22,31,32,41,42,51,61,71,81,91,Catalog".split(",")) {
                Assert.assertEquals((Object)string, (Object)((Entry)treeSet.first()).getName());
                treeSet.remove(treeSet.first());
            }
        }
    }

    @Test(expected=UnsupportedOperationException.class)
    public void testChildEntriesUnmodifiable() throws IOException {
        try (CompoundDocument compoundDocument = this.createTestDocument();){
            Entry entry = compoundDocument.getRootEntry();
            Assert.assertNotNull((Object)entry);
            SortedSet sortedSet = entry.getChildEntries();
            sortedSet.remove(sortedSet.first());
        }
    }

    @Test
    public void testReadThumbsCatalogFile() throws IOException {
        try (CompoundDocument compoundDocument = this.createTestDocument();){
            Entry entry = compoundDocument.getRootEntry();
            Assert.assertNotNull((Object)entry);
            Assert.assertEquals((long)25L, (long)entry.getChildEntries().size());
            Entry entry2 = entry.getChildEntry("Catalog");
            Assert.assertNotNull((Object)entry2);
            Assert.assertNotNull((String)"Input stream may not be null", (Object)entry2.getInputStream());
        }
    }

    @Test
    public void testReadCatalogInputStream() throws IOException {
        InputStream inputStream = this.getClass().getResourceAsStream(SAMPLE_DATA);
        Assert.assertNotNull((String)"Missing test resource!", (Object)inputStream);
        CompoundDocument compoundDocument = new CompoundDocument(inputStream);
        Entry entry = compoundDocument.getRootEntry();
        Assert.assertNotNull((Object)entry);
        Assert.assertEquals((long)25L, (long)entry.getChildEntries().size());
        Entry entry2 = entry.getChildEntry("Catalog");
        Assert.assertNotNull((Object)entry2);
        Assert.assertNotNull((String)"Input stream may not be null", (Object)entry2.getInputStream());
    }

    @Test
    public void testReadCatalogSeekableStream() throws IOException {
        InputStream inputStream = this.getClass().getResourceAsStream(SAMPLE_DATA);
        Assert.assertNotNull((String)"Missing test resource!", (Object)inputStream);
        CompoundDocument compoundDocument = new CompoundDocument((SeekableInputStream)new MemoryCacheSeekableStream(inputStream));
        Entry entry = compoundDocument.getRootEntry();
        Assert.assertNotNull((Object)entry);
        Assert.assertEquals((long)25L, (long)entry.getChildEntries().size());
        Entry entry2 = entry.getChildEntry("Catalog");
        Assert.assertNotNull((Object)entry2);
        Assert.assertNotNull((String)"Input stream may not be null", (Object)entry2.getInputStream());
    }

    @Test
    public void testReadCatalogImageInputStream() throws IOException {
        InputStream inputStream = this.getClass().getResourceAsStream(SAMPLE_DATA);
        Assert.assertNotNull((String)"Missing test resource!", (Object)inputStream);
        MemoryCacheImageInputStream memoryCacheImageInputStream = new MemoryCacheImageInputStream(inputStream);
        memoryCacheImageInputStream.setByteOrder(ByteOrder.LITTLE_ENDIAN);
        CompoundDocument compoundDocument = new CompoundDocument((ImageInputStream)memoryCacheImageInputStream);
        Entry entry = compoundDocument.getRootEntry();
        Assert.assertNotNull((Object)entry);
        Assert.assertEquals((long)25L, (long)entry.getChildEntries().size());
        Entry entry2 = entry.getChildEntry("Catalog");
        Assert.assertNotNull((Object)entry2);
        Assert.assertNotNull((String)"Input stream may not be null", (Object)entry2.getInputStream());
    }
}

