/*
 * Decompiled with CFR 0.152.
 */
package com.twelvemonkeys.io.enc;

import com.twelvemonkeys.io.FileUtil;
import com.twelvemonkeys.io.enc.Decoder;
import com.twelvemonkeys.io.enc.DecoderStream;
import com.twelvemonkeys.io.enc.Encoder;
import com.twelvemonkeys.io.enc.EncoderStream;
import com.twelvemonkeys.lang.ObjectAbstractTest;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Random;
import org.junit.Assert;
import org.junit.Test;

public abstract class EncoderAbstractTest
extends ObjectAbstractTest {
    static final long SEED = 12345678L;
    static final Random RANDOM = new Random(12345678L);

    protected abstract Encoder createEncoder();

    protected abstract Decoder createCompatibleDecoder();

    protected Object makeObject() {
        return this.createEncoder();
    }

    @Test
    public final void testNullEncode() throws IOException {
        Encoder encoder = this.createEncoder();
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        try {
            encoder.encode((OutputStream)byteArrayOutputStream, null);
            Assert.fail((String)"null should throw NullPointerException");
        }
        catch (NullPointerException nullPointerException) {
            // empty catch block
        }
    }

    private byte[] createData(int n) {
        byte[] byArray = new byte[n];
        RANDOM.nextBytes(byArray);
        return byArray;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void runStreamTest(int n) throws Exception {
        byte[] byArray = this.createData(n);
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        Object object = new EncoderStream((OutputStream)byteArrayOutputStream, this.createEncoder(), true);
        Object object2 = null;
        try {
            int n2 = (byArray.length + 1) / 2;
            ((OutputStream)object).write(byArray, 0, n2);
            if (byArray.length > n2) {
                ((OutputStream)object).write(byArray, n2, byArray.length - n2);
            }
        }
        catch (Throwable throwable) {
            object2 = throwable;
            throw throwable;
        }
        finally {
            if (object != null) {
                if (object2 != null) {
                    try {
                        ((OutputStream)object).close();
                    }
                    catch (Throwable throwable) {
                        ((Throwable)object2).addSuppressed(throwable);
                    }
                } else {
                    ((OutputStream)object).close();
                }
            }
        }
        object = byteArrayOutputStream.toByteArray();
        object2 = FileUtil.read((InputStream)new DecoderStream((InputStream)new ByteArrayInputStream((byte[])object), this.createCompatibleDecoder()));
        Assert.assertArrayEquals((byte[])byArray, (byte[])object2);
        DecoderStream decoderStream = new DecoderStream((InputStream)new ByteArrayInputStream((byte[])object), this.createCompatibleDecoder());
        byteArrayOutputStream = new ByteArrayOutputStream();
        try {
            FileUtil.copy((InputStream)decoderStream, (OutputStream)byteArrayOutputStream);
        }
        finally {
            byteArrayOutputStream.close();
            decoderStream.close();
        }
        object2 = byteArrayOutputStream.toByteArray();
        Assert.assertArrayEquals((byte[])byArray, (byte[])object2);
    }

    @Test
    public final void testStreams() throws Exception {
        int n;
        for (n = 0; n < 100; ++n) {
            try {
                this.runStreamTest(n);
                continue;
            }
            catch (IOException iOException) {
                iOException.printStackTrace();
                Assert.fail((String)(iOException.getMessage() + ": " + n));
            }
        }
        for (n = 100; n < 2000; n += 250) {
            try {
                this.runStreamTest(n);
                continue;
            }
            catch (IOException iOException) {
                iOException.printStackTrace();
                Assert.fail((String)(iOException.getMessage() + ": " + n));
            }
        }
        for (n = 2000; n < 80000; n += 1000) {
            try {
                this.runStreamTest(n);
                continue;
            }
            catch (IOException iOException) {
                iOException.printStackTrace();
                Assert.fail((String)(iOException.getMessage() + ": " + n));
            }
        }
    }
}

