/*
 * Decompiled with CFR 0.152.
 */
package com.twelvemonkeys.io.enc;

import com.twelvemonkeys.io.enc.Decoder;
import com.twelvemonkeys.io.enc.DecoderStream;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.nio.ByteBuffer;
import java.util.Arrays;
import java.util.Random;
import org.junit.Assert;
import org.junit.Test;

public class DecoderStreamTest {
    private final Random rng = new Random(5467809876546L);

    private byte[] createData(int n) {
        byte[] byArray = new byte[n];
        this.rng.nextBytes(byArray);
        return byArray;
    }

    @Test
    public void testDecodeSingleBytes() throws IOException {
        byte[] byArray = this.createData(1327);
        ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(byArray);
        try (DecoderStream decoderStream = new DecoderStream((InputStream)byteArrayInputStream, (Decoder)new NullDecoder());){
            for (byte by : byArray) {
                int n = decoderStream.read();
                Assert.assertNotEquals((long)-1L, (long)n);
                Assert.assertEquals((long)by, (long)((byte)n));
            }
            Assert.assertEquals((long)-1L, (long)decoderStream.read());
        }
    }

    @Test
    public void testDecodeArray() throws IOException {
        int n = 793;
        byte[] byArray = this.createData(n * 10);
        ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(byArray);
        byte[] byArray2 = new byte[477];
        try (DecoderStream decoderStream = new DecoderStream((InputStream)byteArrayInputStream, (Decoder)new NullDecoder());){
            int n2;
            for (int i = 0; i < byArray.length; i += n2) {
                n2 = decoderStream.read(byArray2);
                Assert.assertFalse((n2 <= 0 ? 1 : 0) != 0);
                Assert.assertArrayEquals((byte[])Arrays.copyOfRange(byArray, i, i + n2), (byte[])Arrays.copyOfRange(byArray2, 0, n2));
            }
            Assert.assertEquals((long)-1L, (long)decoderStream.read());
        }
    }

    @Test
    public void testDecodeArrayOffset() throws IOException {
        int n = 793;
        byte[] byArray = this.createData(n * 10);
        ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(byArray);
        byte[] byArray2 = new byte[477];
        try (DecoderStream decoderStream = new DecoderStream((InputStream)byteArrayInputStream, (Decoder)new NullDecoder());){
            int n2;
            for (int i = 0; i < byArray.length; i += n2) {
                int n3 = i % byArray2.length;
                n2 = decoderStream.read(byArray2, n3, byArray2.length - n3);
                Assert.assertFalse((n2 <= 0 ? 1 : 0) != 0);
                Assert.assertArrayEquals((byte[])Arrays.copyOfRange(byArray, i + n3, i + n2), (byte[])Arrays.copyOfRange(byArray2, n3, n2));
            }
            Assert.assertEquals((long)-1L, (long)decoderStream.read());
        }
    }

    private static final class NullDecoder
    implements Decoder {
        private NullDecoder() {
        }

        public int decode(InputStream inputStream, ByteBuffer byteBuffer) throws IOException {
            int n = inputStream.read(byteBuffer.array(), byteBuffer.arrayOffset(), byteBuffer.remaining());
            if (n > 0) {
                byteBuffer.position(n);
            }
            return n;
        }
    }
}

